%==========================================================================
%
%   copyCellFiles.m designed to copy and rename cell image files
%
%   Copyright  2010, Steffen Remmele, Julia Ritzerfeld
%
%   This program is free software; you can redistribute it and/or modify it 
%   under the terms of the GNU General Public License as published by the 
%   Free Software Foundation; either version 3 of the License, 
%   or (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful, but 
%   WITHOUT ANY WARRANTY; without even the implied warranty of 
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
%   General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along 
%   with this program; if not, see <http://www.gnu.org/licenses/>.
%
%   CONTACT:
%   Steffen Remmele 
%   Experimental Radiation Oncology 
%   Mannheim Medical Center - University of Heidelberg 
%   Phone: 0621-383-6916
%   Mail: steffen.remmele@ziti.uni-heidelberg.de
%   HP: www.medical-physics.de
%
%   Dr. Julia Ritzerfeld
%   Biochemie-Zentrum der Universitt Heidelberg (BZH)
%   Phone: 06221-544180
%   Mail: julia.ritzerfeld@bzh.uni-heidelberg.de
%   HP: www.uni-heidelberg.de/zentral/bzh/
%
%==========================================================================

function varargout = copyCellFiles(varargin)
%==========================================================================
%
%   Copies and renames cell image files. The requirements for the automated
%   analysis will be preserved.
%
%==========================================================================
% COPYCELLFILES M-file for copyCellFiles.fig
%      COPYCELLFILES, by itself, creates a new COPYCELLFILES or raises the existing
%      singleton*.
%
%      H = COPYCELLFILES returns the handle to a new COPYCELLFILES or the handle to
%      the existing singleton*.
%
%      COPYCELLFILES('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in COPYCELLFILES.M with the given input arguments.
%
%      COPYCELLFILES('Property','Value',...) creates a new COPYCELLFILES or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before copyCellFiles_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to copyCellFiles_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help copyCellFiles

% Last Modified by GUIDE v2.5 12-Dec-2007 18:40:04
%==========================================================================

    % Begin initialization code - DO NOT EDIT
    gui_Singleton = 1;
    gui_State = struct('gui_Name',       mfilename, ...
                       'gui_Singleton',  gui_Singleton, ...
                       'gui_OpeningFcn', @copyCellFiles_OpeningFcn, ...
                       'gui_OutputFcn',  @copyCellFiles_OutputFcn, ...
                       'gui_LayoutFcn',  [] , ...
                       'gui_Callback',   []);
    if nargin && ischar(varargin{1})
        gui_State.gui_Callback = str2func(varargin{1});
    end

    if nargout
        [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
    else
        gui_mainfcn(gui_State, varargin{:});
    end
    % End initialization code - DO NOT EDIT
end

% --- Executes just before copyCellFiles is made visible.
function copyCellFiles_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to copyCellFiles (see VARARGIN)

    % Choose default command line output for copyCellFiles
    handles.output = hObject;

    % Update handles structure
    guidata(hObject, handles);

    % UIWAIT makes copyCellFiles wait for user response (see UIRESUME)
    % uiwait(handles.figure1);
end

% --- Outputs from this function are returned to the command line.
function varargout = copyCellFiles_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
    varargout{1} = handles.output;
end

function Target_Callback(hObject, eventdata, handles)
% hObject    handle to Target (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Target as text
%        str2double(get(hObject,'String')) returns contents of Target as a double
end

% --- Executes during object creation, after setting all properties.
function Target_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Target (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end
% --- Executes on button press in buttonTarget.
function buttonTarget_Callback(hObject, eventdata, handles)
% hObject    handle to buttonTarget (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    targetPath = uigetdir('.', 'Zielordner auswhlen');

    set(handles.Target,'String',targetPath);
end

function Replace1_Callback(hObject, eventdata, handles)
% hObject    handle to Replace1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace1 as text
%        str2double(get(hObject,'String')) returns contents of Replace1 as a double

    replace = get(handles.Replace1,'String');

    if size(replace,2) ~= 2
        set(handles.Replace1,'String','01');
    end
end

% --- Executes during object creation, after setting all properties.
function Replace1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source1_Callback(hObject, eventdata, handles)
% hObject    handle to Source1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source1 as text
%        str2double(get(hObject,'String')) returns contents of Source1 as a double
end

% --- Executes during object creation, after setting all properties.
function Source1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource1.
function buttonSource1_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source1,'String',sourcePath);
end

% --- Executes on button press in buttonCheck.
function buttonCheck_Callback(hObject, eventdata, handles)
% hObject    handle to buttonCheck (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    target = get(handles.Target,'String');
    source1 = get(handles.Source1,'String');

    if size(target,2) < 5 || size(source1,2) < 5
        set(handles.textCheck,'Visible','on');
    else
        set(handles.buttonCheck,'Visible','off');
        set(handles.textCheck,'Visible','off');    
        set(handles.buttonCopy,'Visible','on');

        set(handles.buttonTarget,'Visible','off');
        set(handles.buttonSource1,'Visible','off');
        set(handles.buttonSource2,'Visible','off');
        set(handles.buttonSource3,'Visible','off');
        set(handles.buttonSource4,'Visible','off');
        set(handles.buttonSource5,'Visible','off');
        set(handles.buttonSource6,'Visible','off');

    end % if1
end

% --- Executes on button press in buttonCopy.
function buttonCopy_Callback(hObject, eventdata, handles)
% hObject    handle to buttonCopy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    set(handles.buttonCopy,'Visible','off');

    target = get(handles.Target,'String');

    replace1 = get(handles.Replace1,'String');
    source1 = get(handles.Source1,'String');

    replace2 = get(handles.Replace2,'String');
    source2 = get(handles.Source2,'String');

    replace3 = get(handles.Replace3,'String');
    source3 = get(handles.Source3,'String');

    replace4 = get(handles.Replace4,'String');
    source4 = get(handles.Source4,'String');

    replace5 = get(handles.Replace5,'String');
    source5 = get(handles.Source5,'String');

    replace6 = get(handles.Replace6,'String');
    source6 = get(handles.Source6,'String');

    if size(source1,2) > 5

        source = source1;
        replace = replace1;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    if size(source2,2) > 5

        source = source2;
        replace = replace2;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    if size(source3,2) > 5

        source = source3;
        replace = replace3;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    if size(source4,2) > 5

        source = source4;
        replace = replace4;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    if size(source5,2) > 5

        source = source5;
        replace = replace5;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    if size(source6,2) > 5

        source = source6;
        replace = replace6;

        files = dir(source);

        amountFiles = size(files, 1);

        for i = 1:amountFiles

            if size(files(i).name,2) > 5

                oldFileLocation = strcat(source,'\', files(i).name);

                newFileName = files(i).name;

                newFileName(1) = replace(1);
                newFileName(2) = replace(2);

                newFileLocation = strcat(target,'\', newFileName);

                imgRead = imread(oldFileLocation);
                imwrite(imgRead, newFileLocation);

            end % if2
        end %for1
    end %if1

    set(handles.buttonDone,'Visible','on');
end

% --- Executes on button press in buttonDone.
function buttonDone_Callback(hObject, eventdata, handles)
% hObject    handle to buttonDone (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    close(handles.figure1);
end

function Replace2_Callback(hObject, eventdata, handles)
% hObject    handle to Replace2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace2 as text
%        str2double(get(hObject,'String')) returns contents of Replace2 as a double

    replace = get(handles.Replace2,'String');

    if size(replace,2) ~= 2
        set(handles.Replace2,'String','02');
    end
end

% --- Executes during object creation, after setting all properties.
function Replace2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source2_Callback(hObject, eventdata, handles)
% hObject    handle to Source2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source2 as text
%        str2double(get(hObject,'String')) returns contents of Source2 as a double
end

% --- Executes during object creation, after setting all properties.
function Source2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource2.
function buttonSource2_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source2,'String',sourcePath);
end

function Replace3_Callback(hObject, eventdata, handles)
% hObject    handle to Replace3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace3 as text
%        str2double(get(hObject,'String')) returns contents of Replace3 as a double

    replace = get(handles.Replace3,'String');

    if size(replace,2) ~= 2
        set(handles.Replace3,'String','03');
    end
end

% --- Executes during object creation, after setting all properties.
function Replace3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source3_Callback(hObject, eventdata, handles)
% hObject    handle to Source3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source3 as text
%        str2double(get(hObject,'String')) returns contents of Source3 as a double
end

% --- Executes during object creation, after setting all properties.
function Source3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource3.
function buttonSource3_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source3,'String',sourcePath);
end

function Replace4_Callback(hObject, eventdata, handles)
% hObject    handle to Replace4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace4 as text
%        str2double(get(hObject,'String')) returns contents of Replace4 as a double

    replace = get(handles.Replace4,'String');

    if size(replace,2) ~= 2
        set(handles.Replace4,'String','04');
    end
end

% --- Executes during object creation, after setting all properties.
function Replace4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source4_Callback(hObject, eventdata, handles)
% hObject    handle to Source4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source4 as text
%        str2double(get(hObject,'String')) returns contents of Source4 as a double
end

% --- Executes during object creation, after setting all properties.
function Source4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource4.
function buttonSource4_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source4,'String',sourcePath);
end

function Replace5_Callback(hObject, eventdata, handles)
% hObject    handle to Replace5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace5 as text
%        str2double(get(hObject,'String')) returns contents of Replace5 as a double

    replace = get(handles.Replace5,'String');

    if size(replace,2) ~= 2
        set(handles.Replace5,'String','05');
    end 
end

% --- Executes during object creation, after setting all properties.
function Replace5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source5_Callback(hObject, eventdata, handles)
% hObject    handle to Source5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source5 as text
%        str2double(get(hObject,'String')) returns contents of Source5 as a double
end

% --- Executes during object creation, after setting all properties.
function Source5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource5.
function buttonSource5_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source5,'String',sourcePath);
end

function Replace6_Callback(hObject, eventdata, handles)
% hObject    handle to Replace6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Replace6 as text
%        str2double(get(hObject,'String')) returns contents of Replace6 as a double

    replace = get(handles.Replace6,'String');

    if size(replace,2) ~= 2
        set(handles.Replace6,'String','06');
    end
end

% --- Executes during object creation, after setting all properties.
function Replace6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Replace6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Source6_Callback(hObject, eventdata, handles)
% hObject    handle to Source6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Source6 as text
%        str2double(get(hObject,'String')) returns contents of Source6 as a double
end

% --- Executes during object creation, after setting all properties.
function Source6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Source6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonSource6.
function buttonSource6_Callback(hObject, eventdata, handles)
% hObject    handle to buttonSource6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    sourcePath = uigetdir('.', 'Quellordner auswhlen');

    set(handles.Source6,'String',sourcePath);
end
