%==========================================================================
%
%   SingleCellAnalyse.m designed to manage an analysis of one cell data set
%
%   Copyright  2010, Steffen Remmele, Julia Ritzerfeld
%
%   This program is free software; you can redistribute it and/or modify it 
%   under the terms of the GNU General Public License as published by the 
%   Free Software Foundation; either version 3 of the License, 
%   or (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful, but 
%   WITHOUT ANY WARRANTY; without even the implied warranty of 
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
%   General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along 
%   with this program; if not, see <http://www.gnu.org/licenses/>.
%
%   CONTACT:
%   Steffen Remmele 
%   Experimental Radiation Oncology 
%   Mannheim Medical Center - University of Heidelberg 
%   Phone: 0621-383-6916
%   Mail: steffen.remmele@ziti.uni-heidelberg.de
%   HP: www.medical-physics.de
%
%   Dr. Julia Ritzerfeld
%   Biochemie-Zentrum der Universitt Heidelberg (BZH)
%   Phone: 06221-544180
%   Mail: julia.ritzerfeld@bzh.uni-heidelberg.de
%   HP: www.uni-heidelberg.de/zentral/bzh/
%
%==========================================================================

function varargout = SingleCellAnalyse(varargin)
%==========================================================================
%
%   Chose three files for a single analysis. Break option can be choosen to
%   see more details of analysis process (-> Test segmentation or decide
%   about classification function). Results are shown in figure and in
%   command window. 
%
%   Analysis is done using analyseImages.m
%
%==========================================================================
% SINGLECELLANALYSE M-file for SingleCellAnalyse.fig
%      SINGLECELLANALYSE, by itself, creates a new SINGLECELLANALYSE or raises the existing
%      singleton*.
%
%      H = SINGLECELLANALYSE returns the handle to a new SINGLECELLANALYSE or the handle to
%      the existing singleton*.
%
%      SINGLECELLANALYSE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SINGLECELLANALYSE.M with the given input arguments.
%
%      SINGLECELLANALYSE('Property','Value',...) creates a new SINGLECELLANALYSE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SingleCellAnalyse_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SingleCellAnalyse_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SingleCellAnalyse

% Last Modified by GUIDE v2.5 04-Mar-2010 15:17:11

% Begin initialization code - DO NOT EDIT
    gui_Singleton = 1;
    gui_State = struct('gui_Name',       mfilename, ...
                       'gui_Singleton',  gui_Singleton, ...
                       'gui_OpeningFcn', @SingleCellAnalyse_OpeningFcn, ...
                       'gui_OutputFcn',  @SingleCellAnalyse_OutputFcn, ...
                       'gui_LayoutFcn',  [] , ...
                       'gui_Callback',   []);
    if nargin && ischar(varargin{1})
        gui_State.gui_Callback = str2func(varargin{1});
    end

    if nargout
        [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
    else
        gui_mainfcn(gui_State, varargin{:});
    end
    % End initialization code - DO NOT EDIT
end

% --- Executes just before SingleCellAnalyse is made visible.
function SingleCellAnalyse_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SingleCellAnalyse (see VARARGIN)

    % Choose default command line output for SingleCellAnalyse
    handles.output = hObject;

    % Update handles structure
    guidata(hObject, handles);

    % UIWAIT makes SingleCellAnalyse wait for user response (see UIRESUME)
    % uiwait(handles.figure1);

    %%%ADDED GLOBAL VARIABLES%%%
    %global imgHoechst; 
    %global imgGFP; 
    %global imgCherry; 

    %initial settings for checkboxes
    set(handles.checkboxCherryImage,'value',1);  %assume Cherry image is available
    set(handles.checkboxCherrySegmentation,'value',0);
    set(handles.checkPause,'value',1);

    %DEBUG settings
    %==========================================================================
    set(handles.GFPfile,'String','--W00003--P00001--Z00000--T00000--eGFP.tif');
    set(handles.GFPpath,'String','J:\TestData\MIAAB\TESTdataSET\');
    set(handles.Hoechstfile,'String','--W00003--P00001--Z00000--T00000--Hoechst.tif');
    set(handles.Hoechstpath,'String','J:\TestData\MIAAB\TESTdataSET\');
    set(handles.Cherryfile,'String','--W00003--P00001--Z00000--T00000--Cherry.tif');
    set(handles.Cherrypath,'String','J:\TestData\MIAAB\TESTdataSET\');
    %==========================================================================
end

% --- Outputs from this function are returned to the command line.
function varargout = SingleCellAnalyse_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    % Get default command line output from handles structure
    varargout{1} = handles.output;
end

function GFPfile_Callback(hObject, eventdata, handles)                  
% hObject    handle to GFPfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GFPfile as text
%        str2double(get(hObject,'String')) returns contents of GFPfile as a double
end

% --- Executes during object creation, after setting all properties.
function GFPfile_CreateFcn(hObject, eventdata, handles)                  
% hObject    handle to GFPfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonGFP.
function buttonGFP_Callback(hObject, eventdata, handles)               
% hObject    handle to buttonGFP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    [file_name1, path1]=uigetfile('*.tif','Load TIF Image');

    set(handles.GFPfile,'String',file_name1);
    set(handles.GFPpath,'String',path1);
end

function GFPpath_Callback(hObject, eventdata, handles)                 
% hObject    handle to GFPpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GFPpath as text
%        str2double(get(hObject,'String')) returns contents of GFPpath as a double
end

% --- Executes during object creation, after setting all properties.
function GFPpath_CreateFcn(hObject, eventdata, handles)                 
% hObject    handle to GFPpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Cherryfile_Callback(hObject, eventdata, handles)                 
% hObject    handle to Cherryfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Cherryfile as text
%        str2double(get(hObject,'String')) returns contents of Cherryfile as a double
end

% --- Executes during object creation, after setting all properties.
function Cherryfile_CreateFcn(hObject, eventdata, handles)                 
% hObject    handle to Cherryfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Cherrypath_Callback(hObject, eventdata, handles)                 
% hObject    handle to Cherrypath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Cherrypath as text
%        str2double(get(hObject,'String')) returns contents of Cherrypath as a double
end

% --- Executes during object creation, after setting all properties.
function Cherrypath_CreateFcn(hObject, eventdata, handles)                 
% hObject    handle to Cherrypath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonCherry.
function buttonCherry_Callback(hObject, eventdata, handles)                 
% hObject    handle to buttonCherry (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    [file_name2, path2]=uigetfile('*.tif','Load TIF Image');

    set(handles.Cherryfile,'String',file_name2);
    set(handles.Cherrypath,'String',path2);
end

function Hoechstfile_Callback(hObject, eventdata, handles)           
% hObject    handle to Hoechstfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Hoechstfile as text
%        str2double(get(hObject,'String')) returns contents of Hoechstfile as a double
end

% --- Executes during object creation, after setting all properties.
function Hoechstfile_CreateFcn(hObject, eventdata, handles)           
% hObject    handle to Hoechstfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function Hoechstpath_Callback(hObject, eventdata, handles)           
% hObject    handle to Hoechstpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Hoechstpath as text
%        str2double(get(hObject,'String')) returns contents of Hoechstpath as a double
end

% --- Executes during object creation, after setting all properties.
function Hoechstpath_CreateFcn(hObject, eventdata, handles)           
% hObject    handle to Hoechstpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonHoechst.
function buttonHoechst_Callback(hObject, eventdata, handles)           
% hObject    handle to buttonHoechst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    [file_name3, path3]=uigetfile('*.tif','Load TIF Image');

    set(handles.Hoechstfile,'String',file_name3);
    set(handles.Hoechstpath,'String',path3);
end

% --- Executes on button press in buttonShow.
function buttonShow_Callback(hObject, eventdata, handles)               
% hObject    handle to buttonShow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    global imgHoechst; 
    global imgGFP; 
    global imgCherry; 

    GFPImageFile     = get(handles.GFPfile,'String');
    HoechstImageFile = get(handles.Hoechstfile,'String');

    boolCherryImage = get(handles.checkboxCherryImage,'Value');

    %if there is no cherry file, just use GFP filename to move on
    if boolCherryImage == 1 
        CherryImageFile  = get(handles.Cherryfile,'String');
    else
        CherryImageFile = GFPImageFile;
    end %if1

    %check whether all pathes are set
    gfpImgSize = size(GFPImageFile);
    cherryImgSize = size(CherryImageFile);
    hoechstImgSize = size(HoechstImageFile);

    if ( gfpImgSize(2) < 3 || cherryImgSize(2) < 3 || hoechstImgSize(2) < 3)
        set(handles.textPathesNotSet,'Visible','on');
    else
        set(handles.checkboxCherryImage,'Visible','off');

        boolCherryImage = get(handles.checkboxCherryImage,'Value');
        if boolCherryImage == 1
            set(handles.textCherryImage,'Visible','on');
        end

        set(handles.textPathesNotSet,'Visible','off');
        set(handles.buttonShow,'Visible','off');

        set(handles.buttonGFP,'Visible','off');
        set(handles.buttonCherry,'Visible','off');
        set(handles.buttonHoechst,'Visible','off');

        %GFP
        path1 = get(handles.GFPpath,'String');
        GFPImage = strcat(path1, GFPImageFile);

        imgGFP = imread(GFPImage); %global

        axes(handles.GFPImg);
        imagesc(imgGFP);
        colormap(gray);

        %Hoechst
        path2 = get(handles.Hoechstpath,'String');
        HoechstImage = strcat(path2, HoechstImageFile);

        imgHoechst = imread(HoechstImage); %global

        axes(handles.HoechstImg);
        imagesc(imgHoechst);
        colormap(gray);

        %Cherry
        if boolCherryImage == 1 
            path3 = get(handles.Cherrypath,'String');
            CherryImage  = strcat(path3, CherryImageFile);
        else
            CherryImage = GFPImage;
        end %if1

        imgCherry = imread(CherryImage); %global

        if boolCherryImage == 1
            axes(handles.CherryImg);
            imagesc(imgCherry);
            colormap(gray);
        end

        set(handles.HoechstImg,'Visible','on');
        set(handles.GFPImg,'Visible','on');

        set(handles.textHoechst,'Visible','on');
        set(handles.textGFP,'Visible','on');

        set(handles.checkPause,'Visible','on');
        set(handles.buttonAnalyse,'Visible','on');

        if boolCherryImage == 1
            set(handles.CherryImg,'Visible','on');
            set(handles.textCherry,'Visible','on');
            set(handles.checkboxCherrySegmentation,'Visible','on');
        else
            set(handles.CherryImg,'Visible','off');
            set(handles.textCherry,'Visible','off');  
            set(handles.checkboxCherrySegmentation,'Visible','off');
        end

    end %if1

end

% --- Executes on button press in buttonAnalyse.
function buttonAnalyse_Callback(hObject, eventdata, handles) 
% hObject    handle to buttonAnalyse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    global imgHoechst; 
    global imgGFP; 
    global imgCherry; 
    
    boolCherryImage = get(handles.checkboxCherryImage,'Value');
    boolCherrySegmentation  = get(handles.checkboxCherrySegmentation,'Value');
    boolPause = get(handles.checkPause,'Value');
    
    set(handles.buttonAnalyse,'Visible','off');
    set(handles.checkPause,'Visible','off');
    if boolPause == 1
        set(handles.textPause,'Visible','on');
    end
    set(handles.checkboxCherrySegmentation,'Visible','off');
    if boolCherrySegmentation == 1
        set(handles.textCherrySegmentation,'Visible','on');
    end
    
    set(handles.text33AnalyseRunning,'Visible','on');
        
    pause(0.1); %pause is necessary to alter figure before starting analyses 
    
    %cellResult =[34,1,2,3,4,5,6,24,1,2,3,4,5,6];
    cellResult = analyseImages(imgGFP, imgCherry, imgHoechst, boolPause, boolCherryImage, boolCherrySegmentation);
       
    set(handles.totalCells,'String',num2str(cellResult(1))); 
    set(handles.totalCyto,'String',num2str(cellResult(2))); 
    set(handles.totalGolgi,'String',num2str(cellResult(3))); 
    set(handles.totalMem,'String',num2str(cellResult(4))); 
    %set(handles.totalManual,'String',num2str(cellResult(5))); 
    set(handles.totalUndec,'String',num2str(cellResult(6))); 
    set(handles.totalInvalid,'String',num2str(cellResult(7))); 
    
    set(handles.totalCherryCells,'String',num2str(cellResult(8))); 
    set(handles.totalCherryCyto,'String',num2str(cellResult(9))); 
    set(handles.totalCherryGolgi,'String',num2str(cellResult(10))); 
    set(handles.totalCherryMem,'String',num2str(cellResult(11))); 
    %set(handles.totalCherryManual,'String',num2str(cellResult(12))); 
    set(handles.totalCherryUndec,'String',num2str(cellResult(13))); 
    set(handles.totalCherryInvalid,'String',num2str(cellResult(14))); 
    
    set(handles.text33AnalyseRunning,'Visible','off');
        
    set(handles.textcells,'Visible','on'); 
    set(handles.textCyto,'Visible','on'); 
    set(handles.textGolgi,'Visible','on'); 
    set(handles.textMem,'Visible','on'); 
    %set(handles.textMan,'Visible','on'); 
    set(handles.textUndec,'Visible','on'); 
    set(handles.textInval,'Visible','on'); 
    set(handles.text30GFP,'Visible','on'); 
    

    set(handles.totalCells,'Visible','on'); 
    set(handles.totalCyto,'Visible','on'); 
    set(handles.totalGolgi,'Visible','on'); 
    set(handles.totalMem,'Visible','on'); 
    %set(handles.totalManual,'Visible','on'); 
    set(handles.totalUndec,'Visible','on'); 
    set(handles.totalInvalid,'Visible','on'); 
    
    if boolCherryImage == 1
        set(handles.text31Cherry,'Visible','on'); 
        set(handles.totalCherryCells,'Visible','on'); 
        set(handles.totalCherryCyto,'Visible','on'); 
        set(handles.totalCherryGolgi,'Visible','on'); 
        set(handles.totalCherryMem,'Visible','on'); 
        %set(handles.totalCherryManual,'Visible','on'); 
        set(handles.totalCherryUndec,'Visible','on'); 
        set(handles.totalCherryInvalid,'Visible','on'); 
    end
    
    set(handles.buttonFinish,'Visible','on'); 
    
end
    
% --- Executes on button press in checkPause.
function checkPause_Callback(hObject, eventdata, handles)             
% hObject    handle to checkPause (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkPause
end

function pathSave_Callback(hObject, eventdata, handles)                
% hObject    handle to pathSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of pathSave as text
%        str2double(get(hObject,'String')) returns contents of pathSave as a double
end

% --- Executes during object creation, after setting all properties.
function pathSave_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to pathSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCyto_Callback(hObject, eventdata, handles)                
% hObject    handle to totalCyto (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCyto as text
%        str2double(get(hObject,'String')) returns contents of totalCyto as a double
end

% --- Executes during object creation, after setting all properties.
function totalCyto_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalCyto (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalGolgi_Callback(hObject, eventdata, handles)                
% hObject    handle to totalGolgi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalGolgi as text
%        str2double(get(hObject,'String')) returns contents of totalGolgi as a double
end

% --- Executes during object creation, after setting all properties.
function totalGolgi_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalGolgi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalMem_Callback(hObject, eventdata, handles)                
% hObject    handle to totalMem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalMem as text
%        str2double(get(hObject,'String')) returns contents of totalMem as a double
end

% --- Executes during object creation, after setting all properties.
function totalMem_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalMem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalUndec_Callback(hObject, eventdata, handles)                
% hObject    handle to totalUndec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalUndec as text
%        str2double(get(hObject,'String')) returns contents of totalUndec as a double
end

% --- Executes during object creation, after setting all properties.
function totalUndec_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalUndec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalInvalid_Callback(hObject, eventdata, handles)                
% hObject    handle to totalInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalInvalid as text
%        str2double(get(hObject,'String')) returns contents of totalInvalid as a double
end

% --- Executes during object creation, after setting all properties.
function totalInvalid_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCells_Callback(hObject, eventdata, handles)                
% hObject    handle to totalCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCells as text
%        str2double(get(hObject,'String')) returns contents of totalCells as a double
end

% --- Executes during object creation, after setting all properties.
function totalCells_CreateFcn(hObject, eventdata, handles)                
% hObject    handle to totalCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function edit16_Callback(hObject, eventdata, handles)            
% hObject    handle to edit16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit16 as text
%        str2double(get(hObject,'String')) returns contents of edit16 as a double
end

% --- Executes during object creation, after setting all properties.
function edit16_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to edit16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in buttonFinish.
function buttonFinish_Callback(hObject, eventdata, handles)            
% hObject    handle to buttonFinish (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    boolCherryImage = get(handles.checkboxCherryImage,'Value');
    
    GFPfile = get(handles.GFPfile,'String');
    Cherryfile = get(handles.Cherryfile,'String');

    GFPCells = get(handles.totalCells,'String');
    GFPCyto = get(handles.totalCyto,'String');
    GFPGol  = get(handles.totalGolgi,'String');
    GFPMem  = get(handles.totalMem,'String');
    %GFPMan  = get(handles.totalManual,'String');
    GFPUndec = get(handles.totalUndec,'String');
    GFPInv  = get(handles.totalInvalid,'String');
    
    fprintf('Filename;Anzahl Zellen;Anzahl Cytoplasma;Anzahl Golgi; Anzahl Golgi (strong); Anzahl Membran;  Anzahl Invalid\n');
    fprintf(strcat(GFPfile,';',GFPCells,';',GFPCyto,';',GFPGol,';',GFPUndec,';',GFPMem,';',GFPInv,'\n'));
    
    if boolCherryImage == 1 
        CherryCells = get(handles.totalCherryCells,'String');
        CherryCyto = get(handles.totalCherryCyto,'String');
        CherryGol  = get(handles.totalCherryGolgi,'String');
        CherryMem  = get(handles.totalCherryMem,'String');
        %CherryMan  = get(handles.totalCherryManual,'String');
        CherryUndec = get(handles.totalCherryUndec,'String');
        CherryInv  = get(handles.totalCherryInvalid,'String');
        
        fprintf(strcat(Cherryfile,';',CherryCells,';',CherryCyto,';',CherryGol,';',CherryUndec,';',CherryMem,';',CherryInv,'\n'));
    end
    
    close(handles.figure1);
end
    
function totalCherryCyto_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryCyto (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryCyto as text
%        str2double(get(hObject,'String')) returns contents of totalCherryCyto as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryCyto_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryCyto (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCherryGolgi_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryGolgi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryGolgi as text
%        str2double(get(hObject,'String')) returns contents of totalCherryGolgi as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryGolgi_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryGolgi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCherryMem_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryMem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryMem as text
%        str2double(get(hObject,'String')) returns contents of totalCherryMem as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryMem_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryMem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCherryUndec_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryUndec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryUndec as text
%        str2double(get(hObject,'String')) returns contents of totalCherryUndec as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryUndec_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryUndec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCherryInvalid_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryInvalid as text
%        str2double(get(hObject,'String')) returns contents of totalCherryInvalid as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryInvalid_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

function totalCherryCells_Callback(hObject, eventdata, handles)            
% hObject    handle to totalCherryCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of totalCherryCells as text
%        str2double(get(hObject,'String')) returns contents of totalCherryCells as a double
end

% --- Executes during object creation, after setting all properties.
function totalCherryCells_CreateFcn(hObject, eventdata, handles)            
% hObject    handle to totalCherryCells (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end
end

% --- Executes on button press in checkboxCherryImage.
function checkboxCherryImage_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxCherryImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxCherryImage
    boolCherryImage = get(handles.checkboxCherryImage,'Value');

    if boolCherryImage == 1
        set(handles.Cherrypath,'Visible','on');
        set(handles.text4,'Visible','on');
        set(handles.Cherryfile,'Visible','on');
        set(handles.text2,'Visible','on');
        set(handles.buttonCherry,'Visible','on');
    else
        set(handles.Cherrypath,'Visible','off');
        set(handles.text4,'Visible','off');
        set(handles.Cherryfile,'Visible','off');
        set(handles.text2,'Visible','off');
        set(handles.buttonCherry,'Visible','off');  
    end
end

% --- Executes on button press in checkboxCherrySegmentation.
function checkboxCherrySegmentation_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxCherrySegmentation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxCherrySegmentation
end

