%==========================================================================
%
%   CheckImageQuality.m designed to check the quality of cell data images
%
%   Copyright  2010, Steffen Remmele, Julia Ritzerfeld
%
%   This program is free software; you can redistribute it and/or modify it 
%   under the terms of the GNU General Public License as published by the 
%   Free Software Foundation; either version 3 of the License, 
%   or (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful, but 
%   WITHOUT ANY WARRANTY; without even the implied warranty of 
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
%   General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along 
%   with this program; if not, see <http://www.gnu.org/licenses/>.
%
%   CONTACT:
%   Steffen Remmele 
%   Experimental Radiation Oncology 
%   Mannheim Medical Center - University of Heidelberg 
%   Phone: 0621-383-6916
%   Mail: steffen.remmele@ziti.uni-heidelberg.de
%   HP: www.medical-physics.de
%
%   Dr. Julia Ritzerfeld
%   Biochemie-Zentrum der Universitt Heidelberg (BZH)
%   Phone: 06221-544180
%   Mail: julia.ritzerfeld@bzh.uni-heidelberg.de
%   HP: www.uni-heidelberg.de/zentral/bzh/
%
%==========================================================================

function badFileValue = CheckImageQuality(img1, threshold)
%==========================================================================
% part of cell analyse
%
% analyses the quality of the one image by using FFT and giving back the
% result as bool. 
%
% Using fft2.
% If there are too less information in different frequency domains the
% image is considered to be too much out of focus and is reported as bad
% file.
%
%==========================================================================
    
    %threshold = 1000000;
    
    imageSize = size(img1);    
    
    amountImg1 = 0;
    
    fftImage1 = fftshift(fft2(double(img1)));
 
    absFftImage1 = abs(fftImage1); 
       
    for i=1:imageSize(1)
        for j=1:imageSize(2)
            if absFftImage1(i,j) > threshold
                amountImg1 = amountImg1 +1;
            end %if1
        end %for2
    end %for1

    badFileValue = amountImg1;


    
    