#!/usr/bin/env python
### 06.26.10
### Tina
import sys
from cmdline.cmdline import CommandLineApp
import pysam
from Bio import SeqIO
import random
import math
from mapping_functions import *


class ReadSampler(CommandLineApp):
	def __init__(self):
		CommandLineApp.__init__(self)
		op = self.option_parser
		op.set_usage('usage: countReads.py')

		op.add_option('-o', '--out', dest='out', type='string', default=None, 
			help='output file')

		op.add_option('-d', '--hmm_data', dest='hmm_data', type='string', default="hmm_data", 
			help='Location of hmm input data')

		op.add_option('-b', '--barcodes', dest='barcodes_file', type='string', default=None, 
			help='Barcodes file')


	def main(self):
		self.variables, self.bc = read_barcodes(self.options.barcodes_file)

		stats_file = open(self.options.out,'w')
		stats_file.write("indiv,num_reads\n")
		for ind in self.bc:
			indiv_name = 'indiv' + ind[1] + '_' + ind[0]

			samfilename = self.options.hmm_data + '/' + indiv_name + '/aln_' + indiv_name + '_par1-filtered.sam'
			if not os.path.exists(samfilename ):
				samfilename = self.options.hmm_data + '/' + indiv_name + '/aln_' + indiv_name + '_par1-filtered.sam.gz'
				if not os.path.exists(samfilename ):
					stats_file.write("%s,NA\n" % (indiv_name))
					continue

			### note: no header lines in the filtered sam file
			number_reads = count_lines(samfilename)
			stats_file.write("%s,%d\n" % (indiv_name,number_reads))
		stats_file.close()


if __name__ == '__main__':
    try:
	ReadSampler().run()
    except Exception, e:
	print '%s' % e
	sys.exit(2)
