#!/usr/bin/perl

use vars qw/ %opt /;

# process the command-line args
sub init() {
        use Getopt::Std;
        my $opt_string = 'hd:i:';
        getopts("$opt_string", \%opt) or usage();
        usage() if $opt{h} or !$opt{d} or !$opt{i};
}

# print if requested or insufficent args
sub usage() {
        print STDERR << "EOF";
        

usage: $0 [-h] [-d directory] 
        
 -h     : this message
 -d	: sequence directory
 -i	: bowtie index name

example: $0 -d NA12345 -e L1RP 

EOF
        exit;
}

init();

my $dir = $opt{d};
my $index = $opt{i};
die ("directory $dir does not exist!") if (! -d $dir);

open(LOG, ">$dir.run.log");

# uncompress the .gz files
my $unpack_jid = `./unpack.sh $dir`;
chomp $unpack_jid;

print LOG "unpack.sh submitted with job id $unpack_jid\n";
print "unpack.sh submitted with job id $unpack_jid\n";

# run bowtie for each file in directory vs. index

my %usedfiles;

opendir(DIRH, $dir);
for (readdir DIRH) {
	if ($_ =~ /\.fastq\.gz$/) { #gzipped FASTQ files only
		my $subfn = "b.$fnum." . int(rand(999999999)) . ".sub.sh";

		my $fn = $_;
		$fn =~ s/\.gz$//; # files will be decompressed

		# write and submit script for bowtie qsub

		my $bwt_jid = `./bwt.sh $fn $dir $index $unpack_jid`;
		chomp $bwt_jid;

		$usedfiles{"$fn"} = $bwt_jid; 

		print LOG "submitted bowtie job $fn vs $index with job id $bwt_jid holding on $unpack_jid\n";
		print "submitted bowtie job $fn vs $index with job id $bwt_jid holding on $unpack_jid\n";
	}
}
closedir DIRH;

my @runfiles;
for (keys %usedfiles) {
	push @runfiles, $_ if ($_ =~ /_1/);
}

my @genome_jids;
# find unpaired l1 ends and align to genome
for (@runfiles) {
	my $f1 = $_;
	my $f2 = $_;
	$f2 =~ s/_1/_2/;
	my $f1_jid = $usedfiles{$f1};
	my $f2_jid = $usedfiles{$f2};

	my $genome_jid = `./pair.sh $f1 $dir $index $f1_jid $f2_jid`;
	chomp $genome_jid;
	push @genome_jids, $genome_jid;
	
	print LOG "pairing and aligning to hg18, command: ./pair.sh $f1 $dir $index $f1_jid $f2_jid\n";
	print "pairing and aligning to hg18, command: ./pair.sh $f1 $dir $index $f1_jid $f2_jid\n";
}

my $jidstring = join(',',@genome_jids);
print "submitting cleanup, waiting for jids: $jidstring\n";
`qsub -hold_jid $jidstring cleanup.sh $dir`;

close LOG;
