#!/bin/sh

if [ $# -ne 5 ]
then
	echo "usage: pair.sh <first file> <directory> <existing results directory> <hold_jid1> <hold_jid2>"
	echo "first file should correspond to the first paired end i.e. something_1.fastq"
	exit 65;
fi

if [ ! -e $2/${3}PAIR ]
then
	mkdir $2/${3}PAIR
fi

FN=$1 # _1 pair, original file
F2=`echo $FN | sed -e 's/_1/_2/'` # _2 pair, original file

BN=$FN.vs$3.bwt
B2=`echo $BN | sed -e 's/_1/_2/'`; # _2 pair, alignments

SCR=$2.pair.${RANDOM}${RANDOM}.sub.sh

echo "IF=\`perl $HOME/1000genomes/find_unpaired.pl -x $HOME/1000genomes/$2/$FN -y $HOME/1000genomes/$2/$F2 -a $HOME/1000genomes/$2/$3/$BN -b $HOME/1000genomes/$2/$3/$B2 -d $HOME/1000genomes/$2/${3}PAIR\`" > $SCR
echo "OF=\`echo \$IF | sed -e 's/\.fastq$/\.bwt/'\`" >> $SCR
echo "$HOME/bin/bowtie --best -p 2 -m 1 $HOME/bowtie/indexes/hg18 $HOME/1000genomes/$2/${3}PAIR/\$IF $HOME/1000genomes/$2/${3}PAIR/\$OF" >> $SCR

echo `qsub -hold_jid $4,$5 -l mem_free=6G -pe DJ 2 $SCR | awk '{print $3}'`
