#!/bin/sh

if [ $# -ne 4 ]
then
	echo "usage: bwt.sh <filename> <directory> <result subdir> <hold jid>"
	exit 65;
fi

if [ ! -e $2/$3 ]
then
	mkdir $2/$3
fi

OFN=$2.bwt.${RANDOM}${RANDOM}.sub.sh
echo "$HOME/bin/bowtie --best -m 1 -n 1 $HOME/bowtie/indexes/$3 $HOME/1000genomes/$2/$1 $HOME/1000genomes/$2/$3/$1.vs$3.bwt" > $OFN

JOBNUM=`qsub -hold_jid $4 $OFN | awk '{print $3}'`
echo $JOBNUM;
