(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138998,       2474]
NotebookOptionsPosition[    137744,       2432]
NotebookOutlinePosition[    138088,       2447]
CellTagsIndexPosition[    138045,       2444]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Mathematica Notebook for diffusion approximation results for Denver et al. \
\"Selective sweeps and parallel mutation in the adaptive recovery from \
deleterious mutation in Caenorhabditis elegans.\" Genome Research 2010\
\>", "Subtitle",
 CellChangeTimes->{{3.49097903168257*^9, 3.490979056883233*^9}, {
  3.490979092474362*^9, 3.4909790986008787`*^9}, {3.49097919302915*^9, 
  3.4909791980840693`*^9}, {3.490979234630385*^9, 3.490979243188046*^9}}],

Cell[CellGroupData[{

Cell["\<\
Fixation probability under netural mutation-drift process (from Crow and \
Kimura 1970, eq. 8.5.19)\
\>", "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.490979205654916*^9, 3.49097920942798*^9}, {
   3.490979250874452*^9, 3.490979272858083*^9}, {3.490979349769992*^9, 
   3.490979354242537*^9}, 3.490979646867927*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"probfixby", "[", 
   RowBox[{"t_", ",", "ne_", ",", "mu_", ",", "sum_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "c", "}"}], ",", 
    RowBox[{
     RowBox[{"c", "=", 
      RowBox[{"4", "ne", " ", "mu"}]}], ";", 
     RowBox[{"1", "-", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}]}], 
         RowBox[{"Gamma", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"i", "-", "1", "+", "c"}], ")"}], "*", 
           "1.00000000000000000000000000000000000000000"}], "]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"2", "i"}], "-", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Gamma", "[", 
             RowBox[{
             "c", "*", "1.00000000000000000000000000000000000000000"}], "]"}], 
            RowBox[{"i", "!"}]}], ")"}]}], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "i"}], " ", "t", 
           RowBox[{"(", 
            RowBox[{"mu", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"i", "-", "1"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "ne"}], ")"}]}]}], ")"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "sum"}], "}"}]}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.469558076618471*^9, 3.469558121816374*^9}, {
   3.469558263403303*^9, 3.4695584073105993`*^9}, {3.469558514089415*^9, 
   3.469558627197823*^9}, {3.469559063218507*^9, 3.469559069340106*^9}, {
   3.4695591037566433`*^9, 3.469559111007217*^9}, {3.46955946959706*^9, 
   3.4695594698672333`*^9}, 3.470412591351098*^9, {3.470412829794845*^9, 
   3.4704128354812193`*^9}, {3.470412881108494*^9, 3.4704128859554443`*^9}, {
   3.47041404177118*^9, 3.470414048860774*^9}, {3.470414131054023*^9, 
   3.4704141359227962`*^9}, {3.4704141828500338`*^9, 3.470414187255128*^9}, {
   3.470414788801696*^9, 3.470414811344721*^9}, 3.470414842573134*^9, {
   3.490979017841061*^9, 3.490979023145589*^9}, 3.4909796468683233`*^9, 
   3.4909806155353813`*^9, {3.4909806947300367`*^9, 3.490980700905779*^9}, 
   3.490980901677165*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Solutions", " ", "for", " ", "small", " ", "t", " ", "are", " ", 
     "extremely", " ", "unstable"}], ",", " ", 
    RowBox[{
    "so", " ", "look", " ", "at", " ", "the", " ", "trend", " ", "of", " ", 
     "the", " ", "upper", " ", "bound", " ", "for", " ", "increasing", " ", 
     "Ne"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", 
          RowBox[{"probfixby", "[", 
           RowBox[{"60", ",", "k", ",", 
            RowBox[{"10", "^", 
             RowBox[{"-", "9"}]}], ",", "100"}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "100", ",", "1000", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4705183170680656`*^9, 3.470518366274575*^9}, {
   3.470520843392796*^9, 3.4705208552238894`*^9}, {3.470520890354465*^9, 
   3.470520945702286*^9}, {3.470520976115212*^9, 3.470520985056263*^9}, {
   3.470521025492722*^9, 3.470521036859899*^9}, {3.490980935948655*^9, 
   3.490980936361602*^9}, {3.490980971837779*^9, 3.4909809867359343`*^9}, 
   3.4909810380316467`*^9, {3.49098109009474*^9, 3.490981094872306*^9}, {
   3.490981128868085*^9, 3.490981158255353*^9}, {3.490987097372437*^9, 
   3.490987127835669*^9}, {3.490987161909676*^9, 3.4909871677332897`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwLyk9STGVgYGACYnUQ7RDJAAYHtA0PCP4Ty3aIboDwdaYKJLlvuuMQB5XX
/em26WGupEOCA4SvH2c3vXaRvEMiVL1B4tsrUbtcHZIOQPiGoswrbR0ZHFKg
+g1PhK9WOcrnkArVb1T9KEG6XsohDarfWH/u5Du11x3SofqNH7cIPi7b7pAJ
1W8yfWKhn5acQxZUv6n3wbcJpm8dsqH6zRiE3NXv9zrkQPWbbalfe0N4pUMe
VL95Jvsa5fo/DvlQ/RayKyQTli5yKIDxL8XzTmGb51DwAMK3bNe6vtOsyKEQ
ar6VDefXs1/6HYoUoPwPv/kc/t1wKILaZ730z6uayeUOxQkQvk00X1Eo/0WH
Eqj9tgJ6KwzS+R1KFkD5R2OWHil2dSiF2m9XNX1moLmtQynUfnv9e4cdp99w
KIPab//UsETR+4JDOdR+B1/31ly2XIdyqP0Oy39XTgu771ABtd+RaUuQXgq3
QyXUfsfYwgvMa/IdKqH2O+4w3tH3q8ShCmq/k9DPqw3LZzlUQe13yj38JTok
wqEaar/TiYnPpKyZHWqg9jsrJ9c97Et1qIHa71xnMXX7xLMOtVD7ne8Zv1bJ
nu1QB7XfRdvFIu3oHwAPK8I2
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{100., -40.},
  PlotRange->{{100., 480.}, {-40.3380194188903, -13.597168504969167`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.490980817178666*^9, 3.490980880305849*^9, {3.49098091714392*^9, 
   3.4909809457585*^9}, {3.490980976916857*^9, 3.490980996487832*^9}, 
   3.490981038031851*^9, 3.490981104698765*^9, 3.490981166839899*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution of the diffusion equation under dift and selection", \
"Subsection",
 CellChangeTimes->{{3.490979205654916*^9, 3.49097920942798*^9}, {
   3.490979250874452*^9, 3.490979272858083*^9}, {3.490979349769992*^9, 
   3.490979354242537*^9}, 3.490979608708366*^9, {3.490979723568087*^9, 
   3.49097975090125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Diffusion", " ", "model", " ", "with", " ", "partial", " ", "selfing"}], 
    ",", " ", 
    RowBox[{"following", " ", "Caberallo", " ", "and", " ", "Hill", " ", 
     RowBox[{"(", "1992", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"mdelp", "[", 
      RowBox[{"p_", ",", "s_", ",", "h_", ",", "f_"}], "]"}], ":=", 
     RowBox[{"p", 
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], "s", 
      RowBox[{"(", 
       RowBox[{"h", " ", "+", 
        RowBox[{"p", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "h"}]}], ")"}]}], "+", 
        RowBox[{"f", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p", "-", "h", "+", 
           RowBox[{"2", " ", "p", " ", "h"}]}], ")"}]}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vdelp", "[", 
      RowBox[{"p_", ",", "ne_"}], "]"}], ":=", 
     RowBox[{"p", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "ne"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"diffsol", "[", 
      RowBox[{"s_", ",", "h_", ",", "f_", ",", "ne_"}], "]"}], ":=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{"vdelp", "[", 
             RowBox[{"x", ",", "ne"}], "]"}], 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], 
             "/", "2"}]}], "+", 
           RowBox[{
            RowBox[{"mdelp", "[", 
             RowBox[{"x", ",", "s", ",", "h", ",", "f"}], "]"}], 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"x", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}], "f"}]}], ")"}], "^", "ne"}]}], 
         ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "1"}], "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
       "u", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "60"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", "0.005"}], ",", 
       RowBox[{"MaxSteps", "\[Rule]", "20000"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.490979519149187*^9, 3.490979550273305*^9}, {
  3.490987247041786*^9, 3.490987265833445*^9}, {3.49098733802991*^9, 
  3.4909873435268097`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsolution", "=", 
  RowBox[{"diffsol", "[", 
   RowBox[{".5", ",", ".5", ",", "1", ",", "1000"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4705861897277403`*^9, 3.470586199614636*^9}, {
  3.47058623698278*^9, 3.470586238070654*^9}, {3.470586571503459*^9, 
  3.470586593190343*^9}, {3.4705866796692457`*^9, 3.4705866829827757`*^9}, {
  3.470587802089218*^9, 3.4705878025808287`*^9}, {3.470587857461774*^9, 
  3.470587858359475*^9}, {3.4749175096018744`*^9, 3.474917513361224*^9}, {
  3.474917551462834*^9, 3.4749175548157682`*^9}, {3.490979881418951*^9, 
  3.490979890452005*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "60.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.4749209593798923`*^9, 3.4909855824530697`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "/.", "dsolution"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "60"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.470259227474532*^9, 3.47025926533215*^9}, {
   3.470259312771401*^9, 3.4702593195446568`*^9}, {3.470400262511775*^9, 
   3.470400279162094*^9}, {3.470400389876752*^9, 3.470400438214398*^9}, {
   3.47040078163853*^9, 3.470400782108189*^9}, {3.47040082154198*^9, 
   3.470400822332137*^9}, {3.47040097282157*^9, 3.470400973045795*^9}, {
   3.470402706012205*^9, 3.4704027073129053`*^9}, {3.470402782409672*^9, 
   3.470402782724324*^9}, {3.470402947395144*^9, 3.470402947744463*^9}, {
   3.47040308219144*^9, 3.4704030827258997`*^9}, {3.470408126703794*^9, 
   3.47040812706124*^9}, {3.470408358772627*^9, 3.4704084025497913`*^9}, {
   3.4705190040464*^9, 3.470519112163558*^9}, {3.4705191982404633`*^9, 
   3.470519229449728*^9}, {3.47051926996329*^9, 3.470519270805361*^9}, {
   3.470519306524727*^9, 3.470519306718258*^9}, {3.470519481488727*^9, 
   3.47051948172301*^9}, {3.470519553693823*^9, 3.470519554089961*^9}, {
   3.470519728127947*^9, 3.470519754682675*^9}, {3.470520161656983*^9, 
   3.470520163436069*^9}, {3.4705813801049347`*^9, 3.470581381277986*^9}, {
   3.470581418457253*^9, 3.470581440981045*^9}, {3.470581484945011*^9, 
   3.470581485733488*^9}, {3.470581784709111*^9, 3.470581789872344*^9}, {
   3.470581844538279*^9, 3.470581844600421*^9}, {3.470581945601851*^9, 
   3.470581968414113*^9}, {3.470582108657806*^9, 3.470582109824388*^9}, {
   3.4705821589568157`*^9, 3.4705821593675737`*^9}, {3.470582199459216*^9, 
   3.470582221980138*^9}, {3.47058238199236*^9, 3.4705823822953978`*^9}, {
   3.4705825476931543`*^9, 3.470582548319914*^9}, {3.470582771177367*^9, 
   3.4705827715649443`*^9}, {3.470583098171104*^9, 3.4705830986219254`*^9}, {
   3.470583241050068*^9, 3.4705832421656113`*^9}, {3.4705835038890963`*^9, 
   3.470583504323543*^9}, 3.470586409427722*^9, {3.470586629403574*^9, 
   3.470586633606296*^9}, {3.470586690117179*^9, 3.470586690351776*^9}, {
   3.470587862353015*^9, 3.470587863152492*^9}, {3.47491751784175*^9, 
   3.474917518112075*^9}, {3.47491755838433*^9, 3.47491755865388*^9}, {
   3.4909798937615347`*^9, 3.490979894724636*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFnXlYTd/3x4tMUUgyJJKLDCUZ03BuhjSZ50iGQnErc0TCR8bIRUqmFEKG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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNm3n8R+WUx5/7rCSRSsZkaVUpFSGVSmQnCi1GQ9Yh0wyyRDOWCY2ayi7C
WBpFDDPWGkqGhJKlyFJCDWPJIFsx7/dz7rxe88f3de/vfu/33mc553M+53PO
76Cjj9zyr1NKOaX6I46F4305bsylq1IaT+bSvVLqb+TzKK5/PO6b93Le+X75
IffejuOX1vMtOPKc9jyO3NbO5vOvnO/L/Z/j2LjnDnxxIedfXn/L/f1Azm/D
vc/l6PtvxT2/5l2ncjya63fmnody/kLO7x7fe186it/vst7v+T6c35bzMznf
O56ZTuOcd+fNOf8Tz3lYPMfn9UfG/e1YjvfmOveXN/D38Zzfifc/mPOXce11
rMdzeM53+Tydz6Zc/wfu2Y57HsTfV/Lx/bfm+iu4vgPXeX57Oefbc/4Qvvs2
n6fwuSXXP8b1r3Bkkdrfc861ej++uwUf57n53Ja0MN50NeNkHxJzrAcwlgs4
/z7Hv+H77/B5Gh++a8xp4UftA9zH75cncc9nOH6Tzze4thnHu/LcTWP+yynr
mryH809zztjTjdy3B+fb8HFeb+e4Lde3YgyHcLw9z78513bifH/uZVx1a+77
HUfu6wfzHfd03t3+juuD40e5xh5nnrFssD6fe8t7ObLGebt4ztiPa4yvv55z
nl3Yv/6m+N77FvdjL85dzz3Xc9a5fJh3fJDv+X1/NMdj437H1x/HkTXou3L/
fVYbZm6dfch3Cxuud48x13vyW96dt+S+yzg/l3PWLDG34f3/xf1/xfVPrGv4
W64/lXP8oWsTl8VvnfOyx7qer+L8butzXsR9PDPtyLuwwfZFvnsi19yTu/DB
jtNHwh6Wm4QPVvwmncWR5zb3kj3ou4Q/ef+C/fQncL4zx8dzz8VcY06dd9bL
+e2/cO35rNHD49mZ9y9v44NPlOv5YIMJvy3P4rvKR6P7Ab/5C+75Z47/w7M2
iLXoN+PvX4RNeL09k/NzuH5Tfs93id9kfKRsyDnrno/hu5vEes17OE+Hcv1v
GRtrkRhTY/0W7CRdx+cI/taewYCm74NNC/e13/Nb/ds94O+yCeeu+3GcY4vJ
+YM3zfs/uY7z5zFH51rw2cS4C+9p+sz53MMY+83D7vtGXGdMy2fWc3xuwZ66
+MW+JubZ2IuCH6ZfcXwJYwOTFrCt787f7HdiXzLPbtj9wn41bKbh70nfYB2K
D3sM9/C7Im6xRxkfzPh7dg6sZ95kxTTmXrQv/Doz5s6+LNh4Fzt/ynVsOeNn
7YTYq/l8bVa7P5Hrv+TaOzky1v6QuF7fxeeE2KMOzgx8oWCjHawrjCFhh/kF
3POE8B/H3/UHbKQ/lg/3Jvy1MqfyiDjP/8bf4hX7VljHIm7x3vx+zsVY3pnB
ouIY3sH52fEcsaIfyXXmubAu5WQ+4HB6H/f8O9+Jw8ynPpDrxhUx2X0kXixg
deEd9c85x2bLpfwG+0135PiA8IXK78cJgT/Gmfobvrsmnpl5ZmOehXUa2o+Y
9iGuY6MF20zMKWPThXVKHPOneOZ/cE78qdhrFUtfzTWx+KLA0O4e/oR7jEMH
BQYmnld/zHPA9YRNZNeUe5Z/4nueXf+Sc/yysb75jhETjY0FO1jY78J9jbEU
fHYwj8L+JDH6s/wWrFqYTyXWtjdzvnPYRsf2k9+zro13LyeGndeNI8aWk3gW
+JV/xnVsehDrC2vV8ZPB2hXWpr+Vc+yjEEc7zx6MtfCbTgwf2EHBJjt7OvDv
gm90/GQczjn+2Nn3AQYVnt3Zx8FeFHyyY7uD+RbiY2dOQ3t5Bues+0LsyfrG
f3Odews42LDNfv+I502sPynwpLu/PCcbQ/C19LM4T9jOwK+yuAXGDG2L+Nrd
u8O4DvZ07R3fTuxP5rnl2Ph9wdfrdqsd/jpiyPKHiBPj5RHn/O0Cxi+uKWu0
PH4933/di2s53m69ToxIX+XIWi3MKWEbfbf4vTFowA0y97eNYv/n3H2nfqcN
fY974Bv1VitfIv4tjDOBBwMbKOIcx2Fs95lwgYX1X8CFRY7x+xi/PGCOAVxd
GNuAq1TsrN+Dv9njBXxMt17n8aOYS3tKrEkDE8bG4QPt8OBy+c/4LX5fwc50
SthMPY/zkyNGyz0yPtkPWmO9cQQ86/sEd3C+FTxK/8m5WLZX8JsOJjZi1CLP
5F19q+A0HdzsWwR36cZmffCVgVd9u+BbXT7wrZiz7+3bBD/r2wbHE0+7Povf
pFPDnvsdg4f1LYOPOFbHueB/ua0851Hhk5NLwH2XG1cOtmfc20rEyhknwZkO
J0vYc/3HlS/5nGtjPTOxqONn45aBLw17HLcI3GmHBvbnjQL/tWnt2ft93+R+
a0ye4+R9Y6PAynbIOoatYo37gyKWdPjqOD7su2PDy5Hr+Fus+dyTPeM387li
jeNlrhn/G4yvMO4OVi9y6F+svgm2F3Ctg+MDOyuuN/xgsM6F9ervXG1YH3IM
rHvhmZ0YMOD2hX3u745YMmMKdjj4FG0GjjTgYAVs76zhMKZqb6ztYB8K4+z4
ymCPinwHexzwm0Jc6NjEwD4yc+zwhoHNZOy/w0P6A2NtxY2BD+QbOCdWDt6Z
tZlnx7qJM+LNYLwFH+7E78GcCljTWYNBzCr8voufxMTCO7rxY++Iux3bGuBo
0e6IDYO1LeLGazjHrot8GDwfcnf2tr+Fc/hbARe6eQXzznDJTjwb7E1hnh2/
GoypiHmnc844C+vasa/BPhQwtIOdA1soxuczONc/3V+45mB/ipiJbw32vWjP
+O0wpvKsTjwd2FDBPjpxd7yY37rmn+ecYyZmdjjRMA/BBrr4umvsnbF/yBWw
nQ5nauKUWCEflmuAad04dIfgqYXfD/a/YB+d33b97RKO7PmA61awrZsP8vvl
N8F3Pc6/U8SIaYfGhSPiuyp33ifu8f581+AVxt2BHSzvDg45zMPMsdz7JwZW
TMz4Q5xPnN8+OGtnLONOwWU7MXdsF5y1wxMGflac7wtWnP9VxIIBhmYwtus7
mwU/69jT2DQ4QQcXxtbhY521GbeKWN7Ys7FJcJdOTB3YcpZrgwFjp+AN/aWc
7xJ8t+PTY9vgmh0OPHYM7tvZt7FN8MsOBo87B5/rcNSxc3DNTjwZdwkO3YkD
Y9fgl534NrDBwhw6camy9+kNYZ/ufxIjHhe2mcw3jlh9HDtcxJsd19ihTR0W
2J4/FzFwrhG2W4nxCb9p+wefWdjDZtwHzxd83dyqsGdJfs1eFDiXgaFgq5W4
bY5VmHvj2cv9InY0uEX6cDynEAfT1/jJ19Y4e8iaJ8mZDwg+tHwx4nqCEyzG
ZrkF46zmJuKOPAs+nr7Oc/hUbGHBD/O7IyYZmxpzTn/kXG5qvPp82J86Q90o
rmdzUDBxMV/eLeL2jN8bRJyb8c6cFk5n7t6/HDFzPsccT/72lnhXXnM8c7bi
fMGbQuxdjPd7xN/mMYuYbo6M/6tzFPNN57/3+rc5JbacwZNqjoYflBMins97
5I+fXJ/Jb/NpcfQec7sFvEvsUwGTE3aUX8tzzG/lutjnYozBnpLcjbVM2FcG
0zJ4Z77r3s29Bq+TfNvnyavMO8D/xPeZnDvp76zZ1HrOjLVuz4p1MDc2z1Vf
mDoD9l6/wT3M2ZzXXNqcuuEnBd9OcJvyonWtHAexob1vPeKf7WnBGSv+XnaO
+WXWMMmddo/16uYDzKWLO3Irnm++ap4q3zZXrebF91h/a765U/BUw/KiH34g
4v8CBqlFFNeJd+ZTApN8ZlY3uHzlcObIN8b9xRzK8YhBjL3IK8GsQrwrriVr
n4kvFV6w6Nvw8ySX2371VTmSGogc/49xPZtznBXPTMbPs9fjeaE1TN2P+S/a
hLay2ToueaW+Qhxf1DGwnaKWgi1k+EA/P75r53JdP2NcWe3AXEmugn0V7kty
HWMgMSxh9wW7KKxL0l7MV/HhRU3gnDgu5vng4tQriLPFsfOchViWsIH0o7ie
xEXxXM2KuN3Ed+Jfg/8XuG7CnzPYoU6jFpflMmIAcTUbW4ibizqYuaX+hM1k
/LBcE3apHZh/L+p95NbFd8vV5NRnhL00/Kdiv9l8S3y9Mjhd0cZcb20Zuy/a
Ahwkm58SG5L2iz00/DlhVw0sLu4b3CSDyWXr8ImM77Wjwqfa9/mNmpKaIXGv
iBPwjsy6Fuwuydf1Ye6bWgK2UrQLOFF+5eqzHJP6j3at5ip35Rnm8umjXIe3
JXhO+WTki+LZXNv3hy+qKc34vE/E6MZ4i9zthaH5zmvqOMR7NdfGu9sxgU9D
XLhfYGcGw/ttA5PVCdXQ1M/S5auWhc00x/9qwZP794x8YOYFtwttVs20ma9g
j+Y0BTtsagXqrx8PPXTqosRf856Z//Dcgp0m3pX3WvnAfnFfv0tgr7p1A3/N
DRvY1fHvxTXAX4r7Du5nOdoBgdtZrc31vX3so9zavEKOntWB2A9zse76Yg9d
7e3a9R6+V3Nd3G9tnWcl7i3Y8AK+LepCm8c6qROoa6jP+N76Jc43j/Grg7aL
Iv411/nwiIGZ+9Uv1bQz/ty+Es9t4px5DTE6vzk4ZuIZ+WPBExNrkB0vMT6J
Z8ajZ8d4y5mR68zxm++4R7yjfXfVNsHH9uKZeqR0aZr5uNqE43E9za3McwTM
ckz4tD7ezg/fbtYDTg5ca2LXMfEucy7zIZ8/czC4jnp4cyxvib1N+G45Os2X
Z+K3eon8Qa7QTlnHy5q1V8W9DV+auTD+OPnMkTHmzDpNTff1YZfNegT5UIMH
Ne3nJ5GPqwerrctX2jsCN8SEgn3O2PjB4L/JmH/pGjPl0mqL10R8bGBmgXOb
6xfeo0aSyIWzmps6JMcMtpmfJeJfxkfUXRK+kPlbbSZdwTl/q7vIqTI4pB6T
OGb2RS0n8YzMfeoxiWvZfHv/iBWV96tVz3ithilHg6O2W0TtwRpEs170zIgz
zRqQsVa9zDxPxzf3ltM+PWJMkzMYx4lv1VglEQLfM2NRf5k6jPqBGj8+WpzX
DbG2ZdVI1Epc9yo+7Rr2IF9O6uyHRo6S8Id8SPDxZFxWWzgp7q8HRc6XmENm
H8YzI/Z3xtbUssCncUzkjgkfy0dGvpjgsPmJkV8m80m1POJpwqayupe2rZah
Xi7/w97lCEXuKkdmr4p2KqdTs3bPwZFs3iaHgVsU9cgS658fH89Y4KTJOeov
YHomRmVij3Wl/PDAOLGu8hnuGfbfeX4jliZieHX8v4vzbG7vOstpyTuyOozc
w5jN+4p5s7qSNo8NV69JYtRBXCdrWHI3eft5Kye8YY3Fzw2frwfHu/RZtWf9
a2KER/V78wswKL0xeJ16QMLPM1zVnFhOncGa8tvAQGtD5sdqTZk43Xwmfl+t
JaqxbxjYXV0buaG5iFz7OYEJ5uIJXMinrnzmtLBjNYnEHDLc0BzdZ2Y1nq0C
t61vqWcksCqraTsvYyBjVfNIcJbs79XO5MzyNbHuCxE7rPm5R0192GdeH7Wb
mS9cGHHROtOsN6l/YF+JmJrhF9bi1JONl9brxDRj3nJx4Lm4aa6fwPfM++qB
YUttszWmnR5YtrCe5lnWvWZ91VhIjFAPSIw1q6mbB702Yon1S+uYxlA1bu2t
iUHWHFk3cwvrcmpomfdU5rfgAxVO0cRwYqp1nOI6GH/FYOuLO6z4KP/k3Y35
t6sD+xrPUbuWTzVrauzV5NX4Tnt9+MXEFmxFzd9YK6cWK+TuDd4mH5765z3i
3L1sF4S9zXzzjBXDsE/rw+Ys8iG1BDUF8aSbV6o5m3fBM63vzFrzp+P+dnp8
b/1IrrZYP7KmLH8w1zWfZw2Kz1HjM05Y41XTgzOroydwPWvP5o5v59wYh71b
txzwhfw9rqvFmYuakzGOrPambemTrFnRftwT90PtFvvODw6Ny7yjmesxvnQJ
19lvtauE3WT+VitK7HnWjqwXPTZ4yKyJyPm1wz3CNzO8rx0d51Ue5RzVJdTk
5P7q6cT/5bjAfTG/Wl/zXrC3mm8dEXtaiSvWUJo4rG6yBH/Uz/V36zTuuXsv
1pWrUnBmYlWFByby3oa/VmK2NZp28Dp25wA3rcwtGV/wy8rcrB+1RwbnmDm3
+tw3V4y1/k1ub32nPWrldQeE7qTmbJ7RLl05nlxi5Z1yCXlmtZYEBnfzNuuz
fxfzrNZl1CVuH1xTztnhKPXwiAttixXPXxK2PetW7GfFputhgcmNaxUbkbc3
67aHRnxp3iNmWwNhLk07Ia43c13XSu6gviVeYTuNvKyeHGvZe2D75E4nR0w1
HzTGTu1MfU+90NoZPqMuXVlXa0zq0uY6y/Hhn9bmZw1eTdN8wbqT/MMYJB/k
U61dgEnWC7q5BnNql8VvzX3ne+GPiTjQ9uNv4zIYofaibm9O2cAk84iZ+58Z
+cLMHd4b9RA1w7p7cATxRWwRY+a5/v6b4AnW1madaKeo4Uze/YOwefmjPNLY
1K6M+GXNuahzbrjmcO7VUZFbqYkurLs1R2PL/K3xxRzL+KNWJ7+/ZeRk1Rht
Xwd2av3a2k4Dtzv+N7UB5m3+vfB7c+85hucFZ15esPKc/dbxfn+18+PCz5q9
GeK/tqBNip/mVfKbN6SZYzawqsoB4AQN36pqE6xpA8uqMdSao/zgWWG36pnV
NT8g9MlqDGGOjXWo8ltr2jvF+M1rhzqrmoC9BUvgjvijDtzZczUDefjsP/lW
8JMqrrrOrqfx+f6hVc4xWMdm/Sq+Jt9Q86zG6ieH3l7N358aenjVHg8JLbSC
o9bH1bSr+wVOtm3jfb53+uBmwRNmrrhFjM0xztxQruT+mdM/JnTRmTtcsfr8
eSm0Pf6ucm9zJmvS3GMfgnp+NfY9KWoB1pXMz9ola74gfmn/8md4fJPbGhvA
IPMI+zHs2ahqrHLvDSNuVm35oaE/V2uUDwtdWq3KuKfem7GPdLOIBdb08p0D
H+Rl8jP1rJnDqi2rAduHoCbmujD2yvsGeU81N3l06MMz/r44sMM+GfV078vG
o5tGXMvGsg3WePf1wJYCNtujYm2g6tfXrnzMMckNHxj6edVvHhDadX5GzMVc
oJs3XRo1i3z1yit2WLkJeDB1WrUK4kmzT8j8xZ4s5l3Nd+Auzb32OYzFXoJp
DweHBj61BcbaxUZz2C0j7mXj3SYrb7z/yofU6G+zvvP6lcMcG9hSuZasKYiZ
cnPr8/L1fQO7itxzn5XncSnLv9STrDmeE/y3q+eZi8p9xQH9XCzOwdfUridn
u2/gZ5F7iD+PDMy1njzjn3FQDUTcl0daTxHv1FkZ42IdCzuYujRc0V6Hept4
jpqbdZpZr/lsHOVmE1/MB6+PPNRegkLeP4wF4qy6PzFi1pkPD99Xr5xYoDYo
p8SvrAFMvnnoen5djHnWweWs1qJfus7hsYFvDV82d7ZW2+1VkD+4jsZKObc6
iFz3Y+scj4j5qlM59pl7PiLeOd9dIl9Q22/wmX5RxNuhjVu3MS6639ZGjd/W
du8a503NRl33TYHzxqQZm5yjXFTuc9uVV/9wfRfzMmefv/11rJV1/Cbm2w8o
h1dfMG/3Ocayp4VfyYmdg20A9mzZu+X94sjEkxG/E6/klDP3eXLg2tQ5xXbP
je9q545djmo/k5zm62GHzb0SG49asUONaNOVVx627q/9fg+I9bEfwN5I8xox
cOY3X4w9mDh52or1l4Wtzvfqg08PjJjarzHoZsEVJmfw/IrYzzlm1wBe3d4U
+sPs07D+fHGM1XyiYs/JPhPzuOes++J77CNSuzkxsNr+o2FdipiljqltzHxK
v31P4Ixjr/bwuRdqUMZO9Za1PjD7GcxLwN+KH9qz1MDfyr32MrUD198ac7Qp
ezh5XwM/KvmienIzThB/5VrN/NF+LTCt4EMVf7A/qtmTYFzibzXTyljVbxsx
2P4ix6v92+cw986alPULYlSDM1d1e2ti4E2FT1tPaeBQtU4E/jXielV3VTPe
e8XSrwS+zfzr+OCQVY2RuNLuFX6/mOfDKSv5ifWFBn+tcFp1/qZd7BXrZr1J
DXpq0eQO1VyK2NH2XHVI3tWN+9b1WItmz5V5jLrZqeveXRDrXuScatRybvMO
8jhzuyb/eUU8v8lRiSHN+HZhYKyxeepmJ8T1Zi2AtWz24pjXfCRi37yOnZgD
NvHT/rgfrzzS3EgcfmU8Z2KfNTvX8KfruTjv3l0bNqWmav3ac69NPeTENeYe
GOOr+soxYa/2ABYxELwsxOBqfZNY2oxb9jDdwPGseMaM3TfEO+f6eO2XYdMT
614Xe2l8mvqDfS2vCpvWtl3zxd+bP+OXxd+qrdpTtnfMy3qfsc1nGBPVthe5
o7zEfFNOo456ati5tljlpPhl2zp0JnMle6Wr77F/lTH0b4W2JS/tV4WeJa/r
V4SGZR7Uvxe6mM/p9i9vFJytfzu0KnOozlzs/ZC79u+E1mZ871eG1iYHUz+w
hjHrF++KOFHAiawuxXzVJap6F7HA3rNZZzGvB7f6d0MLkz9YhzK+FuMde2k/
yeS66kS3Ds5m7+DU2vG5oa86dnCpXxJ8xV6gfmnE124upj5hD6rc0bq5foyP
9msix5j9bOpy4Id9dP3yyOfN3foPIseW5/SrQzds1rTEO33JnvVvhn5nzti/
EZqgeWK/OHSEqc2qD9j7hl1Zd5s9k2oCZ0S8tWdy1nDV+F8afu/59H3tQb2f
WGnd0VzFHMc4ajxVL1UbKfapmSPhS/Zc2H+illKxnfGM1afcI7Vv8ceeJ2tp
1mLkhuod1j7tY1CLtq7k+rHvs05pT4b91PZymGNhC83Ybw5uHquPWPv6YfiP
fuP/KWR9fPPgTtb+Zu+ouYs4zO/tmbFGU+ydIf5UtVx7UcDOqsbLOtqjOPNZ
e57VJa0LbBZcrqozuf/WWRyD9mC/44i5mqNXdWNrMh/iXM0ZPLB/cupFauIX
rnoR7y/2yahX4/uzNwa8sg9q5nFqTvYqsw/dtdshMH9ixadWzNEHto+40O2V
2PH/xQIw2f6ibo+Fmt5+afYST45v3x5rZS+T+WO3trxLcNquXqKeISdTj9k6
YkRfa58T5+2D3i5iRBe/7xSxpsoByffsI+3q+tZrzHNPirVyzaZu4/fskT1E
C2O1Ttp1cDUV77G+Y1+Gva/HBU+wj7vLla0Zmnv+KXif2kzFz9V7/d8BtZlF
jUkt8Y9xbu7c3Dv1quNS1OitsZuHspeJPNh+LXu6vT61nv3ib3u9Z4yDK9jf
1c2lwA/z6FkrOTdiYb8utAD/P2WIu/sGfxj23u4VvGLY27Jn8IRhTLjnGgvs
t7AH0R4j6x5ypN2mxD37JIyh3XxLrsU+9a+FrdvzYK3GHovZS/PiwDp71a1t
WR+3ft6/GnasLm2cnPe7DtYgxT+w0L5rc7cOj7bn39hiL+6wL3m/4C3D3FWt
xfWR1+we/Kcby+8WHKbbY7LrykPAGjXP2W9mHmmd19q8cdN8X7u0lmTdDAwf
5pdyKPM39teeErnHsD/3PsHBrNvKhf3flqHGyjvV/YY5tDVN8p8hx7X+yzuG
Wi3jVYe0jix3Vhuwr8Z8rOgH1wenXVYd2F6U2cOmPm8vllhhz8DGkT/OeqW+
qmZlD5I692vCPsW28fywtwW8s/ds9hh7VAcwHmtPzkfdwR4t81trvfZVysnV
f98b93Q5t9qmPYv7xnfWaOy3sO+ir1rw7IOwl6Kvz2fPqjmHff7gaJUv2yv4
iuClxvjyszUXsM7zhcizzK/s66/2RGGf9kwu2Lv1nlnrcb7YpD2WU3s0Xonz
ztdage+yzsJc7Rv0/xGsK1lv1T6Xj0ScmDr8mTFH133WbOUQ9gzZ8yZWwiWW
l0W8ya6L/SP+XwOYt1wVMdfeLWu75quzZ4ZYZT3P3rDZo71F5IAz7yDWmCsV
MGhYgz93jf/2fsk5nxH4XM2TxNTnRa3OOosxwxzWvNZeZvn95PnGRDn81sH3
/q9/xR5m++LM7au1AffRPk57EtQq7RewJ/L8WPuh1kYstS5vf7K6jVqzsU8d
W83dWKk+YBx0DtYuZ80du1aTUUM0bvo/C3Kizvms9dvDTw5ZnYt8yhi9bYzB
3o7q/3Swx/YutiPCtq3D22O+gN1F7LgubGzWyq9Y9ww/qtbw/X8Z3mcvi3US
+3Jnf5Q9OJ6zV/YP2Cdczc+c9wmBsdkeS3v/bgybt+br/x/NGj3PU6Odtmd/
gHoDeOr/NMweEvv38e/qOqgnidHnBHc2F5j1G/ES/6jq58QCe5KrPNreVzkd
a5YOX7mWdglezb5q+RHfDffi2bHOBYydmsnZESPm/wfJwcwbfx5jtFY+ew/k
uBcE/s4eA3tyzDfll/YVXBTc0jrgrKH4/zHYYrV3SM74jvW328Sz7dFSa5m9
ka6P87Kv6LLg8GKLvYVTizBv9//P5LFqM/6v01tjHBPn3hx7516rGdkz6/9P
zXqZPmzOAp7Zu2sv2LzfcZtTvG71wU9EDDE/s7c27xbc2NxNXjZYs2pOaTyx
9wnMV/P2fbNX8t6BP1U9DH+293XWU+SZ6iynr2O2l0Zda8+wQ/9HxHhhf+js
r5AbiR2+y1rztYEjc66sX5X/2yPv/8GdFeu5vO1/AbwFGEA=
         "]], 
        Polygon3DBox[CompressedData["
1:eJw1m3vgvvV4xz/nu1VaaFMYGqZVDiGUtg4kh0lKbTl1sKnQIk0/1Tog5lSJ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         "]], Polygon3DBox[CompressedData["
1:eJwt13X8bUUVBfB9Z8/Mz1YMbOFZqDxABFRMBLtFMLAQW1DsTrAFHojtw0Z9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         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0r8vXmEUB/Bzr/u+qkX9A22DTVKbiKJpFBWvpTo0SBcbkVo1/gASZu1c
YW0ktRATiVgVbf0oBokEiaTsPjfv8M3nnDuc57nn3sHJ0frPEZHILG7KdfJb
qiKybn0d3/EF37OZn9jJCQ5wmiOck3n1OJf4hSvl2dkGv3KHy/zD1YjCT2e9
VW9FFM1Nm/R9cufZL16K89M9vaT7lMSs9EAtSa47pxLmpvnsv5Q4pMQRJY4p
cUKJf5Q4pcRZRMWamf1yrz/ntQy5a76nXXf/z01e0P2z/Hzvm21zgeuc4Q9O
cVG+q8doFzFMu4kS7So6aH/x0hn2lzSon9vHR3dq1D+TW8+e8ko+eN6rr2UP
a5h/q2p28Qnf8DFf07dMnRGP2M5KvmKRbSyY+Y2ZvpUVbGGq9C5JKf83HgBe
sUgP
       "]]}, {Line3DBox[CompressedData["
1:eJwVz7k2g1EUBtAj8t8YW40hElOIisrQkRdQSK9JJ3gBw0NlLTOleQxC41Fs
xV7fd879h3U3mlul7Yjooh6RX4/I9iNyv/paRHo05/SavsSTuVsus8Imq3YH
3OsLMs+d3uJZPyTThxlhjFG7I3w/LcrEg/8MmYv6Mf/vFvDPNE5JP+FVb0QU
dvUXvcyEfsq7fVP28GY/yZR+Jq+d7ei9tM3TzOjn9nvykz4+7CvM4vvZBR36
+bKb87z7phvzJT8M8G1368x9U9V8JefloKz/AVY5Kdg=
       "]], 
      Line3DBox[{1095, 1640, 1811, 1094, 742, 1096, 1597, 1624, 1927, 1294, 
       1598, 516, 1417, 373, 1500, 1719, 1746, 1418, 1295, 1519, 415, 1419, 
       1296, 1520, 1908, 1411, 1297, 1097, 1412, 1641, 1894, 1098, 1413, 1642,
        1895, 1099, 1414, 1747, 1298, 1100, 1415, 1748, 1299, 1101, 1724, 
       1749, 1300, 1102, 1725, 1750, 1301, 1103, 1896, 1416, 1302, 1420}], 
      Line3DBox[{1105, 1643, 1812, 1104, 1644, 1813, 1106, 1421, 1422, 1645, 
       1897, 1521, 1522, 1372, 1424, 1303, 1523, 1524, 1909, 1373, 1426, 1502,
        1503, 1501, 1525, 1910, 1374, 1473, 1304, 1107, 1751, 1305, 1108, 
       1646, 1814, 1109, 1647, 1815, 1110, 1648, 1816, 1111, 1752, 1306, 1112,
        1753, 1307, 1113, 1754, 1308, 1114, 1755, 1309, 1115}], 
      Line3DBox[{1117, 1649, 1817, 1116, 1650, 1818, 1118, 1375, 1423, 1376, 
       1911, 1526, 1119, 1527, 1377, 1425, 1378, 1120, 1599, 1891, 1379, 1427,
        1380, 1529, 1121, 1898, 1428, 1474, 1429, 1122, 1756, 1310, 1123, 
       1651, 1819, 1124, 1652, 1820, 1125, 1653, 1821, 1126, 1654, 1822, 1127,
        1757, 1311, 1128, 1758, 1312, 1129, 1759, 1313, 1130}], 
      Line3DBox[{1132, 1655, 1823, 1131, 1656, 1824, 1133, 1381, 1430, 1825, 
       1720, 1530, 1134, 1478, 1528, 1479, 1588, 1135, 1600, 1721, 1925, 1431,
        1382, 1603, 1136, 1631, 1926, 1601, 1625, 1602, 1137, 1760, 1314, 
       1138, 1657, 1826, 1139, 1658, 1827, 1140, 1659, 1828, 1141, 1660, 1829,
        1142, 1661, 1830, 1143, 1761, 1315, 1144, 1762, 1316, 1145}], 
      Line3DBox[{1147, 1662, 1831, 1146, 1663, 1832, 1148, 1383, 1432, 1833, 
       1532, 1531, 1149, 1533, 1534, 1480, 1536, 1535, 1150, 1537, 1538, 1912,
        1433, 1384, 1151, 1664, 1834, 1152, 1763, 1317, 1153, 1665, 1835, 
       1154, 1666, 1836, 1155, 1667, 1837, 1156, 1668, 1838, 1157, 1669, 1839,
        1158, 1670, 1840, 1159, 1764, 1318, 1160}], 
      Line3DBox[{1164, 1765, 1319, 1162, 1605, 1766, 1320, 1606, 1609, 1610, 
       1437, 1730, 1900, 1321, 1504, 1386, 1438, 1506, 1322, 1505, 1543, 1914,
        1734, 1439, 1323, 1169, 1767, 1324, 1171, 1768, 1325, 1173, 1769, 
       1326, 1175, 1770, 1327, 1177, 1771, 1328, 1179, 1772, 1329, 1181, 1773,
        1330, 1183, 1774, 1331, 1185, 1775, 1332, 1187}], 
      Line3DBox[{1186, 1851, 1680, 1184, 1850, 1679, 1182, 1849, 1678, 1180, 
       1848, 1677, 1178, 1847, 1676, 1176, 1846, 1675, 1174, 1845, 1674, 1172,
        1844, 1673, 1170, 1843, 1672, 1168, 1387, 1436, 1733, 1899, 1542, 
       1167, 1540, 1541, 1435, 1385, 1166, 1539, 1913, 1732, 1434, 1608, 1607,
        1165, 1741, 1842, 1604, 1161, 1841, 1671, 1163}], 
      Line3DBox[{1189, 1681, 1852, 1188, 1611, 1776, 1333, 1612, 1613, 1614, 
       1440, 1907, 1508, 1334, 1507, 1388, 1441, 1510, 1335, 1509, 1722, 1777,
        1442, 1336, 1190, 1778, 1337, 1191, 1779, 1338, 1192, 1682, 1853, 
       1193, 1780, 1339, 1194, 1781, 1340, 1195, 1782, 1341, 1196, 1783, 1342,
        1197, 1784, 1343, 1198, 1785, 1344, 1199}], 
      Line3DBox[{1201, 1683, 1854, 1200, 1443, 1444, 1684, 1901, 1544, 1545, 
       1389, 1445, 1902, 1345, 1546, 1547, 1390, 1446, 1512, 1513, 1511, 1723,
        1786, 1475, 1346, 1202, 1787, 1347, 1203, 1788, 1348, 1204, 1685, 
       1855, 1205, 1686, 1856, 1206, 1789, 1349, 1207, 1790, 1350, 1208, 1791,
        1351, 1209, 1792, 1352, 1210, 1793, 1353, 1211}], 
      Line3DBox[{1213, 1687, 1857, 1212, 1391, 1448, 1731, 1892, 1515, 1514, 
       1548, 1392, 1450, 1688, 1893, 1549, 1550, 1393, 1452, 1517, 1518, 1516,
        1628, 1928, 1447, 1626, 1354, 1214, 1794, 1355, 1215, 1795, 1356, 
       1216, 1689, 1858, 1217, 1690, 1859, 1218, 1691, 1860, 1219, 1796, 1357,
        1220, 1797, 1358, 1221, 1798, 1359, 1222, 1799, 1360, 1223}], 
      Line3DBox[{1225, 1692, 1861, 1224, 1394, 1449, 1395, 1915, 1551, 1226, 
       1552, 1396, 1451, 1397, 1916, 1227, 1615, 1398, 1453, 1399, 1616, 1228,
        1630, 1924, 1590, 1627, 1591, 1229, 1800, 1361, 1230, 1801, 1362, 
       1231, 1693, 1862, 1232, 1694, 1863, 1233, 1695, 1864, 1234, 1696, 1865,
        1235, 1802, 1363, 1236, 1803, 1364, 1237, 1804, 1365, 1238}], 
      Line3DBox[{1240, 1632, 1633, 1929, 1239, 1400, 1454, 1401, 1917, 1554, 
       1241, 1481, 1553, 1866, 1728, 1242, 1617, 1402, 1455, 1403, 1618, 1243,
        1635, 1740, 1930, 1634, 1592, 1244, 1805, 1366, 1245, 1806, 1367, 
       1246, 1697, 1867, 1247, 1698, 1868, 1248, 1699, 1869, 1249, 1700, 1870,
        1250, 1701, 1871, 1251, 1807, 1368, 1252, 1808, 1369, 1253}], 
      Line3DBox[{1267, 1371, 1810, 1266, 1879, 1708, 1265, 1878, 1707, 1264, 
       1877, 1706, 1263, 1876, 1705, 1262, 1875, 1704, 1261, 1874, 1703, 1260,
        1370, 1809, 1259, 1873, 1702, 1258, 1619, 1636, 1931, 1638, 1637, 
       1257, 1620, 1621, 1457, 1559, 1558, 1256, 1556, 1557, 1872, 1482, 1404,
        1255, 1555, 1589, 1923, 1735, 1456, 1582, 1581, 1254, 1918, 1459, 
       1458, 1460}], 
      Line3DBox[{1281, 1464, 1890, 1727, 1280, 1889, 1717, 1279, 1888, 1716, 
       1278, 1887, 1715, 1277, 1886, 1714, 1276, 1885, 1713, 1275, 1884, 1712,
        1274, 1883, 1711, 1273, 1882, 1710, 1272, 1881, 1709, 1271, 1406, 
       1463, 1562, 1561, 1270, 1560, 1919, 1736, 1462, 1405, 1269, 1726, 1880,
        1477, 1461, 1268, 1739, 1922, 1583, 1476, 1585, 1584, 1629}]}, {
      Line3DBox[{565, 737, 1742, 566, 742, 584, 1813, 749, 595, 1818, 760, 
       606, 1824, 770, 617, 1832, 780, 629, 1842, 1072, 1073, 791, 1766, 641, 
       1074, 1075, 802, 1776, 653, 947, 1032, 1901, 813, 665, 1034, 904, 1000,
        1892, 1001, 1002, 677, 1036, 906, 1915, 1004, 1005, 1006, 689, 1038, 
       908, 1917, 1007, 1008, 1009, 1055, 1923, 1042, 1076, 909, 1041, 858, 
       712, 1880, 951, 869, 725}], Line3DBox[CompressedData["
1:eJwVz78rxHEcx/G3+37y7ZIM/AO3+FlW7Ba3kJRRKcNJDOquqyulJCl2f4DF
ZrfYTBYuP/Pzshn8KKXkccOz169vn8/nO7u2WFqNiA7MRxTGItIghvjniM5z
Oi4PY4R/i8i36ZSsz47wo6vo3jEn/6Kqq9ELXKJpW6B/+hKt4wrXuLEtO88b
cvdmDdziDve29lm+T0newAMe8aRfsW/acplmL3jVr9OWbY9u2Yt0VO9fCwf8
jq5LXuIndId0V3Z36uYndcdymT/V9dBp3Qnfq5+R22d/4BNftjO996U+eR/f
fD8GbM1/ssMwqQ==
       "]], 
      Line3DBox[{408, 226, 1408, 266, 228, 1417, 287, 231, 1424, 293, 1425, 
       235, 424, 1528, 348, 349, 1480, 240, 301, 1435, 243, 1438, 304, 246, 
       1441, 307, 249, 1446, 312, 253, 1452, 316, 1453, 256, 318, 1455, 258, 
       320, 1457, 261, 326, 1463, 263, 470}], Line3DBox[CompressedData["
1:eJwV0D0vQ2EYBuBHT9Xf0JaNEaFNfPwEJqsmFon6TKWiqaiPMPkZEkEbfoDY
OjUWm8HAYDISotcZrtzPud/zvufNWayu5NcjYoCliMx0RFLliY2IXE9esskz
W7o0r9jmO2JoV+7ww3VEdkzW9BX5yx5/3Fgb1x+b6/yzr/Pp5FZmrKXvHvBK
Q5fIO/2aedDc5I1Dzzl9ek6bI95pud+X7HDCB6e69G6P3PNp35l8cEaJGcoM
6+3PFsgzy5zuXBYZZYR5FvQXcoIpJv27rm7Zuavmlz6HUizv
       "]], 
      Line3DBox[{570, 914, 1045, 473, 1566, 474, 412, 1014, 415, 938, 885, 
       979, 1910, 421, 960, 941, 1898, 983, 551, 1081, 556, 1926, 1071, 1070, 
       619, 1834, 781, 631, 1843, 792, 1767, 643, 803, 1778, 655, 815, 1787, 
       667, 826, 1794, 679, 837, 1800, 691, 848, 1805, 702, 1873, 859, 715, 
       1882, 871, 728}], 
      Line3DBox[{571, 915, 964, 1047, 1046, 956, 916, 1015, 1908, 917, 586, 
       751, 1751, 597, 761, 1756, 608, 771, 1760, 620, 782, 1763, 632, 1844, 
       793, 1768, 644, 804, 1779, 656, 816, 1788, 668, 827, 1795, 680, 838, 
       1801, 692, 849, 1806, 703, 860, 1809, 716, 1883, 872, 729}], 
      Line3DBox[{8, 358, 1487, 23, 1097, 38, 1108, 53, 1123, 68, 1138, 83, 
       1153, 98, 1172, 1173, 113, 1192, 128, 1204, 143, 1216, 158, 1231, 173, 
       1246, 188, 1260, 203, 1274, 218}], 
      Line3DBox[{572, 918, 965, 966, 1905, 739, 573, 919, 1894, 744, 587, 
       1814, 752, 598, 1819, 762, 609, 1826, 772, 621, 1835, 783, 633, 1845, 
       794, 1769, 645, 1853, 805, 657, 1855, 817, 669, 1858, 828, 681, 1862, 
       839, 693, 1867, 850, 704, 1874, 861, 717, 1884, 873, 730}], 
      Line3DBox[{574, 920, 967, 968, 740, 1903, 575, 921, 1895, 745, 588, 
       1815, 753, 599, 1820, 763, 610, 1827, 773, 622, 1836, 784, 634, 1846, 
       795, 1770, 646, 806, 1780, 658, 1856, 818, 670, 1859, 829, 682, 1863, 
       840, 694, 1868, 851, 705, 1875, 862, 718, 1885, 874, 731}], 
      Line3DBox[{576, 922, 969, 970, 971, 1904, 577, 923, 746, 1747, 589, 
       1816, 754, 600, 1821, 764, 611, 1828, 774, 623, 1837, 785, 635, 1847, 
       796, 1771, 647, 807, 1781, 659, 819, 1789, 671, 1860, 830, 683, 1864, 
       841, 695, 1869, 852, 706, 1876, 863, 719, 1886, 875, 732}], 
      Line3DBox[{578, 924, 972, 974, 1906, 975, 579, 925, 747, 1748, 590, 755,
        1752, 601, 1822, 765, 612, 1829, 775, 624, 1838, 786, 636, 1848, 797, 
       1772, 648, 808, 1782, 660, 820, 1790, 672, 831, 1796, 684, 1865, 842, 
       696, 1870, 853, 707, 1877, 864, 720, 1887, 876, 733}], 
      Line3DBox[{580, 926, 973, 927, 1745, 1048, 957, 928, 929, 1749, 591, 
       756, 1753, 602, 766, 1757, 613, 1830, 776, 625, 1839, 787, 637, 1849, 
       798, 1773, 649, 809, 1783, 661, 821, 1791, 673, 832, 1797, 685, 843, 
       1802, 697, 1871, 854, 708, 1878, 865, 721, 1888, 877, 734}], 
      Line3DBox[{581, 930, 976, 931, 1049, 1920, 958, 932, 933, 1750, 592, 
       757, 1754, 603, 767, 1758, 614, 777, 1761, 626, 1840, 788, 638, 1850, 
       799, 1774, 650, 810, 1784, 662, 822, 1792, 674, 833, 1798, 686, 844, 
       1803, 698, 855, 1807, 709, 1879, 866, 722, 1889, 878, 735}], 
      Line3DBox[{582, 934, 977, 1051, 1050, 1921, 959, 935, 1896, 936, 593, 
       758, 1755, 604, 768, 1759, 615, 778, 1762, 627, 789, 1764, 639, 1851, 
       800, 1775, 651, 811, 1785, 663, 823, 1793, 675, 834, 1799, 687, 845, 
       1804, 699, 856, 1808, 710, 867, 1810, 723, 1890, 952, 953, 954}], 
      Line3DBox[{724, 868, 1052, 1054, 1053, 1922, 711, 857, 1040, 1918, 950, 
       700, 846, 1086, 1929, 1085, 688, 835, 1861, 676, 824, 1857, 664, 812, 
       1854, 652, 801, 1852, 640, 1765, 790, 1841, 628, 779, 1831, 616, 769, 
       1823, 605, 759, 1817, 594, 748, 1812, 583, 741, 1811, 564, 736, 912, 
       955}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJykvHk4Ve3bBiyh0ZQhUgkpypSEhKUolcpQSBEiMhRKNMgQKimZk5B5nufx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    "]],
  AutomaticImageSize->True,
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{422.2578426054372, 252.0235920539566},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 60}, {0, 1}, {-5.770982639907749*^-26, 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-1.4267053894190467`, -2.857041588718616, 1.1188498970527234`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{3.490985661297665*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "probability", " ", "of", " ", "new", " ", "mutation", " ", "in", " ", 
     "the", " ", "population"}], " ", "=", " ", "\[Mu]Ne"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"newmut", " ", "=", " ", 
    RowBox[{"0.0000000026", "*", "1000"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.490980172762637*^9, 3.4909802330509043`*^9}, {
  3.490980283540441*^9, 3.49098028400185*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Cummulative", " ", "probability", " ", "of", " ", "fixation", " ", "of", 
     " ", "a", " ", "new", " ", "mutation", " ", 
     RowBox[{"(", 
      RowBox[{"prob", " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2000"}], " ", "for", " ", "N"}], "=", "1000"}]}], 
      ")"}], " ", "is", " ", "based", " ", "on", " ", "the", " ", 
     "possibility", " ", "that", " ", "the", " ", "mutation", " ", "could", 
     " ", "arise", " ", "and", " ", "fix", " ", "in", " ", "any", " ", 
     "previous", " ", "generation"}], ",", " ", 
    RowBox[{
    "so", " ", "must", " ", "sum", " ", "over", " ", "all", " ", "previous", 
     " ", "generations"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gen", ",", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "2000"}]}], "]"}], "/.", "dsolution"}], 
            "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "1", ",", "gen"}], "}"}]}], "]"}], "*", 
        "newmut"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"gen", ",", "5", ",", "60"}], "}"}]}], "]"}], "//", 
   "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.474924469664299*^9, 3.474924548210074*^9}, {
  3.47492458810191*^9, 3.4749245884156637`*^9}, {3.4909802743343363`*^9, 
  3.49098027778767*^9}, {3.490981283259602*^9, 3.4909813093274384`*^9}, {
  3.490986631506682*^9, 3.490986633452209*^9}, {3.4909868861673403`*^9, 
  3.490986931682598*^9}, {3.490987021383819*^9, 3.490987034234239*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5", "4.59979704229383`*^-159"},
     {"6", 
      RowBox[{"-", "3.6844052283354357`*^-118"}]},
     {"7", 
      RowBox[{"-", "4.797122447562155`*^-90"}]},
     {"8", 
      RowBox[{"-", "6.634214813628549`*^-71"}]},
     {"9", 
      RowBox[{"-", "6.669670838558652`*^-57"}]},
     {"10", "3.9802809885105555`*^-48"},
     {"11", 
      RowBox[{"-", "6.516637699652096`*^-42"}]},
     {"12", 
      RowBox[{"-", "3.0935497564537623`*^-38"}]},
     {"13", 
      RowBox[{"-", "1.4049886876173717`*^-35"}]},
     {"14", "1.4499682948758266`*^-29"},
     {"15", "1.9569411011118055`*^-24"},
     {"16", "1.5820167262779613`*^-20"},
     {"17", "2.160093714253099`*^-17"},
     {"18", "7.258309976335402`*^-15"},
     {"19", "7.104577263911735`*^-13"},
     {"20", "2.511589666138876`*^-11"},
     {"21", "3.9886555646219485`*^-10"},
     {"22", "3.4202308781019577`*^-9"},
     {"23", "1.8300076955557898`*^-8"},
     {"24", "6.826061747216742`*^-8"},
     {"25", "1.9311629792278057`*^-7"},
     {"26", "4.4177956038819353`*^-7"},
     {"27", "8.579801210678985`*^-7"},
     {"28", "1.468070151938161`*^-6"},
     {"29", "2.2767495083335745`*^-6"},
     {"30", "3.2703198851089376`*^-6"},
     {"31", "4.423641143556303`*^-6"},
     {"32", "5.707134183899131`*^-6"},
     {"33", "7.091909327854149`*^-6"},
     {"34", "8.552657653196365`*^-6"},
     {"35", "0.00001006875659610875`"},
     {"36", "0.000011624248084623573`"},
     {"37", "0.000013207248364061284`"},
     {"38", "0.000014809163523186635`"},
     {"39", "0.00001642391946530684`"},
     {"40", "0.000018047300533890107`"},
     {"41", "0.0000196764235987694`"},
     {"42", "0.000021309340448951567`"},
     {"43", "0.000022944747698879423`"},
     {"44", "0.00002458178063461316`"},
     {"45", "0.000026219869634572725`"},
     {"46", "0.000027858641743797493`"},
     {"47", "0.000029497854055553566`"},
     {"48", "0.00003113734908891758`"},
     {"49", "0.000032777025157540894`"},
     {"50", "0.000034416816836303014`"},
     {"51", "0.00003605668210422955`"},
     {"52", "0.00003769659416654395`"},
     {"53", "0.00003933653592855737`"},
     {"54", "0.00004097649650583291`"},
     {"55", "0.0000426164689827232`"},
     {"56", "0.00004425644897371263`"},
     {"57", "0.000045896433702679126`"},
     {"58", "0.000047536421415146526`"},
     {"59", "0.00004917641100397774`"},
     {"60", "0.00005081640177150809`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.49098567780933*^9, 3.490986635716488*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{952, 811},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"7.0 for Mac OS X PowerPC (32-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 460, 7, 146, "Subtitle"],
Cell[CellGroupData[{
Cell[1052, 33, 369, 7, 49, "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[1424, 42, 2427, 59, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3854, 103, 1585, 34, 43, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5442, 139, 8048, 139, 238, 1009, 22, "CachedBoxData", "BoxData", "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[13527, 283, 319, 5, 34, "Subsection"],
Cell[13849, 290, 3289, 95, 118, "Input"],
Cell[CellGroupData[{
Cell[17163, 389, 603, 10, 27, "Input"],
Cell[17769, 401, 500, 16, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18306, 422, 2441, 39, 27, "Input"],
Cell[20750, 463, 111575, 1819, 267, "Output"]
}, Open  ]],
Cell[132340, 2285, 475, 12, 43, "Input"],
Cell[CellGroupData[{
Cell[132840, 2301, 1845, 45, 73, "Input"],
Cell[134688, 2348, 3016, 79, 1011, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
