#include <stdio.h>


#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>

int main(int argc, char** argv) {
	unsigned int start=0;
	unsigned int end=-1;

	if (argc==5) {
		start=atoi(argv[3]);
		end=atoi(argv[4]);
	} else {
		printf("%s scov_filename lamba_filename start end\n",argv[0]);
		exit(1);
	}
	printf("Printing from %u to %u\n",start,end);
	

	FILE *f = fopen(argv[1],"rb");
	if (f==NULL){ 
		printf("Error opening file\n");
		exit(1);
	}
	FILE *g = fopen(argv[2],"rb");
	if (g==NULL){ 
		printf("Error opening file\n");
		exit(1);
	}
		
	double * fs= (double*)malloc(sizeof(double)*(end-start+1));
	if (fs==NULL) {
		printf("Cannot malloc mem\n");
		exit(1);
	}	
	double * gs= (double*)malloc(sizeof(double)*(end-start+1));
	if (gs==NULL) {
		printf("Cannot malloc mem\n");
		exit(1);
	}	

	long go_to=(start-1)*sizeof(double);
	printf("Want to set fseek to %ld\n",go_to);
	int res = fseek(f,go_to,SEEK_SET);
	assert(res==0);
	res = fseek(g,go_to,SEEK_SET);
	assert(res==0);
	res=fread(fs,sizeof(double)*(end-start+1),1,f);
	assert(res==1);
	res=fread(gs,sizeof(double)*(end-start+1),1,g);
	assert(res==1);
	double sum_unmasked=0.0;
	double sum_masked=0.0;
	double sum_expected=0.0;
	int masked = 0;
	int index=0;
	while (index<(end-start+1)) {
		printf("%d\t%.4f\t%.4f\n",index+start,fs[index],gs[index]);
		sum_unmasked+=fs[index];
		if (gs[index]>0.0) {
			sum_masked+=fs[index];
			sum_expected+=gs[index];
		} else {
			masked++;
		}
		index++;
	}
	printf("SUM unmasked %.4f\nSUM masked %.4f\nSUM expected %.4f\nRepeat masked %d\n",sum_unmasked,sum_masked,sum_expected,masked);
	
	
	fclose(f);
	fclose(g);

	return 0;
}
