#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>

#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "include/dbtypes.h"

#define BUFF_SIZE 10000



void usage(char* program_name) {
	printf("%s index_filename contig_name contig_length\n",program_name);
	//printf("%s index_filename contig_name contig_length window_size min_normodds min_sum\n",program_name);
}


int compute_normodds(char* index_filename,int sequence_length, char* contig_name, double** contig_sum_normodds,double** contig_min_normodds) {
	//Allocate the doubles array
	*contig_sum_normodds=(double*)malloc(sizeof(double)*sequence_length);
	*contig_min_normodds=(double*)malloc(sizeof(double)*sequence_length);
	double * sum_normodds=*contig_sum_normodds;
	double * min_normodds=*contig_min_normodds;
	if (sum_normodds==NULL || min_normodds==NULL) {
		fprintf(stderr,"Trouble allocating memory for arrays contig_normodds\n");
		exit(1);
	}
	int j;
	//zero all the entries
	for (j=0; j<sequence_length; j++) {
		sum_normodds[j]=0.0;
		min_normodds[j]=1.0;
	}	

	FILE *f=NULL;
	if (strcmp(index_filename,"-")==0) {
		f=stdin;
	} else {
		f=fopen(index_filename,"rb");
		if (f==NULL) {
			fprintf(stderr,"Error opening index file\n");
			exit(1);
		}
	}
	mapping_t_small buffer[BUFF_SIZE*10];

	int empty=1;
	size_t read_in;
	while((read_in=fread(buffer,sizeof(mapping_t_small), BUFF_SIZE*10,f))>0) {
		unsigned int i;
		empty=0;
		for (i=0; i<read_in; i++) {
			if (strcmp(buffer[i].contigname,contig_name)==0) {
				uint64_t start=buffer[i].contigstart;
				if ((start>=sequence_length || start<=0)) {
					printf("%llu>=%llu or %llu<=%llu\n",start, sequence_length, start, 0);
				}
				assert(start<sequence_length && start>0);
				sum_normodds[start-1]+=buffer[i].normodds;
				if (buffer[i].normodds<min_normodds[start-1]) {
					min_normodds[start-1]=buffer[i].normodds;
				}
			}
		}
	}
	


	fclose(f);

	return empty;
}



void get_window_stats(int start, int window_size, double* contig_sum_normodds, double* contig_min_normodds, double* sum, double *min) {
	*sum=0.0;
	*min=1.0;
	int i;
	for (i=0; i<window_size; i++) {
		*sum+=contig_sum_normodds[i+start];
		if (*min<contig_min_normodds[i+start]) {
			*min=contig_min_normodds[i+start];
		}
	}
	return;
}


int main (int argc, char** argv) {
	if (argc!=4) {
		usage(argv[0]);
		exit(1);
	}

	char* index_filename=argv[1];
	char* contig_name=argv[2];
	uint64_t contig_length=atol(argv[3]);
	//int window_size=atoi(argv[4]);
	//double min_normodds=atof(argv[5]);
	//double min_sum=atof(argv[6]);	
	//assert(min_sum>0.0); //Need this because of window_stats

	//compute normodds for contig
	double * contig_sum_normodds;
	double * contig_min_normodds;
	int empty = compute_normodds(index_filename,contig_length,contig_name,&contig_sum_normodds,&contig_min_normodds);

	if (empty==1) {
		exit(1);
	}
	//write it out
	char* filename_out=(char*)malloc(sizeof(char)*(strlen(contig_name)+15));
	assert(filename_out!=NULL);
	strcpy(filename_out,contig_name);
	strcat(filename_out,".scov");
	FILE *f = fopen(filename_out,"wb");
	if (f==NULL) {
		fprintf(stderr,"Trouble opening output file");
		exit(1);
	}
	int res=fwrite(contig_sum_normodds,sizeof(double),contig_length,f);
	assert(res>=0);
	assert((unsigned int)res==contig_length);	

	//Now print out the antirepeats
	/*double window_sum=0.0;
	double window_min=1.0;

	int anti_repeat_start=-1;
	int i;
	for (i=0; i<=(contig_length-window_size); i++) {
		get_window_stats(i,window_size,contig_sum_normodds,contig_min_normodds,&window_sum,&window_min);	
		if (window_sum>=min_sum && window_min>=min_normodds) {
			if (anti_repeat_start==-1) {
				anti_repeat_start=i;
			}
		} else {
			if (anti_repeat_start!=-1) {
				printf("%s %d %d\n",contig_name,anti_repeat_start+1,i+1);
				anti_repeat_start=-1;
			}
		}
	}
        if (anti_repeat_start!=-1) {
        	printf("%s %d %d\n",contig_name,anti_repeat_start+1,i+1);
        	anti_repeat_start=-1;
        }*/

	fclose(f);


	return 0;

}
