#ifndef __DBTYPES_H__
#define __DBTYPES_H__

#include <stdint.h>

/* Read mapping struct */
#define READNAME_LEN    48
#define CONTIGNAME_LEN  32
#define EDITSTRING_LEN  32
#define CONTIGNAME_LEN_SMALL 6

typedef struct {
    char        readname[READNAME_LEN];
    char        contigname[CONTIGNAME_LEN];
    uint64_t    contigstart;
    uint64_t    contigend;
    char        strand;
    uint16_t     readstart;
    uint16_t     readend;
    uint16_t     readlength;
    uint16_t     score;
    char        editstring[EDITSTRING_LEN];
    double      normodds;
    double      pgenome;
    double      pchance;
} mapping_t;



typedef struct {
    //char        contigname[CONTIGNAME_LEN_SMALL];
    char	contig_number;
    uint32_t    contigstart;
    uint32_t    read_id;    
    char	orientation;
} mapping_t_small_readid;

typedef struct {
    char        contigname[CONTIGNAME_LEN_SMALL];
    uint64_t    contigstart;
    double      normodds;
} mapping_t_small;

typedef struct {
	char        readname[READNAME_LEN];
	char        contigname[CONTIGNAME_LEN];
	uint64_t    contigstart;
	uint64_t    contigend;
	char        strand;
	uint8_t     score;
	double      normodds;
} mapping_mrfast_t;


/* Coverage map */
typedef struct {
    double      normodds;
    char        max_f_readname[READNAME_LEN];
    double      max_f_normodds;
    char        max_r_readname[READNAME_LEN];
    double      max_r_normodds;
} coverage_t;

typedef struct {
    double      normodds;
} coverage_t_small;



void print_coverage_t(coverage_t * cov) {
	printf("\
			normodds: %e\n\
			max_f_readname: %s\n\
			max_f_normodds: %e\n\
			max_r_readnam: %s\n\
			max_r_normodds: %e\n",
			cov->normodds,
			cov->max_f_readname,
			cov->max_f_normodds,
			cov->max_r_readname,
			cov->max_r_normodds);

	/*cout << "normodd: " << cov->normodds;
	cout << "\nmax_f_readname: " << cov->max_f_readname;
	cout << "\nmax_f_normodds: " << cov->max_f_normodds;
	cout << "\nmax_r_readname: " << cov->max_r_readname;
	cout << "\nmax_r_normodds: " << cov->max_r_normodds;
	cout << endl;
	*/
}

void print_mapping(mapping_mrfast_t * mapping) {
	/* cout << "readname: " << mapping->readname;
	cout << "\ncontigname: " << mapping->contigname; 
	cout << "\ncontigstart: " << mapping->contigstart; 
	cout << "\ncontigend: " << mapping->contigend; 
	cout << "\nstrand: " << mapping->strand; 
	cout << "\nscore: " << mapping->score; 
	cout << "\nnormodds: " << mapping->normodds << endl;
	*/
/*	printf("\
readname: %s\n\
contigname: %s\n\
contigstart: %llu\n\
contigend: %llu\n\
strand: %c\n\
score: %d\n\
normodds: %e\n",
mapping->readname,
mapping->contigname,
mapping->contigstart,
mapping->contigend,
mapping->strand,
mapping->score,
mapping->normodds);
*/	 
}


void print_probcalc_mapping(mapping_t * mapping) {
	/*cout << "readname: " << mapping->readname;
	cout << "\ncontigname: " << mapping->contigname; 
	cout << "\ncontigstart: " << mapping->contigstart; 
	cout << "\ncontigend: " << mapping->contigend; 
	cout << "\nstrand: " << mapping->strand; 
	cout << "\nreadstart: " << mapping->readstart; 
	cout << "\nreadend: " << mapping->readend; 
	cout << "\nreadlength: " << mapping->readlength; 
	cout << "\nscore: " << mapping->score; 
	cout << "\neditstring: " << mapping->editstring; 
	cout << "\nnormodds: " << mapping->normodds; 
	cout << "\npgenome: " << mapping->pgenome ;
	cout << "\npchance: " << mapping->pchance << endl;*/
/*        printf("\
                        readname: %s\n\
                        contigname: %s\n\
                        contigstart: %llu\n\
                        contigend: %llu\n\
                        strand: %c\n\
                        readstart: %d\n\
                        readend: %d\n\
                        readlength: %d\n\
                        score: %d\n\
                        editstring: %s\n\
                        normodds: %e\n\
                        pgenome: %e\n\
                        pchance: %e\n",
                        mapping->readname,
                        mapping->contigname,
                        mapping->contigstart,
                        mapping->contigend,
                        mapping->strand,
                        mapping->readstart,
                        mapping->readend,
                        mapping->readlength,
                        mapping->score,
                        mapping->editstring,
                        mapping->normodds,
                        mapping->pgenome,
                        mapping->pchance);
*/
}

#endif /* !defined(__DBTYPES_H__) */
