#include<cassert>
#include<cmath>
#include<string>
#include<iostream>
#include<sstream>
#include<fstream>
#include<cstdlib>
#include<vector>
#include<map>
#include<list>
#include<queue>
#include<cstdarg>
#include<algorithm>

using namespace std;

typedef unsigned long int pType;

pType get_bowtie_rid(const string & buf) {
	// example: 3+:<24,11910070,2>
	istringstream line(buf);
	int i;
	char c;
	for (i = 0; i < buf.length(); i++) {
		line.get(c);
		if ((c == '+')  || (c == '-')) {
			return atol(buf.substr(0, i).c_str());
		}
	}
	cerr << "Encountered bad readname: " << buf << endl;
	return 0;

}


int main(int argc, char * argv[]) {
	if (argc < 3) {
		cerr << "Usage: idx_build <index_filename> <data_filename> {<mode> {<delimeter>}}.\n";
		exit(1);
	}

	string mode = "basic";
	string delim = "";

	if (argc > 3) {
		mode = argv[3];
		if (mode == "delim") delim = argv[4];
	}

	//open mapping file
	ofstream indexFile(argv[1], ios::out | ios::binary);
	ifstream dataFile(argv[2]);

	pType pos = dataFile.tellg(); 

	string sbuf;
	if (mode == "basic") {
		while (getline(dataFile, sbuf)) {
			indexFile.write((char*) &pos, sizeof(pType));
			pos = dataFile.tellg(); 
		}
	} else if (mode == "delim") {
		while (dataFile >> sbuf) {
			if (sbuf == delim) {
				indexFile.write((char*) &pos, sizeof(pType));
			}
			pos = dataFile.tellg();
		}
	} else if (mode == "bowtie_concise") {
		pType last = 948238;
		while (getline(dataFile,sbuf)) {
			pType rid = get_bowtie_rid(sbuf);
			if (rid != last) {
				indexFile.write((char*) &rid, sizeof(pType));
				indexFile.write((char*) &pos, sizeof(pType));
				last = rid;
			}
			pos = dataFile.tellg();
		}
	}


}


