#ifndef DEFS_H
#define DEFS_H


#include<cassert>
#include<cmath>
#include<string>
#include<iostream>
#include<sstream>
#include<fstream>
#include<cstdlib>
#include<vector>
#include<map>
#include<list>
#include<queue>
#include<cstdarg>
#include<algorithm>



using namespace std;


//print vector of vectors
template<class T>
ostream & operator << (ostream & out, const vector<vector<T > > & v) {
	out << v.size() << endl;
	if (v.size() != 0) {
		out << v[0];
		for (int i = 1; i < v.size(); i++) out << endl << v[i];
	}
	return out;
}

//read vector of vectors
template<class T>
istream & operator >> (istream & in, vector<vector<T > > & v) {
	int count;
	vector<T> row;
	in >> count;
	v.reserve(count);
	for (int i = 0; i < count; i++) {
		row.clear();
		in >> row;
		v.push_back(row);
	}

	return in;
}

//print vector of T
template<class T>
ostream & operator << (ostream & out, const vector<T> & v) {
	out << v.size() << '\t';
	if (v.size() != 0) {
		out << v[0];
		for (int i = 1; i < v.size(); i++) out << '\t' << v[i];
	}
	return out;
}
//read vector of T
template<class T>
istream & operator >> (istream & in, vector<T> & v) {
	int count;
	T val;
	in >> count;
	v.reserve(count);
	for (int i = 0; i < count; i++) {
		in >> val;
		v.push_back(val);
	}
	return in;
}


template<class T>
string make_string(const T & s) {
	ostringstream o;
	o << s;
	return o.str();
}

string add_commas(int num) {
	string s, retval;
	s = make_string(num);
	for (int i = 0; i < s.length(); i++) {
		retval.push_back(s.at(i));
		int j = s.length() - 1 - i;
		if (((j % 3) == 0) && (j != 0)) {
			retval.push_back(',');
		}
	}
	return retval;
}

// Generate a random integer in the range [min, max]
inline int randNumber (int min, int max) { return min + int((((double) rand()) / RAND_MAX ) * (max - min + 1) ); }

// Generate a random double in the range [min, max]
inline double randNumberDouble (double min, double max) { return min + (((double) rand()) / RAND_MAX ) * (max - min) ; }


string revcomp(const string &s) {
	string t("");
	for (int i = s.length() - 1; i >= 0; i--) {
		if (s[i] == 'A')
			t.push_back('T');
		else if (s[i] == 'C')
			t.push_back('G');
		else if (s[i] == 'G')
			t.push_back('C');
		else if (s[i] == 'T')
			t.push_back('A');
		else if (s[i] == 'a')
			t.push_back('t');
		else if (s[i] == 'c')
			t.push_back('g');
		else if (s[i] == 'g')
			t.push_back('c');
		else if (s[i] == 't')
			t.push_back('a');
		else if (s[i] == 'N')
			t.push_back('N');


	}
	return t;
}

char complement(const char & c) {
	if (c == 'A')
		return 'T';
	else if (c == 'C')
		return 'G';
	else if (c == 'G')
		return 'C';
	else if (c == 'T')
		return 'A';
	return c;
}
string complement(const string &s) {
	string t("");
	for (int i = 0; i < s.length(); i++) {
		if (s[i] == 'A')
			t.push_back('T');
		else if (s[i] == 'C')
			t.push_back('G');
		else if (s[i] == 'G')
			t.push_back('C');
		else if (s[i] == 'T')
			t.push_back('A');
	}
	return t;
}

char mid_char (const string & str, const int & beg, const int & len) {  //len should be odd
	return str.at(beg + ((len - 1)/ 2));
}


void flip( bool &val) { val = !val; }

bool get_row(istream & inFile, vector<string> & row, char delim = '\t') {  //read a tab delimited line from file
	string line, s;
	row.clear();
	getline(inFile, line);
	if (inFile.eof()) return false;
	istringstream lineStream(line);

	while (getline(lineStream, s, delim)) {
		row.push_back(s);
	}
	return true;
}
#endif



