#include<cassert>
#include<cmath>
#include<string>
#include<iostream>
#include<sstream>
#include<fstream>
#include<cstdlib>
#include<vector>
#include<map>
#include<list>
#include<queue>
#include<cstdarg>
#include<algorithm>
//#include<mysql++.h>
//#include <boost/foreach.hpp>

using namespace std;
ostringstream oMsg;
string sbuf;
string filename, baseFilename;
#include "defs.h"
//#include "index.h"

typedef	enum dirEnum { FOR = 0, BACK = 1};
bool CONCISE_OUTPUT = false;
bool PREPEND_OUTPUT = false;

string fsuf = "";
string bsuf = "";
int upperd = -2;
int lowerd = -1;
int matepair_mappings_counter = 0;
int maxDist = 1000000000; //1G
int readLen= -1;
vector<ofstream * > outFiles(24); 
vector<ostringstream *> tmpStm(24);


typedef struct {
	string readname;
	string contigname; 
	char        strand;
	uint64_t    contigstart;
	//uint64_t    mismatches;
} rmapping_t;

typedef vector< list<rmapping_t> > mapsType;

string to_string(const rmapping_t & m) {
	ostringstream o;
	o << m.readname << m.strand << ":<" << m.contigname << "," << m.contigstart << ",*>" ;
	return o.str();
}

void read_mapping(string buf, rmapping_t & map) {
	// example: 3+:<24,11910070,2>
	istringstream line(buf);
	int i;
	int start=0; //0 not necessary, just to get rid of warning
	char c;
	for (i = 0; i < buf.length(); i++) {
		line.get(c);
		if ((c == '+')  || (c == '-')) {
			map.strand = c;
			map.readname = buf.substr(0, i);
			start = i + 3;
			break;
		}
	}

	line.get(c);
	assert (c == ':');
	line.get(c);
	assert (c == '<');

	for (i += 3; i < buf.length(); i++) {

		if (buf[i] == ',') {
			map.contigname = "chr";
			int n =  atoi(buf.substr(start, i - start).c_str());
			//this fixes the bowtie concise convention 0=chr1, 21=chr22, 22=mitochondria, 23=chr23, 24=chr24
			assert(n!=22); if (n < 22) n++; 
			if (n == 23) map.contigname += "X";
			else if (n == 24) map.contigname += "Y";
			//else map.contigname += make_string(n + 1);
			else map.contigname += make_string(n);
			start = i + 1;
			break;
		}
	}
	for (i += 1; i < buf.length(); i++) {
		if (buf[i] == ',') {
			map.contigstart = atol(buf.substr(start, i - start).c_str());
			break;
		}
	}
	//cerr<< "Read in mapping from line: " << buf << "."; cerr << "Result is: " << to_string(map) << ".\n";

}

void parse_readname(string readname, string & matepair, dirEnum &type) {
	int parity = atol(readname.c_str()) % 2;
	matepair = make_string(atol(readname.c_str()) - parity);
	if (parity== 0) 
		type = FOR;
	else 
		type = BACK;
	return;
}

int mapped_dist(const rmapping_t & fmap, const rmapping_t & bmap) {

	const rmapping_t * lmap;
	const rmapping_t * rmap;
	if (fmap.contigstart < bmap.contigstart) {
		lmap = &fmap;
		rmap = &bmap;
	} else {
		lmap = &bmap;
		rmap = &fmap;
	}

	if ((lmap->strand == '+') && (rmap->strand == '-')) {
		return rmap->contigstart - lmap->contigstart + readLen;
	} else if ((lmap->strand == '-') && (rmap->strand == '+')) {
		return rmap->contigstart - lmap->contigstart +  3*readLen;
	} else if ((lmap->strand == '+') && (rmap->strand == '+')) {
		return rmap->contigstart - lmap->contigstart +  2*readLen;
	} else if ((lmap->strand == '-') && (rmap->strand == '-')) {
		return rmap->contigstart - lmap->contigstart +  2*readLen;
	}

	return 0; //should never get here
}


string mappings2str(const rmapping_t & fmap, const rmapping_t & bmap, double totalMapsForMatepair) {
	ostringstream o;
	o << fmap.readname << "\t" << fmap.contigname << "\t" << fmap.strand << "\t" << fmap.contigstart << "\t";
	o << bmap.readname << "\t" << bmap.contigname << "\t" << bmap.strand << "\t" << bmap.contigstart << "\t";
	o << 1 / (double) totalMapsForMatepair;
	return o.str();
}





/**************************************/

bool is_concordant(const rmapping_t & fmap, const rmapping_t & bmap, int & dist) {
	dist =  mapped_dist(fmap, bmap);
	bool correct_orientation = false;
	correct_orientation = 
		(fmap.strand  == '+') && (bmap.strand == '-') && (fmap.contigstart < bmap.contigstart) || 
		(fmap.strand  == '-') && (bmap.strand == '+') && (fmap.contigstart > bmap.contigstart);
	if (correct_orientation && (dist >= lowerd) && (dist <= upperd)) return true;
	return false;

}

int contig2num(string contigname) {
	if (contigname == "chrX") return 22;
	else if (contigname == "chrY") return 23;
	else return atoi(contigname.substr(3, 2).c_str()) - 1;
}

string num2contig(int contignum) {
	assert((contignum >= 0) && (contignum < 24));
	string contigname = "invalid";
	if (contignum < 22) {
		contigname = "chr";
		contigname += make_string(contignum+1);
	} else if (contignum == 22) {
		contigname = "chrX";
	} else if (contignum == 23) {
		contigname = "chrY";
	}
	return contigname;
}

void process_matepair_disc(mapsType & fmaps, mapsType & bmaps, const int & totalMaps) {
	list<rmapping_t>::const_iterator itf, itb;
	int dist, chr;
	int counterRecall = matepair_mappings_counter;
	bool foundDiscordantMapping = false;
	string readnames[2];

	for (chr = 0; chr < 24; chr++){
		tmpStm[chr]->str("");
		for (itf = fmaps.at(chr).begin(); itf != fmaps.at(chr).end(); itf++) {
			for (itb = bmaps.at(chr).begin(); itb != bmaps.at(chr).end(); itb++) {
				if (is_concordant(*itf, *itb, dist)) {
					matepair_mappings_counter = counterRecall;
					return;
				} 
				if ((itf->contigname == itb->contigname) && (dist <= maxDist)) {
					if (!CONCISE_OUTPUT) { 
						const rmapping_t * lmap;
						const rmapping_t * rmap;
						int type = 0; // 0 not necessary, its just to get rid of warning
						if (itf->contigstart < itb->contigstart) {
							lmap = &(*itf);
							rmap = &(*itb);
						} else {
							lmap = &(*itb);
							rmap = &(*itf);
						}
						if ((lmap->strand == '+') && (rmap->strand == '-')) {
							type = 0;
						} else if ((lmap->strand == '-') && (rmap->strand == '+')) {
							type = 1;
						} else if ((lmap->strand == '+') && (rmap->strand == '+')) {
							type = 2;
						} else if ((lmap->strand == '-') && (rmap->strand == '-')) {
							type = 3;
						}

						if (PREPEND_OUTPUT) *(tmpStm[chr]) << ++matepair_mappings_counter << "\t";
						*(tmpStm[chr]) << dist << "\t" << itf->contigname << "\t";
						*(tmpStm[chr]) << lmap->contigstart << "\t" << rmap->contigstart << "\t";
						*(tmpStm[chr]) << itf->readname << "\t" << type << "\t" << lmap->strand << "\t" << rmap->strand;
						*(tmpStm[chr]) << endl;
						//id, dist, chr, left, right, template, type, left-strand, right-strand
					} else {
						foundDiscordantMapping = true; //this is for the concise output
						readnames[0] = itf->readname;
						readnames[1] = itb->readname;
					}
				} 
			}
		}
	}

	//Write output
	if (!CONCISE_OUTPUT) {
		for (chr = 0; chr < 24; chr++){
			//cout << "chr = " << chr << ", and length tmpStm = " << tmpStm[chr]->str().size() << endl;
			*(outFiles[chr]) << tmpStm[chr]->str();
			outFiles[chr]->flush();
		}
	} else {
		//just write to cout the template id
		if (foundDiscordantMapping) {
			cout << readnames[0] << endl << readnames[1] << endl;
		}
	}

	return;
}


void usage(int argc, char * argv[]) {
	cout << "Usage: " << argv[0] << " <map_file> <> {<optparam3>} " << endl;
	exit(1);
}

int main(int argc, char * argv[]) {
	//if (argc != 1+0) usage(argc, argv);

	char ch;

	istream * mFile;
	ifstream ifs;
	while ((ch = getopt(argc, argv, "pcf:b:u:l:t:d:r:o:")) != -1) {
		switch (ch) {
			case 'p':
				PREPEND_OUTPUT = true;
				break;
			case 'c':
				CONCISE_OUTPUT = true;
				break;
			case 'f':
				fsuf = optarg;
				break;
			case 'b':
				bsuf = optarg;
				break;
			case 'u':
				upperd = atoi(optarg);
				break;
			case 'l':
				lowerd = atoi(optarg);
				break;
			case 'd':
				maxDist = atoi(optarg);
				break;
			case 'r':
				readLen = atoi(optarg);
				break;
			case 'o':
				filename = optarg;
				ofstream * of;
				for (int i = 0; i < 24; i++){
					oMsg.str("");
					oMsg << filename << "." << num2contig(i);
					of = new ofstream(oMsg.str().c_str());
					outFiles.at(i) = of;
					}

				break;
			}
		}

		/*
		   cerr << "Starting concordancy_analysis.";
		   cerr << "\nforward_suffix = " << fsuf << "\nbackward_suffix = " << bsuf << "\nlower bound distance = " << lowerd;
		   cerr << "\nupper bound distance = " << upperd<< "\nmaxDist = " << maxDist << endl;
		   if (CONCISE_OUTPUT) cerr << "Using concise output.\n";
		 */

		//sanity checks
		if (!((fsuf != "") && (bsuf != "") && (upperd >= lowerd) && (lowerd >= 0) && (readLen > 0) && (fsuf.length() == bsuf.length()))) {
			cerr << "Invalid options.\n";
			usage(argc, argv);
		}

		if (( optind != argc - 1 )) { //should be one other parameter
			cerr << "Invalid parameters.\n";
			usage(argc, argv);
		}

		//set up some streams to hold temp output
		for (int i = 0; i < 24; i++) {
			ostringstream * ostm = new ostringstream;
			tmpStm.at(i) = ostm;
		}


		//open mapping file
		filename = argv[optind];
		if (filename == "-") {
			//cerr << "Using standard in for matepair file.\n";
			mFile = &cin;
		} else {
			ifs.open(filename.c_str(), ifstream::in);
			//cerr << "Using " << filename << " for matepair file.\n";
			if (ifs.fail()) {
				cerr << "Cannot open file " << filename << endl;
				exit(1);
			}
			mFile = &ifs;
		}

	//for (int index = optind; index < argc; index++) printf ("Non-option argument %s\n", argv[index]);

	//main loop
	string buf;
	string lastmate = "";
	mapsType fmaps;
	mapsType bmaps;
	fmaps.resize(24); bmaps.resize(24);
	int totalMaps = 0;

	while (getline(*mFile, buf)) {
		rmapping_t curMap;
		dirEnum dir;
		string mate;
		read_mapping(buf, curMap);
		//print_probcalc_mapping(&curMap);
		parse_readname(curMap.readname, mate, dir);
		if (mate != lastmate) { //finished reading in all mappings of current matepair, so process them.
			process_matepair_disc(fmaps, bmaps, totalMaps);
			fmaps.clear();
			bmaps.clear();
			fmaps.resize(24); bmaps.resize(24);
			totalMaps = 0;
		}

		totalMaps++;
		if (dir == FOR) fmaps.at(contig2num(curMap.contigname)).push_back(curMap);
		else if (dir == BACK) bmaps.at(contig2num(curMap.contigname)).push_back(curMap);
		lastmate = mate;
	}

	//close output files
	for (int i = 0; i < 24; i++){
		if (outFiles.at(i) != NULL) {
			outFiles.at(i)->close();
			delete outFiles.at(i);
		}
		delete tmpStm.at(i);
		
	}





}

