#!/bin/bash
QUERY=$1
OUTPUT_DIR=/home/pashadag/cnv/cluster/data

# The file containing a list of the mapping files, one file per line
RMAPPING_FILES="mappings.txt" 

if [ "${QUERY}" = "cluster" ]; then
	if [ $# -ne 4 ]; then
		echo "Usage: $0 cluster chr link_id link_type(0-3), or"
		echo "$0 tmid template_mapping_id mapping_filenum"
		exit
	fi
	CHR=$2
	LINK=`expr $3 - 1`
	TYPE=$4
	CLUSTER_INDEX=${OUTPUT_DIR}/indices/clusters.${CHR}.t${TYPE}.idx
	CLUSTER_DATA=${OUTPUT_DIR}/clusters.${CHR}.t$TYPE

	idx_lookup normal ${CLUSTER_INDEX} ${CLUSTER_DATA} $LINK | grep HEADER1

	TMIDS=`idx_lookup normal ${CLUSTER_INDEX} ${CLUSTER_DATA} $LINK | grep HEADER2 | awk '{ $1 = ""; print $0 }'` #template map ids

	echo "dist,chr,left,right,tid,type,lstrand,rstrand"

	for tmid in $TMIDS; do
		echo -n "$tmid	"
		$0 tmid $tmid
	done
else
	if [ "${QUERY}" = "tmid" ]; then
		if [ $# -ne 2 ]; then
			echo "Usage: $0 cluster chr link_id link_type(0-3), or"
			echo "$0 tmid template_mapping_id mapping_filenum"
			exit
		fi
		tmid=$2
		filenum=`echo $tmid | awk -F"_" '{ print $1 }'`
		loctmid=`echo $tmid | awk -F"_" '{ print $2 }'`
		TMAP_BASE_FILE=`awk -v filenum=$filenum '{ if ((NR - 1) == filenum) print $0 }'`
		CHR=`echo $tmid | awk -F"_" '{ print $3 }'`
		TMAP_INDEX=${OUTPUT_DIR}/indices/`basename ${TMAP_BASE_FILE}`.disc.${CHR}.idx
		TMAP_DATA=${OUTPUT_DIR}/`basename ${TMAP_BASE_FILE}`.disc.${CHR}
		idx_lookup normal ${TMAP_INDEX} ${TMAP_DATA} $loctmid
	else 
		echo "Usage: $0 cluster chr link_id link_type(0-3), or"
		echo "$0 tmid template_mapping_id mapping_filenum"
	fi
fi
