#include <string.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "include/dbtypes.h"

#define BUFF_SIZE 100000
#define ARRAY_SIZE 50000
#define NUM_CHR 25
#define MAX_NUM_READS 60000000


int hash(int key)
{
  key = ~key + (key << 15); // key = (key << 15) - key - 1;
  key = key ^ (key >> 12);
  key = key + (key << 2);
  key = key ^ (key >> 4);
  key = key * 2057; // key = (key + (key << 3)) + (key << 11);
  key = key ^ (key >> 16);
  return key;
}


void usage(char * program_name) {
	printf("%s - bwtie_concise_to_binary\n",program_name);
	printf("------------------------------\n");
	printf("Usage: %s sub_sample/modulus\n",program_name);
}


int main ( int argc, char ** argv) {
	int contig_number=-1;
	if (argc>3 || argc < 2) {
		usage(argv[0]);
		exit(1);
	} else if (argc==3) {
		contig_number=atoi(argv[2]);
	}

	int mod=atoi(argv[1]);

	if (contig_number>=0) {
		fprintf(stderr,"Contig selected was %d\n",contig_number);
		if (contig_number<22) {
			contig_number++;
		} else if (contig_number==22) {
			contig_number=0;
		}
		fprintf(stderr,"Contig now is %d\n",contig_number);
	}
	
	char buffer[BUFF_SIZE];
	FILE * f_handles[NUM_CHR];
	int filled[NUM_CHR];
	mapping_t_small_readid * ready_to_write[NUM_CHR]; 
	char filename[BUFF_SIZE];
	int i;

	//Allocate normordds counter
	unsigned int * read_counter=(unsigned int*)malloc(sizeof(unsigned int)*MAX_NUM_READS);
	if (read_counter==NULL) {
		fprintf(stderr,"Failed to allocate memory for read_counter\n");
		exit(1);
	}
	for (i=0; i<MAX_NUM_READS; i++) {
		read_counter[i]=0;
	}

	//Open files and allocate arrays
	for(i=0; i<NUM_CHR; i++) {
		if (contig_number<0 || contig_number==i) {
			sprintf(filename,"chr%d_mod%d.bin",i,mod);
		} else {
			sprintf(filename,"/dev/null");
		}
		f_handles[i]=fopen(filename,"wb");
		if (f_handles[i]==NULL) {
			printf("Error opening file %s for writing\n",filename);
			exit(1);
		}
		//Allocate arrays
		ready_to_write[i]=(mapping_t_small_readid*)malloc(sizeof(mapping_t_small_readid)*ARRAY_SIZE);
		if (ready_to_write[i]==NULL) {
			printf("Error allocating arary\n");
			exit(1);
		}	
		//Set filled to 0
		filled[i]=0;
	}	

	mapping_t_small_readid temp_map;
	int contig_num;
	while(fgets(buffer,BUFF_SIZE,stdin)!=NULL) {
		int read_in=sscanf(buffer,"%u%c:<%d,%u,%*u>",&(temp_map.read_id),&(temp_map.orientation),&contig_num,&(temp_map.contigstart));
		assert(temp_map.read_id<MAX_NUM_READS);
		read_counter[temp_map.read_id]++;
		assert(read_in==4);
		assert(contig_num<NUM_CHR);
		assert(contig_num>=0);
		//BOWTIE CHR INDEX CORRECTION
		if (contig_num<22) {
			contig_num++;
		} else if (contig_num==22) {
			contig_num=0;
		}
		//BOWTIE IS ZERO BASED WANT 1 BASED
		temp_map.contigstart++;
		temp_map.contig_number=contig_num;
		if (filled[contig_num]==ARRAY_SIZE) {
			int res=fwrite(ready_to_write[contig_num],sizeof(mapping_t_small_readid),filled[contig_num],f_handles[contig_num]);
			assert(res==ARRAY_SIZE);
			filled[contig_num]=0;
		}
		assert(filled[contig_num]<ARRAY_SIZE);
		ready_to_write[contig_num][filled[contig_num]]=temp_map;
		if ( hash(temp_map.read_id/2)%mod  == 0) {
			filled[contig_num]++;
		}
	}

	for(i=0; i<NUM_CHR; i++) {
		//Check to see if there is anything waiting to be written
		if (filled[i]>0) {
			int res=fwrite(ready_to_write[i],sizeof(mapping_t_small_readid),filled[i],f_handles[i]);
			assert(res==filled[i]);
			filled[i]=0;
		}
		assert(filled[i]==0);
		fclose(f_handles[i]);
	}

	for (i=0; i<NUM_CHR; i++) {
		free(ready_to_write[i]);
	}

	//Second pass
	mapping_t_small_readid * in_records=(mapping_t_small_readid*)malloc(sizeof(mapping_t_small_readid)*ARRAY_SIZE);
	mapping_t_small * out_records=(mapping_t_small*)malloc(sizeof(mapping_t_small)*ARRAY_SIZE);
	if (out_records==NULL || in_records==NULL) {
		fprintf(stderr,"Failed to allocate memory for either in_records or out_records\n");
		exit(1);
	}
	FILE * in_handle;
	FILE * out_handle;
	for (i=0; i<NUM_CHR; i++) {
		if (contig_number==-1 || contig_number==i) {
		sprintf(filename,"chr%d_mod%d.bin",i,mod);
		in_handle=fopen(filename,"rb");
		if (in_handle==NULL) {
			fprintf(stderr,"Failed to open %s for reading\n",filename);
			exit(1);
		}
		sprintf(filename,"chr%d_mod%d.final",i,mod);
		out_handle=fopen(filename,"w");
		if (out_handle==NULL) {
			fprintf(stderr,"Failed to open %s for writting\n",filename);
			exit(1);
		}
		int read_in;
		while((read_in=fread(in_records,sizeof(mapping_t_small_readid),ARRAY_SIZE,in_handle))>0) {
			int j;
			for (j=0; j<read_in; j++) {
				out_records[j].contigstart=in_records[j].contigstart;
				sprintf(out_records[j].contigname,"chr%u",in_records[i].contig_number);
				out_records[j].normodds=1.0/read_counter[in_records[j].read_id];
			} 
			int wrote_out=fwrite(out_records,sizeof(mapping_t_small),read_in,out_handle);
			assert(wrote_out==read_in);
		}
		fclose(in_handle);
		fclose(out_handle);
		}
	}
	return 0;	

}
