<!-- For external contribution to the database -->
<html>
<head>
<title>ANISEED - Submit your data</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="Aniseed is applied for the moment to early ascidians (Ciona intestinalis and Halocynthia roretzi). Ascidians, which are marine invertebrate
chordates, are model organisms of choice because their embryos develop with a small number of cells and an invariant lineage.
Moreover, ascidians display a larval body plan similar to that of vertebrates.">
<meta name="keywords" content="Aniseed, Curation, Annotation, Ciona intestinalis, Halocynthia roretzi, ciona intestinalis database, invertebrate, chordate, larval body plan, development, Tassy, Lemaire, Daian, Dauga, Sobral, Khoueiry">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("frames_header.php");
?>



<font size="+2" color="#D64242">Submit your data!!</font>
<font color="#000000" size="-1">
<p>
ANISEED is a community tool, and the direct involvement of external contributors is important to optimise the quality of the submitted data. 

<ul>
<li><font size="+1"><strong> Why sould I submit data? </strong></font></li>
<br>

In parallel to the further development of the ANISEED system, a major issue is to optimise data collection.  For this, your input is crucial.

<p>For example, a large fraction of experimental data collected in your lab will probably remain unpublished. These data, which may not be very interesting to you, could however be of crucial interest for someone else in the community, and vice versa. Also, entering data into ANISEED is a great way to back up high-resolution data including images, to organize data, to compare data with those obtained by other groups And your data can stay private if you wish, so that no one else can see them. Not even our curator team.

</p><p>Entering published literature is also critical, for the system, and for the visibility of the papers. You have probably already been in the situation in which you remember that someone carried out a crucial experiment for your project. But where was it? Who did it? What was precise result obtained? Scanning Pubmed will not give you the answer if it is not in the article's abstract but a simple interrogation of ANISEED will return what you are looking for. That is, provided the paper has been entered in the database. Conversely, any paper entered into ANISEED has an increased impact because it pops up when looking for regulators of a given gene, or genes involved in a process, or lineage tracing experiments, etcEven if the result is mentioned in the main text, but not the abstract. Even if it is in a supplemental figure!

</p>
<li><font size="+1"><strong> What type of data can I submit?</strong></font></li>
     <br>
     <ul type="square"
         <li>Expression patterns during normal development as well as in response to experimental manipulation (embryological or molecular)</li>
         <li>Morphological phenotypes        </li>
         <li>Cis-regulatory element informations  (gene reporter activity, binding sites, etc...)       </li>
         <li>Molecular tools (inhibitors, constructs, morpholinos, etc...)   </li>
     </ul>
      <p>
Unpublished data can be entered independently of one another. 
<br>For published data, you need to adopt a more rigorous format to make sure you are not forgetting pieces of
information. This is achieved via the "article card" concept, which ensures that your article has the best visibility.
The system only accepts clones (ESTs, cDNAs) that have been submitted to Genbank. If this is not your case, contact the curator to find a solution.
The developmental stages are as in the standard ascidian developmental table (Hotta et al 2007 Developmental Dynamics), except that ANISEED compresses 
tailbud stages into 4 stages only (initial, early, mid, late).
</p>
<li><font size="+1"><strong> How can I submit the data?</strong></font></li>
<p>
You can enter data obtained from experiments thanks to the ANISEED-Curator. For that, contact the ANISEED Curator (<a href="mailto:dauga@ibdm.univ-mrs.fr">Delphine Dauga</a>) to get an individual password before entering data.
A detailed manual available <a href="Data_submission/How_enter_data_in_Aniseed.pdf"><font color=#6E6E6E>here</font></a> was written to help you to enter every type of data.
<br>
<br>
You can also use a modified Excel spreadsheet for larger submission. Thanks to these files, you can enter expression profiles in wild type or mutant condition, morphological phenotypes and studies of regulatory sequences. Once the excel forms are filled, a parser enter automatically data from the files into the database. 
You can also use these files to organize and store expression data. 
You are provided with a template that specifies the required information and facilitates data entry via keyword selection lists and a detailed user guide.

<ul type="square">

         <li><a href="Data_submission/Expression_data_wild_type.xls"><font color=#6E6E6E>Excel file to enter expression data in wild type condition</font></a></li>
         <li><a href="Data_submission/Expression_data_molecular_perturbation.xls"><font color=#6E6E6E>Excel file to enter expression data in deregulated molecule context</font></a> </li>
         <li><a href="Data_submission/Expression_data_anatomical_perturbation.xls"><font color=#6E6E6E>Excel file to enter expression data in perturbed anatomical context</font></a> </li>
         <li><a href="Data_submission/Morphological_phenotype.xls"><font color=#6E6E6E>Excel file to enter a morphological phenotype</font></a></li>
         <li><a href="Data_submission/Regulatory_region_analysis.xls"><font color=#6E6E6E>Excel file to enter cis-regulatory region information</font></a></li>
         <li><a href="Data_submission/Excel_tutorial.pdf"><font color=#6E6E6E>Quick start to use the Excel Files</font></a></li>

</ul>
</p>
</ul>
</p>
</font>

<?php
    include("frames_footer.php");
?>
