<!--display a regulatory region and its related region(s)-->
<html>
<head>
<title>ANISEED - Regulatory Region result (Ciona intestinalis or Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page describe a Halocynthia roretzi or Ciona intestinalis regulatory region. You will find different features as the different Ciona constructs used to test the regions, the transcription factors, the regulatory motifs.">
<meta name="keywords" content="Aniseed, Ciona intestinalis, regulatory region, Ciona intestinalis regulatory region, regulatory sequence, regulatory motif, transcription factor, Ciona transcription factor.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
reg-region-edit.php

AUTHOR: Daniel Sobral
12/12/2006

*/

function printhierarchy($c,$curr,$root,$level){
	for($i=0;$i<$level;$i++){
	  echo '&nbsp&nbsp&nbsp&nbsp|&nbsp';
	}	

	//print current promoter...
  	$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$root.";";
	$stmt = pg_query($c,$khoueiry); 
	if($row=pg_fetch_array($stmt)){
	  
	    $img_html = "";
		if($root==$row["BASE_REG_ID"]){
		  	//$img_html .= '<img '.$img_ext.' src="pictures/reg_base.gif">';
		  	$img_html .= '&nbsp;&nbsp;';
	  	} elseif( ($row["DELETION"]=='y') || ($row["MUTATION"]=='y') || ($row["ADDITION"]=='y') ) {
	  	  	$img_html="";
			//if ($row["DELETION"]=='y'){ $img_html .= '<img '.$img_ext.' src="pictures/reg_deletion.gif">'; } 
			//if ($row["MUTATION"]=='y'){ $img_html .= '<img '.$img_ext.' src="pictures/reg_mutation.gif">'; } 
			//if ($row["ADDITION"]=='y'){ $img_html .= '<img '.$img_ext.' src="pictures/reg_addition.gif">'; }	
			if ($row["DELETION"]=='y'){ $img_html .= '&nbsp;&nbsp;(deletion)&nbsp;&nbsp;'; } 
			if ($row["MUTATION"]=='y'){ $img_html .= '&nbsp;&nbsp;(mutation)&nbsp;&nbsp;'; } 
			if ($row["ADDITION"]=='y'){ $img_html .= '&nbsp;&nbsp;(artificial modification)&nbsp;&nbsp;'; }	
		} else {
		  
		  	if($row["IS_NATURAL"]=='y'){
			  	$img_html .= '&nbsp;&nbsp;(natural variation)&nbsp;&nbsp;';			    
			} else {
			  	$img_html .= '&nbsp;&nbsp;(unknown change)&nbsp;&nbsp;';
			  	//$img_html .= '<img '.$img_ext.' src="pictures/reg_unknown.gif">';  
			}
		  	
		}						
		echo $img_html;
		
		if($curr==$root){		    		    
			echo '<font color="blue"><strong>'.$row["NAME"].'</strong></font>'; 
		} else {
			echo $row["STABLE_ID"].':&nbsp;&nbsp;<a href="reg-region-view.php?id='.$root.'">'.$row["NAME"].'</a>';  
		}		
		
		echo ' [ '.$row["TYPE"].' ]';
	} else {
		echo '<strong>Information for region not available'.$root.'</strong>';
	}
	echo '<br/>';
	
	//print children... 
	$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"BASE_REG_ID\"=".$root." AND \"BASE_REG_ID\"!=\"PROMOTER_ID\" AND \"PRIVATE\"='n' AND (\"CHECKED\"='y' OR \"BEING_CURATED\"='y') ORDER BY \"BEGIN\" ASC, \"END\" DESC, \"NAME\";";
	$stmt = pg_query($c,$khoueiry); 
	while($row=pg_fetch_array($stmt)){
		printhierarchy($c,$curr,$row["PROMOTER_ID"],$level+1);    
	}	
}

function findroot($c,$base_id){  	
    $root = $base_id;  	
  	$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$root." AND \"PRIVATE\"='n' AND (\"CHECKED\"='y' OR \"BEING_CURATED\"='y') ;";
	$stmt = pg_query($c,$khoueiry); 
	$row=pg_fetch_array($stmt); 	
	while($row!=false && $row["BASE_REG_ID"]!=$root){
		$root = $row["BASE_REG_ID"];
	  	$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$root.";";
		$stmt = pg_query($c,$khoueiry);
		$row=pg_fetch_array($stmt);
	}
	
	return $root;
}  


//START

include ("frames_header.php"); 
include ("connection.php");

print "<title>ANISEED v3.0 - Cis-regulatory region</title>";


//print "<center><strong>Updates in progress.</strong></center>";
//include ("frames_footer.php");
//return;

$max_width = 600;		

$id=$_GET["id"];
    
//START OF THE REGION INFORMATION	
$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$id.";";	
$stmt = pg_query($c,$khoueiry);
if($row=pg_fetch_array($stmt)){	
	if(($row["CHECKED"]=='n') || ($row["PRIVATE"]=='y')) {
		print "<h1>No Match</h1>";
		include ("frames_footer.php"); 
		return;
	}
} else { 
	print "<h1>No Match</h1>";
	include ("frames_footer.php"); 
	return;
}
	
//AUTHOR, ANNOTATOR AND CURATION INFO	
		    
$khoueiry="SELECT A.\"NAME\", A.\"SURNAME\", A.\"MAIL\", B.\"ENTRY_DATE\" FROM \"AUTHOR\" A, \"ENTRY_ORIGIN\" B WHERE  (B.\"BIO_ID\"=$id) AND (A.\"AUTHOR_ID\"=B.\"AUTHOR_ID\")";
	
$stmt = pg_query($c,$khoueiry);
if (! $rowcond=pg_fetch_array($stmt) ){
	print "Author: <strong>Warning - no author information!</strong>";
} else {
	echo 'Author: <strong><a href="mailto:'.$rowcond["MAIL"]."\">".$rowcond["SURNAME"]." ".$rowcond["NAME"]."</a></strong>&nbsp;&nbsp;&nbsp;".$rowcond["ENTRY_DATE"]."&nbsp;&nbsp;&nbsp;";  
}
	
echo '&nbsp;&nbsp;<br>';		
		
$rannot="SELECT \"ANNOTATOR_ID\",\"ANNOTATION_DATE\" from \"ENTRY_ORIGIN\" where \"BIO_ID\"='$id'";
$sannot=pg_query($c,$rannot);

//On fait afficher les informations sur l'annotator
$fetch=pg_fetch_array($sannot);
$annotator_id=$fetch["ANNOTATOR_ID"];
if (strlen($annotator_id)>0)
{
	$annotation_date=$fetch["ANNOTATION_DATE"];
	$rannot="SELECT \"NAME\",\"SURNAME\",\"MAIL\" from \"AUTHOR\" where \"AUTHOR_ID\"='$annotator_id'";
	$sannot=pg_query($c,$rannot);
	$fetch2=pg_fetch_array($sannot);
	print "Annotator: <strong> <a href=\"mailto:".$fetch2["MAIL"]."\">".$fetch2["SURNAME"]." ".$fetch2["NAME"]."</a></strong>&nbsp;&nbsp;&nbsp;$annotation_date&nbsp;&nbsp;&nbsp;";

	$test="SELECT \"IS_ADMIN\" from \"AUTHOR\" where \"LOGIN\"='".$_SESSION["login"]."'";
	$stest=pg_query($c,$test);
	$rtest=pg_fetch_array($stest);
	print "<br/>";
}


$rcura="SELECT \"CURATOR_ID\",\"CURATION_DATE\" from \"ENTRY_ORIGIN\" where \"BIO_ID\"='$id'";
$scura=pg_query($c,$rcura);

//On fait afficher les informations pour le curator
$fetch=pg_fetch_array($scura);
$curator_id=$fetch["CURATOR_ID"];
if (strlen($curator_id)>0)
{
	$curation_date=$fetch["CURATION_DATE"];
	$rcura="SELECT \"NAME\",\"SURNAME\",\"MAIL\" from \"AUTHOR\" where \"AUTHOR_ID\"='$curator_id'";
	$scura=pg_query($c,$rcura);
	$fetch2=pg_fetch_array($scura);
	print "Curator: <strong> <a href=\"mailto:".$fetch2["MAIL"]."\">".$fetch2["SURNAME"]." ".$fetch2["NAME"]."</a></strong>&nbsp;&nbsp;&nbsp;$curation_date&nbsp;&nbsp;&nbsp;";

	$test="SELECT \"IS_ADMIN\" from \"AUTHOR\" where \"LOGIN\"='".$_SESSION["login"]."'";
	$stest=pg_query($c,$test);
	$rtest=pg_fetch_array($stest);
	print "<br/>";
}

////////////////////////////////////////////// SAY  IF  IT  IS    CURATED   OR   BEING CURATED  OR  NOT CURATED!! ////////////////////////////////////


	//START OF THE REGION INFORMATION	
    $khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$id.";";	
	$stmt = pg_query($c,$khoueiry);
	if($row=pg_fetch_array($stmt)){
	  
  	    $info[$id] = $row;
  	    
		$stable_id = $row["STABLE_ID"];
	    $name=$row["NAME"];
	    $comments=$row["COMMENTS"];
	    $begin = $row["BEGIN"];
	    $end = $row["END"];
		$curated = $row["CHECKED"];
		$private=$row["PRIVATE"];


	if (($curated=="n") || ($private=="y")){print "NO MATCH<br>";include("frames_footer.php");return;}

		$being = $row["BEING"];

   	    $deletion = $row["DELETION"];
   	    $mutation = $row["MUTATION"];
   	    $addition = $row["ADDITION"];
	    $base_id=$row["BASE_REG_ID"];	
	    
	    $is_natural = $row["IS_NATURAL"];
	    $type = $row["TYPE"];
	    
	    $length = 0;
	    $khoueiry="select \"LENGTH\" from \"SEQUENCE\" where \"MOL_ID\"=".$id.";";
		$stmt = pg_query($c,$khoueiry);		
		if($row=pg_fetch_array($stmt)){
			  $length = $row["LENGTH"];
		}
		
		print "<br/><strong><font size=\"2\"><em>Regulatory Region ".$stable_id.": <font color=\"blue\"\">".$name."</font></em></font></strong> <br/>";				
		

		if($curated=='y'){
			if($being=='y'){
				print "<strong><font color=\"yellow\" size=\"1\">Status: In Process of Manual Curation</font></strong> <br/>";				
			} else {
				print "<strong><font size=\"1\">Status: Curated</font></strong> <br/>";				
			}
		} else {
			print "<strong><font color=\"red\" size=\"1\">Status: Not Curated</font></strong> <br/>";				
		}
			
		if($is_natural=='y'){
		  	$ann = "SELECT \"SPECIES\" FROM \"MOL_ENTITY\" WHERE \"MOL_ID\"=".$id;
	  	  	$sann=pg_query($c,$ann);
			$rann=pg_fetch_array($sann);	
			print "&nbsp;&nbsp;Natural Region from ".$rann["SPECIES"]."";  		  
		} else {
			print "&nbsp;&nbsp;Artificial Region";  
		}	
		print "&nbsp;<br/>";										

		//////////////////////////////////////////GBROWSE/////////////////////////////////////////////

		$khoueiry="select * from \"PROMOTER_POS\" where \"PROMOTER_ID\"=$id ORDER BY \"BEGIN\"";
		$stmt = pg_query($c,$khoueiry);			
		if($row=pg_fetch_array($stmt)){		
			//I'm assuming the lines from 
							
			$local_base = $row["LOCAL"];
			$begin_base = $row["BEGIN"];
			$end_base = $row["END"];
			$end_final = $end_base;
				
			$str_pos = "auto=".$local_base."+Regulatory_region+".str_replace(" ","_",$name)."+".$begin_base."-".$end_base.";";				
				
			while($row=pg_fetch_array($stmt)){
				if($row["LOCAL"]!==$local_base){
					print "<br/><strong>Position in the genome likely to be incorrect!!</strong>";	
					break;
				}					
				
				$end_final = $row["END"];
				$str_pos = $str_pos."a=".$local_base."+Regulatory_region+".str_replace(" ","_",$name)."+".$row["BEGIN"]."-".$row["END"].";";				
			}
				
			$ref = "http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=".$local_base.":".($begin_base-500)."..".($end_final+500).";".$str_pos;		
			

/*
print "<br><center><a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=".$local_base.":".($begin_base-500)."..".($end_final+500).";".$str_pos."\">
<img border=\"0\" src=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=".$local_base.":".($begin_base-500)."..".($end_final+500).";".$str_pos."type=JGI_transcripts+EnsemblJGI2+kyotoGrail+Conservation_profile;\">


</a></center>";
*/
	//a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+kyotoGrail+Conservation_profile;
/*TRAVAUX
http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis/?name=scaffold_490%3A13352..18544;a=scaffold_490%20aniseedV3_11245%20Nodal%2014352..17544;type=JGI_transcripts%20EnsemblJGI2%20kyotoGrail%20Conservation_profile

http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis/?name=Scaffold_98%3A242160..248031;auto=Scaffold_98%20Blast_result%20Otx_cis_regulatory_region_from_3541_to_1333%20242660..247531;type=JGI_transcripts%20EnsemblJGI2%20kyotoGrail%20Conservation_profile

http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/?name=Scaffold_98%3A242160..248031;auto=Scaffold_98%20Blast_result%20Otx_cis-regulatory_region_from_-3541_to_1333%20242660-247531
*/
			print "<br/>Position in the genome obtained: <a href=\"$ref\" target=\"_blank\">See it in Gbrowse</a>";
								
		}	

		//////////////////////////////////////////MODIFICATION/////////////////////////////////////////////		
	    if(!is_null($base_id) && $base_id!=$id){	              	        
									  		      	
	      	echo "<br/>";
		    $khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$base_id.";";	
			$stmt = pg_query($c,$khoueiry);
			if($row=pg_fetch_array($stmt)){	      
			    print "&nbsp;&nbsp;Modification of <a href=\"reg-region-view.php?id=".$base_id."\" target=\"_blank\">".$row["NAME"]."</a>";			    						
			    if($deletion=="y"){	            
					print "&nbsp;by deletion; ";  						
				}			    
				if($mutation=="y"){				  
					print "&nbsp; By mutation(s); ";  
				} 
				if($addition=="y"){
					print "&nbsp; By other artificial modification; ";  					  					
				} 
			    print '<br/><br/>';
			}
		}	
		
		print "<br/><br/><strong>Comments:</strong><br/>".$comments."<br/>";
		        
		/////////////////////////////HIERARCHY/////////////////////////////////////////////
		echo "<br/><u><strong><font size=\"2\">Hierarchy of Regulatory Regions:</font></strong></u><br/><br/>";
	        
	    //find the main root and then print the whole hierarchy... 
		//this way it is more uniform...
	    $root = findroot($c,$id);
	    printhierarchy($c,$id,$root,0);		
		echo '<br/>';		        
	      						
		
		///////////////////////////////////////TYPE OF REGULATION///////////////////////////////////////////////
		if($type==NULL){
			$type = "(not defined)";
		}
		print "<br /><strong><u><font size=\"2\">Type of Regulation:</font></u> ".$type."</strong><br/>";		
		
		/*///////////////////////////////////////REGULATED GENES///////////////////////////////////////////////
		print "<br><u><strong><font size=\"2\">Regulated genes:</font></strong></u>&nbsp;<br/>";
		$khoueiry="select a.\"NAME\", a.\"GENE_ID\", b.\"TYPE\" from \"GENE\" a, \"GENE_REGULATION\" b where (b.\"PROMOTER_ID\"='$id') and (a.\"GENE_ID\"=b.\"GENE_ID\")";
		$stmt = pg_query($c,$khoueiry);
		$count=0;
		while($row=pg_fetch_array($stmt)){
		    ++$count;
			
			$gname = $row["NAME"];
			$reg_gene = "";
			$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$row["GENE_ID"]." AND \"ORIGIN\"='user-JGI'";
			$stmt = pg_query($c,$khoueiry); 		
			if($row=pg_fetch_array($stmt)){
				$reg_gene = " <font size=\"2\">".$row["SYNO"]."</font> <font size=\"1\">(".$gname.")</font>";
			} else {
				$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$reg_gene." AND \"ORIGIN\"='phylogeny'";
				$stmt = pg_query($c,$khoueiry); 
				//Just take the first
				if($row=pg_fetch_array($stmt)){
					$reg_gene = " <font size=\"2\">".$row["SYNO"]."</font> <font size=\"1\">(".$gname.")</font>";
				} else {
					$reg_gene = " <font size=\"2\">".$gname."</font> <font size=\"1\">(no biological name available)</font>";
				}
			}	
			//magic condition to avoid empy names!!
			if(strlen($gname)>1 && $reg_gene !== ""){
				print "<strong>Regulated gene: &nbsp;</strong> <a href=\"molecule-gene.php?name=".$gname."\">".$reg_gene."</a><br/>";		    
			}
		}
		if($count==0) print "No regulated genes<br>";*/


///////////////////////////////////////REGULATED GENES///////////////////////////////////////////////
		print "<br><u><strong><font size=\"2\">Regulated genes:</font></strong></u>&nbsp;<br/>";
		$khoueiry="select a.\"NAME\", a.\"GENE_ID\", b.\"TYPE\" from \"GENE\" a, \"GENE_REGULATION\" b where (b.\"PROMOTER_ID\"='$id') and (a.\"GENE_ID\"=b.\"GENE_ID\")";
		$stmt = pg_query($c,$khoueiry);
		$count=0;
		while ($row=pg_fetch_array($stmt))
		{
		++$count;
		$requete0="SELECT \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"='".$row["GENE_ID"]."'";
		$stmt0=pg_query($c,$requete0);
		$row0=pg_fetch_array($stmt0);
		$clustid=$row0["GENE_CLUSTER_ID"];
		$aniseed_gw=str_replace("cluster","aniseedV3_",$row0["GENE_CLUSTER_ID"]);

		$requete0="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row0["GENE_CLUSTER_ID"]."'";
		$stmt0=pg_query($c,$requete0);
		$gene_name="";
		while ($row0=pg_fetch_array($stmt0))
		{
		if (strlen($gene_name)==0) $gene_name=$row0["GENE_CLUSTER_NAME"];
		else $gene_name.=" / ".$row0["GENE_CLUSTER_NAME"];
		}
		
		
		print "<a href=\"gene-card.php?clusterid=$clustid\"><font size=\"2\">$gene_name</font> <font size=\"1\">(".$aniseed_gw.")</font></a>";

		}
		if($count==0) print "No regulated genes";

		print "<br/>";
		/*while($row=pg_fetch_array($stmt)){
		    ++$count;
			
			$gname = $row["NAME"];
			$reg_gene = "";
			$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$row["GENE_ID"]." AND \"ORIGIN\"='user-JGI'";
			$stmt = pg_query($c,$khoueiry); 		
			if($row=pg_fetch_array($stmt)){
				$reg_gene = " <font size=\"2\">".$row["SYNO"]."</font> <font size=\"1\">(".$gname.")</font>";
			} else {
				$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$reg_gene." AND \"ORIGIN\"='phylogeny'";
				$stmt = pg_query($c,$khoueiry); 
				//Just take the first
				if($row=pg_fetch_array($stmt)){
					$reg_gene = " <font size=\"2\">".$row["SYNO"]."</font> <font size=\"1\">(".$gname.")</font>";
				} else {
					$reg_gene = " <font size=\"2\">".$gname."</font> <font size=\"1\">(no biological name available)</font>";
				}
			}	
			//magic condition to avoid empy names!!
			if(strlen($gname)>1 && $reg_gene !== ""){
				print "<strong>Regulated gene: &nbsp;</strong> <a href=\"molecule-gene.php?name=".$gname."\">".$reg_gene."</a><br/>";		    
			}
		}
		if($count==0) print "No regulated genes<br>";*/



		///////////////////////////////////////CONSTRUCTS//////////////////////////////////////////////////////
		print "<br/><u><strong><font size=\"2\">Constructs made to test this region:</font></strong></u> &nbsp;<br/>";	
			
		$khoueiry="SELECT * FROM \"CONSTRUCTION\" WHERE \"PROMOTER_ID\"=$id;";
		$stmt = pg_query($c,$khoueiry);
		$count=0;
		while($row=pg_fetch_array($stmt)){		  
		    ++$count;		    
	    	print "	Construct ".$row["STABLE_ID"].": <a href=\"construct-view.php?constructid=".$row["CONSTRUCTION_ID"]."\" target=\"_blank\">".$row["NAME"]."</a> <a href=\"insitu-result.php?target=".$row["STABLE_ID"]."&MOLtype=1\" target=\"_blank\"> (View Insitu Data)</a> <br />";			
		}

		if($count==0) { 		  
			print "No constructs<br/>";	
		} else {
		   //SHOW GLOBAL_IN_SITU
		}
		
		///////////////////////////////////////SEQUENCE OVERVIEW///////////////////////////////////////////////
		
		print "<br><u><strong><font size=\"2\">Overview of the regulatory motifs in this sequence:</font></strong></u>";
		//print the graphical display with motifs...
		if($length>0){
			print '<br/><br/><strong>'.$begin.'</strong><img src="reg-region-draw.php?width='.$max_width.'&id='.$id.'" border=0></img><strong>'.$end.'</strong>';  
		}						
		print '<br/>';							 
		
		///////////////////////////////////////REGULATORY MOTIFS///////////////////////////////////////////////		
		print "<br><u><strong><font size=\"2\">Regulatory motifs:</font></strong></u> <br>";

		print '<table width="99%" border="0" cellspacing="0" cellpadding="0">';
		print '<tr align="center" valign="middle">
			<td><font color="#456898" size="2">&nbsp;</font></td>
			<td><font color="#456898" size="2">Motif Name</font></td>
			<td><font color="#456898" size="2">Binding Factor(s)</font></td>
			<td><font color="#456898" size="2">Sequence</font></td>
			<td><font color="#456898" size="2">Position in Region </font></td>
			<td width="33%"><font color="#456898" size="2">Comments</font></td>
		</tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>';				
						
		$khoueiry="select A.\"MOTIF_COORD_ID\", A.\"SEQUENCE\", A.\"MOTIF_ID\", A.\"BEGIN\", A.\"STOP\", A.\"ORIENTATION\", A.\"UPDATE_MATRIX\", B.\"NAME\", A.\"COMMENTS\", B.\"RGB_RED\", B.\"RGB_GREEN\", \"RGB_BLUE\" from \"MOTIF_COORD\" A, \"MOTIF_REGUL\" B where A.\"MOTIF_ID\"=B.\"MOTIF_ID\" and A.\"PROMOTER_ID\"=$id order by A.\"BEGIN\" ";
		$stmt = pg_query($c,$khoueiry);
		$motif_list = array();
		$count=0;
		$pair = false;
		while($row=pg_fetch_array($stmt)){
			$motif_list[$count] = $row;
		    $count++;				
					
			$binds = "&nbsp;-&nbsp;";
			$kh="SELECT \"NAME\", \"GENE\".\"GENE_ID\" FROM \"MOTIF_COORD_GENE\", \"GENE\" WHERE \"GENE\".\"GENE_ID\"=\"MOTIF_COORD_GENE\".\"GENE_ID\" AND \"MOTIF_COORD_ID\"=".$row["MOTIF_COORD_ID"];
			$first = true;
			$smkh = pg_query($c,$kh);
			while($rkh=pg_fetch_array($smkh)){
			
				//// get name of the clustid
				$name=(array) null;
				$reqt="SELECT DISTINCT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$rkh["GENE_ID"]." AND \"SYNO\" != '".$rkh["NAME"]."'";
				$stt=pg_query($c,$reqt) or die (pg_last_error($c));
				while ($rw=pg_fetch_array($stt)) { $name[count($name)]=$rw["SYNO"]; }
				$vic_name = implode (" / ",$name);
				$g_name = $rkh["NAME"];				
				if($first){
					$binds = "";
					$first = false;					
				} else {
					$binds = $binds."<br/>";
				}
				$binds = $binds. "<a href=\"molecule-gene.php?name=$g_name\" title=\"$vic_name\"> $g_name </a>";
				
			}
			
			//COLOR...
			$red = dechex($row["RGB_RED"]);
			if(strlen($red)==1) {$red='0'.$red;}
			$green = dechex($row["RGB_GREEN"]);
			if(strlen($green)==1) {$green='0'.$green;}
			$blue = dechex($row["RGB_BLUE"]);
			if(strlen($blue)==1) {$blue='0'.$blue;}
			$color = strtoupper($red.$green.$blue);
			
			if($pair){
				$colour = '';
			} else {
				$colour = 'background-color: rgb(200, 200, 200);';
			}
			$pair = !$pair;
			
			echo '<tr align="center" valign="middle" $colour>';			
			print "<td style=\"$colour\"><font size=\"2\"> $count </font> </td>";
			print "<td style=\"$colour\"><font size=\"2\" color=\"$color\">".$row["NAME"]." </font></td>";
			print "<td style=\"$colour\"> <font size=\"2\">".$binds." </font></td>";
			print "<td style=\"$colour\"> <font size=\"2\" color=\"$color\">".strtoupper($row["SEQUENCE"])." </font></td>";
			print "<td style=\"$colour\"><font size=\"2\"> [".$row["BEGIN"]." / ".$row["STOP"]."] </font></td>";
			print "<td style=\"$colour\"> <font size=\"2\">".$row["COMMENTS"]." </font></td>";	                
		}						
				
		print '<tr valign="top">
				<td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>
				<td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>
			</tr>';
		print '</table>';		
		if($count==0) print "No motifs<br>";
		
	//////////////////////////////////////////SEQUENCE/////////////////////////////////////////////
	
	//TODO Adjust to be just one sequence....
	$khoueiry="select \"SEQUENCE\", \"LENGTH\", \"COMMENTS\", \"MOL_ID\" from \"SEQUENCE\" where \"MOL_ID\"=$id";
	$stmt = pg_query($c,$khoueiry);
		
	if($row=pg_fetch_array($stmt)){
		$lob = $row["SEQUENCE"];

		pg_query ($c, "begin");		
		$handle_lo = pg_lo_open($c,$lob,"r");
		$seq=pg_lo_read($handle_lo);
		pg_query($c,"end");
			
		//$seq=ereg_replace("<br>","",$seq);
		$seq=ereg_replace("\n","",$seq);		
		//$seq = chunk_split($seq, 70, "\n");
		
		$motif_seq = '';
		$mtf = 0;
		$count_seventy = 0;
		if(count($motif_list)>0){
		
			for($i=0;$i<strlen($seq);$i++){
		
				$count_seventy++;
				if($count_seventy==70){
					$motif_seq.="\n";
					$count_seventy=1;
				}
			
				$motif = $motif_list[$mtf];
				$motif_pos_a = $motif["BEGIN"] - $begin;
				if(($motif["BEGIN"]*$begin)<0){ $motif_pos_a = $motif_pos_a - 1; }		  	
				$motif_pos_b = $motif["STOP"] - $begin;
				if(($motif["STOP"]*$begin)<0){ $motif_pos_b = $motif_pos_b - 1; }	
			
				//COLOR...
				$red = dechex($motif["RGB_RED"]);
				if(strlen($red)==1) {$red='0'.$red;}
				$green = dechex($motif["RGB_GREEN"]);
				if(strlen($green)==1) {$green='0'.$green;}
				$blue = dechex($motif["RGB_BLUE"]);
				if(strlen($blue)==1) {$blue='0'.$blue;}
				$color = strtoupper($red.$green.$blue);
			
				#normal case... just print the character...
				if(!($i==$motif_pos_a) && !($i==$motif_pos_b)){
					$motif_seq.=substr($seq,$i,1);
				}
			
				#we hit a motif!... so we open the motif color
				if($i==$motif_pos_a){
					$motif_seq.="<font color=\"#$color\"><strong>".substr($seq,$i,1);
				}
			
				#we hit the end of the current motif... so we close the color
				if($i==$motif_pos_b){
					$motif_seq.=substr($seq,$i,1)."</font></strong>";
								
					#now check for overlaps...							
					$next_motif_pos_b = -1;	
					$next_motif_pos_a = $i;
					while($i>=$next_motif_pos_b && $mtf < (count($motif_list)-1)){
						$mtf++;
						$next_motif = $motif_list[$mtf];
						$next_motif_pos_a = $next_motif["BEGIN"] - $begin;
						if(($next_motif["BEGIN"]*$begin)<0){ $next_motif_pos_a = $next_motif_pos_a - 1; }		  	
						$next_motif_pos_b = $next_motif["STOP"] - $begin;
						if(($next_motif["STOP"]*$begin)<0){ $next_motif_pos_b = $next_motif_pos_b - 1; }
				
						//COLOR...
						$red = dechex($next_motif["RGB_RED"]);
						if(strlen($red)==1) {$red='0'.$red;}
						$green = dechex($next_motif["RGB_GREEN"]);
						if(strlen($green)==1) {$green='0'.$green;}
						$blue = dechex($next_motif["RGB_BLUE"]);
						if(strlen($blue)==1) {$blue='0'.$blue;}
						$color = strtoupper($red.$green.$blue);	
					
									#after removing overlaps									
						if($i>=$next_motif_pos_a && $i<$next_motif_pos_b){
							$motif_seq.="<font color=\"#$color\"><strong>";
						}
					}												
				}		
			}
		} else {
			$motif_seq = chunk_split($seq, 70, "\n");
		}
		
		/*
		$motif_seq = '';
		if(count(motif_list)>0){
					
			$mtf = 0;
			$count_seventy = 0;
			for($i=0;$i<strlen($seq);$i++){
		
				$count_seventy++;
				if($count_seventy==70){
					$motif_seq.="\n";
					$count_seventy=1;
				}
			
				$motif = $motif_list[$mtf];
				$motif_pos_a = $motif["BEGIN"] - $begin;
				if(($motif["BEGIN"]*$begin)<0){ $motif_pos_a = $motif_pos_a - 1; }		  	
				$motif_pos_b = $motif["STOP"] - $begin;
				if(($motif["STOP"]*$begin)<0){ $motif_pos_b = $motif_pos_b - 1; }	
			
				//COLOR...
				$red = dechex($motif["RGB_RED"]);
				if(strlen($red)==1) {$red='0'.$red;}
				$green = dechex($motif["RGB_GREEN"]);
				if(strlen($green)==1) {$green='0'.$green;}
				$blue = dechex($motif["RGB_BLUE"]);
				if(strlen($blue)==1) {$blue='0'.$blue;}
				$color = strtoupper($red.$green.$blue);
			
				#normal case... just print the character...
				if(!($i==$motif_pos_a) && !($i==$motif_pos_b)){
					$motif_seq.=substr($seq,$i,1);
				}
			
				#we hit a motif!... so we open the motif color
				if($i==$motif_pos_a){
					$motif_seq.="<font color=\"#$color\"><strong>".substr($seq,$i,1);
				}
			
				#we hit the end of the current motif... so we close the color
				if($i==$motif_pos_b){
					$motif_seq.=substr($seq,$i,1)."</font></strong>";
									
					#now check for overlaps...							
					$next_motif_pos_b = -1;	
					$next_motif_pos_a = $i;
					while($i>=$next_motif_pos_b && $mtf < (count($motif_list)-1)){
						$mtf++;
						$next_motif = $motif_list[$mtf];
						$next_motif_pos_a = $next_motif["BEGIN"] - $begin;
						if(($next_motif["BEGIN"]*$begin)<0){ $next_motif_pos_a = $next_motif_pos_a - 1; }		  	
						$next_motif_pos_b = $next_motif["STOP"] - $begin;
						if(($next_motif["STOP"]*$begin)<0){ $next_motif_pos_b = $next_motif_pos_b - 1; }
				
						//COLOR...
						$red = dechex($next_motif["RGB_RED"]);
						if(strlen($red)==1) {$red='0'.$red;}
						$green = dechex($next_motif["RGB_GREEN"]);
						if(strlen($green)==1) {$green='0'.$green;}
						$blue = dechex($next_motif["RGB_BLUE"]);
						if(strlen($blue)==1) {$blue='0'.$blue;}
						$color = strtoupper($red.$green.$blue);	
					
										#after removing overlaps									
						if($i>=$next_motif_pos_a && $i<$next_motif_pos_b){
							$motif_seq.="<font color=\"#$color\"><strong>";
						}
					}					
							
				}
		
			}
		} else {
			$motif_seq = chunk_split($seq, 70, "\n");
		}
		*/
/*		
	    $motif_seq = '';
	    $pos = 0;
	    
	    $found_trouble = false;
	    $mtf = 0;	    
	    //foreach($motif_list as $motif){
	    while($mtf<count($motif_list)){
	        $motif = $motif_list[$mtf];

			if(($motif["BEGIN"] < $begin) || ($motif["STOP"] > $end)){
			 	$found_trouble = true;
				$mtf++;
				continue;  
			} else {
			  	//Position 0 does not exist
				$motif_pos_a = $motif["BEGIN"] - $begin;
				if(($motif["BEGIN"]*$begin)<0){ $motif_pos_a = $motif_pos_a - 1; }		  	
				$motif_pos_b = $motif["STOP"] - $begin;
				if(($motif["STOP"]*$begin)<0){ $motif_pos_b = $motif_pos_b - 1; }
			  				
				$motif_pos_a = $motif_pos_a + floor($motif_pos_a / 70);
				$motif_pos_b = $motif_pos_b + floor($motif_pos_b / 70);			
			
				//COLOR...
				$red = dechex($motif["RGB_RED"]);
				if(strlen($red)==1) {$red='0'.$red;}
				$green = dechex($motif["RGB_GREEN"]);
				if(strlen($green)==1) {$green='0'.$green;}
				$blue = dechex($motif["RGB_BLUE"]);
				if(strlen($blue)==1) {$blue='0'.$blue;}
				$color = strtoupper($red.$green.$blue);
				//$motif_seq = $motif_seq.substr($seq,$pos,($motif_pos_a)-$pos)."<font color=\"#FF0000\"><strong>";
				$motif_seq = $motif_seq.substr($seq,$pos,($motif_pos_a)-$pos)."<font color=\"#$color\"><strong>";
			
				$motif_length = $motif_pos_b - $motif_pos_a + 1;
				$pos = $motif_pos_a;									
				$motif_seq = $motif_seq . substr($seq,$pos,$motif_length) . "</strong></font>";
			
				$pos = $pos + $motif_length;
			
				//deal with overlapping motifs!
				while(isset($motif_list[$mtf+1]) && ($motif_list[$mtf+1]["STOP"]<=$motif_list[$mtf]["STOP"])){
					  $mtf++;				  
				} 
				if(isset($motif_list[$mtf+1]) && ($motif_list[$mtf+1]["BEGIN"]<$motif_list[$mtf]["STOP"])){
					$motif_list[$mtf+1]["BEGIN"]=$motif_list[$mtf]["STOP"]+1;	  
				}
						
				$mtf++;			 	 
			}
			
		}
		$motif_seq = $motif_seq . substr($seq,$pos);
*/
				
		print "<br><br><u><strong><font size=\"2\">Sequence</font></strong></u><br/>";
		print "<strong>ANISEED Coordinates: </strong>[".$begin." / ".$end."]<br/>";
		print "<strong>Length: </strong>".$row["LENGTH"]."<br/>";		
		print $row["COMMENTS"]."<br/>";		

		//////////////////////////////////////////SEQUENCE WITH MOTIFS/////////////////////////////////////////////
		print "<pre><font face=\"Courier New, Courier, mono\" size=\"3\">".strtoupper($motif_seq)."</font></pre>";
		
		}
		else
		{
		print "<br><br><u><strong><font size=\"2\">Sequence</font></strong></u><br></pre>";
		}
	
	if($found_trouble){
		echo "<strong>Warning: </strong> Coordinates of some motifs do not agree with region coordinates!";
	}

		//////////////////////////////////////REFERENCES////////////////////////////////////////////////////////
		print "<br><u><strong><font size=\"2\">References:</font></strong></u> &nbsp; <br/>";
		
		$khoueiry="
		select \"ARTICLE_ID\",\"TITLE\",\"PUBMED_ID\",\"PAPER\",\"AUTHORS\",\"COMMENTS\",\"URL\" from \"ARTICLE\" where \"PUBMED_ID\" in (
		SELECT \"PUBMED_ID\" FROM \"REFERENCE\" WHERE \"BIO_ID\"='$id')";

// 		$khoueiry="SELECT * from \"REFERENCE\" where \"BIO_ID\"='$id'";


		$stmt = pg_query($c,$khoueiry);
		$count=0;
		while($row=pg_fetch_array($stmt)){
		    ++$count;

	    	print "<br/>".$row["AUTHORS"].". ".$row["TITLE"]."&nbsp;&nbsp; PUBMED ID: <a href=\"view-article.php?id=".$row["ARTICLE_ID"]."\" target=\"_blank\"> ".$row["PUBMED_ID"]."</a><br/>
		<a target=\"blank\" href=\"".$row["URL"]."\">".$row["URL"]."</a><br/>";

                }
		if($count==0) print "No references<br>";   	  

///////////////////////////////////////////////////////END
	}else{
		print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
	}


	include ("frames_footer.php"); 

?>