<html>
<head>
<title>ANISEED - Regulatory Region result (Ciona intestinalis or Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page will list Halocynthia roretzi or Ciona intestinalis regulatory regions of interest. You can search regulatory regions by species, identifier, biological name, type of regulation, gene regulated, or publication.">
<meta name="keywords" content="Aniseed, Ciona intestinalis, regulatory region, Ciona intestinalis regulatory region, regulatory sequence, regulatory motif, transcription factor, Ciona transcription factor.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
	//connection
	include("connection.php");
    include("frames_header.php");
?>

<?php


///////////////////////////////////////////// COMPATIBILITY ARTICLE CARD /////////////////////////////////////////////////////////////////////////

				if (count($_POST)==0)  foreach ($_GET as $key => $val) $_POST[$key]=$val;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



$bool = false;
$khoueiry = "";
$first = true;

if($_POST["species"] !== '-----ANY-----' ){
  	if($first){
		$khoueiry .= "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\", \"MOL_ENTITY\" WHERE \"PROMOTER_ID\"=\"MOL_ID\" AND \"SPECIES\"='".$_POST["species"]."' ";	    
		$first = false;
	} else {
		$khoueiry .= " INTERSECT SELECT \"PROMOTER_ID\" FROM \"PROMOTER\", \"MOL_ENTITY\" WHERE \"PROMOTER_ID\"=\"MOL_ID\" AND \"SPECIES\"='".$_POST["species"]."' ";	    	
		
	}
}


$_POST["name"] = trim($_POST["name"]);
if(strlen($_POST["name"]) > 0 ){
  	if($first){
		$khoueiry .= "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE UPPER(\"NAME\") LIKE '%".strtoupper($_POST["name"])."%' OR \"STABLE_ID\"='".$_POST["name"]."' ";
		$first = false;
	} else {
		$khoueiry .= " INTERSECT SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE UPPER(\"NAME\") LIKE '%".strtoupper($_POST["name"])."%' OR \"STABLE_ID\"='".$_POST["name"]."' ";
	}  		
}

if( $_POST["reg_type"] !== '-----ANY-----' ){
  	if($first){
		$khoueiry .= "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"TYPE\"='".$_POST["reg_type"]."' ";
		$first = false;
	} else {
		$khoueiry .= "INTERSECT SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"TYPE\"='".$_POST["reg_type"]."' ";
	}  	
}

//////////////// AJOUT ///////////////////////
$_POST["pmid"] = trim($_POST["pmid"]);
if(strlen($_POST["pmid"]) > 0 ){
  	if($first){
		$khoueiry .= "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"BASE_REG_ID\" in (
		select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='".$_POST["pmid"]."'
		)";
		$first = false;
	} else {
		$khoueiry .= " INTERSECT SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"BASE_REG_ID\" in (
		select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='".$_POST["pmid"]."'
		) ";
	}  		
}

//////////////////////////////////////////////

//////////////// AJOUT ///////////////////////
$_POST["target"] = trim($_POST["target"]);
if(strlen($_POST["target"]) > 0 ){
  	if($first){
		$khoueiry .= "SELECT \"PROMOTER_ID\" FROM \"GENE_REGULATION\" WHERE \"GENE_ID\" in (select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"=(select \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$_POST["target"]."')))";
		$first = false;
	} else {
		$khoueiry .= " INTERSECT SELECT \"PROMOTER_ID\" FROM \"GENE_REGULATION\" WHERE \"GENE_ID\" in (select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"=(select \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$_POST["target"]."')))";
	}  		
}

//////////////////////////////////////////////



print '<font color="#D64242" size="3"><b>Matching records</b></font><br><br>';	

if($khoueiry==""){
  	//then select all... but only the main regions
	$khoueiry = "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"BASE_REG_ID\"=\"PROMOTER_ID\""; 
	echo '<div><strong>Only the main regions are displayed</strong></div><br/>';
	
} 

$promids = array();



$stmt = pg_query($c,$khoueiry); 
while($row=pg_fetch_array($stmt)){	
	$promids[] = $row["PROMOTER_ID"];
}
	
//Les resultats	
print '<table width="99%" border="0" cellspacing="0" cellpadding="0">';
print '<tr align="center" valign="middle">
		<td><font color="#456898" size="2">Reference</font></td>
		<td><font color="#456898" size="2">Name</font></td>
		<td><font color="#456898" size="2">Species</font></td>
		<td><font color="#456898" size="2">Type</font></td>
		<td><font color="#456898" size="2">Gene Regulated</font></td>
		<td><font color="#456898" size="2">Status</font></td>
	</tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>';					

$inferred = false;	
	
//Selection des resultats
foreach ($promids as $promid)
{
	//Get Promoter data... only Public, independently of being curated or not....	
	$khoueiry = "SELECT * FROM \"PROMOTER\" WHERE \"PROMOTER_ID\"=".$promid." AND \"PRIVATE\"='n' AND (\"CHECKED\"='y' OR \"BEING_CURATED\"='y')";
	$stmt = pg_query($c,$khoueiry); 
	if($row=pg_fetch_array($stmt)){ 	
			$bool=true;
			$stable_id = $row["STABLE_ID"];
			$name = $row["NAME"];
			$type = $row["TYPE"];
			if($row["CHECKED"]=='y'){
				if($row["BEING_CURATED"]=='y'){ 
					$status = "Being Curated"; 
				} else { 
					$status = "Curated"; 
				}
			} else { 
				$status = "Not Curated"; 
			}
			
			$is_natural = $row["IS_NATURAL"];
			
			//SPECIES
			$khoueiry = "SELECT * FROM \"MOL_ENTITY\" WHERE \"MOL_ID\"=".$promid;
			$stmt = pg_query($c,$khoueiry); 		
			$row=pg_fetch_array($stmt);
			$species = $row["SPECIES"];
			if($species==''){ 
				if($is_natural=='y'){
					$species='-';	
				} else {
					$species='Artificial Region';	
				}
			}
			
			
			//GENE...
			$gene="";			
			
			$khoueiry = "SELECT \"GENE_ID\" FROM \"GENE_REGULATION\" WHERE \"PROMOTER_ID\"=".$promid;
			$stmt = pg_query($c,$khoueiry); 		
			$reg_genes = array();
			while($row=pg_fetch_array($stmt)){
					$reg_genes[]=$row["GENE_ID"];
			}
			
			foreach($reg_genes as $reg_gene){
				$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$reg_gene." AND \"ORIGIN\"='user-JGI'";
				$stmt = pg_query($c,$khoueiry); 		
				if($row=pg_fetch_array($stmt)){
					$gene = $gene." <font size=\"-1\">".$row["SYNO"]."</font>";
				} else {
					$inferred = true;
					$khoueiry = "SELECT \"SYNO\" FROM \"SYNO\" WHERE \"GENE_ID\"=".$reg_gene." AND \"ORIGIN\"='phylogeny'";
					$stmt = pg_query($c,$khoueiry); 
					//Just take the first
					if($row=pg_fetch_array($stmt)){
						$gene = $gene." <font size=\"-1\">".$row["SYNO"]."*</font>";
					}					
				}
			}
			
			if(count($reg_genes)==0){
				$gene="-";			
			}		
						
			print '<tr>';
			print '<td align="center"><font size="2">'.$stable_id.'</font></td>';
			print '<td align="center"><a href="reg-region-view.php?id='.$promid.'"><font size="2">'.$name.'</font></a></td>';
			print '<td align="center"><font size="2">'.$species.'</font></td>';
			print '<td align="center"><font size="2">'.$type.'</font></td>';
			print '<td align="center"><font size="2\">'.$gene.'</font></td>';
			print '<td align="center"><font size="2">'.$status.'</font></td>';
			print '</tr>';		
							
	}	 		
}						


	print '<tr valign="top">
			<td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>
			<td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>
		</tr>';
	print '</table>';	
	if($inferred){
			print '<br/>*inferred name</br/>';
	}	
	
	if (!$bool) {
		print "<center><strong>No match</strong></center>";
		include ("frames_footer.php");
		return;
	}
	
?>


<?php
    include("frames_footer.php");
?>