<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
//
//
// Script qui va permettre la gestion des barres de navigation dans ANISEED
//
//

//
//Barre de resultat donne le nombre de resultat total, la fourchette de resultat de la page et le temps d'exec de la requete
// Modification possible: parametrage du nombre de resultat par page ... (fixe a 20)
//

function resultsBar($stmt,$offset)
{
global $number_of_pages;
global $current_page;

//Calcul sur le nombre de pages et le nombre de résultat
$cpt=$offset+20; //Pour que le nombre de page commence a 1 pour un offset de 20.
$num_rows=pg_num_rows($stmt); //Nombre de lignes dans le résultat
if ($num_rows==0) return;
$number_of_pages=ceil($num_rows/20); //Le nombre de pages pour un offset de 20 ... arrondi superieur.
$current_page=$cpt/20; //La page courante pour un offset de 20 ... division entiere.
print '<div align="right"><small>';
//Affichage du nombre de resultats
if (pg_num_rows($stmt)<=1) print "Result 1 to $num_rows of $num_rows record ";
else {
$offset_plus_un=$offset+1;
	if ($cpt>$num_rows) print "Results $offset_plus_un to $num_rows of $num_rows records ";
	else print "Results $offset_plus_un to $cpt of $num_rows records ";
}
//Affichage du temps d'execution de la page, precision 2
$execute = microtime();
print "(".number_format($execute,2);
echo "s)";
print "</small>";

print "</center></div>";

}


//
// Affiche la page courant par rapport aux nombre de pages total
//
function currentPageBar()
{
global $current_page;
global $number_of_pages;
if ($number_of_pages>0) print "<center>Page: $current_page / $number_of_pages</center>";
}



//
// Affiche la barre de navigation en bas de la page (par methode GET)
//
function navigationBar()
{
global $current_page;
global $number_of_pages;
global $offset;

global $nbMAX;
global $_GET;
global $option;
global $species;
global $_SERVER;

if ($number_of_pages<=1) return;


if ($number_of_pages<=10)
	{
		for ($i=1;$i<=$number_of_pages;$i++)
		{
		if ($i!=$current_page)
		{
		$link_to_page="<a href=\"".$_SERVER["PHP_SELF"].
			 "?private=".$_GET["private"]."&option=$option".
			 "&offset=".((($i-1)*$nbMAX)).
			 "&species=$species&selectediddev=".$_GET["selectediddev"]."&mutant=".$_GET["mutant"]."&target=".$_GET["target"]."&amputation=".$_GET["amputation"]."&idanat=".$_GET["idanat"]."&Order=".$_GET["Order"]."&BOOLmut=".$_GET["BOOLmut"]."&BOOLtarg=".$_GET["BOOLtarg"]."&BOOLanat=".$_GET["BOOLanat"]."&xref=".$_GET["xref"]."&MOLtype=".$_GET["MOLtype"]."&pmid=".$_GET["pmid"]."&annotator=".$_GET["annotator"]."&author=".$_GET["author"]."&only=".$_GET["only"]."&news=".$_GET["news"]."&BOOLmanip=".$_GET["BOOLmanip"]."&fate=".$_GET["fate"]."&fatemode=".$_GET["fatemode"].//"&fateonly=".$_GET["fateonly"].
			 "&nbMAX=$nbMAX\">";
		
		print "$link_to_page $i </a>&nbsp;&nbsp;";
		}
	
		else print "$i &nbsp;&nbsp;";
		}


	}
	else
	{

//Les 5 premiers
	for ($i=$current_page-5;$i<$current_page;$i++)
		{
			if ($i>=1) 
			{
			if ($i!=$current_page)
			{
			$link_to_page="<a href=\"".$_SERVER["PHP_SELF"].
			 "?private=".$_GET["private"]."&option=$option".
			 "&offset=".(($i-1)*$nbMAX).
			 "&species=$species&selectediddev=".$_GET["selectediddev"]."&mutant=".$_GET["mutant"]."&target=".$_GET["target"]."&amputation=".$_GET["amputation"]."&idanat=".$_GET["idanat"]."&Order=".$_GET["Order"]."&BOOLmut=".$_GET["BOOLmut"]."&BOOLtarg=".$_GET["BOOLtarg"]."&BOOLanat=".$_GET["BOOLanat"]."&xref=".$_GET["xref"]."&MOLtype=".$_GET["MOLtype"]."&pmid=".$_GET["pmid"]."&annotator=".$_GET["annotator"]."&author=".$_GET["author"]."&only=".$_GET["only"]."&news=".$_GET["news"]."&BOOLmanip=".$_GET["BOOLmanip"]."&fate=".$_GET["fate"]."&fatemode=".$_GET["fatemode"].//"&fateonly=".$_GET["fateonly"].
			 "&nbMAX=$nbMAX\">";
			
			print "$link_to_page ".$i." </a>&nbsp;&nbsp;";			
			}
			}	
		}


	//La page courante
	print "&nbsp;$current_page&nbsp;&nbsp;";

	//Les 5 derniers
	for ($i=$current_page;($i<=$current_page+5);$i++)
			{
			if ($i<=$number_of_pages)
			{
			if ($i!=$current_page)
			{
			$link_to_page="<a href=\"".$_SERVER["PHP_SELF"].
			 "?private=".$_GET["private"]."&option=$option".
			 "&offset=".(($i-1)*$nbMAX).
			 "&species=$species&selectediddev=".$_GET["selectediddev"]."&mutant=".$_GET["mutant"]."&target=".$_GET["target"]."&amputation=".$_GET["amputation"]."&idanat=".$_GET["idanat"]."&Order=".$_GET["Order"]."&BOOLmut=".$_GET["BOOLmut"]."&BOOLtarg=".$_GET["BOOLtarg"]."&BOOLanat=".$_GET["BOOLanat"]."&xref=".$_GET["xref"]."&MOLtype=".$_GET["MOLtype"]."&pmid=".$_GET["pmid"]."&annotator=".$_GET["annotator"]."&author=".$_GET["author"]."&only=".$_GET["only"]."&news=".$_GET["news"]."&BOOLmanip=".$_GET["BOOLmanip"]."&fate=".$_GET["fate"]."&fatemode=".$_GET["fatemode"].//"&fateonly=".$_GET["fateonly"].
			 "&nbMAX=$nbMAX\">";
			
			print "$link_to_page ".$i." </a>&nbsp;&nbsp;";			
			}
			}

			}
	}

}
//Calcul divers


//
// Idem mais par méthode POST
//	 A necessité la création de la fonction javascript: self.setbrowsergoto($i)
//	qui calcule étant donné le numéro de page son offset
//
function navigationBarPOST()
{
global $current_page;
global $number_of_pages;
global $offset;

global $nbMAX;
global $_POST;
global $option;
global $species;
global $_SERVER;


if ($number_of_pages<=1) return;

if ($number_of_pages<=10)
	{
$css="text-decoration:underline; color:black; text-align:center; background-color:transparent; padding:5px border-width:0px;border-style:none;border-color:blue";

		for ($i=1;$i<=$number_of_pages;$i++)
		{
		if ($i!=$current_page)
		{
		$link_to_page="<input type=\"submit\" value=\"$i\" style=\"$css\" onClick=\"javascript:self.setbrowsergoto($i); submit;\">";
		
		print "$link_to_page &nbsp;";
		}
	
		else print "$i &nbsp;&nbsp;";
		}


	}
else
	{

/*Definition du CSS pour faire comme si c t normal*/
$css="text-decoration:underline; color:black; text-align:center; background-color:transparent; padding:5px border-width:0px;border-style:none;border-color:blue";

//Les 5 premiers
	for ($i=$current_page-5;$i<$current_page;$i++)
		{
			if ($i>=1) 
			{
			if ($i!=$current_page)
			{
			
			$link_to_page="<input type=\"submit\" value=\"$i\" style=\"$css\" onClick=\"javascript:self.setbrowsergoto($i); submit;\">";
			
			print "$link_to_page &nbsp;";			
			}
			}	
		}


	//La page courante
	print "&nbsp;$current_page&nbsp;&nbsp;";

	//Les 5 derniers
	for ($i=$current_page;($i<=$current_page+5);$i++)
			{
			if ($i<=$number_of_pages)
			{
			if ($i!=$current_page)
			{
			$link_to_page="<input type=\"submit\" value=\"$i\" style=\"$css\" onClick=\"javascript:self.setbrowsergoto($i); submit;\">";
			
			print "$link_to_page </a>&nbsp;";			
			}
			}

			}
	}






}




//
// Barre de navigation par URL.
//
function navigationBarCompare()
{
global $current_page;
global $number_of_pages;
global $offset;

global $nbMAX;
global $id;
global $target;
global $option;
global $mode;

if ($number_of_pages<=1) return;


if ($number_of_pages<=10)
	{
		for ($i=1;$i<=$number_of_pages;$i++)
		{
		if ($i!=$current_page)
		{
		$res=($i-1)*$nbMAX;
		$link_to_page="<a href= \"compare.php?id=$id&target=$target&mode=$mode&option=$option&offset=$res&nbMAX=$nbMAX\";>";
		
		print "$link_to_page $i </a>&nbsp;&nbsp;";
		}
	
		else print "$i &nbsp;&nbsp;";
		}


	}
	else
	{

//Les 5 premiers
	for ($i=$current_page-5;$i<$current_page;$i++)
		{
			if ($i>=1) 
			{
			if ($i!=$current_page)
			{
			$res=($i-1)*$nbMAX;
		$link_to_page="<a href= \"compare.php?id=$id&target=$target&mode=$mode&option=$option&offset=$res&nbMAX=$nbMAX\";>";
		
		print "$link_to_page $i </a>&nbsp;&nbsp;";
			}
			}	
		}


	//La page courante
	print "&nbsp;$current_page&nbsp;&nbsp;";

	//Les 5 derniers
	for ($i=$current_page;($i<=$current_page+5);$i++)
			{
			if ($i<=$number_of_pages)
			{
			if ($i!=$current_page)
			{
			$res=($i-1)*$nbMAX;
		$link_to_page="<a href= \"compare.php?id=$id&target=$target&mode=$mode&option=$option&offset=$res&nbMAX=$nbMAX\";>";
		
		print "$link_to_page $i </a>&nbsp;&nbsp;";	
			}
			}

			}
	}

}







?>