<html>
<head>
<title>ANISEED - Lineage Tree (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page shows Ciona intestinalis lineage information thanks to a tree representation. For more information, contact aniseed@ibdm.univ-mrs.fr.">
<meta name="keywords" content="Lineage information, lineage data, cells, Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("connection.php");
    include("frames_header.php");
?>

<script type="text/javascript" src="tooltip.js"></script>
<div id="tooltip"></div>

<?php
    $id=$_GET["idanat"];
	
	if(! is_numeric($id)){
	    Print "Error: missing parameter";
		include("frames_footer.php");
		return;
	}
	
    $dev="";
	$lastdev="";
	print "</center>";
	
	$requete="select B.\"NAME\" as \"DEV\", A.\"NAME\", A.\"DEV_STAGE_ID\" from \"ANAT_ENTITY\" A, \"DEV_STAGE\" B where A.\"ANAT_ID\"='$id' and A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\"";
    $stmt = pg_query($c,$requete);
	if ($row=pg_fetch_array($stmt)){
	    $dev=$row["DEV_STAGE_ID"];
	    print "<h2><strong><em><u>".$row["NAME"]." &nbsp;(".$row["DEV"].") lineage</u></em></strong></h2>";
	}
	
	

//RAJOUT
print "<h1><em><font size=-1>Note: Put your mouse over a cell or a region to display its fate(s) .</font></em></h1><br>";
//


	$count=0;
	$doublons=(array) null;//when a structure has several parents -> avoid doublons
	//search for cell precursors



$term=(array) null;
$term2=(array) null;

function select_recursif_descendant_2($conn,$start,$res,$nivo,$doubl)
{
global $doublons;
global $lastdev;
global $count;
global $dev;
global $term;
global $term2;

/*ON ECRIT SA REQUETE*/

if ($start!='')
{
$requete="SELECT * FROM \"LINEAGE\" WHERE  \"DAUGHTER_CELL\"= $start ";

}
else return;

$stmt=pg_query($conn,$requete);

//Rajout
if (pg_num_rows($stmt)!=0) $nivo++;//print "Nz";
if (pg_num_rows($stmt)==0) $nivo--;//print "Ze";



while ($row=pg_fetch_array($stmt))
	{
	
	$res=select_recursif_descendant_2($conn,$row["MOTHER_CELL"],$res,$nivo,$doubl);
	

	//print "->".$row["DAUGHTER_CELL"];



	if ($doubl=='yes')
	{

	    if(! in_array($row["DAUGHTER_CELL"],$doublons))
	    	{
		$doublons[count($doublons)]=$row["DAUGHTER_CELL"];
		
		//Rjout
		$mothercell=$row["MOTHER_CELL"];
		$requete3= "SELECT a.\"NAME\" FROM \"ANAT_ENTITY\" a where a.\"ANAT_ID\"='$mothercell' ";
		$stmt3 = pg_query($conn,$requete3);
		if ($row3=pg_fetch_array($stmt3)) {
		    $mothername=$row3["NAME"];
			
		}
        ++$count;
		$requete2= "SELECT a.\"NAME\", a.\"DEV_STAGE_ID\", b.\"NAME\" as \"DEV\" FROM \"ANAT_ENTITY\" a, \"DEV_STAGE\" b where a.\"ANAT_ID\"='".$row["DAUGHTER_CELL"]."' and a.\"DEV_STAGE_ID\"=b.\"DEV_STAGE_ID\"";
		$stmt2 = pg_query($conn,$requete2);
		
		if ($row2=pg_fetch_array($stmt2)){
		    $daughtername=$row2["NAME"];
			$dev2=$row2["DEV_STAGE_ID"];
			if($dev2==$dev)
			    $devname='<strong><font color="#FF9900">'.$row2["DEV"].'</font></strong>';
			else
			    $devname=$row2["DEV"];
		}
		}
		else continue;
		
		
	}
	else
	{
		//Rjout
		$mothercell=$row["MOTHER_CELL"];
		$requete3= "SELECT a.\"NAME\" FROM \"ANAT_ENTITY\" a where a.\"ANAT_ID\"='$mothercell' ";
		$stmt3 = pg_query($conn,$requete3);
		if ($row3=pg_fetch_array($stmt3)) {
		    $mothername=$row3["NAME"];
			
		}
        ++$count;
		$requete2= "SELECT a.\"NAME\", a.\"DEV_STAGE_ID\", b.\"NAME\" as \"DEV\" FROM \"ANAT_ENTITY\" a, \"DEV_STAGE\" b where a.\"ANAT_ID\"='".$row["DAUGHTER_CELL"]."' and a.\"DEV_STAGE_ID\"=b.\"DEV_STAGE_ID\"";
		$stmt2 = pg_query($conn,$requete2);
		
		if ($row2=pg_fetch_array($stmt2)){
		    $daughtername=$row2["NAME"];
			$dev2=$row2["DEV_STAGE_ID"];
			if($dev2==$dev)
			    $devname='<strong><font color="#FF9900">'.$row2["DEV"].'</font></strong>';
			else
			    $devname=$row2["DEV"];
		}

	}
	
	
if ($doubl=='yes') $term[$nivo].=$row["MOTHER_CELL"].">".$row["DAUGHTER_CELL"]."@";
if ($doubl=='no') $term2[$nivo].=$row["MOTHER_CELL"].">".$row["DAUGHTER_CELL"]."@";
	
//
	}
return $res;
}


$res=select_recursif_descendant_2($c,$id,$res,0,'yes');
$res=select_recursif_descendant_2($c,$id,$res,0,'no');



///////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////

	$lastdev="";
	//$lastmother="";

//On a $term dans l'ordre inverse, on va le remettre dans l'ordre:
$oterm=(array) null;
$oterm2=(array) null;

for ($a=count($term);$a>=0;$a--) $oterm[count($oterm)]=$term[$a];
for ($a=count($term2);$a>=0;$a--) $oterm2[count($oterm2)]=$term2[$a];
/*
for ($a=0;$a<=count($oterm);$a++)
print $oterm[$a]."<br>";
print "<br>";
for ($a=0;$a<=count($oterm2);$a++)
print $oterm2[$a]."<br>";
*/


$box=(array) null;
$k=0;

for ($a=-1;$a<count($oterm)-2;$a++)
{
$tmp=explode("@",$oterm[$a+1]);
$len=count($tmp)-1;
$y1=($a+1)*150; //espace vertical entre les cellules
//80//150
//print "$y1<br>";

for ($b=0;$b<$len;$b++)
{

$x1=$b*160+150; //espace horizontal entre les cellules //+150 pour le decalage pour mettre le stade de developpement
//100
//print "($x1,$y1,$x2,$y2)<br>";

//ImageRectangle ($image, $x1, $y1, $x1+80, $y1+40, $noir);
$x2=$x1+140;
$y2=$y1+60;
//ImageRectangle ($image, $x1, $y1, $x1+140, $y1+60, $noir);
//imagestring($image, 4, 35, 15, count($recap), $blanc);
//Calcul des centres
$Cx1=($x1+($x1+140))/2;$Cy1=$y1;
//ImageSetPixel ($image, $Cx1, $Cy1, $rouge);

$Cx2=($x1+($x1+140))/2;$Cy2=$y1+60;
//ImageSetPixel ($image, $Cx2, $Cy2, $rouge);

$name=$tmp[$b];

$fils=getFils($name);
$pere=getPere($name);
$box[$k]="$a;$pere;$fils;$x1;$y1;$x2;$y2;$Cx1;$Cy1;$Cx2;$Cy2";
$k++;
}

}


print '<MAP NAME=mymap0>';
for ($a=0;$a<count($box);$a++)
{
$coord=explode(";",$box[$a]);
$requete="SELECT \"NAME\",\"DEV_STAGE_ID\" from \"ANAT_ENTITY\" where \"ANAT_ID\"='".$coord[2]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$region=$row["NAME"];
$reqdev=$row["DEV_STAGE_ID"];

$fat="SELECT \"KEYWORDS\" from \"FATE\" where \"ANAT_ID\"='".$coord[2]."'";
$stmt=pg_query($c,$fat);
$fate="";
while ($row=pg_fetch_array($stmt)) $fate.=$row["KEYWORDS"]." <br> ";
$fate=substr($fate,0,strlen($fate)-2);

print '<AREA HREF="short_hierarchy.php?region='.$coord[2].'&dev='.$reqdev.'" ALT="HTML and CSS Reference" COORDS="'.$coord[3].','.$coord[4].','.$coord[5].','.$coord[6].'" onmouseover="return escape(\'<u>Fate</u>: <br><b>'.$fate.'</b>\');" title="Fate: '.$fate.'">';
}
print '
</MAP>
<IMG SRC="imgLineage0.php?idanat='.$id.'" ALT="" USEMAP="#mymap0" BORDER="0" ><br>';


//Fin de la vignette des peres




	$couleur=array();
	
	$doublons=(array) null;//not sure it is usefull here
	//search for daughter cells

$nivo=0;

$recap=(array) null;
$recap2=(array) null;

$tree="";

function select_recursif_descendant_3($conn,$start,$res,$nivo,$doubl)
{
global $doublons;
global $lastdev;
global $count;
global $dev;

global $recap;
global $recap2;
global $tree;

/*ON ECRIT SA REQUETE*/

if ($start!='')
{
$requete="SELECT * FROM \"LINEAGE\" WHERE  \"MOTHER_CELL\"= $start ";

}
else return;


$stmt=pg_query($conn,$requete);

if (pg_num_rows($stmt)!=0) $nivo++;//print "Nz";
if (pg_num_rows($stmt)==0) $nivo--;//print "Ze";


while ($row=pg_fetch_array($stmt))
	{
	
	if ($doubl=='yes')
	{    if(! in_array($row["DAUGHTER_CELL"],$doublons))
	    	{
		$doublons[count($doublons)]=$row["DAUGHTER_CELL"];
		$mocell=$row["MOTHER_CELL"];
////////
		
		$requete2= "SELECT a.\"NAME\", a.\"DEV_STAGE_ID\", b.\"NAME\" as \"DEV\" FROM \"ANAT_ENTITY\" a, \"DEV_STAGE\" b where a.\"ANAT_ID\"='".$row["DAUGHTER_CELL"]."' and a.\"DEV_STAGE_ID\"=b.\"DEV_STAGE_ID\"";
		$stmt2 = pg_query($conn,$requete2);
		if ($row2=pg_fetch_array($stmt2)) {
		    $daughtername=$row2["NAME"];
			$dev2=$row2["DEV_STAGE_ID"];
			if($dev2==$dev)
			    $devname='<strong><font color="red">'.$row2["DEV"].'</font></strong>';
			else
			    $devname=$row2["DEV"];
		}
	
		$requete3= "SELECT a.\"NAME\" FROM \"ANAT_ENTITY\" a where a.\"ANAT_ID\"='$mocell' ";
		$stmt3 = pg_query($conn,$requete3);
		if ($row3=pg_fetch_array($stmt3)) {
		    $mothername=$row3["NAME"];
			
		}
		}
		else
		    continue;
	}
	else
	{	
	
        ++$count;
		$mocell=$row["MOTHER_CELL"];
////////
		
		$requete2= "SELECT a.\"NAME\", a.\"DEV_STAGE_ID\", b.\"NAME\" as \"DEV\" FROM \"ANAT_ENTITY\" a, \"DEV_STAGE\" b where a.\"ANAT_ID\"='".$row["DAUGHTER_CELL"]."' and a.\"DEV_STAGE_ID\"=b.\"DEV_STAGE_ID\"";
		$stmt2 = pg_query($conn,$requete2);
		if ($row2=pg_fetch_array($stmt2)) {
		    $daughtername=$row2["NAME"];
			$dev2=$row2["DEV_STAGE_ID"];
			if($dev2==$dev)
			    $devname='<strong><font color="red">'.$row2["DEV"].'</font></strong>';
			else
			    $devname=$row2["DEV"];
		}
	
		$requete3= "SELECT a.\"NAME\" FROM \"ANAT_ENTITY\" a where a.\"ANAT_ID\"='$mocell' ";
		$stmt3 = pg_query($conn,$requete3);
		if ($row3=pg_fetch_array($stmt3)) {
		    $mothername=$row3["NAME"];
			
		}		



	}

if ($doubl=='yes') $recap[$nivo].=$row["MOTHER_CELL"].">".$row["DAUGHTER_CELL"]."@";
if ($doubl=='no') $recap2[$nivo].=$row["MOTHER_CELL"].">".$row["DAUGHTER_CELL"]."@";


	$res=select_recursif_descendant_3($conn,$row["DAUGHTER_CELL"],$res,$nivo,$doubl);
	
	}
return $res;
}


$res=select_recursif_descendant_3($c,$id,$res,0,'yes'); //Avec doublon pour remplir recap
$res=select_recursif_descendant_3($c,$id,$res,0,'no');  //Sans doublon pour remplir recap2




	if($count==0)
	    print "<strong>No match</strong>";
	print "</center>";







//Autre chose
//On va précalculer la position des boites pour pouvoir rendre les boites cliquables
function getPere($string)
{
$tmp=explode(">",$string);
return $tmp[0];
}

function getFils($string)
{
$tmp=explode(">",$string);
$fils=substr($tmp[1],0,strlen($tmp[1]));
return $fils;
}

$box=(array) null;
$k=0;

if (count($recap)==null) 
	{
	include("frames_footer.php");
	return;	
	}

for ($a=0;$a<count($recap);$a++)
{
$tmp=explode("@",$recap[$a+1]);
$len=count($tmp)-1;
$y1=$a*150; //espace vertical entre les cellules
//80//150
//print "$y1<br>";

for ($b=0;$b<$len;$b++)
{

$x1=$b*160+150; //espace horizontal entre les cellules //+150 pour le decalage pour mettre le stade de developpement
//100
//print "($x1,$y1,$x2,$y2)<br>";

//ImageRectangle ($image, $x1, $y1, $x1+80, $y1+40, $noir);
$x2=$x1+140;
$y2=$y1+60;
//ImageRectangle ($image, $x1, $y1, $x1+140, $y1+60, $noir);
//imagestring($image, 4, 35, 15, count($recap), $blanc);
//Calcul des centres
$Cx1=($x1+($x1+140))/2;$Cy1=$y1;
//ImageSetPixel ($image, $Cx1, $Cy1, $rouge);

$Cx2=($x1+($x1+140))/2;$Cy2=$y1+60;
//ImageSetPixel ($image, $Cx2, $Cy2, $rouge);

$name=$tmp[$b];

$fils=getFils($name);
$pere=getPere($name);
$box[$k]="$a;$pere;$fils;$x1;$y1;$x2;$y2;$Cx1;$Cy1;$Cx2;$Cy2";
$k++;
}

}

$coord=explode(";",$box[1]);


print '
<MAP NAME=mymap>';
for ($a=0;$a<count($box);$a++)
{
$coord=explode(";",$box[$a]);
$requete="SELECT \"NAME\",\"DEV_STAGE_ID\" from \"ANAT_ENTITY\" where \"ANAT_ID\"='".$coord[2]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
//$region=$row["ANAT_ID"];
$reqdev=$row["DEV_STAGE_ID"];

$fat="SELECT \"KEYWORDS\" from \"FATE\" where \"ANAT_ID\"='".$coord[2]."'";
$stmt=pg_query($c,$fat);
$fate="";
while ($row=pg_fetch_array($stmt)) $fate.=$row["KEYWORDS"]." <br> ";
$fate=substr($fate,0,strlen($fate)-2);

//print '<AREA HREF="short_hierarchy.php?region='.$coord[2].'&dev='.$reqdev.'" ALT="HTML and CSS Reference" COORDS="'.$coord[3].','.$coord[4].','.$coord[5].','.$coord[6].'" onmouseover="tooltip.show(this)" onmouseout="tooltip.hide(this)" title="Fate: '.$fate.'">';
print '<AREA HREF="short_hierarchy.php?region='.$coord[2].'&dev='.$reqdev.'" ALT="HTML and CSS Reference" COORDS="'.$coord[3].','.$coord[4].','.$coord[5].','.$coord[6].'" onmouseover="return escape(\'<u>Fate</u>: <br><b>'.$fate.'</b>\');" title="Fate: '.$fate.'">';
}

print '
</MAP>
<IMG SRC="imgLineage1.php?idanat='.$id.'" ALT="" USEMAP="#mymap" BORDER="0" >
';




function rgb2html($r,$g,$b)
{
  // Le str_pad permet de remplir avec des 0
  // parce que sinon rgb2html(Array(0,255,255)) retournerai #0ffff<=manque un 0 !
  return "#" . str_pad(dechex( ($r<<16)|($g<<8)|$b ), 6, "0", STR_PAD_LEFT);
}

?>
<!--Rajout pour le tooltiptext -->
<script type="text/javascript" src="wz_tooltip.js"></script>
<?php
    include("frames_footer.php");
?>