<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("connection.php");
//Title before frames_header
print '<title>ANISEED v3.0 - Find progeny/precursors of a territory</title>';

    include("frames_header.php");
?>

<script>
var selected_part=new Array();

function popup_anatomy_selector() {
  dev = "";
  names = "";
  for(a=0; a<window.document.formulaire.elements['devstage[]'].options.length; ++a){
  	if(window.document.formulaire.elements['devstage[]'].options[a].selected==true){
	  	dev  += window.document.formulaire.elements['devstage[]'].options[a].value+':'; // tab[a-1]+':';
		names+= window.document.formulaire.elements['devstage[]'].options[a].text+':';
	}
  }
  if(dev.length<=1){
  	alert("Select an Ascidian species and specific developmental stages first");
	return;
  }
  
  species=window.document.formulaire.species.options[window.document.formulaire.species.selectedIndex].text;

  if ((window.document.anat_keywords == null) || (window.document.anat_keywords.closed == true)) {
    window.document.anat_keywords = window.open("anatomyTreeLine.php?namedev="+names+"&iddev="+dev+"&species="+species,"anat_keywords","menubar=yes,toolbar=no,scrollbars=yes,resizable=yes,height=500,width=600");
  } else {
    window.document.anat_keywords.focus();
  }
}


function update(){
	window.document.formulaire.elements['region[]'].options.length = selected_part.length;
	//ids="";
	for(a=0; a<selected_part.length; ++a){
		window.document.formulaire.elements['region[]'].options[a].text  = selected_part[a][0];//+" ("+selected_part[a][1]+")";
		window.document.formulaire.elements['region[]'].options[a].value = selected_part[a][1];
		//ids+=selected_part[a][1]+":";
	}
	//window.document.formulaire.idanat.value=ids;
}

function addtoarray(name,value){
	selected_part[selected_part.length]=[name,value];
	update();
}

function retrenchtoarray(num){
	selected_part.splice(num,1);
	update();
}

function remove_structures(){
	
	for(a=0; a<selected_part.length; ++a){
		if(window.document.formulaire.elements['region[]'].options[a].selected == true){
			selected_part.splice(a,1);
			window.document.formulaire.elements['region[]'].options[a]=null;
			a-=1;
		}
	}
	update();
	//reloadit();
}

function reset_structures(){
	window.document.formulaire.elements['region[]'].options.length=0;
	selected_part=new Array();
	//window.document.formulaire.idanat.value='';
	//reloadit();
	update();
}


function selectanatomy(){
  for(a=0; a<window.document.formulaire.elements['region[]'].options.length; ++a){
 		window.document.formulaire.elements['region[]'].options[a].selected=true;
  }
}
</script>

<div style="border-top:0px solid black;border-bottom:1px solid black;">
<font color="#D64242" size="3"><b>Find progeny/precursors of a territory</b></font>
</div>

<br>
This page allows you to retrieve from the lineage data the precursors/ 
progeny of a territory of interest. Select your species,
developmental stage and add territories by clicking on the Add
button. A pop up window opens that allows to select territories from
the relevant anatomical ontology. You can remove territories or reset
the whole field. Before submitting tick on the rightwhether you
want to see the progenitors, progeny or both. Upon submissionof the
requestthe relevant part of the lineage is displayed in a new window.
<br>

<center>

<form name="formulaire" action="lineage-result.php" method="post" target="_blank">
<?php
            $celllist="";
			if(isset($_POST["celllist"]))
            	$celllist=$_POST["celllist"];
            if(strlen($celllist)>0)
			      print "<center><H2><font color=\"#FF6600\">Refine subset mode</font> <a href=\"lineage-search.php\" target=\"_self\"><img src=\"pictures/button-reset.jpg\" border=\"0\" align=\"middle\"></a> </H2></center>";
            
			print '<input name="celllist" type="hidden" value="'.$celllist.'">';
//////////////////////////////////////////////////////////////////////////////////////////////////////////

?>

            
	        <table width="99%" border="0" cellspacing="0" cellpadding="0">
              
              <tr> 
                <td>&nbsp;</td>
                <td>&nbsp;</td>
				<td>&nbsp;</td>
              </tr>
			  
              <tr> 
                
				<td align="center" valign="top">
				    <font color="#456898" size="2"><b>Species</b></font>
				    <!--
					<select name="species" size="1" onChange="javascript: self.location.href = 'fate-search.php?species=' + this.options[ this.selectedIndex ].value;">
					<select name="species" size="1" onChange="javascript: self.formulaire.action='lineage-search.php'; self.formulaire.target='_self'; submit();">
					-->
					<br>
					<!--<select name="species" size="1" onChange="javascript: document.forms[0].action='lineage-search.php'; document.forms[0].target='_self'; submit();">-->
					<select name="species" size="1" onChange="javascript: document.formulaire.action='lineage-search.php'; document.formulaire.target='_self'; submit();">
						<option></option>
						<?php
							$species="";
							if (isset($_POST["species"])) $species=$_POST["species"];

							$requete="Select \"NAME\" from \"SPECIES\" order by \"NAME\"";
							$stmt = pg_query($c,$requete);
							while( $row=pg_fetch_array($stmt) ){
								$name=$row["NAME"];
								print "<option";
								if($species==$name)
								    print " selected";
								print ">$name</option>";
							}
						?>
				    </select>&nbsp;
				</td>
                <td align="center" valign="top">
		            <font color="#456898" size="2"><b>Developmental stage</b></font><br>
                    <select name="devstage[]" size="10" multiple style="width:200">
                    
                    <?php
						
						if(strlen($species)>0){
							 $query="SELECT \"NAME\", \"DEV_STAGE_ID\" FROM \"DEV_STAGE\" WHERE \"SPECIES\"='$species' ORDER BY \"DEV_PERCENT\"";
							 $stmt = pg_query($c,$query);
	
							 while($row=pg_fetch_array($stmt)){
								print "<option value=\"".$row["DEV_STAGE_ID"]."\">";
								print $row["NAME"]."</option>\n";
								
							 }
						}
					 ?>
                  </select>
				</td>
				<td align="center" valign="top">
				    
				    <table width="100%" border="0" cellspacing="0" cellpadding="0">
					  <tr>
						<td align="center">
						    <font color="#456898" size="2"><b>Anatomical part</b></font><br>
						    <select name="region[]" size="10" multiple style="width:200">
						        
                            </select>
							<br>
							<img src="pictures/button-add.jpg" onClick="self.popup_anatomy_selector();" border="0">
							<img src="pictures/button-remove.jpg" onClick="self.remove_structures();" border="0">
							<img src="pictures/button-reset.jpg" onClick="self.reset_structures();" border="0">

					    </td>
						<td>
						    <input name="ance" type="checkbox" value="y" checked><font color="#656565" size="-1">Progenitor</font>
							<br>
						    <input name="desc" type="checkbox" value="y"><font color="#656565" size="-1">Progeny</font>
							<br><br>
						    <input name="and" type="radio" value="y"><font color="#656565" size="-1">and</font>
							&nbsp;&nbsp;
							<input name="and" type="radio" value="n" checked><font color="#656565" size="-1">or</font>
						</td>
					  </tr>
					</table>

				</td>
              </tr>
			  
              <tr> 
                <td><hr size="1" color="#505F70"></td>
                <td><hr size="1" color="#505F70"></td>
				<td><hr size="1" color="#505F70"></td>
              </tr>
			  
              <tr>
                <td>&nbsp;</td>
				<td>&nbsp;</td>
                <td align="right">
				    <input name="submit" type="image" src="pictures/button-submit.jpg" onClick="self.selectanatomy(); submit">
					&nbsp;&nbsp;
				    <br>
				</td>
              </tr>
            </table>
</form>

</center>


<?php
    include("frames_footer.php");
?>