<!-- search insitus by its genes, transcripts or clones studied -->
<html>
<head>
<title>ANISEED - Expression data search by molecule (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page allows you to find Halocynthia roretzy and Ciona intestinalis in situ expression patterns associated to a gene or EST/cDNA clone.">
<meta name="keywords" content="Tassy, Lemaire, Ciona experiment data, Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database, expression data, EST, cDNA clone, in situ data, search interface">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    //connection
	include("connection.php");


	$regionarray=array();
	array_pop($regionarray);
	$idanatarray=array();
	array_pop($idanatarray);
	
	
	if(isset($_POST["celllist"])){
		$regionarray=split(":",$_POST["celllist"]);
		array_pop($regionarray);
	    $idanatarray=$regionarray;
        array_pop($idanatarray);
	}else{
	
	if(isset($_GET["region"])){
		$regionarray=split(":",$_GET["region"]);
		array_pop($regionarray);
	}
    if(isset($_GET["idanat"])){
	    $idanatarray=split(":",$_GET["idanat"]);
        array_pop($idanatarray);
	}
	
	}
	
?>

<SCRIPT>

var selected_part=new Array();

<?php

    //init du tableau avec les valeurs de l'espece precedente
	if(count($regionarray)==count($idanatarray)){
		for($a=0;$a<count($regionarray);++$a){
			print "self.addtoarray('$regionarray[$a]','$idanatarray[$a]');";
		}
	}

?>

function popup_anatomy_selector() {

  tab=window.document.formulaire2.iddev.value.split(":");
  dev = "";
  names = "";
  for(a=1; a<window.document.formulaire.devstage.options.length; ++a){
  	if(window.document.formulaire.devstage.options[a].selected==true){
	  	dev+= tab[a-1]+':';
		names+= window.document.formulaire.devstage.options[a].text+':';
	}
  }
  if(dev.length<=1){
  	alert("Select an Ascidian species and specific developmental stages first");
	return;
  }
  
  species=window.document.formulaire.species.options[window.document.formulaire.species.selectedIndex].text;

  if ((window.document.anat_keywords == null) || (window.document.anat_keywords.closed == true)) {
    window.document.anat_keywords = window.open("anatomytree.php?namedev="+names+"&iddev="+dev+"&species="+species,"anat_keywords","menubar=yes,toolbar=no,scrollbars=yes,resizable=yes,height=500,width=600");
  } else {
    window.document.anat_keywords.focus();
  } 
}

function reset_structures(){
	window.document.formulaire.region.options.length=1;
	selected_part=new Array();
	window.document.formulaire.idanat.value='';
	reloadit();
}

function remove_structures(){
	
	for(a=0; a<selected_part.length; ++a){
		if(window.document.formulaire.region.options[a+1].selected == true){
			selected_part.splice(a,1);
			window.document.formulaire.region.options[a+1]=null;
			a-=1;
		}
	}
	update();
	reloadit();
}

function addtoarray(name,value){
	selected_part[selected_part.length]=[name,value];
}

function retrenchtoarray(num){
	selected_part.splice(num,1);
}

function update(){
	window.document.formulaire.region.options.length = selected_part.length + 1;
	ids="";
	for(a=0; a<selected_part.length; ++a){
		window.document.formulaire.region.options[a+1].text = selected_part[a][0];//+" ("+selected_part[a][1]+")";
		ids+=selected_part[a][1]+":";
	}
	window.document.formulaire.idanat.value=ids;
	
}

function reloadit(){
	
  	//tab=window.document.formulaire2.iddev.value.split(":");
	//alert (tab);
	window.document.formulaire.selectediddev.value="";
	dev='';
	for(a=1; a<window.document.formulaire.devstage.options.length; ++a){
  		if(window.document.formulaire.devstage.options[a].selected==true){
	  		//dev+= tab[a-1]+':';
			window.document.formulaire.selectediddev.value+=window.document.formulaire.devstage.options[a].value+":";
	
		}	
  	}
	//window.document.formulaire.selectediddev.value=dev;
	//alert (window.document.formulaire.selectediddev.value);
	
	
	if( (window.document.anat_keywords != null)&&(window.document.anat_keywords.closed == false) ) {
		window.document.anat_keywords.close();
		popup_anatomy_selector();
	}
}

function getSelectedAnatomy(){
    str="";
    for(a=1; a<window.document.formulaire.region.options.length ;++a){
	    str+=window.document.formulaire.region.options[a].text+":";
	}
	return (str);
}

function getTarget(){

	    targ=window.document.formulaire.target.value;
	return (targ);
}


function enableField(){
    if(window.document.formulaire.fatemode[0].checked==true){
        window.document.formulaire.region.disabled=false;
		window.document.formulaire.elements['fate[]'].disabled=true;
		window.document.formulaire.elements['notfate[]'].disabled=true;
	}else{
        window.document.formulaire.region.disabled=true;
		window.document.formulaire.elements['fate[]'].disabled=false;
		window.document.formulaire.elements['notfate[]'].disabled=false;
	}
}
</SCRIPT>

<?php
    include("frames_header.php");

?>

<?php

    $species="";
	if (isset($_GET["species"])) $species=$_GET["species"];


	if(strlen($species)>0){
	$requete="SELECT \"NAME\", \"DEV_STAGE_ID\" FROM \"DEV_STAGE\" WHERE \"SPECIES\"='$species' ORDER BY \"DEV_PERCENT\"";
		$query=pg_query($c,$requete);
		
	}

	$author="";
	if((isset($_GET["author"]))and(strlen($_GET["author"])>0))
	    $author=$_GET["author"];

	$pmid="";
	if((isset($_GET["pmid"]))and(strlen($_GET["pmid"])>0))
	    $pmid=$_GET["pmid"];
	
	$mutant="";
	if((isset($_GET["mutant"]))and(strlen($_GET["mutant"])>0))
	    $mutant=$_GET["mutant"];
		
	$moltype="";
	if((isset($_GET["MOLtype"]))and(strlen($_GET["MOLtype"])>0))
	    $moltype=$_GET["MOLtype"];
	else
	    $moltype="2";


	$target="";
	if((isset($_GET["target"]))and(strlen($_GET["target"])>0))
	    $target=$_GET["target"];
	else{
	    if((isset($_POST["genelist"]))and(strlen($_POST["genelist"])>0)){ //get the gene set to refine
		if (substr_count($_POST["genelist"],":")<=100)
		       { 
			
			$target=$_POST["genelist"];
			$moltype=2;}
		else
			{
			$target="Error! \nTOO MANY MOLECULES ...\nLimit: 100 molecules ";
			}
		}
	}
	
		
	$order="DEV_STAGE_ID";
		
	$boolmut="";
	if((isset($_GET["BOOLmut"]))and(strlen($_GET["BOOLmut"])>0))
	    $boolmut=$_GET["BOOLmut"];
	else
	    $boolmut="3";
		
	$booltarg="";
	if((isset($_GET["BOOLtarg"]))and(strlen($_GET["BOOLtarg"])>0))
	    $booltarg=$_GET["BOOLtarg"];
	else
	    $booltarg="0";
		
	$only="";
	if((isset($_GET["only"]))and(strlen($_GET["only"])>0))
	    $only=$_GET["only"];
	else
	    $only="0";
		
	$boolanat="";
	if((isset($_GET["BOOLanat"]))and(strlen($_GET["BOOLanat"])>0))
	    $boolanat=$_GET["BOOLanat"];
	else
	    $boolanat="0";
		
	$boolmanip="";
	if((isset($_GET["BOOLmanip"]))and(strlen($_GET["BOOLmanip"])>0))
	    $boolmanip=$_GET["BOOLmanip"];
	else
	    $boolmanip="2";

	$fatemode="";
	if((isset($_GET["fatemode"]))and(strlen($_GET["fatemode"])>0))
	    $fatemode=$_GET["fatemode"];
	else
	    $fatemode="0";
?>

<div style="border-top:0px solid black;border-bottom:1px solid black;">
<font color="#D64242" size="3"><b>In situ staining search by molecule.</b></font><br>
</div><br>
<font size="2">
This page allows you to find the in situ expression patterns
associated to a gene or EST/cDNA clone.
<br>
Select a species, a developmental stage, and a gene of interest
(stained molecule). The gene model ID can be found following the
"Find a gene model by its name" link.
</font>
<br>
<br>

        

		<form Method="POST" Action="insitu-result-POST.php" name="formulaire" target="_blank">


<TABLE width="100%">
<TR>
<TD valign="top">

<div  style="padding:5px;background-color:#f0fbfe;color:#D64242;"><font size="-1"><b> Species </b></font></div>
<div style="padding:5px;background-color:white;border:0px solid black;">


<center>
<select name="species" size="1" onChange="javascript: self.location.href = 'insitu-search-by-molecule.php?species=' + this.options[ this.selectedIndex ].value + '&BOOLmut=' + window.document.formulaire2.radioBOOLmut.value + '&MOLtype=' + window.document.formulaire2.radioMOLtype.value + '&BOOLtarg=' + window.document.formulaire2.radioBOOLtarg.value + '&only=' + window.document.formulaire2.radioOnly.value + '&BOOLanat=' + window.document.formulaire2.radioBOOLanat.value + '&idanat=' + window.document.formulaire.idanat.value + '&BOOLmanip=' + window.document.formulaire2.radioBOOLmanip.value + '&fatemode=' + window.document.formulaire2.radiofatemode.value  + '&target=' + self.getTarget();">
					  <option ></option>
                      <?php
							$requete5="Select \"NAME\" from \"SPECIES\" order by \"NAME\"";

							$query5=pg_query($c,$requete5);							

							while( $row5=pg_fetch_array($query5) ){
								$name=$row5["NAME"];
								print "<option value=\"$name\"";
								if($species==$name)
									print " selected";
								print ">$name</option>";
							}
					 
					?>
                    </select>
<br></center>
</div>
</div>
</TD>
</TR>
<TR>
<TD valign="top">
<div  style="padding:5px;background-color:#f0fbfe;color:#D64242;"><font size="2"><b>Developmental Stage(s) </b></font></div>
<div style="padding:5px;background-color:white;border:0px solid black;">
<center>
<select name="devstage" size="5" multiple onChange="self.reloadit()">
                    <option>_____________any____________</option>
                    <?php

			if (strlen($species)>0)
				{
						 $id="";
						 while($row=pg_fetch_array($query))
						 {
							print "<option value=\"".$row["DEV_STAGE_ID"]."\">";
							print $row["NAME"]."</option>\n";
							
							$id .= $row["DEV_STAGE_ID"].":";
						 }
					print "<hr><hr><hr><hr><hr><hr><hr><hr><hr>======================>$id";
				}
					  	?>
                  </select> <input type="hidden" name="selectediddev" value=""> 
                  <input type="hidden" name="idanat" value="<?php if (isset ($_GET["idanat"])) print $_GET["idanat"]; else if (isset ($_POST["celllist"])) print $_POST["celllist"];?>"> 

</center>
</div>
</div>
</TD>
</TR>
</TABLE>


<!-------- STAINED MOLECULE --------->

<br>
<div  style="padding:5px;background-color:#f0fbfe;color:#D64242;"><font size="2"><b> Stained Molecule(s) </b></font></div>
<div style="padding:5px;background-color:white;border:0px solid black;">
<font color="#656565">
<br>
<center>
Paste a molecule ID or list of molecule IDs you want to know the expression pattern of.<br><br>
<textarea name="target" cols="50" rows="1"><?php print $target ?></textarea>&nbsp;&nbsp; <br>
<input type="hidden" name="BOOLtarg" value="0"> <!-- former or -->
<br>

<table width="50%">
<tr>
<td>
<input name="MOLtype" type="radio" value="1" <?php if($moltype=="1")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioMOLtype.value='1';}">
<font color="#656565" size="-1">Clone &nbsp;&nbsp;</font><font color="#656565" size="-1">(e.g. 002ZE11, AF305499)</font> <br>
</td>
</tr>
<tr>
<td>
<input name="MOLtype" type="radio" value="2" <?php if($moltype=="2")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioMOLtype.value='2';}">
<font color="#656565" size="-1">Transcript models &nbsp;&nbsp;<br> (e.g. ci0100133709, KYOTOGRAIL2005.98.32.1, ENSCINT00000018028, ...)</font><br>
</td>
</tr>
<tr>
<td>
<input name="MOLtype" type="radio" value="10" <?php if ($moltype=="10") print "checked"; ?>
onclick="javascript: if (this.checked) {window.document.formulaire2.radioMOLtype.value='10';}"> 
<font color="#656565" size="-1"> Aniseed Gene model (e.g. aniseedV3_3592,...)</font><br>
</td>
</tr>
</table>
</center>
<br>
By default only the WT expression patterns are shown. Expression patterns in manipulated conditions (gene deregulation, embryo manipulation) can be accessed by filling the next 2 sections.
<br><br>
<div style="background-color:white">
<strong>Notes:</strong>&nbsp;&nbsp;
* You can enter a list of several IDs, separated by the ":" symbol without space. If you are searching for a C.intestinalis transcript model please use its
JGIv1.0, Kyotograil or ENSEMBL transcript model ID found using the <a href="gene-search.php"  target="_blank"><font color="#3366CC">"Find a gene "</font></font></a> interface
</div>
</font>
</div>
<br>
<br>

<!-------------- DEREG -------------------->
<br>
<div style="padding:5px;background-color:#f0fbfe;color:#D64242;"><font size="2"><b> Deregulated Molecule(s) </b></font></div>
<div style="padding:5px;background-color:white;border:0px solid black;">
<font color="#656565">
<center>
This section gives access to expression patterns in response to the deregulation of the specified gene(s).<br> If you leave the textbox empty and click on "include expression pattern in deregulated context" all data in Deregulated contexts will be included in the result 
<br><br>
Paste a Transcript Model ID (JGI, Kyoto or Ensembl) or a list of Transcript Model ID that have been deregulated. <br><br>

<input name="mutant" type="text" size="30" value="<?php print $mutant; ?>">  &nbsp;&nbsp;&nbsp;(eg. ci0100133709, ...) 
<br>
<br>
<table width="50%">
<tr>
<td>
<input name="BOOLmut" type="radio" value="0" <?php if($boolmut=="0")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioBOOLmut.value='0';}">
<font color="#656565" size="-1"> Include expression patterns in Deregulated Context</font>
</td>
</tr>
<tr>
<td>
<input name="BOOLmut" type="radio" value="3" <?php if($boolmut=="3")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioBOOLmut.value='3';}">
<font color="#656565" size="-1"> Exclude expression patterns in Deregulated Context</font> <br>
</td>
</tr>
</table>
</center>
<br>
<div style="background-color:white">
<strong>Notes:</strong>&nbsp;&nbsp;
* You can enter several names by separating your entries with the ":"
symbol without space. If you are searching for a C.intestinalis transcript model please use its
JGIv1.0, Kyotograil or ENSEMBL transcript model ID found using the <a href="gene-search.php"  target="_blank"><font color="#3366CC">"Find a Gene"</font></font></a> interface
</div>
</font>
</div>
<br>
<br>
<!------------------------------------------------------------->

<!------------------EMBRYO MANIP------------------------------->
<br>
<div style="padding:5px;background-color:#f0fbfe;color:#D64242;"><font size="2"><b> Embryo Manipulation </b></font></div>
<div style="padding:5px;background-color:white;border:0px solid black;">
<center>
<font color="#656565">
This section gives access to expression patterns in experimentally manipulated embryos. Embryo manipulations  correspond to  the ablation of specific cells or territories
<br><br>
<table width="50%">
<tr>
	<td>
	<input name="BOOLmanip" type="radio" value="0" <?php if($boolmanip=="0")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioBOOLmanip.value='0';}">
        <font color="#656565" size="-1">Include expression patterns in experimentally manipulated embryos </font>
	</td>
</tr>
<tr>
	<td>
	<input name="BOOLmanip" type="radio" value="2" <?php if($boolmanip=="2")print"checked"; ?> onclick="javascript:if(this.checked){window.document.formulaire2.radioBOOLmanip.value='2';}">
                    <font color="#656565" size="-1">Exclude expression patterns in experimentally manipulated embryos</font>
	</td>
</tr>
</table>
</font>
</center>
</div>
<!-------------------------------------------------------------->
<br><br>

<input type="hidden" name="Order" value="DEV_STAGE_ID">




<center>
<input name="submit" type="image" src="pictures/button-submit.jpg" onClick="submit"> 
</center>	
		
</form>
		
 
	  


        <form name="formulaire2">
          <input type="hidden" name="radioOrder" value="<?php print $order; ?>">
          <input type="hidden" name="radioBOOLmanip" value="<?php print $boolmanip; ?>">
          <input type="hidden" name="radioBOOLmut" value="<?php print $boolmut; ?>">
          <input type="hidden" name="radioMOLtype" value="<?php print $moltype; ?>">
          <input type="hidden" name="radioBOOLtarg" value="<?php print $booltarg; ?>">
          <input type="hidden" name="radioOnly" value="<?php print $only; ?>">
          <input type="hidden" name="radioBOOLanat" value="<?php print $boolanat; ?>">
		  <input type="hidden" name="iddev" value="<?php print $id; ?>">
		  <input type="hidden" name="radiofatemode" value="<?php print $fatemode; ?>">


        </form>


<script type="text/javascript" src="wz_tooltip.js"></script>

<?php
	
    include("frames_footer.php");
?> 
