<!-- Display all results of insitu search scripts -->
<html>
<head>
<title>ANISEED - In situ results (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page lists Halocynthia roretzi or Ciona intestinalis expression data. For more information, contact the Aniseed team">
<meta name="keywords" content="Experiment data, Ciona intestinalis expression data, Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database, expression data, in situ data">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    //connection
	include("connection.php");

    include("frames_header.php");
//Nouvel ajout pour la navigation
include("navigation.php");


function to_target_JGI($c,$gene)
{

$t=(array) null;
$requete="
SELECT \"MOL_ID\" as \"ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
UNION 
select \"CLONE_SEQ_ID\" as \"ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene')
UNION
select \"CLONE_ID\" as \"ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene')
)
";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $t[$row["ID"]]++;
return $t;
}


function to_target_KYOTO($c,$gene)
{
$t=(array) null;
$tkyo=explode(".",$gene);
$kabstract=$tkyo[0].".".$tkyo[1].".".$tkyo[2];

$requete="select \"MOL_ID\" as \"ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract' and \"TYPE\"='abstract')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract' and \"TYPE\"='abstract')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $t[$row["ID"]]++;
return $t;
}

function to_target_ENS($c,$gene)
{

$t=(array) null;

$requete="select \"MOL_ID\" as \"ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$gene'))
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$gene'))
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $t[$row["ID"]]++;
return $t;
}



function to_target($c,$gm)
{

$requete="SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$gm'";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
$requete0="SELECT \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"='".$row["GENE_MODEL_ID"]."'";
$stmt0=pg_query($c,$requete0);
$row0=pg_fetch_array($stmt0);
//print "===".$row0["NAME"];
$t=(array) null;
$u=(array) null;
$v=(array) null;
if ($row0["NAME"]{0}=="c") $t=to_target_JGI($c,$row0["NAME"]);
if ($row0["NAME"]{0}=="K") $u=to_target_KYOTO($c,$row0["NAME"]);
if ($row0["NAME"]{0}=="E") $v=to_target_ENS($c,$row0["NAME"]);
if (count($t)>0) foreach ($t as $key => $val) if (strlen($w[$key])==0) $w[$key]=$val;
if (count($u)>0) foreach ($u as $key => $val) if (strlen($w[$key])==0) $w[$key]=$val;
if (count($v)>0) foreach ($v as $key => $val) if (strlen($w[$key])==0) $w[$key]=$val;
}
$res="";
foreach ($w as $key => $val) if (strlen($res)==0) $res="'$key'";else $res.=",'$key'";
return $res;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


?>

<SCRIPT>
function ZoomIn() {
		for(a=0;a<document.images.length;++a){
			if( (document.images[a].name=="pics") && (document.images[a].width+20 < 1000) )
				document.images[a].width+=20;
		}
}
function ZoomOut() {
		for(a=0;a<document.images.length;++a){
			if( (document.images[a].name=="pics") && (document.images[a].width-20 > 0) )
				document.images[a].width-=20;
		}
}
</SCRIPT>






<?php
	
	//connection
	//include("connection.php");
	
	
	//variables pour le systeme page suiv/prec
	if( isset($_GET["option"]) ) $option=$_GET["option"];
	if( isset($_GET["offset"]) ) $offset=$_GET["offset"];
	if( isset($_GET["nbMAX"])  ) $nbMAX=$_GET["nbMAX"];
	
	if(! isset($option)) $option= 1;
	if(! isset($offset)) $offset= 0;
	if(! isset($nbMAX)) $nbMAX= 20;
	
	
	//recup species
	if(isset($_GET["species"]))
		$species = $_GET["species"];
	
	//recup regions	
	/*Test sur la selection d'une partie anatomique dans la page précédente*/
	if(isset($_GET["idanat"]))
	{
		$id = $_GET["idanat"];
		if ($id=="undefined:")
		{
			print "<br><br><center><h2><strong>Error, please select an anatomical part.</strong></h2></center><br><br>";
			include ("frames_footer.php");
			return;
		}
		else
		{
			$requete="SELECT \"DEV_STAGE_ID\" AS stage from \"ANAT_ENTITY\" where \"ANAT_ID\"='$id'";
			$stmt=pg_query($c,$requete);
			$row=pg_fetch_array($stmt);
			$stage=$row["stage"];
		}
	}

	
	if($id)
	{
?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<!-- Header pour l'onglet -->
<div id="header">
  <ul>
    <li><a href="anatomy.php?species=<?print $species;?>&dev=<?print $stage;?>&region=<?print $id;?>">Anatomical Ontology</a></li>
    <li><a onclick="this.href='short_hierarchy.php?region=<? print $id;?>&dev=<?print $stage;?>'" href="">Anatomical Territory Summary Card</a></li>
    <li><a href="lineage.php?idanat=<?print $id?>">Lineage</a></li>
    <li id="current"><a href="">Molecular Markers</a></li>
	<li>
					<a onclick="this.href='anatomy-regulation-card.php?idanat=<?print $id;?>'" href="#">
						Regulatory Network
					</a>
				</li>
			
	
  </ul>
</div>

<?php
	}
	/////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////requete//////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////
	
	
	if( (strlen($_GET["idanat"])>1)&&($_GET["fatemode"]==0) ){

// 		print $_GET["idanat"]."<br>";

		$sql_region='';
		$tabanat=split(":",$_GET["idanat"]);
// 		array_pop($tabanat);
		
// 		print_r($tabanat);

		if($_GET["BOOLanat"]==1){//and
			//signifie que l'on cherche aussi les parents des anat fournis
			if($_GET["xref"]==1)
			{
/* SIMULATION D'UNE REQUETE SUR HIERARCHIE PAR UNE PROCEDURE DE REQUETES RECURSIVES */
$IN1="";
function select_recursif_descendant_2($conn,$start,$res)
{
global $IN1;

if ($start!='')
$requete2="SELECT * FROM \"ANAT_ENTITY\" WHERE \"ANAT_ID\"= $start ";
else return;

$stmt2=pg_query($conn,$requete2);
while($row2=pg_fetch_array($stmt2))
	{
	$IN1.=$row2["ANAT_ID"].",";
	$res=select_recursif_descendant_2($conn,$row2["CHILD_OF"],$res);
	}
return $res;
}
/* FIN DE LA SIMULATION */

				for($a=0;$a<count($tabanat);++$a)
					{
					$IN1="";
					$res=select_recursif_descendant_2($c,$tabanat[$a],$res);
					//$IN1=substr($IN1,0,strlen($IN1)-1);
					$IN1.=$tabanat[$a];
					
					if ($IN1=="") $IN1="0";	/*Cas du IN vide*/
					$sql_region.="INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" IN(".
					$IN1.") ";
					}
		/*IN1=SELECT ANAT_ID FROM CIONA_DESIGN.ANAT_ENTITY CONNECT BY ANAT_ID = PRIOR CHILD_OF START WITH ANAT_ID= $tabanat[$a] */
			
			}
			//signifie que l'on cherche aussi les enfants des anat fournis
			else if($_GET["xref"]==2)
			{
/* SIMULATION D'UNE REQUETE SUR HIERARCHIE PAR UNE PROCEDURE DE REQUETES RECURSIVES */
$IN2="";
function select_recursif_descendant($conn,$start,$res)
{
global $IN2;

if ($start!='')
$requete2="SELECT * FROM \"ANAT_ENTITY\" WHERE \"CHILD_OF\"= $start ";
else return;

$stmt2=pg_query($conn,$requete2);
while($row2=pg_fetch_array($stmt2))
	{
	$IN2.=$row2["ANAT_ID"].",";
	$res=select_recursif_descendant($conn,$row2["ANAT_ID"],$res);
	}
return $res;
}
/* FIN DE LA SIMULATION */





				for($a=0;$a<count($tabanat);++$a)
					{
					$IN2="";
					$res=select_recursif_descendant($c,$tabanat[$a],$res);
					//$IN2=substr($IN2,0,strlen($IN2)-1);
					$IN2.=$tabanat[$a];
					if ($IN2=="") $IN2="0"; /*Cas du IN vide*/
					$sql_region.="INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" IN(".$IN2.") ";
					}






/*SELECT ANAT_ID FROM CIONA_DESIGN.ANAT_ENTITY CONNECT BY  CHILD_OF = PRIOR ANAT_ID START WITH ANAT_ID= $tabanat[$a]*/

			}
			//signifie que l'on cherche le terme exact
			else{
				for($a=0;$a<count($tabanat);++$a){
					$sql_region.=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" = $tabanat[$a]";
				}
			}
							
//AJOUT	: 10/12/2009 /////////////////////////
			if($_GET["BOOLmut"]==3)
			{//none
		    //$sql_mutant=" INTERSECT select in_situ_id from ciona_design.in_situ where wild_type='y'";
			$sql_region.=" INTERSECT select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" not in (select \"IN_SITU_ID\" from \"MUTANT\")";
			}
			
			if($_GET["BOOLmanip"]==1)
			{
	    			$sql_region.=" INTERSECT select \"IN_SITU_ID\" from \"EMBRYO_MANIP\"";
			}
			else 
			if($_GET["BOOLmanip"]==2)
			{
			$sql_region.=" INTERSECT select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" not in (select \"IN_SITU_ID\" from \"EMBRYO_MANIP\")";
			}
				
//////////////////////////////////////////////

			if($_GET["only"]==1){  //gestion du only  //avec le and on veut autant de trucs marques que de trucs selectionnes mais pas plus.
			    /*$sql_region.=" intersect select \"IN_SITU_ID\" from (select \"TARGET.*, count(*) over (partition by in_situ_id) count from CIONA_DESIGN.TARGET) where count = ".(count($tabanat));*/

			$sql_region.=" EXCEPT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" NOT IN (".(join(",",$tabanat)).")";


			}
			
		}else{//or
			$zz=join(",",$tabanat);
			//if($_GET["only"]==2)  //gestion de l'option "not stained"
			//    $sql_region="INTERSECT SELECT IN_SITU_ID FROM CIONA_DESIGN.TARGET WHERE NOT EXIST( REGION_ID IN(".$zz.") )";
		    //else
			
			$sql_region=" INTERSECT (SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" IN (".$zz.") ";
			if($_POST["only"]==1){  //gestion du only  //avec le or on veut juste l'un des trucs selectionnes comme marqué ou une combinaison mais pas plus.
			    $sql_region.=" EXCEPT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" NOT IN (".$zz.")";
			}
			$sql_region.=")";
			
			/*
			$sql_region="INTERSECT SELECT IN_SITU_ID FROM CIONA_DESIGN.TARGET WHERE ( REGION_ID IN(".$zz.") )";
			
			if($_GET["only"]==1){  //gestion du only  //avec le or on veut juste l'un des trucs selectionnes de marqué mais pas plus.
			    $sql_region.=" intersect select IN_SITU_ID from (select CIONA_DESIGN.TARGET.*, count(*) over (partition by in_situ_id) count from CIONA_DESIGN.TARGET) where count = 1";
			}
			*/
		    
		}
		
	}

	
	
	// Les Fates
$sql_fate="";
$tabfate="";
if(isset($_POST["fate"]))
$tabfate=$_POST["fate"];

$tabfatelist="";
if(is_array($tabfate)){
$tabfatelist=join("','",$tabfate);
}else{
$tabfatelist=$tabfate;
//$tabfate=split("','",$tabfatelist);
}
//print $tabfate[0];
if((strlen($tabfatelist)>0)&&($_POST["fatemode"]==1))
{ 
$sql_fate="INTERSECT(SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"REGION_ID\" in (select \"ANAT_ID\" from \"FATE\" where \"KEYWORDS\" in ('".$tabfatelist."')))";
}
	
	
	
	//get dev stage id
	//ne s'utilise qu'en l'absence d'anat_id
	//if( (strlen($_GET["selectediddev"])>1)&&((! strlen($sql_region)>0)||$_GET["only"]==2) ){
	if( (strlen($_GET["selectediddev"])>1)&&(! strlen($sql_region)>0) ){
		$tabdev=split(":",$_GET["selectediddev"]);
		array_pop($tabdev);
		$zz=join(",",$tabdev);
		
		$sql_dev_stage="INTERSECT SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE ( \"DEV_STAGE_ID\" IN(".$zz.") )";
	}
	
	//check authors
	if( strlen($_GET["author"])>1 ){
		$author=split(":",$_GET["author"]);
		$zz=join("','",$author);
		$zz=strtoupper($zz);
		
		$sql_author="INTERSECT SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE \"IN_SITU_ID\" IN(  select \"BIO_ID\" from \"ENTRY_ORIGIN\" where \"AUTHOR_ID\" in (select \"AUTHOR_ID\" from \"AUTHOR\" where UPPER(\"NAME\") in ('".$zz."') ) ) ";
	
	}
	
	//check annotator
	if( strlen($_GET["annotator"])>1 ){
		$annot=split(":",$_GET["annotator"]);
		$zz=join("','",$annot);
		$zz=strtoupper($zz);
		
		$sql_annot="INTERSECT SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE \"IN_SITU_ID\" IN(  select \"BIO_ID\" from \"ENTRY_ORIGIN\" where \"ANNOTATOR_ID\" in (select \"AUTHOR_ID\" from \"AUTHOR\" where UPPER(\"NAME\") in ('".$zz."') ) ) ";
	
	}

	//check pmid

	if( strlen($_GET["pmid"])>1 ){
		$pmid=split(":",$_GET["pmid"]);
		$zz=join("','",$pmid);
		$zz=strtoupper($zz);
		
		$sql_pmid="INTERSECT SELECT \"BIO_ID\" AS \"IN_SITU_ID\" FROM \"REFERENCE\" where \"PUBMED_ID\"='$zz' ";
	}



	
	//get targets
	if(strlen($_GET["target"])>0){
		$targetTMP = split(":",strtoupper($_GET["target"]));
		
		if(count($targetTMP)>100){
		    print "<br><br><strong>ERROR:</strong> due to performance reasons, you cannot search for more than 100 molecules";
		    include ("frames_footer.php");
			return;
		}
		
		$sql_target='';
		if($_GET["BOOLtarg"]==1){//and

			if($_GET["MOLtype"]==2){ //si c un gene -> recup des clones correspondant
			/*
				for ($a=0; $a < count($targetTMP); ++$a){
                    $sql_target.=" INTERSECT SELECT IN_SITU_ID FROM CIONA_DESIGN.TARGET WHERE TARGET_ID IN ( select B.clone_id from ciona_design.clone_seq A, ciona_design.clone B where (A.clone_name=B.clone_name) and A.cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where name='$targetTMP[$a]')) ) OR TARGET_ID IN ( select clone_seq_id from ciona_design.clone_seq where cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where name='$targetTMP[$a]')) )";
				}
			*/
			
				////nouvelle version pour utiliser le clustering maison
				for ($a=0; $a < count($targetTMP); ++$a){
					


			//KYOTO
			if ($targetTMP[$a]{0}=="K") //KYOTO
			{
			$temp=explode(".",$targetTMP[$a]);
			$abstract=$temp[0].".".$temp[1].".".$temp[2];
			$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
			$st=pg_query($c,$qu);
			$ro=pg_fetch_array($st);

			$clustidK=$ro["MOL_ID"];
			//FIN AJOUT
			}

			//ENSEMBL

			if ($targetTMP[$a]{0}=="E")
			{
			$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$targetTMP[$a]."')";
			$st=pg_query($c,$qu);
			$ro=pg_fetch_array($st);

 			$clustidE=$ro["ABSTRACT_ID"];
			}

					$sql_target.=" INTERSECT
					 SELECT \"IN_SITU_ID\"
					  FROM \"TARGET\"
					   WHERE \"TARGET_ID\" IN ( 
					   select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and (A.\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    if (strlen($clustidK)>0) $sql_target.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    if (strlen($clustidE)>0) $sql_target.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   $sql_target.=")
					   UNION select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where (\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    if (strlen($clustidK)>0) $sql_target.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    if (strlen($clustidE)>0) $sql_target.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   $sql_target.=")
					   UNION select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";

					/*$sql_target.=" INTERSECT
					 SELECT \"IN_SITU_ID\"
					  FROM \"TARGET\"
					   WHERE \"TARGET_ID\" IN ( 
					   select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and A.\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]') 
					   UNION select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')
					   UNION select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";*/

	
				}
			
			}else{
                //si c un clone
				for ($a=0; $a < count($targetTMP); ++$a){
					$sql_target.=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"TARGET_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE upper(\"NAME\")='$targetTMP[$a]' OR upper(\"FULL_NAME\")='$targetTMP[$a]')";
				}
			}
			
		}else{//or
			
			if($_GET["MOLtype"]==2){ //si c un gene -> recup des clones correspondant
				$name='';
			    /*	
				for ($a=0; $a < count($targetTMP); ++$a){
					if($a==0)
						$name.=" (TARGET_ID IN ( select B.clone_id from ciona_design.clone_seq A, ciona_design.clone B where (A.clone_name=B.clone_name) and A.cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) ) OR TARGET_ID IN ( select clone_seq_id from ciona_design.clone_seq where cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) )) ";
					else
						$name.=" OR (TARGET_ID IN ( select B.clone_id from ciona_design.clone_seq A, ciona_design.clone B where (A.clone_name=B.clone_name) and A.cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) ) OR TARGET_ID IN ( select clone_seq_id from ciona_design.clone_seq where cluster_id=(select cluster_id from ciona_design.clustering where gene_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) )) ";
				}
				$sql_target=" INTERSECT SELECT IN_SITU_ID FROM CIONA_DESIGN.TARGET WHERE ".$name;
				*/
				
				////nouvelle version pour utiliser le clustering maison
                for ($a=0; $a < count($targetTMP); ++$a){
					if($a==0)
						{
						//KYOTO
						if ($targetTMP[$a]{0}=="K") //KYOTO
						{
						$temp=explode(".",$targetTMP[$a]);
						$abstract=$temp[0].".".$temp[1].".".$temp[2];
						$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
						$st=pg_query($c,$qu);
						$ro=pg_fetch_array($st);

						$clustidK=$ro["MOL_ID"];
						//FIN AJOUT
						}

						//ENSEMBL
						if ($targetTMP[$a]{0}=="E")
						{
						$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$targetTMP[$a]."')";
						$st=pg_query($c,$qu);
						$ro=pg_fetch_array($st);

 						$clustidE=$ro["ABSTRACT_ID"];
						}
						//FIN AJOUT

						$name.=" (\"TARGET_ID\" IN ( 
						select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and (A.\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    	if (strlen($clustidK)>0) $name.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    	if (strlen($clustidE)>0) $name.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   	$name.=")
						UNION select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where (\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    	if (strlen($clustidK)>0) $name.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    	if (strlen($clustidE)>0) $name.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   	$name.=")
						UNION select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]'
						";
						}
						//$name.=" (TARGET_ID IN ( select B.clone_id from ciona_design.clone_seq A, ciona_design.clone B where A.clone_name=B.clone_name and A.aniseed_cluster_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]') ) OR TARGET_ID IN ( select clone_seq_id from ciona_design.clone_seq where aniseed_cluster_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) OR TARGET_ID IN (select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]') )";
					else
						{
						//KYOTO
						if ($targetTMP[$a]{0}=="K") //KYOTO
						{
						$temp=explode(".",$targetTMP[$a]);
						$abstract=$temp[0].".".$temp[1].".".$temp[2];
						$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
						$st=pg_query($c,$qu);
						$ro=pg_fetch_array($st);

						$clustidK=$ro["MOL_ID"];
						//FIN AJOUT
						}

						//ENSEMBL

						if ($targetTMP[$a]{0}=="E") //ENSEMBl
						{
						$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$targetTMP[$a]."')";
						$st=pg_query($c,$qu);
						$ro=pg_fetch_array($st);

 						$clustidE=$ro["ABSTRACT_ID"];
						}
						//FIN AJOUT


						$name.= "UNION select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and (A.\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    	if (strlen($clustidK)>0) $name.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    	if (strlen($clustidE)>0) $name.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   	$name.=")
						UNION select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where (\"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]')";
					    	if (strlen($clustidK)>0) $name.="OR \"ANISEED_KYOTO_CLUSTER_ID\" ='$clustidK'";
					    	if (strlen($clustidE)>0) $name.="OR \"ANISEED_ENSEMBL_CLUSTER_ID\"='$clustidE'";
					   	$name.=")
						UNION select \"GENE_ID\" from \"GENE\" where upper(\"NAME\")='$targetTMP[$a]'
						";
						}
						//$name.=" OR (TARGET_ID IN ( select B.clone_id from ciona_design.clone_seq A, ciona_design.clone B where A.clone_name=B.clone_name and A.aniseed_cluster_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]') ) OR TARGET_ID IN ( select clone_seq_id from ciona_design.clone_seq where aniseed_cluster_id=(select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]')) OR TARGET_ID IN (select gene_id from ciona_design.gene where upper(name)='$targetTMP[$a]') )";
				
				}
				$sql_target=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE ".$name."))";
                
			}else{
                //si c un clone
				$name='';
				for ($a=0; $a < count($targetTMP); ++$a){
					if($a==0)
						$name.=" (\"TARGET_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE(upper(\"NAME\")='$targetTMP[$a]' OR upper(\"FULL_NAME\")='$targetTMP[$a]'))) ";
					else
						$name.=" OR (\"TARGET_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE(upper(\"NAME\")='$targetTMP[$a]' OR upper(\"FULL_NAME\")='$targetTMP[$a]'))) ";
					
///////////// BRICOLAGE STABLE_ID... 						
					$name.=" OR (\"TARGET_ID\" IN (SELECT \"CONSTRUCTION_ID\" FROM \"CONSTRUCTION\" WHERE upper(\"STABLE_ID\")='$targetTMP[$a]' )) ";						
///////////// BRICOLAGE STABLE_ID... 

				}
				$sql_target=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"TARGET\" WHERE ".$name;
			//print $sql_target;
			}
			
		}
	}
	
	
	//recup des mutants
	if((strlen($_GET["mutant"])>0)&&($_GET["BOOLmut"]<2)){
		$mutantTMP = split(":",strtoupper($_GET["mutant"]));
		$sql_mutant='';
		if($_GET["BOOLmut"]==1){//and
			for ($a=0; $a < count($mutantTMP); ++$a){
				$sql_mutant.=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"MUTANT\" WHERE \"BIO_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE upper(\"NAME\")='$mutantTMP[$a]' OR upper(\"FULL_NAME\")='$mutantTMP[$a]')";
			}
		}else if($_GET["BOOLmut"]==0){//or
			$name='';
			for ($a=0; $a < count($mutantTMP); ++$a){
				if($a==0)
					$name.=" (\"BIO_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE(upper(\"NAME\")='$mutantTMP[$a]' OR upper(\"FULL_NAME\")='$mutantTMP[$a]'))) ";
				else
					$name.=" OR (\"BIO_ID\" IN (SELECT \"MOL_ID\" FROM \"MOL_ENTITY\" WHERE(upper(\"NAME\")='$mutantTMP[$a]' OR upper(\"FULL_NAME\")='$mutantTMP[$a]'))) ";
			}
			$sql_mutant=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"MUTANT\" WHERE ".$name;
		}
		
	}else if($_GET["BOOLmut"]==2){//any
		    //$sql_mutant=" INTERSECT select in_situ_id from ciona_design.in_situ where wild_type='n'";
			$sql_mutant=" INTERSECT select \"IN_SITU_ID\" from \"MUTANT\"";
	}else if($_GET["BOOLmut"]==3){//none
		    //$sql_mutant=" INTERSECT select in_situ_id from ciona_design.in_situ where wild_type='y'";
			$sql_mutant=" INTERSECT select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" not in (select \"IN_SITU_ID\" from \"MUTANT\")";
	}
	
	
	//recup des manip d'embryon
	$sql_manip='';
	if($_GET["BOOLmanip"]==1){
	    $sql_manip.=" INTERSECT select \"IN_SITU_ID\" from \"EMBRYO_MANIP\"";
	}else if($_GET["BOOLmanip"]==2){
		$sql_manip=" INTERSECT select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" not in (select \"IN_SITU_ID\" from \"EMBRYO_MANIP\")";
	}
	
	
	////////////////////////////////
	//la MEGA requete //
	////////////////////////////////
	
	
	
	//$requete="SELECT IN_SITU_ID FROM CIONA_DESIGN.IN_SITU ";
	$requete="SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE (\"CHECKED\"='y') AND (\"PRIVATE\" = 'n') ";
	
	if((strlen($_GET[idanat]==0))&&(strlen($species)>0))
		$requete.=" INTERSECT SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE \"SPECIES\" = '$species' ";
//		$requete.=" WHERE SPECIES = '$species' ";
	
//	$requete.=" INTERSECT SELECT BIO_ID FROM CIONA_DESIGN.BIO_ENTITY WHERE CURATED='y'";
	
	if(strlen($sql_dev_stage)>0)
		$requete.= $sql_dev_stage;
	
	if(strlen($sql_region)>0)
		$requete .= $sql_region;
	
	if(strlen($sql_fate)>0)
	    $requete .= $sql_fate;
	
	if(strlen($sql_author)>0)
		$requete .= $sql_author;

	if(strlen($sql_annot)>0)
		$requete .= $sql_annot;

	if (strlen($sql_pmid)>0)
		$requete .=$sql_pmid;
	
	if(strlen($sql_target)>0)
		$requete.= $sql_target; 
		
	if(strlen($sql_mutant)>0)
		$requete.= $sql_mutant;
		
	if(strlen($sql_manip)>0)
		$requete .= $sql_manip;	


	/*if($_GET["news"]==1)
	    $requete.=" INTERSECT SELECT IN_SITU_ID FROM CIONA_DESIGN.IN_SITU WHERE checked='n'";*/

	
	if(strlen($_GET["Order"])>0){
		if ($_GET["Order"]=="SPECIES")
		    $requete = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" A, \"DEV_STAGE\" B  WHERE \"IN_SITU_ID\" IN ($requete) and (A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\") ORDER BY B.\"SPECIES\", B.\"DEV_PERCENT\", ascii(chr(ascii(A.\"WILD_TYPE\")+145)), \"IN_SITU_ID\"";
			//$requete = "SELECT IN_SITU_ID FROM CIONA_DESIGN.IN_SITU WHERE IN_SITU_ID IN ($requete) ORDER BY SPECIES, DEV_STAGE_ID, IN_SITU_ID";
		else
		    $requete = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" A, \"DEV_STAGE\" B WHERE \"IN_SITU_ID\" IN ($requete) and (A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\")   ORDER BY B.\"DEV_PERCENT\" asc,  ascii(chr(ascii(A.\"WILD_TYPE\")+145)) , B.\"SPECIES\"";
			//$requete = "SELECT IN_SITU_ID FROM CIONA_DESIGN.IN_SITU WHERE IN_SITU_ID IN ($requete) ORDER BY DEV_STAGE_ID, SPECIES, IN_SITU_ID";select ascii(chr(ascii('y')+145))

	}
//RAJOUT
	else {
$requete = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" A, \"DEV_STAGE\" B WHERE \"IN_SITU_ID\" IN ($requete) and (A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\") ORDER BY B.\"DEV_PERCENT\",ascii(chr(ascii(A.\"WILD_TYPE\")+145)), B.\"SPECIES\", \"IN_SITU_ID\"";
}
	
//  	echo "<br>".$requete;
	
	



	
	
	
	/////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////lecture du resultat/////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

	$query= pg_query($c,$requete);


//////////////////////////////////////////////
if (($offset==0) && ($_GET["fromgenecard"]==1))
	{
	$targ=$_GET["target"];
	$ttarg=explode(":",$targ);
	$requete="SELECT \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"=(
	select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$ttarg[0]."'
	)";
	$stmt=pg_query($c,$requete);
	$row=pg_fetch_array($stmt);
	$clustid=$row["GENE_CLUSTER_ID"];
	?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<div id="header">
  <ul>    
        <li><a href="gene-card.php?clusterid=<?print $clustid;?>">Gene Card</a></li>
        <li><a href="ESTcluster-gene.php?clusterid=<? print $clustid; ?>">ESTs cluster</a></li>
        <li id="current"><a href="#">Detailed Expression</a></li>
        <li><a href="gene-picture.php?clusterid=<? print $clustid; ?>">Expression at a glance <i><small><small><b><font color="crimson">New</font></b></small></small></i></a></li>
	<li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
        <li ><a href="gene-regulation-card.php?clusterid=<?print $clustid; ?>">Upstream regulators</a></li>
        <li ><a href="gene-function-card.php?clusterid=<?print $clustid; ?>">Downstream targets</a></li>
        <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
        <!-- <li><a href="#" style="color:white;">Microarray probe</a></li> -->
        <!--<li><a href="#" style="color:white;">Export</a></li> -->
  </ul>
</div>
<br><br>
<br><br>

<?	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////  EST COUNT    //////////////////////////////////////////////////////////////////////////



$requete="select distinct \"SPECIES\" from \"MOL_ENTITY\" where \"MOL_ID\" in (SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$species=$row["SPECIES"];


//////// ON CHERCHE ET ON TROUVE LES ANISEED CLUSTER ID POUR CHAQUE GENE MODEL
$requete="
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";

$stmt=pg_query($c,$requete);

$est=(array) null;
while ($row=pg_fetch_array($stmt))
{

///////////////////////////////////// KYOTO ////
if ($row["NAME"]{0}=="K") //KYOTO
{
$temp=explode(".",$row["NAME"]);
$abstract=$temp[0].".".$temp[1].".".$temp[2];
$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
$st=pg_query($c,$qu);
$ro=pg_fetch_array($st);

$kyotoid=$ro["MOL_ID"];
}


///////////////////////////////////// ENSEMBL ////////
if ($row["NAME"]{0}=="E")
	{
	$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$st=pg_query($c,$qu);
	$ro=pg_fetch_array($st);

 	$ensid=$ro["ABSTRACT_ID"];
	}

////////////////////////////////////// JGI ////////////

if ($row["NAME"]{0}=="c")
	{
	$requete0="select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."'";
	$stmt0=pg_query($c,$requete0);
	$ro=pg_fetch_array($stmt0);
	$jgiid=$ro["GENE_ID"];
	}



}
//////////////////////////////////////////////////////

//print $jgiid." ".$kyotoid." ".$ensid; return ;

    print "<font color=\"#D64242\" size=\"3\"><b>EST Count result</b></font><br><br><center>";

    	if ($_GET["display"]=="all") print '<table width="99%" border="1" cellspacing="0" cellpadding="0">';
	if ($_GET["display"]=="all") print '<tr align="center" valign="middle"><td><font color="#456898" size="2"><b>Library type</b></strong></td><td><font color="#456898" size="2"><b>Tissue</b></font></td><td width="25%"><font color="#456898" size="2"><b>Library</b></font></td><td><font color="#456898" size="2"><b>Expression</b></font></td>  </tr>';
	$requete="select * from \"LIBRARY\" where \"SPECIES\"='$species' order by \"ORDRE\" ASC";
    $stmt = pg_query($c,$requete);
	
	$count=0;
	$data = array();
	while($row=pg_fetch_array($stmt)){
	

	    if(! isset($data[ $row["COMMENTS"] ][1])){//avoid notice messages
		    $data[ $row["COMMENTS"] ][0]="";
			$data[ $row["COMMENTS"] ][1]="";
		}
		
		$data[ $row["COMMENTS"] ][1] += $row["LIB_SIZE"];//calcule le cumul des tailles des lib de meme type
		
		$type[$count]=$row["COMMENTS"];
		++$count;
        

		//$requete2="select count(distinct B.\"CLONE_ID\") AS res from \"CLONE_SEQ\" A, \"CLONE\" B where (A.\"ANISEED_CLUSTER_ID\"='$cluster' or A.\"ANISEED_KYOTO_CLUSTER_ID\"='$cluster' or A.\"ANISEED_ENSEMBL_CLUSTER_ID\"='$cluster') and (A.\"CLONE_NAME\"=B.\"CLONE_NAME\") and B.\"LIBRARY_ID\"=".$row["LIBRARY_ID"];


$RGLOB="";

$rjgi="(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_CLUSTER_ID\"='$jgiid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')";

$rkyoto="(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_KYOTO_CLUSTER_ID\"='$kyotoid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')";

$rens="(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_ENSEMBL_CLUSTER_ID\"='$ensid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')";

if (strlen($jgiid)>0) $RGLOB=$rjgi;
if (strlen($kyotoid)>0)  if (strlen($RGLOB)==0) $RGLOB=$rkyoto; else $RGLOB.=" UNION $rkyoto";
if (strlen($ensid)>0)  if (strlen($RGLOB)==0) $RGLOB=$rens; else $RGLOB.=" UNION $rens";


	$requete2="
	select count(distinct \"CLONE_ID\") as res from \"CLONE\" where \"CLONE_ID\" in 
	(
		$RGLOB
		
	)
	";




	/*	$requete2="
	select count(distinct \"CLONE_ID\") as res from \"CLONE\" where \"CLONE_ID\" in 
	(
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_CLUSTER_ID\"='$jgiid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	UNION
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_KYOTO_CLUSTER_ID\"='$kyotoid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	UNION
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_ENSEMBL_CLUSTER_ID\"='$ensid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	)
	";*/




//print $requete2."<br>";


		$stmt2 = pg_query($c,$requete2);
	    if($row2=pg_fetch_array($stmt2)){
	        $value=$row2["res"];
		    if($value > 0){
			    //////////////////////4000 au lieu de 1000 pour y voir qq chose
			
		        if ($_GET["display"]=="all") print "<tr align=\"center\"><td><font color=\"#656565\" size=\"-1\">".$row["COMMENTS"]."&nbsp;</font></td><td><font color=\"#656565\" size=\"-1\">".$row["TISSUE"]."&nbsp;</font></td><td><font color=\"#656565\" size=\"-1\">".$row["TITLE"]."&nbsp;</font></td><td valign=\"middle\"><center><img src=\"picture-est.php?value=".round( 4000*($value/$row["LIB_SIZE"]), 4)."\"><br><font color=\"#656565\" size=\"-1\">$value clones/".$row["LIB_SIZE"]."</font></center>&nbsp;</td></tr>";

				
			$data[ $row["COMMENTS"] ][0] += $value;//calcule le cumul des clones trouves dans des lib de meme type
				


			}
		}
	}
	if ($_GET["display"]=="all") print '</table>';

//DEBUT	
	if($count==0){
	    print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
	}else{
	///////////////////////////////////////tableau fusionne de l'expression//////////////////////////
	    //print "<br><br><br><strong>Resume:</strong><br><br>";
		print '<table width="80%" border="1" cellspacing="0" bordercolor="#333333">';
		
		$ll=0;
		$final=array();
		for($f=0; $f<count($type); ++$f){
		    if(! in_array($type[$f], $final) ){
			    $final[$ll++]=$type[$f];
	    	}
		}
	    for($a=0;$a<count($final);++$a){
		    if($data[$final[$a]][1]>0)
		        print '<tr valign="middle"><td><font color="#656565" size="-1">'.$final[$a].":  </font></td><td><center><img src=\"picture-est.php?value=".round( 4000*($data[$final[$a]][0]/$data[$final[$a]][1]), 4)."\"></center></td><td><font color=\"#656565\" size=\"-1\">".(0+$data[$final[$a]][0])." clones/".$data[$final[$a]][1]."</font></td></tr>";
			else
			    print '<tr valign="middle"><td><font color="#656565" size="-1">'.$final[$a].":  </font></td><td><center><img src=\"picture-est.php?value=0\"></center></td><td>&nbsp;</td></tr>";
		}
		
	    print '</table>';
	}
//FIN	
print "</center><br><br>";



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////AFFICHAGE DES PICTURES DES EMBRYOS IN WT CONTEXT///////////////////////////////////////////////////////
/*
$ttarg=explode(":",$_GET["target"]);
$tres="";
for ($i=0;$i<count($ttarg);$i++)
{
if ($ttarg[$i]{0}=="c") $tcur=to_target_JGI($c,$ttarg[$i]);
if ($ttarg[$i]{0}=="K") $tcur=to_target_KYOTO($c,$ttarg[$i]);
if ($ttarg[$i]{0}=="E") $tcur=to_target_ENS($c,$ttarg[$i]);


foreach ($tcur as $key => $val)
{
if (strlen($tres)==0) $tres=$key; else $tres.=",$key";
}

}


$requete0="
select \"PICTURE_ID\",\"PATH\" from \"PICTURE\" where \"IN_SITU_ID\" in (

select \"IN_SITU_ID\" from \"IN_SITU\" where \"PRIVATE\"='n' and \"CHECKED\"='y' and \"WILD_TYPE\"='y' and \"IN_SITU_ID\" in
	( 
	SELECT \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in ($tres)
	)
)";
$stmt0=pg_query($c,$requete0);



if (pg_num_rows($stmt0)==0)
	{
	print "<br><br><center><h2>No Pictures found into Aniseed Database</h2></center>";
	}
else 
{
$aaaa=0;
while ($row0=pg_fetch_array($stmt0))
{

 if (strlen($row0["PATH"])==0) print "<img border=\"0\" width=\"50\" src=\"show_pic.php?id=".$row0["PICTURE_ID"]."\">&nbsp;";
 else print "<img border=\"0\" width=\"50\" src=\"http://crfb.univ-mrs.fr/aniseed/picturesDB/".$row0["PATH"]."\">&nbsp;";

if ($aaaa++%10==0) print "<br>";
}
}


*/

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	}

?>
<font color="#D64242" size="3"><b>In situ search results.</b></font><br><br>
<?


resultsBar($query,$offset);

print '<br>
<img src="pictures/zoom-in.gif" onClick="ZoomIn()" border="0">
<img src="pictures/zoom-out.gif" onClick="ZoomOut()" border="0">
';

   // Start of table and column headings (ID and Name)
   print "<center><TABLE CELLSPACING=\"0\" BORDER=\"0\" style=\"border:1px solid black;padding:5px;margin:10px;\" WIDTH=\"99%\">\n";
   
   // Loop through results
   $count=0;
   while( ($row=pg_fetch_array($query)) && ($count < $offset+$nbMAX) )
//while( $row=pg_fetch_array($query) )
   {  
	  if($count++ >= $offset){
   	    print "  <TR><TD>\n";
		
		

		$id=$row["IN_SITU_ID"];
	    	
		
	
		$requete="SELECT A.\"BEING_CURATED\",A.\"WILD_TYPE\", A.\"DEV_STAGE_ID\", A.\"SPECIES\", A.\"EXP_COMMENTS\", A.\"TIME\", A.\"TEMPERATURE\", A.\"IM_COMMENTS\", B.\"NAME\" AS DEV, C.\"NAME\", C.\"SURNAME\", C.\"MAIL\", C.\"LOGO\", D.\"ENTRY_DATE\" FROM \"IN_SITU\" A, \"DEV_STAGE\" B, \"AUTHOR\" C, \"ENTRY_ORIGIN\" D WHERE (A.\"IN_SITU_ID\"=$id) AND (A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\") AND (D.\"BIO_ID\"=$id) AND (D.\"AUTHOR_ID\"=C.\"AUTHOR_ID\")";
		//print $requete;
		$resultset = pg_query($c,$requete);
				
		$row2=pg_fetch_array($resultset);
		
		//couleur en fonction de wild type ou non
		$wild=$row2["WILD_TYPE"];
		if($wild=='n'){$color='#CCCC99';}else{$color='#FFFFCC';}
		
		//espece & stade de devt. & logo
		print "<TABLE CELLSPACING=\"0\" BORDER=\"0\" bgcolor=\"$color\" WIDTH=\"100%\" style=\"color:black\"><TR>\n";		
		print '<td><table width="100%" border="0" cellspacing="0" cellpadding="0" style="color:black">'
		  .'<tr>'
		  ."<td align=\"left\" >";
		if(strlen($row2["LOGO"])>0)
			print "<img align=\"absmiddle\" src=\"pictures/".$row2["LOGO"]."\">&nbsp;&nbsp;";
		
		print "<a href=\"insitu.php?id=$id\"><img src=\"pictures/button-more.jpg\" border=\"1\"></a>";

if ($row2["BEING_CURATED"]=='y')
			print "&nbsp;&nbsp;<font size=\"2\" color=\"orange\">This entry is  <strong> being manually curated</font></strong>&nbsp;&nbsp;</td>";
		
//TAG HIGH THROUGHPUT
/*
$qh="select \"BIO_ID\" from \"ENTRY_ORIGIN\" where \"ANNOTATOR_ID\" is null and \"CURATOR_ID\" is null
and \"ANNOTATION_DATE\" is null and \"CURATION_DATE\" is null and \"BIO_ID\" in (
SELECT \"IN_SITU_ID\" from \"IN_SITU\" where \"PRIVATE\"='n' and \"CHECKED\"='y' and \"SPECIES\" like 'Ciona%'
) and \"AUTHOR_ID\" in ('10','151','170','171','190','210')";
$stqh=pg_query($c,$qh);

while ($rh=pg_fetch_array($stqh)) 
	if ($rh["BIO_ID"]==$id) 
		{
		print "&nbsp;&nbsp;<font size=\"2\" color=\"red\"><strong> [High throughput entry]</font></strong>&nbsp;&nbsp;</td>";
		break;
		}
// END OF TAG HIGH THROUGHPUT
*/



		print "<td align=\"right\" valign=\"top\"><font color=\"#456898\" size=\"2\"><b>".$row2["SPECIES"]."&nbsp;&nbsp;&nbsp;&nbsp;".$row2[ "dev"]."</b></font></td>"
		  .'</tr></table></td></tr>';

		
		/* ATTENTION   ICI ON TRAITE LES IMAGES DONC MODIFIER LES CHEMINS D'ACCES EN CONSEQUENCE !!!! */

		//picture
		//$requete="SELECT \"PICTURE_ID\", \"PATH\" FROM \"PICTURE\" WHERE \"IN_SITU_ID\" = $id and \"CONTROL\" IS NULL ";
	$requete="SELECT \"PICTURE_ID\", \"PATH\" FROM \"PICTURE\" WHERE \"IN_SITU_ID\" = $id and \"CONTROL\" IS NULL";		

		$stmtpic = pg_query($c,$requete);
		

		print "<TR><TD><TABLE><tr align=\"top\"><td>";
		while($row3=pg_fetch_array($stmtpic)){
			$idpicture=$row3["PICTURE_ID"];
			if(strlen($row3["PATH"])>0)
				{
				if (!preg_match("/mix/",$row3["PATH"]))
			    echo "<a href=\"insitu.php?id=$id\"><img src=\"picturesDB/".$row3["PATH"]."\" border=1 width=\"100\" name=\"pics\"></a> ";
				}
			else
			    echo "<a href=\"insitu.php?id=$id\"><img src=\"picture-mini.php?id=$idpicture\" border=1 width=\"100\" name=\"pics\"></a> ";
		}
		print "</td><td width=\"45%\"><font size=\"-1\" color=\"#000000\">".(str_replace("<br>"," ",$row2[ "IM_COMMENTS"]))."</font></td></tr>";
		print "</TABLE></TD></TR>\n";
		
		
		print "<TABLE cellpadding=\"0\" CELLSPACING=\"0\" BORDER=\"0\" bgcolor=\"$color\" WIDTH=\"100%\" style=\"color:black\">\n";
			//recherche des cibles
			$requete = "SELECT distinct B.\"SURE\", B.\"PART_OF\", A.\"MOL_ID\", A.\"NAME\", A.\"TYPE\", C.\"NAME\" AS \"REGION\", C.\"ANAT_ID\", C.\"DEV_STAGE_ID\" FROM \"MOL_ENTITY\" A, \"TARGET\" B, \"ANAT_ENTITY\" C where (B.\"IN_SITU_ID\"=$id) AND (B.\"TARGET_ID\"=A.\"MOL_ID\") AND (B.\"REGION_ID\"=C.\"ANAT_ID\") ORDER BY C.\"NAME\"";
			
			//print $requete;

			$resultset = pg_query($c, $requete);
			
			$str='';
			$str2='';
			$mol=null; $typemol=null;//sert a retrouver le gene correspondant

			//Le tableau des parties anatomiques a trier + avoid doublons
			$strsort=(array) null;

			while( $row4=pg_fetch_array($resultset )){
				if(substr_count (  $str, $row4["NAME"] )==0){
					if( $row4["TYPE"]=="clone" )
					    $str.="<a href=\"molecule-clone2.php?name=";
					else if( $row4["TYPE"]=="clone_sequence" )
					    $str.="<a href=\"molecule-clone.php?name=";
					else if( $row4["TYPE"]=="gene" )
					    $str.="<a href=\"molecule-gene.php?name=";
					else if( $row4["TYPE"]=="construction" )
					    //$str.="<a href=\"molecule-construction.php?name=";
						$str.="<a href=\"construct-view.php?constructid=";
					else
					    $str.="<a href=\"\" name=\"";
					
					if( $row4["TYPE"]=="construction" ){
						$str.=$row4["MOL_ID"]."\">".$row4["NAME"]."</a> - ";
					} else {
						$str.=$row4["NAME"]."\">".$row4["NAME"]."</a> - ";
					}
					
				    
					$mol[$row4["MOL_ID"]]=$row4["NAME"];
					$typemol[$row4["MOL_ID"]]=$row4["TYPE"];
				}
				//anotation sup sur les "stained anatomy part"
				$partof="";$sure="";
				if($row4["PART_OF"]=="X") $partof="Part of ";  else $partof="";
				if($row4["SURE"]=="X") $sure="?"; else $sure="";
			
				//Sort+avoid doublon
				if (!in_array($row4["REGION"],$strsort))
				{		
$str2.="<a href=\"short_hierarchy.php?region=".$row4["ANAT_ID"]."&dev=".$row4["DEV_STAGE_ID"]."\">$partof".$row4["REGION"]."$sure</a> - ";
//$str2.="<a onmouseover=\"return escape('<center><img src=\'embryos/late32c/late32anim.gif\'></center>');\" href=\"short_hierarchy.php?region=".$row4["ANAT_ID"]."&dev=".$row4["DEV_STAGE_ID"]."\">$partof".$row4["REGION"]."$sure</a> - ";

				$strsort[count($strsort)]=$row4["REGION"];
				}
			}
			
			print "<TR valign=\"top\"><TD width=\"250\"><font color=\"#456898\" size=\"2\"><b>Stained molecule: - </b></font><font size=\"-1\" color=\"#000000\">$str</font></TD>\n";
			
			
			//region
			//Classement des régions anatomiques par ordre alphabétique

			/*
			print_r($strsort);
			usort($strsort,"strcasecmp");
			//sort($strsort);
			print_r($strsort);
			*/
			
			print "<TD><font color=\"#456898\" size=\"2\"><b>Stained region: - </b></font><font size=\"-1\" color=\"#000000\">$str2</font></TD></TR>\n";
			
			
			
///////////////////////
            
			
			while (list($key, $value) = each($mol)) {
			      $count2=0;
			      $geneidlist="";
				  if( $typemol[$key]=="clone" ){
					  $requete="SELECT distinct \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value'";
					    	$resultset=pg_query($c,$requete);
						
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["ANISEED_CLUSTER_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }

					//KYOTO
			  		$requete="select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"=(SELECT distinct \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value' and \"ANISEED_KYOTO_CLUSTER_ID\" is not null limit 1)"; //tempo
				    	$resultset=pg_query($c,$requete);
					$row5bis=pg_fetch_array($resultset);
					$requete="select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\" like '".$row5bis["NAME"].".%' and \"TYPE\" <> 'abstract'";

					$resultset=pg_query($c,$requete);						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["MOL_ID"];

					  }

					//ENSEMBL
					//$requete="SELECT \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\" =(SELECT distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value' and \"ANISEED_ENSEMBL_CLUSTER_ID\" is not null)";//LA VRAI REQUETE
					$requete="SELECT \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\" in (SELECT distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value' and \"ANISEED_ENSEMBL_CLUSTER_ID\" is not null) limit 1";//MODIFIE TEMPORAIREMENT
					
					    	$resultset=pg_query($c,$requete);
						//print $requete;
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["TRANSCRIPT_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }




				  }
				  else if( $typemol[$key]=="clone_sequence" ){
					  $requete="SELECT distinct \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"=$key";
					  $resultset=pg_query($c,$requete);
					  while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["ANISEED_CLUSTER_ID"];
					  }

					//KYOTO
			  		$requete="select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"=(SELECT distinct \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key')";
				    	$resultset=pg_query($c,$requete);
					$row5bis=pg_fetch_array($resultset);
					$requete="select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\" like '".$row5bis["NAME"].".%' and \"TYPE\" <> 'abstract'";
					//print $requete."<br>";
					$resultset=pg_query($c,$requete);						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["MOL_ID"];

					  }

					//ENSEMBL
					$requete="SELECT \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\"=(
						SELECT distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key')";
					    	$resultset=pg_query($c,$requete);
						
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["TRANSCRIPT_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }




				  }
				  else if( $typemol[$key]=="gene" ){
					  $geneidlist[$count2++]=$key;
				  }
				  
				  //recherche des noms possibles pour le gene correspondant
				  if(count($geneidlist)>1)
				      $geneidlist=array_unique($geneidlist);


///////// AJOUT POUR LE CONCEPT DE GENE /////////////////////////////////////////
				$GENE=(array) null;
				for ($a=0;$a<count($geneidlist);++$a)
					{
					//print "==>>".$geneidlist[$a]."<br>";
					if (strlen($geneidlist[$a])==0) continue;
					$requete0="SELECT distinct \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"='".$geneidlist[$a]."'";
					$stmt0=pg_query($c,$requete0);
					$row0=pg_fetch_array($stmt0);
					//print "==>".$row0["GENE_CLUSTER_ID"]."<br>";

					if (!in_array($row0["GENE_CLUSTER_ID"],$GENE)) $GENE[count($GENE)]=$row0["GENE_CLUSTER_ID"];
					}
				//$GENE=array_unique($GENE);

				//print_r($GENE);

				for ($a=0;$a<count($GENE);$a++)
				{
				$genename="";
				$requete0="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$GENE[$a]."'";
				//print $requete0."<br>";
				$stmt0=pg_query($c,$requete0);
				$aaa=0;
				$syno="";
				if (pg_num_rows($stmt0)==0)
					{
					$requete0="SELECT \"GENE_CLUSTER_NAME_BLAST\" as \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='".$GENE[$a]."'";
					$stmt0=pg_query($c,$requete0);
					}
				while ($row0=pg_fetch_array($stmt0))
					{
					
					//$genename=$row0["GENE_CLUSTER_NAME"];
					$genename=$GENE[$a];
					if (++$aaa>1)
						$syno.=' <strong><font color="#990000">/</font></strong> ';
					$syno.=$row0["GENE_CLUSTER_NAME"];
					/*if( strlen($syno)-(($aaa-1)*48) > 100 ){
							  $syno.=" <strong><font color=\"#990000\">/</font></strong>...";
							  break;
						}*/
					}

				if (strlen($genename)==0) $genename=$GENE[$a];

				print "<tr valign=\"top\"><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">Predicted Aniseed Gene model for ".$value.": <a href=\"gene-card.php?clusterid=".$genename."\">".(str_replace("cluster","aniseedV3_",$genename))."</a></font></td><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">".$syno."</font></td></tr>";

				}

////////////////////////////////////////////////////////////////////////////////////

				  /*for($a=0; $a<count($geneidlist); ++$a){
					//print "=>>".$geneidlist[$a]."<br>";
					if( (isset($geneidlist[$a]))and(strlen($geneidlist[$a])>0) ){
					  $requete="SELECT distinct A.\"NAME\", B.\"SYNO\", B.\"ORIGIN\" from \"GENE\" A, \"SYNO\" B where A.\"GENE_ID\"=B.\"GENE_ID\" and B.\"GENE_ID\"=".$geneidlist[$a]."order by B.\"ORIGIN\" DESC";
					  $resultset=pg_query($c,$requete);
					  $syno=""; $aaa=0;
					  while($row6=pg_fetch_array($resultset)){
					      $genename=$row6["NAME"];
						  if($row6["SYNO"]==$row6["NAME"])
							  continue;
						  if(++$aaa>1)
						      $syno.=' <strong><font color="#990000">/</font></strong> ';
						  $syno.=$row6["SYNO"];
						  if($row6["ORIGIN"]=="user-JGI")
							  $syno.="*";
						  
						  if( strlen($syno)-(($aaa-1)*48) > 100 ){
							  $syno.=" <strong><font color=\"#990000\">/</font></strong>...";
							  break;
						  }
					  }
					if($aaa==0){
						$requete="select \"DESCRIPTION\", \"EVALUE\" from \"BLAST\" where \"MOL_ID\"='".$geneidlist[$a]."' and \"SCORE\"=(select max(\"SCORE\") from \"BLAST\" where \"MOL_ID\"='".$geneidlist[$a]."')";
						
						$resultset = pg_query($c,$requete);
						if($row7=pg_fetch_array($resultset)){

							$eval = $row7["EVALUE"];
							if( $eval <= 1e-10)
								$syno.= "HIGHLY ";
							else if( ($eval >= 1e-4) and ($eval <= 1e-3) )
								$syno.= "WEAKLY ";
							if($eval <= 1e-3)
								$syno.= "SIMILAR TO ".$row7["DESCRIPTION"]." (Eval: $eval)";

						}
					}
					
					  
					  
print "<tr valign=\"top\"><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">Predicted gene model for ".$value.": <a href=\"molecule-gene.php?name=".$genename."\">".$genename."</a></font></td><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">".$syno."</font></td></tr>";

					////////////////
					//RAJOUT A MOI
					////////////////
					$globalgenelist.=$genename.":";


					}
				  }*/
			}
//////////////////////////////////



            //description des manipulations d'embryon
			if($wild=='n'){
				//recherche des mutants
                $requete = "SELECT distinct \"NAME\", \"BIO_ID\" FROM \"MUTANT\" where \"IN_SITU_ID\"='$id'";
				$resultset = pg_query($c,$requete);
				$str='';
				$a=0; $geneidlist="";//sert ensuite a retrouver les noms des genes
				while( $row8=pg_fetch_array($resultset) ){
				    $geneidlist[$a++]=$row8["BIO_ID"];
					$str.="<a href=\"molecule-gene.php?name=".$row8["NAME"]."\">".$row8["FULL_NAME"]." ".$row8["NAME"]."</a> - ";
				}
				print "<TR valign=\"top\"><TD><div style=\"border-top:1px solid black;\"/><font color=\"#456898\" size=\"2\"><b>Deregulated molecule: - </b></font><font color=\"#000000\" size=\"-1\">$str</font></TD>\n";
				
				//recherche des amputations
				$requete = "SELECT A.\"DEV_STAGE_ID\", A.\"ANAT_ID\", A.\"NAME\" FROM \"ANAT_ENTITY\" A, \"EMBRYO_MANIP\" B WHERE (B.\"IN_SITU_ID\"=$id) AND (B.\"STRUCTURE_ID\"=A.\"ANAT_ID\")";
				$resultset = pg_query($c,$requete);
				$str='';
				while( $row9=pg_fetch_array($resultset) ){
					$str.="<a href=\"short_hierarchy.php?region=".$row9["ANAT_ID"]."&dev=".$row9["DEV_STAGE_ID"]."\">".$row9["NAME"]."</a> - ";
				}
			    print "<TD><div style=\"border-top:1px solid black;\"/><font color=\"#456898\" size=\"2\"><b>Embryo manipulation: - </b></font><fo