<!-- help of ANISEED web site with video tutorials -->
<html>
<head>
<title>ANISEED - Help </title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="A list of tutorials is available on Aniseed, with little movies to show you how to access ascidian information. For more detail, please contact delphine dauga (dauga@ibdm.univ-mrs.fr).">
<meta name="keywords" content="Tassy, Daian, Sobral, Lemaire, Dauga, Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database, ciona intestinalis gene, help, tutorials">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
?>
<HTML>
<HEAD>
<TITLE>ANISEED V3.0 - Tutorials</TITLE>
</HEAD>
<BODY>

<?
include ("frames_header.php");

?>

<FONT SIZE="+2" COLOR="333333"><A NAME="Top"><strong> ANISEED Quick Start </strong><A NAME="Top"></FONT>

<P><FONT SIZE="+1" COLOR="000000"><strong> Section contents </strong></FONT>

<P><FONT SIZE="+1" COLOR="333333"><strong> The first reflex in ANISEED: <A HREF="#Anisearch">ANISEARCH</A></strong></font>


<P><FONT SIZE="+1" COLOR="333333"><strong>Access to genomic data</strong></font>
<UL TYPE="disc">How do I search for a <A HREF="#Genomicsearch_Gene">gene?</A></UL>
<UL TYPE="disc">How do I search for a <A HREF="#Genomicsearch_moltool">molecular tool?</A></UL>
<UL TYPE="disc"> How do I search for a <A HREF="#Genomicsearch_Clone">clone?</A></UL>
<UL TYPE="disc">How do I search for a <A HREF="#Genomicsearch_reg_seq">regulatory sequence?</A></UL>
<UL TYPE="disc"><a href="Access data in Aniseed.pdf">Special help to find information concerning Gateway-compatible clones and KH transcript models.</a></UL>



<P><FONT SIZE="+1" COLOR="333333"><strong> Explore the genome</strong></font><P>
<UL TYPE="disc"><A HREF="#Blast">Blast search</A></UL>
<UL TYPE="disc">Go to the <A HREF="#Gbrowse">Aniseed genome browser</A></UL>



<P><FONT SIZE="+1" COLOR="333333"><strong> Explore the anatomy </strong></font>
<UL TYPE="disc">How do I find an <A HREF="#Search_anatomy_ontology">anatomical territory in the ontology?</A></UL>
<UL TYPE="disc">How do I find an <A HREF="#Search_anatomy_scheme">anatomical territory on an embryo scheme?</A></UL>
<UL TYPE="disc">How do I find a <A HREF="#Search_territories_fates">territories by their fates?</A></UL>
<UL TYPE="disc">How do I find a <A HREF="#Search_progeny_precursors">progeny/precursors of a territory?</A></UL>
<UL TYPE="disc">How do I find <A HREF="#Search_neighbours">neighbours of a cell?</A></UL>
<UL TYPE="disc">How do I find <A HREF="#Search_cell_shape">cells by their shapes?</A></UL>
<UL TYPE="disc">How do I find <A HREF="#Search_asymetric_cleavage">asymetric cleavages?</A></UL>
<UL TYPE="disc">How do I find <A HREF="#Search_shape_cell_cluster">similarities or differences in shape cells?</A></UL>
<UL TYPE="disc"><A HREF="#show-embryo">show all 3D embryos present in the database</A></UL>


<P><FONT SIZE="+1" COLOR="333333"><strong>Access to expression data</em></strong></font>
<UL TYPE="disc">How do I search by <A HREF="#Search_molecule">molecule?</A></UL>
<UL TYPE="disc">How do I search by <A HREF="#Search_by_anatomy">anatomy?  </A></UL>
<UL TYPE="disc"><A HREF="#Advanced_search"> Advanced search?  </A></UL>
<UL TYPE="disc"><A HREF="#DDD"> DDD?  </A></UL>

<P><FONT SIZE="+1" COLOR="333333"><strong> Explore the literature </strong></font>
<UL TYPE="disc"><A HREF="#Article_given_gene">Find articles related to a given gene</A></UL>
<UL TYPE="disc"><A HREF="#bib-search-anatomy">Find articles describing the specification of a given cell fate</A></UL>
<UL TYPE="disc"><A HREF="#biblio-search">Search articles by Authors or Title words</A></UL>
<UL TYPE="disc"><A HREF="#show-article"> Show all articles present into the database</A></UL>



<P><FONT SIZE="+1" COLOR="333333"><strong> Download section</strong></font>
<UL TYPE="disc">Download <A HREF="#Download_data"> Aniseed data</A></UL>
<UL TYPE="disc">Download <A HREF="#3DVE"> 3D Virtual Embryo</A></UL>

<P><FONT SIZE="+1" COLOR="333333"><strong> <A HREF="submit_data.php"> Submit your data!!</A></strong></font>

<BR>
<BR>
<BR>
<BR>
<P align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Anisearch"><strong> The first reflex in ANISEED: ANISEARCH</strong></A></font></p>
<center><IMG SRC="PictureHelp/Anisearch.bmp"></center><p>
<div align=justify>
Anisearch is a Google-like search engine, which scans all tables of the database for the desired information (this includes comment fields!). You can find Anisearch on the banner page and in the top right corner of each web page.
Just type in the keywords you are interested in and select the "and" and "or" or "complete sentence" operators to link your keywords. The results comes out classified according to various fields (GO term, molecules, ISH comments, articles ) and cross linked to Aniseed and to the genome browser. <p>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find the ISH comments related to "pem".</strong></td></TR>
      </TABLE></center>
      <p>
      

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/AnisearchPem.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie  <A HREF="Videoflv/AnisearchPem.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 

<UL>Click <A HREF="index.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<P align="center"><FONT SIZE="+2" COLOR="333333"><strong>Access to genomic data: use the "Genes/Clones/Cis-regulatory regions" menu</em> </strong></font><p>
<center><IMG SRC ="PictureHelp/GenesMenu.bmp" ></center><p>

Aniseed supports three sets of transcript models: JGI v1.0, KyotoGrail 2005 and ENSEMBL, all grouped into gene models.
Each of these transcript models was functionally annotated either via the Aniseed pipeline (JGI v1.0; Kyotograil2005) or by importing an external functional annotation (ENSEMBL).
When available, the genes are linked to their expression profiles and to the morpholinos used to assay their functions.
A single Halocynthia gene set is supported. A biological name is associated to each transcript model either by inference from its
orthologues in mouse, human, and drosophila or from the best blast hit in Swissprot.


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Genomicsearch_Gene"> How do I search for a gene? </A></FONT><p>


<FONT SIZE="+1"><strong>You can search transcript models by biological name or ID. </strong></font<p>

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Enter the biological name or the identifier of the gene model (ENSEMBL, JGI v1.0, KYOTOGRAIL2005) you are looking for. </LI><br>
                   <LI>Click on the "Submit" button. <p>

      <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find the sequence of Otx</strong></td></TR>
      </TABLE> </center></LI></OL>
      <p>
<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/SearchGeneModel.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
  <!--    Look at the movie <A HREF="Videoflv/SearchGeneModel.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 


<UL><LI><FONT SIZE="+1" ><EM> Can you explain the result of this query? </A></EM></FONT><P>
The result of your query will be presented in a list of the gene model ID (ENSEMBL, JGI v1.0 or KYOTOGRAIL2005), the associated biological name and the specie. You will also access to the best blast hits records displayed on the gene models found by your query. You can either click on the gene name of interest to get the associated gene model card, or tick right of the gene model ID to constitute a list of genes of interest that can be further restricted using the "Refine" button that enables sequential requests.<p>

<UL><LI> What is it described on a gene model card? </LI><p>
                 This page gives access to the functional annotation (name, scaffold, orthologous in mouse, human and drosophila, best blast hit in Swissprot, interpro domains and Gene Ontology classification), the other tabs give access to the sequence (nucleotide and aa), associated ESTs, EST counts in the various sequenced libraries, in situ data in WT and manipulated conditions, molecular tools (morpholinos, full length Gateway clones), microarray probes (to be implemented). The genomic annotations can be exported as a flat file via the export tab.<p>
<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExplainResultGenomicSearchGeneModel.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--
                Look at the movie <A HREF="Videoflv/ExplainResultGenomicSearchGeneModel.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or -->

Click <A HREF="molecule-search.php">here</A> to run this search in ANISEED.<p>
<A HREF="#Top">Return on the top</A></LI></UL></UL>

<FONT SIZE="+1"><strong>You can search transcript models by functionnal annotation. </strong></font><p>

<strong><I>- Searching for gene model using identifier(s) or term(s) of Gene ontology</I></strong><br>
The Aniseed pipeline annotation forms the basis for the Gene Ontology classifications of the genes. This page allows you to search for genes according to their associated Gene Ontology terms (search for proteins involved in a given process, molecular function, subcellular loicalisation).
After entered terms or identifiers of GO you are looking for, you will have a list a GO terms corresponding to your query. You can Select GO terms of interest, specify the specie that you want the genes and click on "get corresponding gene" button. The GO terms were associated to the gene thanks to the ortholog prediction and/or the best blast hits and/or Interproscan. You can also specify in your query if you only want that the GO terms were predicted with one or all by the "soft".
      The result of this query will give you a list of genes model with the GO terms you have clicked. You can use the refine tool to select specific gene model in the list. <p>
<p>

      <OL TYPE="1"><LI>Enter the term(s) or the identifier(s) of Gene Ontology you are looking for. </LI><br>
                   <LI>Click on the "Submit" button. <p>
      You can enter several terms or identifiers by separating your entries with a space. <p>

      <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find for gene model with a <BR>transcription regulator activity </strong></td></TR>
      </TABLE></center></LI></OL>
      <p>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/SearchGeneGO.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
      <!--Look at the movie <A HREF="Videoflv/SearchGeneGO.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 
      
     <UL>Click <A HREF="GO-search.php">here</A> to run this search in ANISEED. </UL>
     <UL><A HREF="#Top">Return on the top</A></UL>

<strong><I>- Searching for gene model using identifier(s) or term(s) of Interpro</I></strong><br>
Interproscan was performed for each Ciona protein and thus, the presence of functional motifs were deduced. You can search for genes according to their InterPro terms (search for protein with given protein motifs).<p>
After entering the term(s) or the identifier(s) of Interpro, you will have a list of Interpro terms corresponding to your query. You can Select Interpro terms of interest, specify the specie that you want the genes and click on "get corresponding gene" button. The result of this query will give you a list of genes model with the Interpro terms you have clicked. You can use the refine tool to select specific gene model in the list.
      
      
      <OL TYPE="1"><LI>Enter the term(s) or the identifier(s) of Interpro you are looking for. </LI><br>
                   <LI>Click on the "Submit" button.<p>
      You can enter several terms or IDs by separating your entries with a space. <p>
      
      <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find for gene model<BR> containing homeoboxes </strong></td></TR>
      </TABLE></center> </LI></OL>
      <p>
      
      <!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/SearchGeneInterpro.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
     <!-- Look at the movie <A HREF="Videoflv/SearchGeneInterpro.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 
     
     <UL>Click <A HREF="IP-search.php">here</A> to run this search in ANISEED. </UL>
     <UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Genomicsearch_moltool"> How do I search for a molecular tool?  </A></FONT><p>
Aniseed supports the description of expression patterns and phenotypes in response to perturbations of gene function.
To define these perturbations, it uses the concept of "Molecular tool" which
can be morpholinos, overexpression contructs (Electroporation or mRNA injection), or pharmacological reagent. .
You can search for molecular tools by name or part of the name.

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Enter the name or a part of the name the molecular tool you are looking for. </LI><br>
                   <LI>Click on the "Submit" button. <p>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find molecular tools perturbing otx gene.</strong></td></TR>
      </TABLE> </center></LI></OL>
      <p>


      
      <UL>Click <A HREF="moltool-search.php">here</A> to run this search in ANISEED. </UL>
      <UL><A HREF="#Top">Return on the top</A></UL>

<FONT SIZE="+2" COLOR="333333"><center><A NAME="Genomicsearch_Clone"> How do I search for a clone? </A></center></FONT><p>
You can search for clone present in ANISEED by clone name.<p>

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Enter the name of the clone you are looking for. </LI><br>
                   <LI>Click on the "Submit" button. <p>
      
      <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find In Situ data assossiated <BR>to the clone cicl01i06.</strong></td></TR>
      </TABLE> </center></LI></OL>
      <p>
      <!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/SearchClone.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
     <!-- Look at the movie <A HREF="Videoflv/SearchClone.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 

      <UL><LI><FONT SIZE="+1" ><EM>Can you explain the result of this query? </A></EM></FONT></LI><P>
      The "clone" page:<br>

      The result of your query will be presented in a list of the clones found in ANISEED corresponding to the clone name that you search. You can access on the description of the clone by clicking on the link. The corresponding page gives access to some features like the library where the clone came from, the vector used You will also find the different clone sequences corresponding to the clone and the cluster that the clone belongs to from the three assemblies. <p>
      <UL><LI>What is it described on a "clone sequence" page?<p>
      Some features like a brief description, the type of the sequence (EST or cDNA), the orientation are first described. You can also access directly to the Genbank clone card by clicking on the Genbank ID. You retrieve the library used, the vector used, the tissue or the organ that it comes from. There are also the genes models corresponding to the clone sequence and when available, a link to the in situ data. Finally, you can find the sequence.
      All the information of this page can be exported in raw text format by clicking on "Display entry in raw text format".
      </LI><p>
      <LI>What is it described on a "cluster" page?</LI><P>
      Some features like the name of the cluster, the number of the clones present, the corresponding gene and the specie are first described. You will also access to the list of the different clone sequence, with its corresponding clone and its orientation. You can click on each clone name or on each clone sequence to find more details.
A "download" button allows you to export the sequence of all the clone (button "select all") or only of the clone that you are interested in by clicking on the corresponding checked boxe.  
</UL><p>
      
<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExplainResultGenomicSearchClone.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
      <!--Look at the movie <A HREF="Videoflv/ExplainResultGenomicSearchClone.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 
      
      Click <A HREF="clone-search.php">here</A> to run this search in ANISEED.<p>
      <A HREF="#Top">Return on the top</A><P></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Genomicsearch_reg_seq"> How do I search for a regulatory sequence?  </A></FONT><p>
In Aniseed, a regulatory region is a segment of the genome that has been tested for its capacity to drive expression in vivo. 
It can have a natural (genomic) or an artificial (mutations, synthetic sequence) origin.
Currently, cis-regulatory regions from 27 genes are described in Aniseed and linked to Aniseed Genome Browser.  <br>
You can search regulatory regions by species, identifier, biological name, type of regulation, gene regulated, or publication. 
The gene must be indicated using its identifier.

<p>
<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find sequences regulating Brachyury.</strong></td></TR>
      </TABLE> </center></LI></OL>
      <p>
      
<UL><LI><FONT SIZE="+1" ><EM>Can you explain the result of this query? </A></EM></FONT></LI><P>
      
      The result of your query will be presented in a list of regulatory regions.
      You can access on the description of the regulatory region by clicking on the link.
      
      The corresponding page gives access to the regulatory region page.

       <p>What is it described on a "regulatory region" page?<p>
      <UL>
      <LI>Link to see the regulatory region on the Aniseed Genome Browser</LI><p>

      <LI>Description: general comment describing the region, the different modules and motifs that are important to regulate the gene. </LI><p>

      <LI>Hierarchy: regulatory regions are organised hierarchically in ANISEED.
      A regulatory region may thus derive from a parent region by deletion, mutation, or/and other artificial modification </LI><p>

      <LI>Type of regulation:
      a region has a specific regulatory activity. ANISEED classification of these activities is based on the ongoing Sequence Ontology,
      and currently includes the following concepts:
 	- basal promoter (only includes sites for the basal transcription machinery)<br>
        - extended promoter (basal promoter plus other regulatory elements, this usually corresponds to a 5&acute; flanking region)<br>
 	- enhancer (a unique enhancer without basal promoter)<br>
 	- silencer ( a unique silencer without basal promoter)<br>
 	- insulator (a unique insulator without basal promoter)<br>
 	- complex regulatory region (several enhancers or silencers, etc but no basal promoter)<br>
 	- No Activity<br>
 	- Unknown activity (Other cases we did not think about..)<br>
      </LI><p>

      <LI>Link to the construct(s) used to test this region:
      the regulatory activity of a region is tested through constructs.
      These are molecular entities used to store spatial and temporal data of expression assays (stored in ANISEED as in-situ records). 
      They contain a sequence (if possible the precise one that was tested, if known, otherwise its JGI v1.0 representative) and a reporter element (e.g. LacZ).
      They may also contain a basal promoter (chosen among the regions that are defined as such), if the region tested does not contain an endogenous promoter.
      </LI><p>

      <LI>Overview and description of the regulatory motifs:
      a region may contain regulatory motifs. These are (usually short) sub-sequences of a regulatory region that play a role in
      the region's capacity to drive expression (e.g. Trancription factor binding sites).
      Their location in the region's sequence is defined by motif coordinates.
      A regulatory motif is an instance of a motif class, which represents the high-level abstract notion of a motif (e.g. GATA motif).
      Each individual motif can be associated to the upstream transcription factor(s) that binds it, when known.
      </LI><p>

      <LI>Sequence and coordinates:
      The 5&acute; and 3&acute; boundaries of the sequence are defined by a set of coordinates.
      In ANISEED, we normalize a region&acute;s coordinates with respect to the expected mature mRNA start site (noted +1).
      For some regions, the ANISEED coordinates may thus differ from the coordinates defined in the publications describing them.
      The comments field allows to indicate this. By definition, a region is represented by its sequence on the JGI version 1 browser,
      even if the individual sequences tested in electroporation constructs differ from the "canonical" sequence because of polymorphisms.
      This info is not lost but will be included in the description of the "construct" used to test the region.
      </LI><p>

      <LI>Reference(s)</LI><p>

      </UL><p>

      Click <A HREF="reg-region-search.php">here</A> to run this search in ANISEED.<p>
      <A HREF="#Top">Return on the top</A><P></UL>


<P align="center"><FONT SIZE="+2" COLOR="333333"><strong> Explore the genome </strong></font></p>
<center><IMG SRC="PictureHelp/GenomeMenu.bmp"></center><p>
<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Blast"> Blast search  </A></FONT><p>

The "Blast search" allows you to blast a nucleotide or protein sequence against all cDNA clones, Ciona or Halocynthia EST/cDNA clones,
the Ciona gene models or the Ciona intestinalis <P>

<OL TYPE="1"><LI>Choose the type of blast you want to perform (Blastn, tBlastn, tBlastx). </LI><br>
            <LI>Choose the database.</LI><BR>
            <LI>Enter your sequence in Fasta format.</LI><BR>
            <LI>Define the blast parameters.</LI><BR>

</OL>

<UL><LI><FONT SIZE="+1" ><EM>Can you explain the result of this query? </A></EM></FONT></LI><P>
The results of this query will be presented in a list of alignments ordered by score. At the end of this page, you will find a link to view the first result in the genome browser.
</UL>


<!--MOVIE-->
<center>
<br>

<embed  width="625" height="400"  src="flvplayer.swf?file=Videoflv/BlastMovie2.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->

      <UL>Click <A HREF="blast-search.php">here</A> to run this search in ANISEED. </UL>
      <UL><A HREF="#Top">Return on the top</A></UL>
      

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Gbrowse"> Go to the Aniseed genome browser </A></FONT><p>

A Gbrowse-based Genome Browser was made public to display various information on the genome.
The ANISEED genome browser is cross linked to the database. Information displayed includes JGI, KyotoGrail2005 and ENSEMBL transcript models, 
TIGR EST clusters and predicted non-coding mRNA. It also displays the conservation profile between the two sequenced ciona genomes (Ciona intestinalis and Ciona savignyi),
as well as Cis-regulatory sequences supported by ANISEED. You can access to this page using the "Explore Genome" menu. <p>

      <UL>Click <A HREF="http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/">here</A> to access to the Aniseed genome browser. </UL>
      <UL><A HREF="#Top">Return on the top</A></UL>



<P align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="ExploreAnatomy"><strong> Explore the anatomy </strong></A></font></p>
<center><IMG SRC="PictureHelp/AnatomyMenu.bmp"></center><p>
<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_anatomy_ontology"> How do I find an anatomical territory in the ontology? </A></FONT><p>

This page allows you to find a territory by searching the anatomical ontology of a species of interest.

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Click on the "Submit" button. </LI><p>

The results page displays the ontology on the left and, depending on the developmental stages, embryo schemes on the right. <p>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find the anatomical dictionary and the scheme of a 64-cell stage embryo.</strong></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExploreAnatomyOntology.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie <A HREF="Videoflv/ExploreAnatomyOntology.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 


<UL>Click <A HREF="anatomy-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_anatomy_scheme">How do I find an anatomical territory on an embryo scheme? </A></FONT><p>
This page allows to retrieve a territory according to its localisation on embryo schemes. You can search whole Ciona and Halocynthia embryos up to the 110-cell stage and the neural plate of Ciona embryos up to the early tailbud stage. <p>

   <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Click on the "Submit" button. </LI><p>

The results page displays a clickable embryo scheme.<p>

<CENTER><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find what are the little cells localized in the posterior part of a 110-cell stage embryo.</strong></td></TR>
      </TABLE></CENTER>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExploreAnatomyScheme.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie <A HREF="Videoflv/ExploreAnatomyScheme.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or -->

<UL>Click <A HREF="anatomy-search-embryo.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_territories_fates">How do I find territories by their fates? </A></FONT><p>

This page allows you to find the territory at a given stage that gives rise to a fate of interest. <p>

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Choose a "Fate" of interest from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Click on the "Submit" button. </LI><p>

You can select several fates and use the boolean operators on the right of the page to restrict your query. The result page lists the corresponding territories. <P>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find cells at 64-cell stage which <BR>give rise only to notochord.</strong></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExploreAnatomyTerritoriebyFates.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie <A HREF="Videoflv/ExploreAnatomyTerritoriebyFates.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or -->

<UL>Click <A HREF="fate-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_progeny_precursors">How do I find progeny/precursors of a territory? </A></FONT><p>

This page allows you to retrieve from the lineage data the precursors/ progeny of a territory of interest.<P>

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Add territories by clicking on the Add button. A pop up window opens that allows to select territories from the relevant anatomical ontology. You can remove territories or reset the whole field. </LI><br>
                   <LI>Tick on the right whether you want to see the progenitors, progeny or both. </LI><br>
                   <LI>Click on the "Submit" button. </LI><p>

Upon submission of the request the relevant part of the lineage is displayed in a new window.<p>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You want to find progenies and <BR>progenitors of B7.6 cell pair.</strong></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/ExploreProgenyProgenitors.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie <A HREF="Videoflv/ExploreProgenyProgenitors.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or -->

<UL>Click <A HREF="lineage-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_neighbours">How do I find neighbours of a cell?</A></FONT><p>

This page allows to search 3D Virtual Embryo data to identify the neighbouring territory of a cell, currentlyup to the 44 cell stage of Ciona intestinalis.
      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Add territories by clicking on the Add button. A pop up window opens that allows to select territories from the relevant anatomical ontology. You can remove territories or reset the whole field. </LI><br>
                   <LI>You can change the default maximum distance to neighbouring territory (<5m). </LI><br>
                   <LI>You can change the default surface of contact between cells (>0m). </LI><br>
                   <LI>Click on the "Submit" button. </LI><p>

Upon submission, a new page appears listing the neighbouring structures and the surface of contact with the territory of interest.<P>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR> <td><center><strong>Example <p></center> </strong></td></TR>
             <TR> <td><center><strong>You want to identify the <BR>neighbouring territory of a4.2.</strong></center></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/SearchNeighbour.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
<!--Look at the movie <A HREF="Videoflv/SearchNeighbour.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A> or--> 


<UL>Click <A HREF="neighbour-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>




<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_cell_shape">How do I find cells by their shapes?</A></FONT><p>

This page allows to search 3D Virtual Embryo data to identify cells of a given shape. All values are set to zero by default and upon submission the values of 
all shape descriptors are displayed (Cell volume, Cell surface, sphericity, convexity, elongation, Flatness, Squareness, Entropy, Surface/volume ratio and 
cell volume/embryo volume).

      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>You can change the shape descriptor parameters according what you are looking for</LI><br>


<center><TABLE background="CC00CC" border="3" width="40%">
             <TR> <td><center><strong>Example <p></center> </strong></td></TR>
             <TR> <td><center><strong>You want to find all the cells that have an elongation bigger than 67%</strong></center></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<!--<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>-->

<UL>Click <A HREF="biometry-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_asymetric_cleavage">How do I find asymetric cleavages?</A></FONT><p>

This page allows to compare the volumes of sister cells in Ciona intestinalis embryos up to the 112 cell stage.


      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>As several 3D embryos are available for each stage, choose one or more embryos. </LI><br>
                   <LI>Select the % of asymmetry (calculated as 1-Vsmall_sister/Vlarge_sister)</LI><br>
                   <LI>Click on the "Submit" button.</LI> <br>
Upon submission a list of sister pairs satisfying the required asymmetry is obtained.
If "asymmetry >0" is selected, the cleavage asymmetry of all sister pairs at the selected stage is displayed in the results page. <p>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR> <td><center><strong>Example <p></center> </strong></td></TR>
             <TR> <td><center><strong>You want to find all the sister pairs that present <BR>more than 20% of asymmetry.</strong></center></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<!--<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>-->

<UL>Click <A HREF="division-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_shape_cell_cluster">How do I find similarities or differences in shape cells?</A></FONT><p>

This page allows to display a tree showing geometry similarities between blastomeres for the selected embryo up to the 44 cell stage.


      <OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down.</LI><br>
                   <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><br>
                   <LI>Click on the "Submit" button.</LI> <br>
                   <LI>The results page present a tree in which you can specify the fate of the different cells.</LI> <br>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR> <td><center><strong>Example <p></center> </strong></td></TR>
             <TR> <td><center><strong>You want to know if muscle cells have a similar shape.</strong></center></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<!--<center>
<br>

<embed  width="800" height="500"  src="flvplayer.swf?file=Videoflv/" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>-->

<UL>Click <A HREF="biom-clust.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="show-embryo">How do I find all 3D embryos present in the database?</A></FONT><p>
This page allows you to access the 3D embryo collection. For each embryo, you can download the corresponding obj file, a summaries of surface, volume, biometry and surface of contact data, obtained with the 3D Virtual Embryo software and the lsm file (when available) used to construct the 3D embryo. You can open the obj file with 3D softwares (these embryos are also available in the 3D Virtual Embryo software from the "embryo" menu, except for <em>Boltenia villosa</em>).
Note that for <em>Boltenia villosa</em> only few cells were reconstructed.

<UL><A HREF="embryo-collection.php">Access all 3D embryos present in Aniseed</A> </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<P align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="ExploreAnatomy"><strong> Access to expression data </strong></A></font></p>
<CENTER><IMG SRC="PictureHelp/ExpressionMenu.bmp"></center><p>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_molecule">How do I search by molecule? </A></FONT><p>

This page allows you to find the in situ expression patterns associated to a gene or EST/cDNA clone. By default only the wild type expression patterns are shown but you can access expression patterns in manipulated conditions (gene deregulation, embryo manipulation) by ticking/filling the relevant boxes/fields. <p>

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down. </LI><BR>
             <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><BR>
             <LI>Enter the clone or the gene model of interest in the "stained molecule" box. If you dont know the ID of the gene model, you can search your molecule ID using the "Find a gene model by its name" interface. You can enter several molecules separated by ":".<p>

        <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for wild type expression data of Otx.</strong></td></TR>
      </TABLE></center>
      <p>

<!--MOVIE-->
<center>
<br>
<embed  width="625" height="400"  src="flvplayer.swf?file=Videoflv/SearchWTotxExpression.flv" quality="high" type="application/x-shockwave-flash" />
<br>
<br>
</center>
<!--ENDOFMOVIE-->


            <LI>If you want to include expression pattern in manipulated conditions like gene deregulation, click on the corresponding button ("Include expression patterns in Deregulated Context"). You can specify by entering a gene model ID in the corresponding box, a gene which could be deregulated in an experiment. Moreover, like the stained molecule, you can enter several gene models ID separated by ":".</LI><p>

        <center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for expression data of Snail in <BR>which Nodal was deregulated.</strong></td></TR>
      </TABLE></center>
      <p>
      
      <!--MOVIE-->
<center>
<br>

<embed  width="625" height="400"  src="flvplayer.swf?file=Videoflv/SearchExpSnail_nodalDown.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->




             <LI>If you just want to access expression pattern in manipulated conditions like embryo manipulation, click on the corresponding button ("Include expression patterns in experimentally manipulated embryos").</LI><p>

           <center>  <TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for expression data of Snail including ablation of blastomeres experiments, at <BR>the 112-cell stage.</strong></td></TR>
      </TABLE></center>
      <p>

<!--MOVIE-->
<center>
<br>

<embed  width="625" height="400"  src="flvplayer.swf?file=Videoflv/SearchExpSnailCellAblated.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
     	<!--Look at the movie <A HREF="Videoflv/SearchExpSnailCellAblated.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A>-->

            </OL>

      <UL><LI><FONT SIZE="+1" ><EM>Can you explain the result of this query? </A></EM></FONT><P>
      You will have a list of all the experiment data corresponding to your query ordered by developmental stages. The number of the experiment is specified on the top right of the window. You can click on the top left of the window to zoom in or to zoom out the pictures. At the bottom, you will access to the refine tool. If you want to know more about an experiment, you can click on the corresponding "more" button.<p>

               </LI></UL>

<UL>Click <A HREF="insitu-search-by-molecule.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Search_molecule">How do I search by anatomy? </A></FONT><p>
This page allows you to retrieve In situ expression profiles labelling defined territories, and excluded from others. By default only the wild type expression patterns are shown but you can access expression patterns in manipulated conditions (gene deregulation, embryo manipulation) by ticking/filling the relevant boxes/fields.<p>

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down. </LI><BR>
             <LI>Choose a "Developmental stage" from the menu by clicking on the arrows and scrolling down. </LI><BR>
             <LI>Define you territories of interest either via the detailed anatomical ontology for each stage (use the "Add" button) or a simpler list of fates. To find tissue specific expression patterns tick the "only" box.</LI><BR>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for the genes ONLY expressed <BR>in B7.6 at 112 cell stage.</strong></td></TR>
      </TABLE></center>
      <p>

<!--MOVIE-->
<center>
<br>

<embed  width="625" height="400" border="20" src="flvplayer.swf?file=Videoflv/SearchExpressionB7.6.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->
 <!--Look at the movie <A HREF="Videoflv/ISHSearch_B76.flv"><IMG SRC='PictureHelp/movie_symbol.gif' BORDER="0"></A>-->

            <LI>You can also specify that you want to exclude patterns labelling a list of unwanted territories.</LI><br>

<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for the genes expressed in the muscle and not in the endodermal strand at early tailbud stage.</strong></td></TR>
      </TABLE></center>
      <p>
</OL>

<!--MOVIE-->
<center>
<br>

<embed  width="625" height="400" border="20" src="flvplayer.swf?file=Videoflv/SearchInMuscleNotInEnd.flv" quality="high" type="application/x-shockwave-flash" />

<br>
<br>
</center>
<!--ENDOFMOVIE-->

<UL>Click <A HREF="insitu-search-by-anatomy.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Advanced_search">Advanced search</A></FONT><p>
This page combines the search options of the Find the In Situ patterns associated to a gene/clone and Find the genes expressed in a given territory.
Thanks to this page, you can make complex query.


<UL>Click <A HREF="insitu-search-NEW.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="DDD">DDD</A></FONT><p>
This pages allows you to retrieve gene models with EST/cDNA clones differentially expressed in the various sequenced cDNA libraries.

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down. </LI><BR>
             <LI>tick the libraries (pool A, pool B) to analyse. Pool A corresponds to libraries you would like ESTs to be enriched over pool B.
              By ticking all, you can retrieve all gene models represented in a given EST pool. </LI><BR>
</OL>


<UL>Click <A HREF="DDD-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>
 
<P align="center"><FONT SIZE="+2" COLOR="333333"><A NAME=""><strong> Explore the literature </strong></A></font></p>
<center><IMG SRC="PictureHelp/LiteratureMenu.bmp"></center>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Article_given_gene">Find articles related to a given gene</A></FONT><p>
This page allows the user to retrieve articles related to a given gene.

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down. </LI><br>
             <LI>Type the name of a gene of interest</LI><BR>
             <LI>By default all ascidian articles studying this gene will be returned.
You can additionally restrict your search to articles reporting studies on the wild type expression, the regulation, or the function of this gene</LI><p>


<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for articles dealing with the regulation <BR>of Otx, for Ciona intestinalis.</strong></td></TR>
      </TABLE></center>
      <p>


</OL>

<UL><LI><FONT SIZE="+1" ><EM> Can you explain the result of this query? </A></EM></FONT></ul>
Upon submission, a first results page will present all genes whose name matches the chain of characters entered.
For each gene, a link gives access to the relevant articles.

<UL>Click <A HREF="bib-search-mol.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>
      
<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="bib-search-anatomy">Find articles describing the specification of a given cell fate</A></FONT><p>

<OL TYPE="1"><LI>Choose an "Ascidian species" from the menu by clicking on the arrows and scrolling down. </LI><br>
             <LI>Select one or several cell fates </LI><BR>
             <LI>Submit</LI><p>


<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example <p> </strong></td></TR>
             <TR ALIGN="center"> <td><strong>You search for all articles in which the specification mechanism for the mesenchyme <br>was experimentally studied.</strong></td></TR>
      </TABLE></center>
      <p>

</OL>

<UL><LI><FONT SIZE="+1" ><EM> Can you explain the result of this query? </A></EM></FONT></ul>
The request will return all ascidian articles entered in ANISEED, in which the specification mechanisms for one at least of the fates specified were experimentally studied.

<UL>Click <A HREF="bib-search-anatomy.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="biblio-search">Search articles by Authors or Title words</A></FONT><p>

<OL TYPE="1"><LI>Type in the field one or several Authors name or words, separated by a comma.</LI><br>
             <LI>Submit</LI><p>


<center><TABLE background="CC00CC" border="3" width="40%">
             <TR ALIGN="center"> <td><strong>Example<p></strong></td></TR>
             <TR ALIGN="center"> <td><strong> You search for all articles from Clare Hudson. </strong></td></TR>
      </TABLE></center>
      <p>

</OL>

<UL><LI><FONT SIZE="+1" ><EM> Can you explain the result of this query? </A></EM></FONT></ul>
The results page lists all articles including all character chains entered in their title or authors list.
Note that incomplete words can be typed to broaden your search: eg "mesenchy" retrieves "mesenchyme" and "mesenchymal".

<UL>Click <A HREF="biblio-search.php">here</A> to run this search in ANISEED. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Articles_aniseed">Show all articles present into the database </A></FONT><p>
This link allows users to access all articles entered in the database.

<UL><A HREF="show-article.php">Access all articles present in Aniseed</A></UL>
<UL><A HREF="#Top">Return on the top</A></UL>


<P align="center"><FONT SIZE="+2" COLOR="333333"><strong> Download section </strong></A></font></p>
<center><IMG SRC="PictureHelp/DownloadMenu.bmp"></center>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="Download_data">Download Aniseed data </A></FONT><p>
All ANISEED data can now be downloaded from the download section. This includes the
anatomical ontologies; fate, lineage and morphometry information; gene models with their
functional annotations; EST/cDNA sets; molecular tools including morpholinos; cisregulatory
sequences; and Cisreg/
ISH whole mount annotations and pictures.
To exchange ISH data, with other systems we defined a new standard MISFISHIE compliant
XML format, the InSitu Markup Language.

<UL>Click <A HREF="Download_data.php">here</A> to download Aniseed data. </UL>
<UL><A HREF="#Top">Return on the top</A></UL>

<p align="center"><FONT SIZE="+2" COLOR="333333"><A NAME="3DVE">Download the 3D Virtual Embryo software</A></FONT><p>

The 3D Virtual Embryo uses interactive three dimensional digital embryo reconstructions to display
information from the database as well as to enter into the database quantitative descriptions
of the geometry of individual embryonic territories and their interactions.   <p>

How to install the 3D Virtual Embryo on your computer ?
<OL TYPE="1"><LI>Install java (from the 1.4 release) If you are using Windows, the installation of java should start automatically.
                 But you can find the installer at <A HREF=http://java.sun.com/javase/downloads/widget/jdk6.jsp>http://java.sun.com/javase/downloads/widget/jdk6.jsp</A> (Choose to download
                 the Java SE corresponding to your operating system). Java is already installed on MacOSX. Make sure it is up to date.
                 </LI><BR>

             <LI>Install java3D (from the 1.3 release) you can find java3d for Windows & solaris & Linux at <A HREF=https://java3d.dev.java.net/binary-builds.html>
             https://java3d.dev.java.net/binary-builds.html.</A>
             For other platforms including MacOS 10.3, check the following url: 
             <A HREF=http://java.sun.com/products/java-media/3D/ports.html>
             http://java.sun.com/products/java-media/3D/ports.html</A>.
             Java3D is already installed with MacOs 10.4.</LI><BR>
             <LI>Download the 3D Virtual Embryo.
                          <OL TYPE="disc"><LI><a href="Software/3dve_Win20100310.zip" target="_self">Download 3D Virtual Embryo for Windows (version 2010-03-10) - Patched version / Embryos to very late 112c stage (Ciona intestinalis) </a></LI>
                                          <LI><a href="Software/3dve_Linux20100310.zip" target="_self">Download 3D Virtual Embryo for Linux (version 2010-03-10) - Patched version / Embryos to very late 112c stage (Ciona intestinalis) </a></LI>
                                          <LI><a href="Software/3dve_Mac20100310.zip" target="_self">Download 3D Virtual Embryo for MacOS (version 2010-03-10) - Patched version / Embryos to very late 112c stage (Ciona intestinalis)  <a></LI>
                          </OL>
             </LI>


             <p>

             <center><IMG SRC="PictureHelp/3DVirtual_embryo.jpg"></center>

</div>

<?
include ("frames_footer.php");
?>

</BODY>
</HTML>
