<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("connection.php");

  Header("Content-type: image/png");

$tGENEID=$_GET["id"];
$FATE=$_GET["fate"];


//------------------
$dv=(array) null;
$requete="SELECT \"DEV_PERCENT\" from \"DEV_STAGE\" where \"SPECIES\"='Ciona intestinalis' order by \"DEV_PERCENT\"";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
$dv[count($dv)]=$row["DEV_PERCENT"];
}
$long=5*$dv[count($dv)-1];
$larg=200;

$image = imagecreate($long,$larg);

$blanc = ImageColorAllocate($image,255,255,255);
$noir = ImageColorAllocate($image,0,0,0); 
$bleu = ImageColorAllocate($image,0,0,255);
$vert = ImageColorAllocate($image,0,255,0);
$rouge = ImageColorAllocate($image,255,0,0);

for ($i=0;$i<count($dv);$i++)
{
//imagedashedline($image,$i*20+15,$larg,$i*20+15,0,$bleu);
imagedashedline($image,$dv[$i]*5,$larg,$dv[$i]*5,0,ImageColorAllocate($image,200,200,255));
}

imagestring($image,1,0,0,"Egg",$rouge);
imagestring($image,1,20,0,"Zyg",$rouge);
imagestring($image,1,45,0,"2c",$rouge);
imagestring($image,1,70,0,"4c",$rouge);
imagestring($image,1,95,0,"8c",$rouge);
imagestring($image,1,115,0,"16c",$rouge);
imagestring($image,1,140,0,"24c",$rouge);
imagestring($image,1,165,0,"e32c",$rouge);
imagestring($image,1,190,0,"l32c",$rouge);
imagestring($image,1,215,0,"44c",$rouge);
imagestring($image,1,240,0,"64c",$rouge);
imagestring($image,1,265,0,"76c",$rouge);
imagestring($image,1,290,0,"110c",$rouge);
imagestring($image,1,315,0,"mGa",$rouge);
imagestring($image,1,340,0,"lGa",$rouge);
imagestring($image,1,365,0,"eNe",$rouge);
imagestring($image,1,390,0,"mNe",$rouge);
imagestring($image,1,415,0,"lNe",$rouge);
imagestring($image,1,435,0,"iT",$rouge);
imagestring($image,1,445,0,"eT",$rouge);
imagestring($image,1,455,0,"mT",$rouge);
imagestring($image,1,470,0,"lT",$rouge);
imagestring($image,1,485,0,"Tad",$rouge);




//------------------

function getProfile($mol)
{
global $c;
global $FATE;
//$mol="ci0100148516";//cdx
$gene=$mol;
$requete0="select \"MOL_ID\" from \"MOL_ENTITY\" where \"TYPE\"='gene' and \"NAME\"='$mol'";
$stmt0=pg_query($c,$requete0);
$row0=pg_fetch_array($stmt0);
$mol=$row0["MOL_ID"];

if ($gene{0}=="c")
{
$requete="
select \"IN_SITU_ID\",\"DEV_STAGE_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in(
select \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) order by \"DEV_STAGE_ID\"
";
}



if ($gene{0}=="K")
{
$tkyo=explode(".",$gene);
$kabstract=$tkyo[0].".".$tkyo[1].".".$tkyo[2];


$requete="
select \"IN_SITU_ID\",\"DEV_STAGE_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in(
select \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract' and \"TYPE\"='abstract')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract' and \"TYPE\"='abstract')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) order by \"DEV_STAGE_ID\"
";
}

if ($gene{0}=="E")
{
$requete="
select \"IN_SITU_ID\",\"DEV_STAGE_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in(
select \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$gene'))
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$gene'))
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$gene'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) order by \"DEV_STAGE_ID\"
";
}




//print $requete;
$stmt=pg_query($c,$requete);

//print $requete;

$prof=(array) null;
while ($row=pg_fetch_array($stmt))
{
$ish=$row["IN_SITU_ID"];
$devid=$row["DEV_STAGE_ID"];

//print $ish." @ ".$devid."<br>";

$requete2="SELECT \"NAME\",\"DEV_PERCENT\" from \"DEV_STAGE\" where \"DEV_STAGE_ID\"='$devid' order by \"DEV_PERCENT\"";
$stmt2=pg_query($c,$requete2);
$row2=pg_fetch_array($stmt2);
$dev=$row2["NAME"];
$devper=$row2["DEV_PERCENT"];

/*
//REQUETE INITIALE POUR LES PROFILS D'EXPRESSION GLOBAUX
$requete2="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\"='$ish'
)";
*/


//MODIF DE LA REQUETE POUR CIBLER LES FATES !
$requete2="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\"='$ish'
INTERSECT
SELECT \"ANAT_ID\" from \"FATE\" where \"KEYWORDS\"='".trim($FATE)."'
)";

$requetebis="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in(
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\"='$ish'
)";
$stmtbis=pg_query($c,$requetebis);
$rowbis=pg_fetch_array($stmtbis);

/*
//MODIF DE LA REQUETE POUR CIBLER LES BLASTOMERES !
$requete2="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\"='$ish'
INTERSECT
SELECT \"ANAT_ID\" from \"ANAT_ENTITY\" where \"NAME\"='A9.16 cell pair'
)";
*/


$stmt2=pg_query($c,$requete2);
$row2=pg_fetch_array($stmt2);
// print $devper."===>".$row2["NAME"]."<br>";
if ($row2["NAME"]=="No expression") $express="false";else $express="true";
if ($rowbis["NAME"]=="Whole embryo") $express="true";
if ((pg_num_rows($stmt2)==0)&&($rowbis["NAME"]!="Whole embryo")) $express="false";

/*else if ((pg_num_rows($stmt2)==0) && ($row2["NAME"]=="Whole embryo")) $express="true";*/






//print $ish." ".$dev." ".$devper." ".$express."<br>";

///// on teste pour voir si on doublone
if (strlen($prof[$devper])==0) $prof[$devper]=$express;
else
	{
	/////// Une idee serait de mettre la valeur suivant le crible qu'on regarde Fuji on prend pas si on a un imai par ex ...
	if ($prof[$devper]=="false") $prof[$devper]=$express;
	if ($prof[$devper]=="true") ;
	}



}
ksort($prof);
// print_r($prof);
return $prof;
}


function graph($prof,$color,$shift)
{
global $dv;
global $image;
global $prof;
global $GENEID;
global $larg;
global $long;


// print_r($dv);
// print_r($prof);

$coord=(array) null;
for ($i=0;$i<count($dv);$i++)
{
$value=$prof[$dv[$i]];
if ($value=="false") $coord[count($coord)]=($dv[$i]*5-2+$shift)."@"."180";
if ($value=="true")  $coord[count($coord)]=($dv[$i]*5-2+$shift)."@"."20";
}

// print_r($coord);


for ($i=0;$i<count($coord)-1;$i++)
{
$tmp=explode("@",$coord[$i]);
$tmp2=explode("@",$coord[$i+1]);


//On cherche
$devtmp=($tmp[0]+2)/5;
$devtmp2=($tmp2[0]+2)/5;

for ($K=0;$K<count($dv);$K++) if ($dv[$K]==$devtmp) {$value1=$K;break;}
for ($K=0;$K<count($dv);$K++) if ($dv[$K]==$devtmp2) {$value2=$K;break;}

$style = array(ImageColorAllocate($image,0,0,0), ImageColorAllocate($image,0,0,0), ImageColorAllocate($image,0,0,0), ImageColorAllocate($image,0,0,0), ImageColorAllocate($image,0,0,0), ImageColorAllocate($image,255,255,255), ImageColorAllocate($image,255,255,255), ImageColorAllocate($image,255,255,255), ImageColorAllocate($image,255,255,255), ImageColorAllocate($image,255,255,255));
imagesetstyle($image, $style);


	if ($value1+1==$value2) imageline($image,$tmp[0]+$shift,$tmp[1]+$shift,$tmp2[0]+$shift,$tmp2[1]+$shift,imagecolorallocate($image,0,0,255));
	else imageline($image,$tmp[0]+$shift,$tmp[1]+$shift,$tmp2[0]+$shift,$tmp2[1]+$shift, IMG_COLOR_STYLED);

}


for ($i=0;$i<count($coord);$i++)
{
$tmp=explode("@",$coord[$i]);
$tmp2=explode("@",$coord[$i+1]);
imagefilledellipse($image, $tmp[0]+$shift,$tmp[1]+$shift, 5, 5, ImageColorAllocate($image,0,150,0));
}


//Le gene sur l'image
//imagestring($image,2,0,$larg-40,$GENEID,ImageColorAllocate($image,0,0,255));

return $image;
}


$tmp=explode(":",$tGENEID);
$colorize=(array) null;

$colorize[0]=ImageColorAllocate($image,0,0,0);
$colorize[1]=ImageColorAllocate($image,255,0,255);
$colorize[2]=ImageColorAllocate($image,0,0,255);
$colorize[3]=ImageColorAllocate($image,0,255,0);



for ($i=0;$i<count($tmp);$i++)
{
$GENEID=$tmp[$i];
$prof=getProfile($GENEID); 
//$image=graph($prof,ImageColorAllocate($image,255,150,0),0);
//$image=graph($prof,ImageColorAllocate($image,255*$i,0,255*$i),0);
$image=graph($prof,$colorize[$i],0);
}


 imagepng($image);


?>