<html>
<head>
<title>ANISEED - Expression at a glance (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="The gene card gives access to Ciona intestinalis functional annotation, the associated ESTs, the in situ data, the cis-regulatory region and the molecular tools. For more detail, contact aniseed@ibdm.univ-mrs.fr">
<meta name="keywords" content="Ciona intestinalis, tunicate, ascidian database, ciona intestinalis database, ciona intestinalis gene, functional annotation, in situ sate, cis-regulatory region, molecular tool">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("connection.php");
include ("frames_header.php");

?>
  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />


<?
$clustid=$_GET["clusterid"];
$aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);

//// get gene models related to the gene give by clustid
$gm=(array) null;
$requete="select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $gm[count($gm)]=$row["NAME"];


//// get name of the clustid
$name=(array) null;
$manual=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\",\"MANUAL\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($row=pg_fetch_array($stmt))
	 {
  	 
	if ($row["MANUAL"]=="y") $manual[count($manual)]=$row["GENE_CLUSTER_NAME"];
	else $name[count($name)]=$row["GENE_CLUSTER_NAME"];
	 }


if( (count($name)==0) || (count($manual)==0) )
	{

	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete);
	while ($row=pg_fetch_array($stmt))$name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"];
	}


//// fetch go term associated to different gm related to the clust
$go=(array) null;
$requete="SELECT \"GO_ID\" from \"GO_DESCRIPTION\" where \"MOL_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $go[$row["GO_ID"]]++;

///// fetch interpro
$interpro=(array) null;
$requete="SELECT \"IP_ID\" from \"IP_DESCRIPTION\" where \"MOL_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $interpro[$row["IP_ID"]]++;

?>

<!-- Header pour l'onglet -->
<?
//// agregation des modeles de genes

$agreg_gm="";
for ($i=0;$i<count($gm);$i++)
	{
	if (strlen($agreg_gm)==0) $agreg_gm=$gm[$i];
	else $agreg_gm.=":".$gm[$i];
	}


?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<div id="header">
  <ul>    
        <li><a href="gene-card.php?clusterid=<?print $clustid;?>">Gene Card</a></li>
        <li><a href="ESTcluster-gene.php?clusterid=<? print $clustid; ?>">ESTs cluster</a></li>
        <li><a href="insitu-result.php?target=<?print $agreg_gm;?>&MOLtype=2&Order=DEV_STAGE_ID&fromgenecard=1">Detailed Expression</a></li>
        <li id="current" ><a href="#">Expression at a glance<i><small><small><b><font color="crimson">New</font></b></small></small></i></a></li>
	<li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
        <li ><a href="gene-regulation-card.php?clusterid=<?print $clustid; ?>">Upstream regulators</a></li>
        <li ><a href="gene-function-card.php?clusterid=<?print $clustid; ?>">Downstream targets</a></li>
        <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
        <!-- <li><a href="#" style="color:white;">Microarray probe</a></li> -->
        <!--<li><a href="#" style="color:white;">Export</a></li> -->
  </ul>
</div>
<br><br>



<?
print "<br><br><font color=\"#D64242\" size=\"3\"><b>Gene Expression Pictures</b></font><br><br>";

$tmp=explode(":",$agreg_gm);

$jgi=(array) null;
$ens=(array) null;
$kyo=(array) null;

for ($i=0;$i<count($tmp);$i++)
{
if (strlen(trim($tmp[$i]))==0) continue;
if ($tmp[$i]{0}=="c") $jgi[count($jgi)]=$tmp[$i];
else if ($tmp[$i]{0}=="E") $ens[count($ens)]=$tmp[$i];
else if ($tmp[$i]{0}=="KY") $kyo[count($kyo)]=$tmp[$i];
}


$requete="";
for ($i=0;$i<count($jgi);$i++)
{

$requete0="select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$jgi[$i]."'";
$stmt0=pg_query($c,$requete0);
$row0=pg_fetch_array($stmt0);
$geneid=$row0["MOL_ID"];

////////////////////////////////// JGI /////////////////////////////////////////
if (strlen($requete)==0)
	{
	$requete="
	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"='$geneid'
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)
	";
	}
else
	{
	$requete.="
	UNION

	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"='$geneid'
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)


	";
	}
}

////////////////////////////////// ENSEMBL /////////////////////////////////////////

for ($i=0;$i<count($ens);$i++)
{
//print $ens[$i]."<br>";


$requete0="
select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$ens[$i]."')";
$stmt0=pg_query($c,$requete0);
$row0=pg_fetch_array($stmt0);
$geneid=$row0["ABSTRACT_ID"];



if (strlen($requete)==0)
	{
	$requete="
	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$ens[$i]."')
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)
	";
	}
else
	{
	$requete.="
	UNION

	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$ens[$i]."')
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)


	";
	}

}
////////////////////////////////// KYOTOGRAIL /////////////////////////////////////////



for ($i=0;$i<count($kyo);$i++)
{

$new=explode(".",$kyo[$i]);
$newn="$new[0].$new[1].$new[2]";


$requete0="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$newn' and \"TYPE\"='abstract'";
$stmt0=pg_query($c,$requete0);
$row0=pg_fetch_array($stmt0);
$geneid=$row0["MOL_ID"];



if (strlen($requete)==0)
	{
	$requete="
	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$kyo[$i]."')
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)
	";
	}
else
	{
	$requete.="
	UNION

	select \"IN_SITU_ID\" from \"PICTURE\" where \"IN_SITU_ID\" in (
	select ish.\"IN_SITU_ID\" from \"IN_SITU\" ish,\"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in (
	select distinct \"IN_SITU_ID\" from \"TARGET\" where \"TARGET_ID\" in (
	select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
	select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$geneid'
	)
	UNION
	select \"GENE_ID\" from \"GENE\" where \"GENE_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$kyo[$i]."')
	UNION
	SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$geneid'
	)
	) and ish.\"PRIVATE\"='n' and ish.\"CHECKED\"='y' and ish.\"WILD_TYPE\"='y'
	and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
	)


	";
	}


}















//}


$requete="

select pic.\"PICTURE_ID\",pic.\"PATH\",pic.\"IN_SITU_ID\" from \"PICTURE\" pic,\"IN_SITU\" ish, \"DEV_STAGE\" dev where ish.\"IN_SITU_ID\" in 
(
$requete
)
and ish.\"WILD_TYPE\"='y'
and ish.\"PRIVATE\"='n'
and ish.\"CHECKED\"='y'
and pic.\"IN_SITU_ID\"=ish.\"IN_SITU_ID\"
and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\"

order by dev.\"DEV_PERCENT\"

";


// print $requete."<br>";


$stmt=pg_query($c,$requete);
//print $requete."<br>";


if (pg_num_rows($stmt)==0)
	{
	print "<center><h2>No Picture found into Aniseed Database for <font color=\"crimson\">$clustid</font></h2></center>";
	}
else 
{

while ($row=pg_fetch_array($stmt))
{
//print $row["IN_SITU_ID"]."<br>";

if (strstr($row["PATH"],"mix")) continue;


 if (strlen($row["PATH"])==0) print "<a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/aniseed/insitu.php?id=".$row["IN_SITU_ID"]."\"><img border=\"0\" width=\"80\" src=\"picture-mini.php?id=".$row["PICTURE_ID"]."\"></a>&nbsp;";
 else print "<a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/aniseed/insitu.php?id=".$row["IN_SITU_ID"]."\"><img border=\"0\" width=\"80\" src=\"http://crfb.univ-mrs.fr/aniseed/picturesDB/".$row["PATH"]."\"></a>&nbsp;";

}
}










?>

<?
include ("frames_footer.php");
?>