<!-- this script lists targets of a gene of interest by territories ans stages -->
<?

/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

include ("connection.php");
print "<title> ANISEED V3.0 - Downstream targets</title>";
include ("frames_header.php");


$clustid=$_GET["clusterid"];
$aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);

$regs=(array) null;

$all_dev_stages=(array) null;
$all_dev_stages_ids=(array) null;

//// get gene models related to the gene give by clustid
$gm_name=(array) null;
$gm_id=(array) null;
$requete="select \"NAME\", \"GENE_ID\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) {
	$gm_name[count($gm_name)]=$row["NAME"];
	$gm_id[count($gm_id)]=$row["GENE_ID"];
}


//// agregation des modeles de genes
$agreg_gm="";
$requete="SELECT \"NAME\" from \"GENE\" where \"GENE_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if (strlen($agreg_gm)==0) $agreg_gm=$row["NAME"];
else $agreg_gm.=":".$row["NAME"];

}


//// get name of the clustid
$name=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid' AND \"MANUAL\"='y'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete) or die (pg_last_error($c));
	while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
}

if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete);
	while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
}

?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<div id="header">
  <ul>    
	<li><a href="gene-card.php?clusterid=<? print $clustid; ?>">Gene Card</a></li>
        <li><a href="ESTcluster-gene.php?clusterid=<? print $clustid; ?>">ESTs cluster</a></li>
        <li><a href="insitu-result.php?target=<?print $agreg_gm;?>&MOLtype=2&Order=DEV_STAGE_ID&fromgenecard=1">Detailed Expression</a></li>
        <li><a href="gene-picture.php?clusterid=<? print $clustid; ?>">Expression at a glance <i><small><small><b><font color="crimson">New</font></b></small></small></i></a></li>
	<li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
        <li ><a href="gene-regulation-card.php?clusterid=<?print $clustid; ?>">Upstream regulators</a></li>
	<li id="current" ><a href="#">Downstream targets</a></li>
        <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
        <!-- <li><a href="#" style="color:white;">Microarray probe</a></li> -->
        <!--<li><a href="#" style="color:white;">Export</a></li> -->
  </ul>
</div>
<br><br>

<?

$gene_name=implode (" / ",$name);
$display_name = $name[0];
print "<br><br><font color=\"#D64242\" size=\"3\"><b>Genes regulated by $name[0]</b></font><br><br>";
print "<table border=\"0\" width=\"100%\">";

print "<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>&nbsp;</td></tr>";

$all_dev_stages = (array) null;	
$all_dev_stages_ids = (array) null;	
$anat_ids=(array) null;	
	
$khoueiry = "SELECT \"INTERACTION_EVIDENCE_ID\", \"GENE_B\", \"INTERACTION_EVIDENCE_TYPE\".\"DESCRIPTION\" AS \"EVIDENCE\", \"INTERACTION_TYPE\".\"DESCRIPTION\" AS \"TYPE\", \"ANAT_ENTITY_ID\", \"ANAT_ENTITY\".\"NAME\" AS \"ANAT_NAME\", \"EVIDENCE_ISH_ID\", \"CONTROL_ISH_ID\", \"DEV_STAGE\".\"NAME\" AS \"STAGE_NAME\", \"DEV_STAGE\".\"DEV_STAGE_ID\", \"CONFIDENCE\" FROM \"INTERACTION_EVIDENCE\", \"INTERACTION_EVIDENCE_TYPE\", \"INTERACTION_TYPE\", \"DEV_STAGE\", \"ANAT_ENTITY\" WHERE \"GENE_A\"='$clustid' AND \"ANAT_ENTITY\".\"ANAT_ID\"=\"INTERACTION_EVIDENCE\".\"ANAT_ENTITY_ID\" AND \"INTERACTION_EVIDENCE\".\"DEV_STAGE_ID\"=\"DEV_STAGE\".\"DEV_STAGE_ID\" AND \"INTERACTION_EVIDENCE\".\"EVIDENCE_TYPE\"=\"INTERACTION_EVIDENCE_TYPE\".\"EVIDENCE_TYPE_ID\" AND \"INTERACTION_EVIDENCE\".\"INTERACTION_TYPE\"=\"INTERACTION_TYPE\".\"INTERACTION_TYPE_ID\" ORDER BY \"DEV_PERCENT\"";
$stmt = pg_query($c,$khoueiry);
while($row=pg_fetch_array($stmt)){ 
	//Check if control exists... if it does then only include if it is the control
	$kh2 = "SELECT \"CTRL_ISH_ID\" FROM \"MUTANT\" WHERE \"IN_SITU_ID\"=".$row["EVIDENCE_ISH_ID"];
	$st2 = pg_query($c,$kh2);
	if(!($r2=pg_fetch_array($st2)) || ($r2["CTRL_ISH_ID"]==null) || ($r2["CTRL_ISH_ID"]==$row["CONTROL_ISH_ID"])){
		if(!in_array($row["STAGE_NAME"],$all_dev_stages)){ 
			$all_dev_stages[count($all_dev_stages)]=$row["STAGE_NAME"];
			$all_dev_stages_ids[count($all_dev_stages_ids)]=$row["DEV_STAGE_ID"];
		}
		$anat_ids[$row["STAGE_NAME"]][$row["ANAT_NAME"]]=$row["ANAT_ENTITY_ID"];
		$regs[$row["STAGE_NAME"]][$row["EVIDENCE"]][$row["GENE_B"]][$row["TYPE"]][$row["ANAT_NAME"]][$row["INTERACTION_EVIDENCE_ID"]][$row["EVIDENCE_ISH_ID"]][$row["CONTROL_ISH_ID"]] = $row["CONFIDENCE"];	
	}
}

for ($i=0;$i<count($all_dev_stages);$i++) {
//foreach($regs as $stage => $stage_list){

	$stage = $all_dev_stages[$i];
	$stage_id = $all_dev_stages_ids[$i];
	
	$stage_list = $regs[$stage];
	if(count($stage_list)>0){
		print "<tr><td colspan=2><strong>$stage</strong></td></tr>";
		print "<tr><td colspan=2>&nbsp;</td></tr>";
	}

	#foreach ($stage_list as $victim => $cve){
	foreach ($stage_list as $evidence => $evidence_list){
	
	$dir = "indirectly";
	if(substr_count($evidence,"Regulatory Region")>0){
		print "<tr><td>&nbsp;</td><td><strong>Evidence for direct interactions from analysis of regulatory regions</strong></td></tr>";
	}
	if(substr_count($evidence,"upregulation")>0){
		$test_upregulation = true;
		print("<tr><td>&nbsp;</td><td><strong>Evidence for potentially indirect interactions by analysis of ectopic gain of function experiments</strong> (beware, may not reflect endogenous regulation in the indicated territory)</td></tr>");
	}
	if(substr_count($evidence,"downregulation")>0){
		print "<tr><td>&nbsp;</td><td><strong>Evidence for potentially indirect interactions by analysis of loss of function experiments</strong></td></tr>";
	}
	print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
		
	
	foreach ($evidence_list as $victim => $cve)
	{
		$vic_cluster = $victim;
		$victim=str_replace("cluster","aniseedV3_",$victim);
			
		//// get name of the clustid
		$name=(array) null;
		$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$vic_cluster' AND \"MANUAL\"='y'";
		$stmt=pg_query($c,$requete) or die (pg_last_error($c));
		while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$vic_cluster'";
			$stmt=pg_query($c,$requete) or die (pg_last_error($c));
			while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		}
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$vic_cluster'";
			$stmt=pg_query($c,$requete);
			while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
		}
		$vic_name = implode (" / ",$name);
		$vic_display_name = $name[0];
			
		foreach ($cve as $up_down => $cre)
		{
			if($test_upregulation)
			{
				$up_down = preg_replace("/indirectly/","ectopically",$up_down);
			}
			else
			{
				$up_down = preg_replace("/indirectly /","",$up_down);
			}
			$up_down = preg_replace("/upregulates/","activates",$up_down);
			$up_down = preg_replace("/downregulates/","represses",$up_down);

			print "<tr><td>&nbsp;</td><td> $display_name $up_down <a href=\"gene-card.php?clusterid=$vic_cluster\" title=\"$vic_name\"> $vic_display_name </a> in";
			
			foreach($cre as $region => $udre){	

				$region_id = $anat_ids[$stage][$region];
				$khoueiry = "SELECT \"CHILD_OF\"  FROM 	\"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=$region_id;";
				$stmt = pg_query($c,$khoueiry);
				$parents[]=$region_id;
				while (($row=pg_fetch_array($stmt)) && (!is_null($row["CHILD_OF"]))){
					$parents[]=$row["CHILD_OF"];
					$khoueiry = "SELECT \"CHILD_OF\" FROM \"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=".$row["CHILD_OF"];
					$stmt = pg_query($c,$khoueiry);
				}

				
				//foreach($pudre as $ptype => $udre){
				
					$evidence_list = (array)null;
				
					foreach ($udre as $evid => $evid_list){
						if(!in_array($evid,$evidence_list)){ $evidence_list[]= $evid; }		
					}		
				
					$region_id = $anat_ids[$all_dev_stages[$i]][$region];
					$region_link = "<a href=\"anatomy.php?dev=$stage_id&region=$region_id\" target=\"_blank\"> $region </a>";		
					$ev_count = count($evidence_list);
					if($ev_count>1){ $ev_count = $ev_count." evidences"; } 	else { $ev_count = "1 evidence"; }
					$evidence = "<font size=\"1\">(<a href=\"display-evidence.php?evidences=".implode(":",$evidence_list )."\" target=\"_blank\">$ev_count</a>)</font>";						

					print "&nbsp;&nbsp;$region_link $evidence";
				
				//}
			}
			print "</td></tr>";
			print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
		}
	}
	}
}



print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr></table>";

include ("frames_footer.php");
?>