<!-- display informations on a gene of interest (biological names, transcript associated functionnal annotation...) -->
<html>
<head>
<title>ANISEED - Gene card</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="The gene card gives access to Ciona intestinalis functional annotation, the associated ESTs, the in situ data, the cis-regulatory region and the molecular tools. For more detail, contact aniseed@ibdm.univ-mrs.fr">
<meta name="keywords" content="Ciona intestinalis, tunicate, ascidian database, ciona intestinalis database, ciona intestinalis gene, functional annotation, in situ sate, cis-regulatory region, molecular tool">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("connection.php");
include ("frames_header.php");

//cipro URL
$ciproURL = 'http://cipro.ibio.jp/2.1/viewdata.cgi?id=';
?>
  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />


<?
$clustid=$_GET["clusterid"];
$aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);

//// get gene models related to the gene give by clustid
$gm=(array) null;
$requete="select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $gm[count($gm)]=$row["NAME"];


//// get name of the clustid
$name=(array) null;
$manual=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\",\"MANUAL\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($row=pg_fetch_array($stmt))
	 {
  	 
	if ($row["MANUAL"]=="y") $manual[count($manual)]=$row["GENE_CLUSTER_NAME"];
	else $name[count($name)]=$row["GENE_CLUSTER_NAME"];
	 }


if( (count($name)==0) || (count($manual)==0) )
	{

	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete);
	while ($row=pg_fetch_array($stmt))$name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"];
	}


//// fetch go term associated to different gm related to the clust
$go=(array) null;
$requete="SELECT \"GO_ID\" from \"GO_DESCRIPTION\" where \"MOL_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $go[$row["GO_ID"]]++;

///// fetch interpro
$interpro=(array) null;
$requete="SELECT \"IP_ID\" from \"IP_DESCRIPTION\" where \"MOL_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) $interpro[$row["IP_ID"]]++;

?>

<!-- Header pour l'onglet -->
<?
//// agregation des modeles de genes

$agreg_gm="";
for ($i=0;$i<count($gm);$i++)
	{
	if (strlen($agreg_gm)==0) $agreg_gm=$gm[$i];
	else $agreg_gm.=":".$gm[$i];
	}


?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<div id="header">
  <ul>    
	<li id="current" ><a href="#">Gene Card</a></li>
        <li><a href="ESTcluster-gene.php?clusterid=<? print $clustid; ?>">ESTs cluster</a></li>
        <li><a href="insitu-result.php?target=<?print $agreg_gm;?>&MOLtype=2&Order=DEV_STAGE_ID&fromgenecard=1">Detailed Expression</a></li>
        <li><a href="gene-picture.php?clusterid=<? print $clustid; ?>">Expression at a glance <i><small><small><b><font color="crimson">New</font></b></small></small></i></a></li>
	<li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
        <li ><a href="gene-regulation-card.php?clusterid=<?print $clustid; ?>">Upstream regulators</a></li>
        <li ><a href="gene-function-card.php?clusterid=<?print $clustid; ?>">Downstream targets</a></li>
        <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
        <!-- <li><a href="#" style="color:white;">Microarray probe</a></li> -->
        <!--<li><a href="#" style="color:white;">Export</a></li> -->
  </ul>
</div>
<br><br>


<?

print "<br><br><font color=\"#D64242\" size=\"3\"><b>Gene Card</b></font><br><br>";


print "<table border=\"0\" width=\"100%\">";
$gene_name=implode (" / ",$name);
$manual_name=implode(" <font color=\"#666666\"><b>/</b></font> ",$manual);

print "<tr><td><font color=\"#456898\" size=\"2\"><b>Gene Name  <small><small>(Manual Annotation)</small></small>:</b></font></td><td><font color=\"#000000\" size=\"2\"><b>$manual_name</b></font></td></tr>";
print "<tr><td><font color=\"#456898\" size=\"2\"><b>Gene Name <small><small>(Inferred)</small></small>:</b></font></td><td><font size=\"2\">$gene_name</font></td></tr>";






print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
print "<tr><td><font color=\"#456898\" size=\"2\"><b>Aniseed Gene id:</b></font></td><td><font size=\"2\">$aniseed_gm</font></td></tr>";
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
//select cipro identifier associated to aniseed gene identifier
$queryCipro = "SELECT \"CIPRO_GENE_ID\" FROM \"CIPRO_LINK\" WHERE \"GENE_CLUSTER_ID\"='$clustid';";
$resultCipro = pg_query($c,$queryCipro);
print("<tr><td><font color=\"#456898\" size=\"2\"><b>Cipro id:</b></font></td>");
$firstCiproLine = true;
while($rowCipro=pg_fetch_array($resultCipro))
{
	$ciproId = $rowCipro["CIPRO_GENE_ID"];
	if($firstCiproLine==true)
	{
		print("<td><a href=\"".$ciproURL.$ciproId."\"><font size=\"2\">CIPRO$ciproId</font></a></td></tr>");
		$firstCiproLine = false;
	}
	else
	{
		print("<tr><td></td><td><a href=\"".$ciproURL.$ciproId."\"><font size=\"2\">CIPRO$ciproId</font></a></td></tr>");
	}
}
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
/*for ($i=0;$i<count($gm);$i++)
	{
	if ($i==0) print "<tr><td><font color=\"#456898\" size=\"2\"><b>Transcript models :</b></font></td><td><font size=\"2\"><a href=\"molecule-gene.php?name=".$gm[$i]."\">".$gm[$i]."</a></font></td></tr>";
	else print "<tr><td><font color=\"#456898\" size=\"2\"><b>&nbsp;</b></font></td><td><font size=\"2\"><a href=\"molecule-gene.php?name=".$gm[$i]."\">".$gm[$i]."</a></font></td></tr>";
	}*/

print "<tr><td><font color=\"#456898\" size=\"2\"><b>Transcript models :</b></font></td><td>";

sort($gm);

for ($i=0;$i<count($gm);$i++)
	{
	if ($i==0) print "<font size=\"2\"><a href=\"molecule-gene.php?name=".$gm[$i]."\">".$gm[$i]."</a></font>";
	else print "<font size=\"2\"> , <a href=\"molecule-gene.php?name=".$gm[$i]."\">".$gm[$i]."</a></font>";

	}
print "</td></tr>";

print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";


///////////Corresponding clones in gene collection 1 or full orf unigene /////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////




$requete="
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";

$stmt=pg_query($c,$requete);

$est=(array) null;
while ($row=pg_fetch_array($stmt))
{

///////////////////////////////////// KYOTO ////
if ($row["NAME"]{0}=="K") //KYOTO
{
$temp=explode(".",$row["NAME"]);
$abstract=$temp[0].".".$temp[1].".".$temp[2];
$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
$st=pg_query($c,$qu);
$ro=pg_fetch_array($st);

$kyotoid=$ro["MOL_ID"];

$requete0="select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$kyotoid'";
$stmt0=pg_query($c,$requete0);
while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;

}

///////////////////////////////////// ENSEMBL ////
if ($row["NAME"]{0}=="E")
	{
	$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$st=pg_query($c,$qu);
	$ro=pg_fetch_array($st);

 	$ensid=$ro["ABSTRACT_ID"];

	$requete0="select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$ensid'";
	$stmt0=pg_query($c,$requete0);
	while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;

	}

////////////////////////////////////// JGI

if ($row["NAME"]{0}=="c")
	{
	$requete0="SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$stmt0=pg_query($c,$requete0);
	while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;
	}



}

//print_r($est);
$tclone=(array) null;
foreach ($est as $key => $val)
{

$requete="SELECT \"CLONE_NAME\",\"PLATE\" from \"CLONE\" where \"CLONE_NAME\"=(
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key'
) AND \"IS_UNIGENE\" IS NULL";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
if (strlen(trim($row["PLATE"]))!=0) $tclone[$row["CLONE_NAME"]]=$row["PLATE"];

$requete2="SELECT \"CLONE_NAME\",\"PLATE\" from \"CLONE\" where \"CLONE_NAME\"=(
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key'
) AND \"IS_UNIGENE\"='y'";
$stmt2=pg_query($c,$requete2);
$row2=pg_fetch_array($stmt2);
if (strlen(trim($row2["PLATE"]))!=0) $tclone2[$row2["CLONE_NAME"]]=$row2["PLATE"];

}


//print_r($tclone);



print "<tr valign=\"top\" align=\"left\"><td><font color=\"#456898\" size=\"2\"><b>Corresponding clone<br>in gene collection 1<br>(N. Satoh) </b></font></td>";

print "<td valign=\"center\">";
foreach ($tclone as $key => $val)
{

print "<table><tr valign=\"top\"><td valign=\"center\"><font size=\"2\"><a href=\"molecule-clone2.php?name=$key\">$key</a> ($val)</td><td valign=\"center\">";

$tmplate=str_replace("R1Ci","",$val);


print "<form name=\"linkformu\" action=\"http://ghost.zool.kyoto-u.ac.jp/cgi-bin3/clusterr1.cgi\" method=\"POST\" target=\"_blank\">

				<input type=\"hidden\" name=\"keytype\" value=\"gcid\">
				<input type=\"hidden\" name=\"inkey\" value=\"$tmplate\">
				<input type=\"submit\" value=\"View Ghost cluster Card\">

				</form> ";


print "</font></td></tr></table>";

}
print "</td>";
print "</tr>";




print "<tr valign=\"top\" align=\"left\"><td><font color=\"#456898\" size=\"2\"><b>Full ORF Gateway-compatible clone<br></b></font></td>";

print "<td valign=\"center\">";
foreach ($tclone2 as $key => $val)
{

print "<table><tr valign=\"top\"><td valign=\"center\"><font size=\"2\"><a href=\"molecule-clone2.php?name=$key\">$key</a> ($val)</td><td valign=\"center\">";

/*$tmplate=str_replace("R1Ci","",$val);


print "<form name=\"linkformu\" action=\"http://ghost.zool.kyoto-u.ac.jp/cgi-bin3/clusterr1.cgi\" method=\"POST\" target=\"_blank\">

				<input type=\"hidden\" name=\"keytype\" value=\"gcid\">
				<input type=\"hidden\" name=\"inkey\" value=\"$tmplate\">
				<input type=\"submit\" value=\"View Ghost cluster Card\">

				</form> ";*/


print "</font></td></tr></table>";

print "<br>";

}
print "</td>";
print "</tr>";











//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////// Reg region /////////////////////////////////////////////////////////////////

print "<tr valign=\"top\" align=\"left\"><td><font color=\"#456898\" size=\"2\"><b>Cis-regulatory regions: </b></font></td><td>";
$requete2="select a.\"NAME\",a.\"PROMOTER_ID\" from \"GENE_REGULATION\" b, \"PROMOTER\" a where a.\"PROMOTER_ID\"=b.\"PROMOTER_ID\" and b.\"GENE_ID\" in (select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid') and a.\"PRIVATE\"='n' and a.\"CHECKED\"='y' and a.\"BASE_REG_ID\"=a.\"PROMOTER_ID\";";
$stmt2 = pg_query($c,$requete2);
if (pg_num_rows($stmt2)==0) print "<font color=\"#656565\" size=\"-1\">No cis regulatory region available</font></td>";	
 while($row2=pg_fetch_array($stmt2)){
print "<a href=\"reg-region-view.php?id=".$row2["PROMOTER_ID"]."\"><font size=\"2\">".$row2["NAME"]."</font></a>";
}
print '</td></tr>';

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
//////// GBROWSE //////////////////////



$scaffold=(array) null;
for ($i=0;$i<count($gm);$i++)
{
	$requete="SELECT \"SCAFFOLD_ID\" from \"GENE\" where \"NAME\"='".$gm[$i]."'";
	$stmt=pg_query($c,$requete);
	$row=pg_fetch_array($stmt);
	//$scaffold[$row["SCAFFOLD_ID"]]++;
	if (strlen($row["SCAFFOLD_ID"])==0) 
	{
		if($gm[$i][0]!='K' && $gm[$i][0]!='H')
	 	{
	 		print "<tr><td>&nbsp;</td><td><font size=\"-2\"><b><u><em>Notice:</em></u> $gm[$i] has not been mapped on the genome</b></font></td></tr>";
		}	
		continue;
	}
	if (strlen($scaffold[$row["SCAFFOLD_ID"]])==0) $scaffold[$row["SCAFFOLD_ID"]]=$gm[$i];
	else $scaffold[$row["SCAFFOLD_ID"]].="@".$gm[$i];
}

$dist=(array) null;
foreach ($scaffold as $key => $val)
{
$tmp=explode("@",$val);
$start=1000000000000000;
$end=0;

	for ($i=0;$i<count($tmp);$i++)
	{
	$requete="SELECT \"BEGIN\",\"END\" from \"GENE\" where \"NAME\"='".$tmp[$i]."'";
	$stmt=pg_query($c,$requete);
	$row=pg_fetch_array($stmt);

	if ($row["BEGIN"]<$start) $start=$row["BEGIN"];
	if ($row["END"]>$end) $end=$row["END"];

	}

$Nstart=$start-1000; if ($Nstart<0) $Nstart=0;
$Nend=$end+1000;

$dist[$key]=$start."@".$end."@".$Nstart."@".$Nend;

}



asort($dist);

$I=0;
foreach ($dist as $key => $val)
{
$scaffold=$key;
$tmp=explode("@",$val);
$start=$tmp[0];
$end=$tmp[1];
$Nstart=$tmp[2];
$Nend=$tmp[3];

	if ($I==0)
	{
		if (strlen($manual[0])==0) print "<tr><td><font color=\"#456898\" size=\"2\"><b>Genome Browser</b></font></td><td><a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=$scaffold:$Nstart..$Nend;auto=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start-$end\"><img border=\"0\" src=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=$scaffold:$Nstart..$Nend;a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+kyotoGrail+KHgenespublished+Conservation_profile;\"></a></td></tr>";
		else
		print "<tr><td><font color=\"#456898\" size=\"2\"><b>Genome Browser</b></font></td><td><a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=$scaffold:$Nstart..$Nend;auto=$scaffold+$aniseed_gm+".(str_replace(" ","_",$manual[0]))."+$start-$end\"><img border=\"0\" src=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=$scaffold:$Nstart..$Nend;a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$manual[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+KHgenespublished+kyotoGrail+Conservation_profile;\"></a></td></tr>";
	}

	else
	{
		if (strlen($manual[0])==0)
		print "<tr><td>&nbsp;</td><td><a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=$scaffold:$Nstart..$Nend;auto=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start-$end\"><img border=\"0\" src=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=$scaffold:$Nstart..$Nend;a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+kyotoGrail+KHgenespublished+Conservation_profile;\"></a></td></tr>";
		else
		print "<tr><td>&nbsp;</td><td><a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=$scaffold:$Nstart..$Nend;auto=$scaffold+$aniseed_gm+".(str_replace(" ","_",$manual[0]))."+$start-$end\"><img border=\"0\" src=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=$scaffold:$Nstart..$Nend;a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$manual[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+kyotoGrail+KHgenespublished+Conservation_profile;\"></a></td></tr>";
	}

$I++;
}


/*
$start=1000000000000000;
$end=0;

//$scaffold=(array) null;
for ($i=0;$i<count($gm);$i++)
{
$requete="SELECT \"BEGIN\",\"END\",\"SCAFFOLD_ID\" from \"GENE\" where \"NAME\"='".$gm[$i]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);

if ($row["BEGIN"]<$start) $start=$row["BEGIN"];
if ($row["END"]>$end) $end=$row["END"];

//$scaffold[$row["SCAFFOLD_ID"]]++;
$scaffold=$row["SCAFFOLD_ID"];

}



$Nstart=$start-1000;
$Nend=$end+1000;



print "<tr><td><font color=\"#456898\" size=\"2\"><b>Genome Browser</b></font></td><td><img src=\"
http://crfb.univ-mrs.fr/ciona-bin/gbrowse_img/intestinalis?name=$scaffold:$Nstart..$Nend;a=$scaffold+$aniseed_gm+".(str_replace(" ","_",$name[0]))."+$start..$end;type=JGI_transcripts+EnsemblJGI2+kyotoGrail+KHgenes+Conservation_profile;\"</td></tr>";
*/
/////////////////////////////////////////




print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";

/*
print "<tr><td><font color=\"#456898\" size=\"2\"><b>Gene expression Summary</b></font></td><td align=\"left\">";



//////////////////////////// GENE EXPRESSION CARD //////////////////////////////////////////////////////
?>

<?


$requete1="
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";
$stmt1=pg_query($c,$requete1);
while ($row1=pg_fetch_array($stmt1))

{
$gene=$row1["NAME"];

//if ($gene{0}=="E") $geneENS=$gene;
if ($gene{0}=="E") $tgeneENS[count($tgeneENS)]=$gene;
//if ($gene{0}=="K") $geneKYO=$gene;
if ($gene{0}=="K") $tgeneKYO[count($tgeneKYO)]=$gene;
//if ($gene{0}=="c") $geneJGI=$gene;
if ($gene{0}=="c") $tgeneJGI[count($tgeneJGI)]=$gene;

}

$anat=(array) null;
$kabstract=(array) null;
for ($i=0;$i<count($tgeneKYO);$i++)
{

// $tkyo=explode(".",$geneKYO);

$tkyo=explode(".",$tgeneKYO[$i]);

// $kabstract=$tkyo[0].".".$tkyo[1].".".$tkyo[2];

$kabstract[$i]=$tkyo[0].".".$tkyo[1].".".$tkyo[2];

}

//if (strlen($geneJGI)>0)
if (count($tgeneJGI)>0)
{
for ($i=0;$i<count($tgeneJGI);$i++)
{
if ($i==0) $rJGI="(select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\")";
else $rJGI.=" UNION (select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneJGI[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\")";
}
}

//if (strlen($geneKYO)>0) 
if (count($tgeneKYO)>0)
{
for ($i=0;$i<count($tgeneKYO);$i++)
{
if ($i==0) $rKYO="(
select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract[$i]' and \"TYPE\"='abstract')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract[$i]' and \"TYPE\"='abstract')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneKYO[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
)";
else $rKYO.=" UNION (
select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract[$i]' and \"TYPE\"='abstract')
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"=(select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$kabstract[$i]' and \"TYPE\"='abstract')
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneKYO[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"
)";
}
}

//if (strlen($geneENS)>0)
if (count($tgeneENS)>0)
{
for ($i=0;$i<count($tgeneENS);$i++)
{
if ($i==0) $rENS="(
select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$tgeneENS[$i]'))
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$tgeneENS[$i]'))
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneENS[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"

)";
else
$rENS.=" UNION (
select anat.\"ANAT_ID\",dev.\"NAME\" from \"ANAT_ENTITY\" anat, \"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"TARGET_ID\" in (
select \"MOL_ID\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"CLONE_ID\" from \"CLONE\" where \"CLONE_NAME\" in (
select \"CLONE_NAME\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$tgeneENS[$i]'))
)
UNION
select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"=(select \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='$tgeneENS[$i]'))
UNION
SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$tgeneENS[$i]'
)
) and \"REGION_ID\" is not null and \"IN_SITU_ID\" in (
select \"IN_SITU_ID\" from \"IN_SITU\" where \"WILD_TYPE\"='y' and \"CHECKED\"='y' and \"PRIVATE\"='n'
)
) and anat.\"SPECIES\"='Ciona intestinalis' and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"

)";

}

}

$requete="";

if (strlen($requete)==0)
	if (strlen($rJGI)>0) $requete=$rJGI;

if (strlen($requete)!=0)
	{
	if (strlen($rKYO)>0) $requete.=" UNION $rKYO";
	}
else $requete="$rKYO";

if (strlen($requete)!=0)
	{
	if (strlen($rENS)>0) $requete.=" UNION $rENS";
	}
else $requete="$rENS";







//  print $requete;


$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
//print $row["NAME"]." ".$row["DEV_STAGE_ID"]."<br>";
//$anat[$row["ANAT_ID"]."@".$row["DEV_STAGE_ID"]]++;


////OBLIGATION DE FAIRE UNE DETECTION DES NOEXPRESSION
$r="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\"='".$row["ANAT_ID"]."'";
$s=pg_query($c,$r);
$ro=pg_fetch_array($s);

if ($ro["NAME"]=="No expression") $anat[$row["NAME"]].="NOEXP@";
else if ($ro["NAME"]=="Whole embryo") $anat[$row["NAME"]].="WHOLE@";
else $anat[$row["NAME"]].=$row["ANAT_ID"]."@";

}


 //print_r($anat);


$anat2=(array) null;

foreach ($anat as $key => $val)
{

$tmp=explode("@",$val);
//print $tmp[0]."!";
if ($tmp[0]=="NOEXP")
	{
	$anat2[$key]="NOEXP";
	}
else 
if ($tmp[0]=="WHOLE")
	{
	$anat2[$key]="WHOLE";
	}
else
	{
for ($i=0;$i<count($tmp)-1;$i++)
	{
	if (trim($tmp[$i])=="WHOLE") break;
	if (trim($tmp[$i])=="NOEXP") break;	 //////////AJOUT //////////////

	$requete="SELECT fate.\"KEYWORDS\",anat.\"NAME\" from \"FATE\" fate,\"ANAT_ENTITY\" anat where fate.\"ANAT_ID\"='".trim($tmp[$i])."' and anat.\"ANAT_ID\"=fate.\"ANAT_ID\"";
	$stmt=pg_query($c,$requete);
	while ($row=pg_fetch_array($stmt))
	{
	//
	//if ($row["NAME"]=="Whole embryo") {$anat2[$key]="WHOLE";break;}
	
	if (strlen($row["KEYWORDS"])==0) continue;

	$anat2[$key].=$row["KEYWORDS"]."@";
	}

	}
	}

}
// print "<hr>";

 //print_r($anat2);

// print "<hr>";
///////////
//LE TABLEAU ANAT2 contient les correspondance DEVSTAGE<=>FATE pour le gene $gene
///////////
$anat=$anat2;

if (count($anat)!=0)
{



$requete="SELECT \"NAME\" from \"DEV_STAGE\" where \"SPECIES\"='Ciona intestinalis' order by \"DEV_PERCENT\"";
$stmt=pg_query($c,$requete);



print "<center><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
print "<tr>
<td>&nbsp;</td>
<td id=\"header0\" align=\"center\" valign=\"top\"><img src=\"es.gif\"></td>

<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"he.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"me.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"mu.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"noto.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"tlc.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"tvc.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"cen.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"ne.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"ns.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"np.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"palps.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"sv.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"tnc.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"ten.gif\"></td>
<td id=\"header0\"  align=\"center\" valign=\"top\"><img src=\"vg.gif\"></td>
<td id=\"headerlast\"  align=\"center\" valign=\"top\"><img src=\"ep.gif\"></td>




</tr>";

while ($row=pg_fetch_array($stmt))
{

$stade=$row["NAME"];
$tabfate=$anat[$row["NAME"]];
print "<tr>";

// print $row["NAME"]." => ".$anat[$row["NAME"]]."<br>";

$tmp=explode("@",$tabfate);

/////ENCHAINEMENT DES FATE POUR L'AFFICHAGE
if (trim($tmp[0])=="WHOLE") print "
<td id=\"casefirst\">$stade</td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"case\"><img src='yes2.gif'></td>
<td id=\"caselast\"><img src='yes2.gif'></td>";
else if (trim($tmp[0])=="NOEXP") print "
<td id=\"casefirst\">$stade</td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"case\"><img src='no2.gif'></td>
<td id=\"caselast\"><img src='no2.gif'></td>";
else if (count($tmp)-1==0) print "
<td id=\"casefirst\">$stade</td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"case\"><img src='gray2.gif'></td>
<td id=\"caselast\"><img src='gray2.gif'></td>";
else 
	{
	//print $stade."\t";print_r($tmp);print "<br>";
	print "<td id=\"casefirst\">".$stade."</td>";
	if (in_array("endodermal strand",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("head endoderm",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("mesenchyme",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("muscle",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("notochord",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("TLC",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("TVC",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("CEN",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("neck",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("nervous system",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("neurohypophysis primordium",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("palps",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("sensory vesicle",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("tail nerve cord",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("TEN",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("visceral ganglion",$tmp)) print "<td id=\"case\"><img src='yes2.gif'></td>"; else print "<td id=\"case\"><img src='no2.gif'></td>";
	if (in_array("epidermis",$tmp)) print "<td id=\"caselast\"><img src='yes2.gif'></td>"; else print "<td id=\"caselast\"><img src='no2.gif'></td>";

	}

print "</tr>";
}


print "</table>
<br>
<font size=\"-2\"><b>
<img src=\"no2.gif\"> No expression in this territory &nbsp;&nbsp;<img src=\"yes2.gif\"> Expression in this territory &nbsp;&nbsp; <img src=\"gray2.gif\"> No data<br>
</b></font>
</center>";
}

else
{
   print "<br></center><center><font color=\"#D64242\" size=\"3\"><b>No Data</b></font></center><br>";

}
////////////////////////////////////////////////////// END OF GENE EXPRESSION CARD ////////////////////////////////

print "</td></tr>";
*/

print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";

print "</table>";

print "<br><br>";




/////////////////////////// ORTHOLOGOUS ////////////////////////////////////////////////////////////

print "<font size=\"2\" color=\"#456898\"><b><u>Orhtolog prediction</u></b></font>&nbsp;&nbsp;";
?>
<!-- <input border="0" type="image" src="plus-box.gif" onclick="window.document.getElementById('ortho').style.display='block';"> &nbsp;&nbsp; -->
<!-- <input border="0" type="image" src="min-box.gif" onclick="window.document.getElementById('ortho').style.display='none';">  -->
<?


// print "<br><br><div id=\"ortho\" name=\"ortho\" style=\"display:none;background-color:#FFFFFF;padding:3px;border:1px solid black;\">";
print "<br><br><div id=\"ortho\" name=\"ortho\">";
for ($i=0;$i<count($gm);$i++)
{
$requete="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='".$gm[$i]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);

$id=$row["MOL_ID"];


/////////////////////////////////////////////////ORTHOLOG/////////////////////////////////////////////////
	print "<br><u><font color=\"#456898\" size=\"-1\"><b>Ortholog prediction (In paranoid applied to
mouse, human and drosophila) for ".$gm[$i]."</b></font></u><br><br>";	
	   
	 $requete="select * from \"PHYLOGENY\" where \"MOL_ID\"=$id and \"ORTHOLOG\" is not NULL order by \"SPECIES\", \"ORTHOLOG\", \"SCORE2\" desc";
    	$stmt = pg_query($c,$requete);

if (pg_num_rows($stmt)>0)
	{
	

        print "<center><table width=\"99%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
	    print "<tr align=\"center\" valign=\"middle\"><td><font color=\"#456898\" size=\"2\"><b>Ortholog name*</font></td><td><font color=\"#456898\" size=\"2\"><b>ID</b></font></td><td><font color=\"#456898\" size=\"2\"><b>Score</b></font></td><td width=\"30%\"><font color=\"#456898\" size=\"2\"><b>Protein familly*</b></font></td><td><font color=\"#456898\" size=\"2\"><b>Species</b></font></td></tr>";
	}

	$count=0;
    	while($row=pg_fetch_array($stmt)){
		    ++$count;

	if ($count%2==0) $colorOR="padding:3px;background-color:#DDDDDD;color:black;border-top:1px solid black;"; else $colorOR="padding:3px;background-color:#AAAAAA;color:black;border-top:1px solid black;";



			if($row["DB"]=="ensembl"){
			    if($row["SPECIES"]=='Drosophila melanogaster')
		            print "<tr align=\"center\" valign=\"middle\"><td style=\"$colorOR\"><a target=\"blank\" href=\"http://www.ensembl.org/Drosophila_melanogaster/protview?peptide=".$row["ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></a></td><td style=\"$colorOR\"><font size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SPECIES"]."</font></td></tr>";
			    else if($row["SPECIES"]=='Homo sapiens')
				    print "<tr align=\"center\" valign=\"middle\"><td style=\"$colorOR\"><a target=\"blank\" href=\"http://www.ensembl.org/Homo_sapiens/protview?peptide=".$row["ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></a></td><td style=\"$colorOR\"><font size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SPECIES"]."</font></td></tr>";
			    else if($row["SPECIES"]=='Mus musculus')
				    print "<tr align=\"center\" valign=\"middle\"><td style=\"$colorOR\"><a target=\"blank\" href=\"http://www.ensembl.org/Mus_musculus/protview?peptide=".$row["ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></a></td><td style=\"$colorOR\"><font size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SPECIES"]."</font></td></tr>";
			    else if($row["SPECIES"]=='Danio rerio')
				    print "<tr align=\"center\" valign=\"middle\"><td style=\"$colorOR\"><a target=\"blank\" href=\"http://www.ensembl.org/Danio_rerio/protview?peptide=".$row["ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></a></td><td style=\"$colorOR\"><font size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SPECIES"]."</font></td></tr>";			    
			    else
				    print "<tr align=\"center\" valign=\"middle\"><td style=\"$colorOR\"><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["SPECIES"]."</font></td></tr>";
			    //print '<tr valign="top"><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td></tr>';
			}else
			    print "<tr valign=\"top\" align=\"center\"><td><font color=\"#000000\" size=\"-1\">".$row["ORTHOLOG"]."</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["ID"]."</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["SCORE2"]."%</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["FAMILLY"]."</font></td><td style=\"$colorOR\"><font  size=\"-1\">".$row["SPECIES"]."</font></td></tr>";
		}
		if($count==0){
 		    print "</center><center><font color=\"#D64242\" size=\"3\"><b>No match</b></font></center>";
		}else{
		    print "</table></center>";
			print "*annotations from <a target=\"blank\" href=\"http://www.ensembl.org/\">Ensembl</a>";
		}
	


print "<br>";//<br><br><br>";

////////////////////////////////////////////////////////////////
}

print "</div>";




////////////////////////////////////////////////////////////////////////////////////////////////////





////////////////////////////////////////////////////////// Interpro /////////////////////////////////////////////////////////////////
print "<br><br><u><font color=\"#456898\" size=\"2\"><b>Interpro (inherited from transcript)</b></u></font><br><br>";

print "<center><table width=\"99%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";

print '<tr align="center" valign="middle"><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>IP ID</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Name</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Type</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Database</b></font></td></tr>';

$count=0;
foreach ($interpro as $key => $val)
{
++$count;

$requete="SELECT ipdesc.\"DB_ID\",ip.\"NAME\",ip.\"TYPE\" from \"IP_DESCRIPTION\" ipdesc, \"INTERPRO\" ip where ipdesc.\"IP_ID\"='$key' and ip.\"IP_ID\"='$key'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);

if ($count%2==0) $colorIP="padding:3px;background-color:#DDDDDD;color:black;border-top:1px solid black;"; else $colorIP="padding:3px;background-color:#AAAAAA;color:black;border-top:1px solid black;";

print "<tr align=\"center\"><td style=\"$colorIP\"><font size=\"-1\">$key</font></td><td style=\"$colorIP\"><font size=\"-1\">".$row["NAME"]."</font></td><td style=\"$colorIP\"><font size=\"-1\">".$row["TYPE"]."</font></td><td style=\"$colorIP\"><font size=\"-1\">".$row["DB_ID"]."</font></td></tr>";
/*
print '<tr valign="top"><td style="border-top:1px solid black;">&nbsp;</td><td style="border-top:1px solid black;">&nbsp;</td><td style="border-top:1px solid black;">&nbsp;</td><td style="border-top:1px solid black;">&nbsp;</td></tr>';
*/
}
print "</TABLE></center>";

if($count==0) print "<font color=\"#D64242\" size=\"3\"><b>No match</b></font></center>";


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////// GO ///////////////////////////////////////////////////////////////////////


print "<br><br><u><font color=\"#456898\" size=\"2\"><b>Gene Ontology (inherited from transcript)</b></u></font><br><br>";

print "<center><table width=\"99%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";

print '<tr align="center" valign="middle"><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>GO ID</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Origin</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Type</b></font></td><td style="border-top:1px solid black;"><font color="#456898" size="2"><b>Term</b></font></td></tr>';

$count=0;
foreach ($go as $key => $val)
{
++$count;

$requete="SELECT godesc.\"SPECIES_ORIGIN\",go.\"GO_TYPE\",go.\"GO_TERM\",go.\"DEFINITION\" from \"GO_DESCRIPTION\" godesc, \"GO\" go where godesc.\"GO_ID\"='$key' and go.\"GO_ID\"='$key'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);


if ($count%2==0) $colorGO="padding:3px;background-color:#DDDDDD;color:black;border-top:1px solid black;"; else $colorGO="padding:3px;background-color:#AAAAAA;color:black;border-top:1px solid black;";



print "<tr align=\"center\">
<td style=\"$colorGO\"><font size=\"-1\">$key</font></td>
<td style=\"$colorGO\"><font size=\"-1\">&nbsp;".$row["SPECIES_ORIGIN"]."</font></td>
<td style=\"$colorGO\"><font size=\"-1\">&nbsp;".$row["GO_TYPE"]."</font></td>
<td style=\"$colorGO\"><a target=\"_blank\" href=\"GO-definition.php?id=".$key."\" onClick=\"return self.popup(this, 'Definition')\"><font color=\"#000000\" size=\"-1\">".$row["GO_TERM"]."</font></a></td></tr>";


}
print "</TABLE></center>";

if($count==0) print "<font color=\"#D64242\" size=\"3\"><b>No match</b></font></center>";

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////







?>


<script type="text/javascript" src="wz_tooltip.js"></script>


<?

include ("frames_footer.php");
?>