<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("connection.php");
//Title before frames_header
?>

<?
    include("frames_header.php");


if (empty($_GET["display"])) $_GET["display"]="no";


?>

  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />


<center>


<?php

    $clustid=$_GET["clusterid"];
    $aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);

print '<title>ANISEED - Gene EST expression for: '.$aniseed_gm.'</title>';


//// agregation des modeles de genes
$agreg_gm="";
$requete="SELECT \"NAME\" from \"GENE\" where \"GENE_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if (strlen($agreg_gm)==0) $agreg_gm=$row["NAME"];
else $agreg_gm.=":".$row["NAME"];

}

?>
<!-- Header pour l'onglet -->
<div id="header">
  <ul>
    <li><a href="gene-card.php?clusterid=<?print $clustid;?>">Gene Card</a></li>
    <li><a href="ESTcluster-gene.php?clusterid=<?print $clustid;?>">ESTs cluster</a></li>
    <li id="current" ><a href="#">EST count</a></li>
    <li><a href="insitu-result.php?target=<?print $agreg_gm;?>&BOOLmut=3&BOOLmanip=2&MOLtype=2&Order=DEV_STAGE_ID">InSitu data</a></li>
    <li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
    <li><a href="#" style="color:white;">Microarray probe</a></li>
    <li><a href="#" style="color:white;">Export</a></li>
    <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
  </ul>
</div>
<!-- EOF Onglet -->
<br><br>
<?


$requete="select distinct \"SPECIES\" from \"MOL_ENTITY\" where \"MOL_ID\" in (SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$species=$row["SPECIES"];


//////// ON CHERCHE ET ON TROUVE LES ANISEED CLUSTER ID POUR CHAQUE GENE MODEL
$requete="
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";

$stmt=pg_query($c,$requete);

$est=(array) null;
while ($row=pg_fetch_array($stmt))
{

///////////////////////////////////// KYOTO ////
if ($row["NAME"]{0}=="K") //KYOTO
{
$temp=explode(".",$row["NAME"]);
$abstract=$temp[0].".".$temp[1].".".$temp[2];
$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
$st=pg_query($c,$qu);
$ro=pg_fetch_array($st);

$kyotoid=$ro["MOL_ID"];
}


///////////////////////////////////// ENSEMBL ////////
if ($row["NAME"]{0}=="E")
	{
	$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$st=pg_query($c,$qu);
	$ro=pg_fetch_array($st);

 	$ensid=$ro["ABSTRACT_ID"];
	}

////////////////////////////////////// JGI ////////////

if ($row["NAME"]{0}=="c")
	{
	$requete0="select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."'";
	$stmt0=pg_query($c,$requete0);
	$ro=pg_fetch_array($stmt0);
	$jgiid=$ro["GENE_ID"];
	}



}
//////////////////////////////////////////////////////

//print $jgiid." ".$kyotoid." ".$ensid; return ;

    print "<br><br><font color=\"#D64242\" size=\"3\"><b>EST Count: $aniseed_gm gene</b></font><br><br>";

    	if ($_GET["display"]=="all") print '<table width="99%" border="1" cellspacing="0" cellpadding="0">';
	if ($_GET["display"]=="all") print '<tr align="center" valign="middle"><td><font color="#456898" size="2"><b>Library type</b></strong></td><td><font color="#456898" size="2"><b>Tissue</b></font></td><td width="25%"><font color="#456898" size="2"><b>Library</b></font></td><td><font color="#456898" size="2"><b>Expression</b></font></td>  </tr>';
	$requete="select * from \"LIBRARY\" where \"SPECIES\"='$species' order by \"ORDRE\" ASC";
    $stmt = pg_query($c,$requete);
	
	$count=0;
	$data = array();
	while($row=pg_fetch_array($stmt)){
	

	    if(! isset($data[ $row["COMMENTS"] ][1])){//avoid notice messages
		    $data[ $row["COMMENTS"] ][0]="";
			$data[ $row["COMMENTS"] ][1]="";
		}
		
		$data[ $row["COMMENTS"] ][1] += $row["LIB_SIZE"];//calcule le cumul des tailles des lib de meme type
		
		$type[$count]=$row["COMMENTS"];
		++$count;
        

		//$requete2="select count(distinct B.\"CLONE_ID\") AS res from \"CLONE_SEQ\" A, \"CLONE\" B where (A.\"ANISEED_CLUSTER_ID\"='$cluster' or A.\"ANISEED_KYOTO_CLUSTER_ID\"='$cluster' or A.\"ANISEED_ENSEMBL_CLUSTER_ID\"='$cluster') and (A.\"CLONE_NAME\"=B.\"CLONE_NAME\") and B.\"LIBRARY_ID\"=".$row["LIBRARY_ID"];

		$requete2="
	select count(distinct \"CLONE_ID\") as res from \"CLONE\" where \"CLONE_ID\" in 
	(
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_CLUSTER_ID\"='$jgiid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	UNION
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_KYOTO_CLUSTER_ID\"='$kyotoid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	UNION
	(select B.\"CLONE_ID\" from \"CLONE_SEQ\" A, \"CLONE\" B where A.\"ANISEED_ENSEMBL_CLUSTER_ID\"='$ensid' and A.\"CLONE_NAME\"=B.\"CLONE_NAME\" and B.\"LIBRARY_ID\"='".$row["LIBRARY_ID"]."')
	)
	";
//print $requete2;


		$stmt2 = pg_query($c,$requete2);
	    if($row2=pg_fetch_array($stmt2)){
	        $value=$row2["res"];
		    if($value > 0){
			    //////////////////////4000 au lieu de 1000 pour y voir qq chose
			
		        if ($_GET["display"]=="all") print "<tr align=\"center\"><td><font color=\"#656565\" size=\"-1\">".$row["COMMENTS"]."&nbsp;</font></td><td><font color=\"#656565\" size=\"-1\">".$row["TISSUE"]."&nbsp;</font></td><td><font color=\"#656565\" size=\"-1\">".$row["TITLE"]."&nbsp;</font></td><td valign=\"middle\"><center><img src=\"picture-est.php?value=".round( 4000*($value/$row["LIB_SIZE"]), 4)."\"><br><font color=\"#656565\" size=\"-1\">$value clones/".$row["LIB_SIZE"]."</font></center>&nbsp;</td></tr>";

				
			$data[ $row["COMMENTS"] ][0] += $value;//calcul le cumul des clones trouves dans des lib de meme type
				


			}
		}
	}
	if ($_GET["display"]=="all") print '</table>';

//DEBUT	
	if($count==0){
	    print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
	}else{
	///////////////////////////////////////tableau fusionne de l'expression//////////////////////////
	    print "<br><br><br><strong>Resume:</strong><br><br>";
		print '<table width="80%" border="1" cellspacing="0" bordercolor="#333333">';
		
		$ll=0;
		$final=array();
		for($f=0; $f<count($type); ++$f){
		    if(! in_array($type[$f], $final) ){
			    $final[$ll++]=$type[$f];
	    	}
		}
	    for($a=0;$a<count($final);++$a){
		    if($data[$final[$a]][1]>0)
		        print '<tr valign="middle"><td><font color="#656565" size="-1">'.$final[$a].":  </font></td><td><center><img src=\"picture-est.php?value=".round( 4000*($data[$final[$a]][0]/$data[$final[$a]][1]), 4)."\"></center></td><td><font color=\"#656565\" size=\"-1\">".(0+$data[$final[$a]][0])." clones/".$data[$final[$a]][1]."</font></td></tr>";
			else
			    print '<tr valign="middle"><td><font color="#656565" size="-1">'.$final[$a].":  </font></td><td><center><img src=\"picture-est.php?value=0\"></center></td><td>&nbsp;</td></tr>";
		}
		
	    print '</table>';
	}
//FIN	
print "<br><br>";
if ($_GET["display"]=="no")
{
?>

<form name="formu" action="est-expression-gene.php" method="GET">
<input type="hidden" name="clusterid" value="<? print $clustid;?>">
<input type="hidden" name="display" value="all">
<input type="submit" value="More details">
</form>

<?
}
else
{
?>

<form name="formu" action="est-expression-gene.php" method="GET">
<input type="hidden" name="clusterid" value="<? print $clustid;?>">
<input type="hidden" name="display" value="no">
<input type="submit" value="Back to expression page">
</form>

<?
}
?>
















</center>


<?php
    include("frames_footer.php");
?> 
