<html>
<head>
<title>ANISEED - Find neighbours of a cell (Ciona intestinalis)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page allows to search 3D Virtual Embryo data (Ciona intestinalis embryo) to identify the neighbouring territory of a cell.">
<meta name="keywords" content="Lemaire, Tassy, Daian, Dauga, Sobral, Khoueiry, Aniseed, Ciona intestinalis, neighbouring cell, 3D embryo, Ciona embryo, developmental stage, surface of contact.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("connection.php");
    include("frames_header.php");
?>

<script>
var selected_part=new Array();

function popup_anatomy_selector() {
  dev = "";
  names = "";
  for(a=0; a<window.document.formulaire.elements['devstage[]'].options.length; ++a){
  	if(window.document.formulaire.elements['devstage[]'].options[a].selected==true){
	  	dev  += window.document.formulaire.elements['devstage[]'].options[a].value+':'; // tab[a-1]+':';
		names+= window.document.formulaire.elements['devstage[]'].options[a].text+':';
	}
  }
  if(dev.length<=1){
  	alert("Select an Ascidian species and specific developmental stages first");
	return;
  }
  
  species=window.document.formulaire.species.options[window.document.formulaire.species.selectedIndex].text;

  if ((window.document.anat_keywords == null) || (window.document.anat_keywords.closed == true)) {
    window.document.anat_keywords = window.open("anatomyTreeLine.php?namedev="+names+"&iddev="+dev+"&species="+species,"anat_keywords","menubar=yes,toolbar=no,scrollbars=yes,resizable=yes,height=500,width=600");
  } else {
    window.document.anat_keywords.focus();
  }
}


function update(){
	window.document.formulaire.elements['region[]'].options.length = selected_part.length;
	//ids="";
	for(a=0; a<selected_part.length; ++a){
		window.document.formulaire.elements['region[]'].options[a].text  = selected_part[a][0];//+" ("+selected_part[a][1]+")";
		window.document.formulaire.elements['region[]'].options[a].value = selected_part[a][1];
		//ids+=selected_part[a][1]+":";
	}
	//window.document.formulaire.idanat.value=ids;
}

function addtoarray(name,value){
	selected_part[selected_part.length]=[name,value];
	update();
}

function retrenchtoarray(num){
	selected_part.splice(num,1);
	update();
}

function remove_structures(){
	
	for(a=0; a<selected_part.length; ++a){
		if(window.document.formulaire.elements['region[]'].options[a].selected == true){
			selected_part.splice(a,1);
			window.document.formulaire.elements['region[]'].options[a]=null;
			a-=1;
		}
	}
	update();
	//reloadit();
}

function reset_structures(){
	window.document.formulaire.elements['region[]'].options.length=0;
	selected_part=new Array();
	//window.document.formulaire.idanat.value='';
	//reloadit();
	update();
}


function selectanatomy(){
  for(a=0; a<window.document.formulaire.elements['region[]'].options.length; ++a){
 		window.document.formulaire.elements['region[]'].options[a].selected=true;
  }
}
</script>

<div style="border-top:0px solid black;border-bottom:1px solid black;">
<font color="#D64242" size="3"><b>Find neighbours of a cell </b></font></br>
</div>
<br>
This page allows to search 3D Virtual Embryo data to identify the
neighbouring territory of a cell, currentlyup to the 44 cell stage
of Ciona intestinalis. Select your developmental stage and anatomical
entities using the "add" button. You can change the default maximum
distance to neighbouring territory (5&micro;m). Upon submission, a new page
appears listing the neighbouring structures and the surface of
contact with the territory of interest.
<br>
<br>
<center>
<font size="2">The dataset this tool work with is still incomplete and involves a restricted set of developmental stages.</font>
<form name="formulaire" action="embryo-neighbour-result.php" method="post" target="_blank">
<?php
            $celllist="";
			if(isset($_POST["celllist"]))
            	$celllist=$_POST["celllist"];
            if(strlen($celllist)>0)
			      print "<center><H2><font color=\"#FF6600\">Refine subset mode</font> <a href=\"lineage-search.php\" target=\"_self\"><img src=\"pictures/button-reset.jpg\" border=\"0\" align=\"middle\"></a> </H2></center>";
            
			print '<input name="celllist" type="hidden" value="'.$celllist.'">';
//////////////////////////////////////////////////////////////////////////////////////////////////////////

?>

            
	        <table width="99%" border="0" cellspacing="0" cellpadding="0">
              <tr> 
                <td>&nbsp;</td>
                <td>&nbsp;</td>
				<td>&nbsp;</td>
              </tr>
			  
              <tr> 
                
				<td align="center" valign="top">
				    <font color="#456898" size="2"><b>Species</b></font>
				    <!--
					<select name="species" size="1" onChange="javascript: self.location.href = 'fate-search.php?species=' + this.options[ this.selectedIndex ].value;">
					<select name="species" size="1" onChange="javascript: self.formulaire.action='lineage-search.php'; self.formulaire.target='_self'; submit();">
					-->
					<br>
					<!--<select name="species" size="1" onChange="javascript: document.forms[0].action='neighbour-search.php'; document.forms[0].target='_self'; submit();">-->

<select name="species" size="1" onChange="javascript: document.formulaire.action='embryo-neighbour-search.php?species='+this.options[this.selectedIndex].value; document.formulaire.target='_self'; submit();">
						<option></option>
						<?php
							$species="";
							if (isset($_POST["species"])) $species=$_POST["species"];

							$requete="Select \"NAME\" from \"SPECIES\" order by \"NAME\"";
							$stmt = pg_query($c,$requete);
							while( $row=pg_fetch_array($stmt) ){
								$name=$row["NAME"];
								print "<option";
								if($species==$name)
								    print " selected";
								print ">$name</option>";
							}
						?>
				    </select>&nbsp;
				</td>
                <td align="center" valign="top">
		            <font color="#456898" size="2"><b>Developmental stage</b></font><br>
                    <select name="devstage[]" onChange="javascript: document.formulaire.action='embryo-neighbour-search.php?species='+document.formulaire.species.options[document.formulaire.species.selectedIndex].value+'&devstage='+this.options[this.selectedIndex].value; document.formulaire.target='_self'; submit();" size="10" style="width:200">
                    
                    <?php
						
						$devid="";
						if (isset($_GET["devstage"])) $devid=$_GET["devstage"];
						

						if(strlen($species)>0){
							 $query="SELECT \"NAME\", \"DEV_STAGE_ID\" FROM \"DEV_STAGE\" WHERE \"SPECIES\"='$species' ORDER BY \"DEV_PERCENT\"";
							 $stmt = pg_query($c,$query);
	
							 while($row=pg_fetch_array($stmt) ){
						
								print "<option value=\"".$row["DEV_STAGE_ID"]."\"";
								if ($row["DEV_STAGE_ID"]==$devid) print " selected";
								print ">";
								print $row["NAME"]."</option>\n";
								
							 }
						}
					 ?>
                  </select>
				</td>

			<td align="center">
		            <center><font color="#456898" size="2"><b>Embryo</b></font></center>
                    <select name="embryo[]" size="10" multiple style="width:400px;" >
		    <?
			
						$embryo="";
						if (strlen($devid)>0)
							{
							$requete="SELECT \"NAME\",\"EMBRYO_ID\" from \"EMBRYO\" where \"DEV_STAGE_ID\"='$devid' order by \"NAME\"";
							$stmt=pg_query($c,$requete);
							while ($row=pg_fetch_array($stmt))
							{
								print "<option style=\"text-align:center;\" value=\"".$row["EMBRYO_ID"]."\">";

								$embryo_name=$row["NAME"];

								$embryo_name=str_replace("@"," ",$embryo_name);
								print $embryo_name."</option>\n";
							}



							}




		    ?>
		    </select>
				</td>

				<td align="center" valign="top">
				    
				    <table width="100%" border="0" cellspacing="0" cellpadding="0">
					  <tr>
						<td align="center">
						    <font color="#456898" size="2"><b>Anatomical part</b></font><br>
						    <select name="region[]" size="10" multiple style="width:200">
						        
                            </select>
							<br>
							<img src="pictures/button-add.jpg" onClick="self.popup_anatomy_selector();" border="0">
							<img src="pictures/button-remove.jpg" onClick="self.remove_structures();" border="0">
							<img src="pictures/button-reset.jpg" onClick="self.reset_structures();" border="0">

					    </td>
						<td>
						<!--
							<br>
						    <input name="and" type="radio" value="y">and
							&nbsp;&nbsp;
							<input name="and" type="radio" value="n" checked>or
						-->
						</td>
					  </tr>
					</table>

				</td>
              </tr>
			  
              <tr> 
                <td><hr size="1" color="#505F70"></td>
                <td><hr size="1" color="#505F70"></td>
				<td><hr size="1" color="#505F70"></td>
              </tr>
			  
			  
              <tr> 
                <td>&nbsp;</td>
                <td>
				    <font color="#656565" size="2">Distance</font><select name="supinf2" size="1"><option value="0">></option><option value="1" selected><</option></select>&nbsp;<input name="dist" type="text" value="5" size="10"><font color="#656565" size="2">&micro;</font>
				</td>
				<td>
				    <font color="#656565" size="2">Surface of contact</font><select name="supinf" size="1"><option value="0">></option><option value="1"><</option></select>&nbsp;<input name="surf" type="text" value="0" size="10"><font color="#656565" size="2">&micro;&sup2;</font>
				</td>
              </tr>
			  
			  
              <tr> 
                <td><hr size="1" color="#505F70"></td>
                <td><hr size="1" color="#505F70"></td>
				<td><hr size="1" color="#505F70"></td>
              </tr>
			  
              <tr>
                <td>&nbsp;</td>
				<td>&nbsp;</td>
                <td align="right">
				    <input name="submit" type="image" src="pictures/button-submit.jpg" onClick="self.selectanatomy(); submit">
					&nbsp;&nbsp;
				    <br>
				</td>
              </tr>
            </table>
</form>

</center>


<?php
    include("frames_footer.php");
?>