<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
//connection
include("connection.php");
//Title before frames_header
print '<title>ANISEED v3.0 - Cleavage inequality result</title>';

   include("frames_header.php");
?>

<center>
<?php
	if($_POST["mvol"]==0)
		$mvol=">=";
	else
		$mvol="<=";
	$vol=$_POST["vol"];

	
	
	if(  (! is_numeric($vol))or($vol<0)  ){
	    print '<center><h2><strong>Wrong parameter.</strong></h2></center>';
		include("frames_footer.php");
		return;
	}
	
	$devstage=array();
	if(isset($_POST["devstage"]))
	    $devstage=$_POST["devstage"];
	
	$species="";
	if(isset($_POST["species"]))
	    $species=$_POST["species"];
	
	$celllist="";
	if(isset($_POST["celllist"]))
		$celllist=$_POST["celllist"];
	
	if(strlen($celllist)>0)
		print "<center><H2><font color=\"#FF6600\">Refining subset mode</font></H2></center>";
				
	
	//search for cells		
	$requete="SELECT distinct a.\"CELL1\", a.\"CELL2\", a.\"RATIO\", b.\"NAME\", b.\"SPECIES\", b.\"DEV_STAGE_ID\", c.\"NAME\" as \"DEV\" FROM \"DIVISION\" a, \"ANAT_ENTITY\" b, \"DEV_STAGE\" c WHERE (a.\"CELL1\"=b.\"ANAT_ID\") and (b.\"DEV_STAGE_ID\"=c.\"DEV_STAGE_ID\") ";
	
	if( $species>0 )
		$requete.=" AND (c.\"SPECIES\" ='$species') ";
	
	if( count($devstage)>0 ){
	    $devstage=join("','",$devstage);
		$requete.=" AND (b.\"DEV_STAGE_ID\" in ('".$devstage."')) ";
	}
	
	if( $vol>0 )
		$requete.=" AND (a.\"RATIO\"".$mvol.$vol.") ";
	
	
	if( strlen($celllist)>0){
		$celllist = substr($celllist, 0, strlen($celllist)-1);
		$celllist = ereg_replace(":","','",$celllist);

		$requete.=" AND ( (a.\"CELL1\" in('".$celllist."'))OR(a.\"CELL2\" in('".$celllist."')) )";
	}
	
	$requete.="order by b.\"DEV_STAGE_ID\"";
//print "$requete";
		
	$stmt = pg_query($c,$requete);



	print "<font color=\"#D64242\" size=\"3\"><b>Matching records</b></font><br><br>";
	print '<table width="99%" border="0" cellspacing="0" cellpadding="0">';
	print '<tr align="center" valign="middle"><td><font color="#456898" size="2"><b>Anatomical entity 1</b></font></td><td><font color="#456898" size="2"><b>Anatomical entity 2</b></font></td><td><font color="#456898" size="2"><b>Asymmetry (%)</b></font></td><td><font color="#456898" size="2"><b>Developmental stage</b></font></td><td><font color="#456898" size="2"><b>Species</b></font></td></tr>';
	$count=0;
	$celllist="";
	while( $row=pg_fetch_array($stmt) ){
	
	    $requete="SELECT \"NAME\" from \"ANAT_ENTITY\" WHERE \"ANAT_ID\"=".$row["CELL2"];
		$stmt2 = pg_query($c,$requete);
		if( $row2=pg_fetch_array($stmt2) )
		    $cell2=$row2["NAME"];
		
		
		++$count;
		print '<tr align="center" valign="top"><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td></tr>';
		
		print '<tr align="center" valign="top"> <td><a href="short_hierarchy.php?region='.$row["CELL1"].'&dev='.$row["DEV_STAGE_ID"].'"><font color="#000000" size="-1">'.$row["NAME"].'</font></a></td> <td>'.'<a href="short_hierarchy.php?region='.$row["CELL2"].'&dev='.$row["DEV_STAGE_ID"].'"><font color="#000000" size="-1">'.$cell2.'</font></a></td> <td><font color="#656565" size="-1">'.$row["RATIO"].'</font></td> <td><font color="#656565" size="-1">'.$row["DEV"].'</font></td> <td><font color="#656565" size="-1">'.$row["SPECIES"].'</font></td> </tr>';
		
		if($count>500){
			//OCICancel($stmt);
			pg_cancel_query($c);
			break;
		}
		
	    $celllist.= $row["CELL1"].":".$row["CELL2"].":";  //liste les cell id pour le rafinage.
		
	}
	print '<tr valign="top"><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td></tr>';
	print '</table>';
	
	if($count==0)
		print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
	else
		print "<br><center>$count result(s)</center><br><br>";

	
	if($count>500)
		print "...<br>More than 500 results has been returned.<br>Please refine your query";




	if(substr_count($celllist,":")<1000){
		print '<form name="formulaire3" action="" method="post">';
		print '<input type="hidden" value="'.$celllist.'" name="celllist">';
		print'&nbsp;&nbsp;&nbsp;<input type="image" src="pictures/button-subset.jpg" onClick="javascript: window.document.formulaire3.action= window.document.formulaire3.redirect.value; submit;">';
		
		/*print '<br>
			   <select name="redirect" size="1">
				   <option value="biometry-search.php">Biometry</option>
				   <option value="neighbour-search.php">Neighbours</option>
				   <option value="fate-search.php">Fate</option>
				   <option value="lineage-search.php">Lineage</option>
				   <option value="division-search.php">Division</option>
				   <option value="insitu-search.php">In situ</option>
				   <option value="ID.php">Export ID list</option>
			   </select>';*/
		include("refine_anatomy.php");
			   
		print '</form>';
    }else{print '<font size="-1" color="#999999">Refine mode not available for set > 1000</font>';}

?>
</center>

<?php
    include("frames_footer.php");
?>