<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

include("connection.php");
//Title before frames_header
print '<title>ANISEED v3.0 - Display evidence for Regulatory Interactions</title>';
include("frames_header.php");

?>

<SCRIPT>
function ZoomIn() {
		for(a=0;a<document.images.length;++a){
			if( (document.images[a].name=="pics") && (document.images[a].width+20 < 1000) )
				document.images[a].width+=20;
		}
}
function ZoomOut() {
		for(a=0;a<document.images.length;++a){
			if( (document.images[a].name=="pics") && (document.images[a].width-20 > 0) )
				document.images[a].width-=20;
		}
}

</SCRIPT>

<?php


$evidence_list = explode ( ":", $_GET["evidences"] );
		print "<h2  style='color: red;'>Evidence in support for an interaction</h2><br />";
		print "<h3 style='color: black;'>
		The evidence for the regulatory interaction comes from several lines of argumentation.<br />
		First the expression of the target gene should be affected by the loss-of-function of the upstream regulatory
		gene in the anatomical territory of interest or in its progeny. 
		This may be assayed at a more advanced developmental stage, leading to evidence ISHs that do not match
		the expected stage.<br />
		Second, the precise timing of the interaction is determined by the timing of onset
		of expression of the target gene in the territory of interest.
		</h3>";

foreach ($evidence_list as $evidence_id){

	$khoueiry = "SELECT \"GENE_A\", \"GENE_B\", \"INTERACTION_EVIDENCE_TYPE\".\"DESCRIPTION\" AS \"EVIDENCE\",
			\"INTERACTION_TYPE\".\"DESCRIPTION\" AS \"TYPE\", \"ANAT_ENTITY_ID\", \"ANAT_ENTITY\".\"NAME\" AS \"ANAT_NAME\",
			\"EVIDENCE_ISH_ID\", \"CONTROL_ISH_ID\", \"DEV_STAGE\".\"NAME\" AS \"STAGE_NAME\",
			\"DEV_STAGE\".\"DEV_STAGE_ID\", \"CONFIDENCE\" 
		FROM \"INTERACTION_EVIDENCE\", \"INTERACTION_EVIDENCE_TYPE\", \"INTERACTION_TYPE\", \"DEV_STAGE\", \"ANAT_ENTITY\" 
		WHERE \"INTERACTION_EVIDENCE_ID\"=$evidence_id 
			AND \"ANAT_ENTITY\".\"ANAT_ID\"=\"INTERACTION_EVIDENCE\".\"ANAT_ENTITY_ID\" 
			AND \"INTERACTION_EVIDENCE\".\"DEV_STAGE_ID\"=\"DEV_STAGE\".\"DEV_STAGE_ID\" 
			AND \"INTERACTION_EVIDENCE\".\"EVIDENCE_TYPE\"=\"INTERACTION_EVIDENCE_TYPE\".\"EVIDENCE_TYPE_ID\" 
			AND \"INTERACTION_EVIDENCE\".\"INTERACTION_TYPE\"=\"INTERACTION_TYPE\".\"INTERACTION_TYPE_ID\"";
	$stmt = pg_query($c,$khoueiry);
	if($row=pg_fetch_array($stmt)){ 
	
	
//// get name of the clustid for gene A
$name=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row["GENE_A"]."' AND \"MANUAL\"='y'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($r=pg_fetch_array($stmt))	 { $name[count($name)]=$r["GENE_CLUSTER_NAME"]; }
if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row["GENE_A"]."'";
	$stmt=pg_query($c,$requete) or die (pg_last_error($c));
	while ($r=pg_fetch_array($stmt))	 { $name[count($name)]=$r["GENE_CLUSTER_NAME"]; }
}

if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='".$row["GENE_A"]."'";
	$stmt=pg_query($c,$requete);
	while ($r=pg_fetch_array($stmt)) { $name[count($name)]=$r["GENE_CLUSTER_NAME_BLAST"]; }
}
$row["GENE_A"] = $name[0];	

//// get name of the clustid for gene B
$name=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row["GENE_B"]."' AND \"MANUAL\"='y'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($r=pg_fetch_array($stmt))	 { $name[count($name)]=$r["GENE_CLUSTER_NAME"]; }
if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row["GENE_B"]."'";
	$stmt=pg_query($c,$requete) or die (pg_last_error($c));
	while ($r=pg_fetch_array($stmt))	 { $name[count($name)]=$r["GENE_CLUSTER_NAME"]; }
}

if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='".$row["GENE_B"]."'";
	$stmt=pg_query($c,$requete);
	while ($r=pg_fetch_array($stmt)) { $name[count($name)]=$r["GENE_CLUSTER_NAME_BLAST"]; }
}
$row["GENE_B"] = $name[0];
		print '<br />';
		print '<br />';
		print "<h3>Evidence that ".$row["GENE_A"]." ".$row["TYPE"]." ".$row["GENE_B"]." in ".$row["ANAT_NAME"]." at the ".$row["STAGE_NAME"]."</h3>";
  		print '<br>
		<img src="pictures/zoom-in.gif" onClick="ZoomIn()" border="0">
		<img src="pictures/zoom-out.gif" onClick="ZoomOut()" border="0">
		';
		print '<br>';
		print "<h4>Experiment in a perturbed condition</h4>";
		printISH($row["EVIDENCE_ISH_ID"],$c);
		print "<h4>Control Experiment</h4>";
		printISH($row["CONTROL_ISH_ID"],$c);
		print "<hr/>";
					
	}
}


// Start of table and column headings (ID and Name)
//print "<center><TABLE CELLSPACING=\"0\" BORDER=\"0\" style=\"border:1px solid black;padding:5px;margin:10px;\" WIDTH=\"99%\">\n";
   
// Loop through results
function printISH($id,$c)
   {  		
	    		
		$requete="SELECT A.\"BEING_CURATED\",A.\"WILD_TYPE\", A.\"DEV_STAGE_ID\", A.\"SPECIES\", A.\"EXP_COMMENTS\", A.\"TIME\", A.\"TEMPERATURE\", A.\"IM_COMMENTS\", B.\"NAME\" AS DEV, C.\"NAME\", C.\"SURNAME\", C.\"MAIL\", C.\"LOGO\", D.\"ENTRY_DATE\" FROM \"IN_SITU\" A, \"DEV_STAGE\" B, \"AUTHOR\" C, \"ENTRY_ORIGIN\" D WHERE (A.\"IN_SITU_ID\"=$id) AND (A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\") AND (D.\"BIO_ID\"=$id) AND (D.\"AUTHOR_ID\"=C.\"AUTHOR_ID\")";
		//print $requete;
		$resultset = pg_query($c,$requete);
				
		$row2=pg_fetch_array($resultset);
		
		//couleur en fonction de wild type ou non
		$wild=$row2["WILD_TYPE"];
		if($wild=='n'){$color='#CCCC99';}else{$color='#FFFFCC';}
		
		//espece & stade de devt. & logo
		print "<TABLE CELLSPACING=\"0\" BORDER=\"0\" bgcolor=\"$color\" WIDTH=\"100%\" style=\"color:black\"><TR>\n";		
		print '<td><table width="100%" border="0" cellspacing="0" cellpadding="0" style="color:black">'
		  .'<tr>'
		  ."<td align=\"left\" >";
		if(strlen($row2["LOGO"])>0)
			print "<img align=\"absmiddle\" src=\"pictures/".$row2["LOGO"]."\">&nbsp;&nbsp;";
		
		print "<a href=\"insitu.php?id=$id\"><img src=\"pictures/button-more.jpg\" border=\"1\"></a>";

if ($row2["BEING_CURATED"]=='y')
			print "&nbsp;&nbsp;<font size=\"2\" color=\"orange\">This entry is  <strong> being manually curated</font></strong>&nbsp;&nbsp;</td>";
		

		print "<td align=\"right\" valign=\"top\"><font color=\"#456898\" size=\"2\"><b>".$row2["SPECIES"]."&nbsp;&nbsp;&nbsp;&nbsp;".$row2[ "dev"]."</b></font></td>"
		  .'</tr></table></td></tr>';


		$requete="SELECT \"PICTURE_ID\", \"PATH\" FROM \"PICTURE\" WHERE \"IN_SITU_ID\" = $id and \"CONTROL\" IS NULL";		

		$stmtpic = pg_query($c,$requete);
		

		print "<TR><TD><TABLE><tr align=\"top\"><td>";
		while($row3=pg_fetch_array($stmtpic)){
			$idpicture=$row3["PICTURE_ID"];
			if(strlen($row3["PATH"])>0)
				{
				if (!preg_match("/mix/",$row3["PATH"]))
			    echo "<a href=\"insitu.php?id=$id\"><img src=\"picturesDB/".$row3["PATH"]."\" border=1 width=\"100\" name=\"pics\"></a> ";
				}
			else
			    echo "<a href=\"insitu.php?id=$id\"><img src=\"picture-mini.php?id=$idpicture\" border=1 width=\"100\" name=\"pics\"></a> ";
		}
		print "</td><td width=\"45%\"><font size=\"-1\" color=\"#000000\">".(str_replace("<br>"," ",$row2[ "IM_COMMENTS"]))."</font></td></tr>";
		print "</TABLE></TD></TR>\n";
		
		
		print "<TABLE cellpadding=\"0\" CELLSPACING=\"0\" BORDER=\"0\" bgcolor=\"$color\" WIDTH=\"100%\" style=\"color:black\">\n";
			//recherche des cibles
			$requete = "SELECT distinct B.\"SURE\", B.\"PART_OF\", A.\"MOL_ID\", A.\"NAME\", A.\"TYPE\", C.\"NAME\" AS \"REGION\", C.\"ANAT_ID\", C.\"DEV_STAGE_ID\" FROM \"MOL_ENTITY\" A, \"TARGET\" B, \"ANAT_ENTITY\" C where (B.\"IN_SITU_ID\"=$id) AND (B.\"TARGET_ID\"=A.\"MOL_ID\") AND (B.\"REGION_ID\"=C.\"ANAT_ID\") ORDER BY C.\"NAME\"";
			
			//print $requete;

			$resultset = pg_query($c, $requete);
			
			$str='';
			$str2='';
			$mol=null; $typemol=null;//sert a retrouver le gene correspondant

			//Le tableau des parties anatomiques a trier + avoid doublons
			$strsort=(array) null;

			while( $row4=pg_fetch_array($resultset )){
				if(substr_count (  $str, $row4["NAME"] )==0){
					if( $row4["TYPE"]=="clone" )
					    $str.="<a href=\"molecule-clone2.php?name=";
					else if( $row4["TYPE"]=="clone_sequence" )
					    $str.="<a href=\"molecule-clone.php?name=";
					else if( $row4["TYPE"]=="gene" )
					    $str.="<a href=\"molecule-gene.php?name=";
					//REGULATORY REGION	
					else if( $row4["TYPE"]=="construction" ) {					
							$str.="<a href=\"construct-view.php?constructid=".$row4["MOL_ID"]."\">".$row4["NAME"]."</a> - ";	
					} else
					    $str.="<a href=\"\" name=\"";
					
					if( $row4["TYPE"]!="construction" )
						$str.=$row4["NAME"]."\">".$row4["NAME"]."</a> - ";
				    
					$mol[$row4["MOL_ID"]]=$row4["NAME"];
					$typemol[$row4["MOL_ID"]]=$row4["TYPE"];
				}
				//anotation sup sur les "stained anatomy part"
				$partof="";$sure="";
				if($row4["PART_OF"]=="X") $partof="Part of ";  else $partof="";
				if($row4["SURE"]=="X") $sure="?"; else $sure="";
			
				//Sort+avoid doublon
				if (!in_array($row4["REGION"],$strsort))
				{		
	$str2.="<a href=\"short_hierarchy.php?region=".$row4["ANAT_ID"]."&dev=".$row4["DEV_STAGE_ID"]."\">$partof".$row4["REGION"]."$sure</a> - ";

				$strsort[count($strsort)]=$row4["REGION"];
				}
			}
			
			print "<TR valign=\"top\"><TD width=\"250\"><font color=\"#456898\" size=\"2\"><b>Stained molecule: - </b></font><font size=\"-1\" color=\"#000000\">$str</font></TD>\n";
			
					
			print "<TD><font color=\"#456898\" size=\"2\"><b>Stained region: - </b></font><font size=\"-1\" color=\"#000000\">$str2</font></TD></TR>\n";
			
			
			
///////////////////////
            
			
			while (list($key, $value) = each($mol)) {
			      $count2=0;
			      $geneidlist="";
				  if( $typemol[$key]=="clone" ){
					  $requete="SELECT distinct \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value'";
					    	$resultset=pg_query($c,$requete);
						
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["ANISEED_CLUSTER_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }

					//KYOTO
			  		$requete="select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"=(SELECT distinct \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value' and \"ANISEED_KYOTO_CLUSTER_ID\" is not null limit 1)";
				    	$resultset=pg_query($c,$requete);
					$row5bis=pg_fetch_array($resultset);
					$requete="select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\" like '".$row5bis["NAME"].".%' and \"TYPE\" <> 'abstract'";
					$resultset=pg_query($c,$requete);						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["MOL_ID"];

					  }

					//ENSEMBL

					$requete="SELECT \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\" in (SELECT distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\"='$value' and \"ANISEED_ENSEMBL_CLUSTER_ID\" is not null) limit 1";//MODIFIE TEMPORAIREMENT
					
					    	$resultset=pg_query($c,$requete);
						//print $requete;
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["TRANSCRIPT_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }

				  }
				  else if( $typemol[$key]=="clone_sequence" ){
					  $requete="SELECT distinct \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"=$key";
					  $resultset=pg_query($c,$requete);
					  while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["ANISEED_CLUSTER_ID"];
					  }

					//KYOTO
			  		$requete="select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"=(SELECT distinct \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key')";
				    	$resultset=pg_query($c,$requete);
					$row5bis=pg_fetch_array($resultset);
					$requete="select \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\" like '".$row5bis["NAME"].".%' and \"TYPE\" <> 'abstract'";
					$resultset=pg_query($c,$requete);						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["MOL_ID"];

					  }

					//ENSEMBL
					$requete="SELECT \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\"=(
						SELECT distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key')";
					    	$resultset=pg_query($c,$requete);
						
						  
					while($row5=pg_fetch_array($resultset)){
						   $geneidlist[$count2++]=$row5["TRANSCRIPT_ID"]; //+ieur genes poss si les est d'un meme clone correspondent a des modeles differents

					  }

				  }
				  else if( $typemol[$key]=="gene" ){
					  $geneidlist[$count2++]=$key;
				  }
				  
				  //recherche des noms possibles pour le gene correspondant
				  if(count($geneidlist)>1)
				      $geneidlist=array_unique($geneidlist);

/////////// AJOUT POUR LES CONCEPTS DE GENES //////////////////////////////////////
				$GENE=(array) null;
				for ($a=0;$a<count($geneidlist);++$a)
					{
					//print "==>>".$geneidlist[$a];
					if (strlen($geneidlist[$a])==0) continue;
					$requete0="SELECT distinct \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"='".$geneidlist[$a]."'";
					$stmt0=pg_query($c,$requete0);
					$row0=pg_fetch_array($stmt0);
					//print "==>".$row0["GENE_CLUSTER_ID"]."<br>";

					$GENE[count($GENE)]=$row0["GENE_CLUSTER_ID"];
					}
				$GENE=array_unique($GENE);

				//print_r($GENE);

				for ($a=0;$a<count($GENE);$a++)
				{
				$requete0="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$GENE[$a]."'";
				$stmt0=pg_query($c,$requete0);
				$aaa=0;
				$syno="";
				if (pg_num_rows($stmt0)==0)
					{
					$requete0="SELECT \"GENE_CLUSTER_NAME_BLAST\" as \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='".$GENE[$a]."'";
					$stmt0=pg_query($c,$requete0);
					}
				while ($row0=pg_fetch_array($stmt0))
					{
					//$genename=$row0["GENE_CLUSTER_NAME"];
					$genename=$GENE[$a];
					if (++$aaa>1)
						$syno.=' <strong><font color="#990000">/</font></strong> ';
					$syno.=$row0["GENE_CLUSTER_NAME"];
					}

				print "<tr valign=\"top\"><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">Predicted Aniseed Gene model for ".$value.": <a href=\"gene-card.php?clusterid=".$genename."\">".(str_replace("cluster","aniseedV3_",$genename))."</a></font></td><td><div style=\"border-top:1px solid black;\"/><font size=\"-1\">".$syno."</font></td></tr>";

				}

			}
//////////////////////////////////



            //description des manipulations d'embryon
			if($wild=='n'){
			
				//Requete pour recuperer le commentaire 
				$r="SELECT \"EXP_COMMENTS\" from \"IN_SITU\" where \"IN_SITU_ID\"='$id'";
				$st=pg_query($c,$r);
				if (pg_num_rows($st)>0)
				{
					$rro=pg_fetch_array($st);
					$comment=$rro["EXP_COMMENTS"];
					print "<TR valign=\"top\"><TD><div style=\"border-top:1px solid black;\"/><font color=\"#456898\" size=\"2\"><b>Experimental conditions:</b></font></TD>\n";
					print "<TD><div style=\"border-top:1px solid black;\"/