<html>
<head>
<title>ANISEED - Blast result (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page is the results of blast (nucleotide or protein sequence) against all cDNA clones, Ciona intestinalis or Halocynthia roretzi EST/cDNA clones, or the Ciona intestinalis gene models. Contact aniseed@ibdm.univ-mrs.fr for more information about Ciona intestinalis database.">
<meta name="keywords" content="Tassy, Daian, Sobral, Dauga, Lemaire, Blast, nucleotide sequence, protein sequence, Ciona intestinalis cDNA clone, Halocynthia roretzi cDNA clone, Ciona intestinalis, Halocynthia roretzi, Aniseed, Ciona intestinalis database, Ciona intestinalis gene models">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

    //evite que le script tourne indefiniment si l'utilisateur annule l'operation.
    $old_abort = ignore_user_abort(true);

    //ini_set("memory_limit","1024M");


	
    include("frames_header.php");
?>
<img src="pictures/ncbi.jpg">
<?php
    //adapt that script to the OS
	$win=0;
	if ( eregi("^win", php_uname('s')) )//if running under windows
		$win=1;


	if( isset($_POST["type"]) ) $type=$_POST["type"];
	if( isset($_POST["expect"]) ) $expect=$_POST["expect"];
	if( isset($_POST["sequence"]) ) $sequence=$_POST["sequence"];
	if( isset($_POST["word"]) ) $word=$_POST["word"];
	if( isset($_POST["matrix"]) ) $matrix=$_POST["matrix"];
	if( isset($_POST["filter"]) ) $filter=$_POST["filter"]; else $filter="F";
	if( isset($_POST["gap"]) ) $gap=$_POST["gap"];else $gap="F";
	if( isset($_POST["db"]) ) $db=$_POST["db"];

 print_r($_POST);


if (strlen($db)==0)
	{
	print "<center><strong>Choose one database to blast your sequence against !</strong></center>";
	include ("frames_footer.php");
	return;
	}

if ($db=="JGIwhole")
	{
	print "Hint: To see where are localized the matching regions on the genome, please go on the top of the page and click on a result<br><br>";
	}
	
	if ( $win==1 ){//if running under windows
		if($db=="ALLclones")
			$db2="\"BLAST\\CIclones BLAST\\HRclones\"";
		else
			$db2="BLAST\\$db";
	}else{                               //else try a unix path type
		if($db=="ALLclones")
			{
			$db2="\"./BLAST/CIclones ./BLAST/HRclones ./BLAST/gateway\"";
			}
		else
			{
			$db2="./BLAST/$db";
			}
	}
	
	
	
	if( ($type=="tblastx") or ($type=="tblastn") ) $word=3;
		
	if(strlen($sequence)<=0){
	    print "<center>Error. No sequence entered</center>";
		include("frames_footer.php");
	    return;
	}
		
	/*
	if(eregi('[^aAcCgGtT]+',$sequence) ){
	    print "<center>incorrect sequence format</center>";
	    return;
		include("frames_footer.php");
	}
	*/
	
	//ecriture de la sequence dans un fichier
	$sequence=eregi_replace ( "[^a-zA-Z]","",$sequence);
	
	if ( $win==1 )//if running under windows
	    $file = fopen("BLAST/SEQtoBLAST.txt", "w"); 
	      //$file=fopen("/tmp2/aniseed/SEQtoBLAST.txt","w");
	else
	   {/* $file = fopen("./BLAST/SEQtoBLAST.txt", "w");*/
  	      //print "ICI";
	$file=fopen("/tmp2/aniseed/SEQtoBLAST.txt","w"); //Pour marcher avec les nouvelles recommandations du serveur
	//$file=fopen("/tmp2/upload/SEQtoBLAST.txt","w"); //Pour marcher avec les nouvelles recommandations du serveur
		//$file=tempnam("./tmp","SEQtoBLAST.txt");	
		}
	
	if (!$file) { 
	  die("Internal error");
	}
    fputs ($file, $sequence );
    fclose ($file);
	
	
	//genere un nom de fichier unique
	//$output="BLAST".date(dHis).".tmp";
	if ( $win==1 )//if running under windows
		$output = tempnam("/tmp2/aniseed", "BLAST");
	else
	{
    	$output=tempnam ("/tmp2/aniseed", "BLAST");
	//$output=tempnam ("/tmp2/upload", "BLAST");
	$output2=tempnam("/tmp2/aniseed","BLAST2");
	}

    //blasting
	if ( $win==1 )//if running under windows
		//$cmd="BLAST\\blastall -p $type -o $output  -e $expect  -i BLAST\\SEQtoBLAST.txt  -F $filter -g $gap -M $matrix -W $word -T T -d $db2";
		$cmd="BLAST\\blastall -p $type -o $output  -e $expect  -i BLAST\\SEQtoBLAST.txt  -F $filter -g $gap -M $matrix -W $word -T T -d $db2";
    else
		{
		//$cmd="./BLAST/blastall -p $type -o $output  -e $expect  -i ./BLAST/SEQtoBLAST.txt  -F $filter -g $gap -M $matrix -W $word -T T -d $db2";

$cmd="./BLAST/blastall -p $type -o $output  -e $expect  -i /tmp2/aniseed/SEQtoBLAST.txt  -F $filter -g $gap -q -1 -M $matrix -W $word -T T -d $db2";
//$cmd="./BLAST/blastall -p $type -o $output  -e $expect  -i /tmp2/aniseed/SEQtoBLAST.txt  -F $filter -g $gap -W $word -T T -d $db2";

$cmd2="./BLAST/blastall -m 8 -p $type -o $output2 -e $expect  -i /tmp2/aniseed/SEQtoBLAST.txt  -F $filter -g $gap -q -1 -M $matrix -W $word -T T -d $db2";



print $cmd2."<br>";
//$cmd2="./BLAST/blastall -m 8 -p $type -o $output2 -e $expect  -i /tmp2/aniseed/SEQtoBLAST.txt  -F $filter -g $gap -W $word -T T -d $db2";

//$cmd="blastall -p $type -o $output  -e $expect  -i /tmp2/upload/SEQtoBLAST.txt  -F $filter -g $gap -M $matrix -W $word -T T -d $db2";
		//$cmd="./BLAST/blastall -p $type -o $output  -e $expect  -i $file  -F $filter -g $gap -M $matrix -W $word -T T -d $db2";
		//print "<br>COMMANDE=$cmd";
		}	
	
	if(exec($cmd)){
	    print "<center>Error. Check your sequence format and the BLAST parameters</center>";
		include("frames_footer.php");
	    return;
	}

	
	if(exec($cmd2)){
	    print "<center>Error. Check your sequence format and the BLAST parameters</center>";
		include("frames_footer.php");
	    return;
	}

/*else
{*/
	
	//traitement des resultats
    $blast=fopen($output, "r"); 
    
$I=0;

	while (!feof($blast)) {
	    $line = fgets($blast, 4096);
		//print $line;
		if (eregi('Score = ',$line)) {$I++;$line=eregi_replace('Score','Result#'.$I.'<br><a href="#result'.($I).'">Gbrowse link</a><br>Score',$line);}

		if( eregi('<html>',$line) or eregi('</html>',$line) or eregi('<body',$line) or eregi('</body>',$line) )
		    $line='';
		
		if( eregi('<a href="http://www.ncbi.nlm.nih.gov/htbin-',$line) )
		    $line=eregi_replace ( '<a href="http://www.ncbi.nlm.nih.gov/htbin-', '<a target="blank" href="http://www.ncbi.nlm.nih.gov/htbin-', $line);
		
		//if( eregi("BLAST.CIclones",$line) )
		//    $line=eregi_replace ( "BLAST.CIclones",$db,$line);
			
		//if( eregi("BLAST.HRclones",$line) )
		//    $line=eregi_replace ( "BLAST.HRclones",$db,$line);
		//$line=eregi_replace("gb=[A-Z]*[0-9]*","<a href=\"molecule-clone.php?name=".$regs[1]."\">".$regs[1]."</a>",$line);
		if (eregi("gb=NM_[0-9]*",$line,$rego))
		{
		$rego[0]=str_replace("gb=","",$rego[0]);
		if( ($db=='CIclones')or($db=='HRclones')or($db=='ALLclones') )
			{
		        $line=eregi_replace("gb=NM_[0-9]*","gb=<a href=\"molecule-clone.php?name=".$rego[0]."\">".$rego[0]."</a>",$line);

			}
		}

		if (eregi("gb=[A-Z]*[0-9]*",$line,$rego))
		{
		$rego[0]=str_replace("gb=","",$rego[0]);
		if( ($db=='CIclones')or($db=='HRclones')or($db=='ALLclones') )
			{
		        $line=eregi_replace("gb=[A-Z]*[0-9]*","gb=<a href=\"molecule-clone.php?name=".$rego[0]."\">".$rego[0]."</a>",$line);

			}
		}



		if( eregi("^><a name.+</a>(.+)</a>",$line,$regs) )
		{
		    
			if( ($db=='CIclones')or($db=='HRclones')or($db=='ALLclones') )
			{
		        //$line=eregi_replace ("</a>".$regs[1]."</a>", "</a><a href=molecule-clone.php?name=".$regs[1].">".$regs[1]."</a>", $line);
			//print $db;
			
	        	}
			else if($db=='CIpredictedmRNA')
			{
		    	$line=eregi_replace ("</a>".$regs[1]."</a>", "</a><a href=molecule-gene.php?name=".$regs[1].">".$regs[1]."</a>", $line);
			}
			else if ($db=="KYOTOmRNA")
			{
		    	$line=eregi_replace ("</a>".$regs[1]."</a>", "</a><a href=molecule-gene.php?name=".$regs[1].">".$regs[1]."</a>", $line);
			}
			else if ($db=="ENSmRNA")
			{
		    	$line=eregi_replace ("</a>".$regs[1]."</a>", "</a><a href=molecule-gene.php?name=".$regs[1].">".$regs[1]."</a>", $line);
			}
			else if ($db=="JGIwhole")
			{
			/*===============> LE POINT VIRGULE	*/;
			/*$line=eregi_replace ("</a>".$regs[1]."</a>", "</a><a href=http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/?name=".$regs[1].">".$regs[1]."</a>", $line);*/
			}
			
		}
	    echo $line;
	
	}
	fclose ($blast);



	//efface le fichier de resultat du BLAST
	unlink( $output );
	//RAJOUT
	unlink($file);
/*}*/




/*
if ($db=="JGIwhole")
{
print "<b>View result in GBROWSE</b><br>";

    $blast2=fopen($output2, "r"); 
$i=0;
	while (!feof($blast2))
	{
    $line = fgets($blast2, 4096);
if (strlen(trim($line))==0) continue;
    $tmp=explode("\t",$line);
if ($tmp[0]!="tmpseq_0") continue;
//print "[$line]<br>";
$i++;
print "<a name=\"result".($i)."\">Result #</a>".($i)."<br>";
print "View in gbrowse : <a href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=".$tmp[1].":".($tmp[8]-2000)."..".($tmp[9]+2000).";auto=".$tmp[1]."+Blast_results+Your_query+".($tmp[8])."-".($tmp[9])."\">Link</a><br>";
print "<br>";


	}
	fclose($blast2);
	unlink($output2);




}
*/

if ($db=="JGIwhole")
{
print "<h2><font color=\"crimson\">Blast Results</font></h2>";

    $blast2=fopen($output2, "r"); 
$i=0;
$XML="";
	while (!feof($blast2)) $XML.=fgets($blast2,4096);

$XML=str_replace("Hsp_query-from","Hsp_query_from",$XML);
$XML=str_replace("Hsp_query-to","Hsp_query_to",$XML);
$XML=str_replace("Hsp_align-len","Hsp_align_len",$XML);
$XML=str_replace("Hsp_bit-score","Hsp_bit_score",$XML);
$XML=str_replace("Hsp_hit-from","Hsp_hit_from",$XML);
$XML=str_replace("Hsp_hit-to","Hsp_hit_to",$XML);



//print($XML);

$xml = simplexml_load_string($XML);


//$hit=$xml->BlastOutput_iterations->Iteration->Iteration_hits->Hit;


foreach ($xml->BlastOutput_iterations->Iteration->Iteration_hits->Hit as $hit)
{

$hit_num=$hit->Hit_num;
$hit_scaffold=$hit->Hit_accession;
$hit_len=$hit->Hit_len;

//print $hitnum."==> ".$hit_scaffold." ".$hit_len."<br>";

print "<div style=\"padding:5px;background-color:lightyellow;border-left:1px solid black;border-top:1px solid black;border-right:1px solid black;\">Result #$hit_num on <b>$hit_scaffold</b>, lenght=<b>$hit_len</b></div>";

print "<div style=\"padding:5px;background-color:white;border-left:1px solid black;border-right:1px solid black;\">";
$totab=(array) null;

foreach ($hit->Hit_hsps->Hsp as $hsp)
{

$hsp_num=$hsp->Hsp_num;
$hsp_score=$hsp->Hsp_score;
$hsp_evalue=$hsp->Hsp_evalue;
$hsp_qseq=$hsp->Hsp_qseq;
$hsp_hseq=$hsp->Hsp_hseq;
$hsp_midline=$hsp->Hsp_midline;
$hsp_bitscore=$hsp->Hsp_bit_score;
$hsp_identity=$hsp->Hsp_identity;
$hsp_positive=$hsp->Hsp_positive;
$hsp_gaps=$hsp->Hsp_gaps; if (trim(strlen($hsp_gaps)==0)) $hsp_gaps=0;
$hsp_align_len=$hsp->Hsp_align_len;

$hsp_from=$hsp->Hsp_hit_from;
$hsp_to=$hsp->Hsp_hit_to;

$totab[count($totab)]=trim($hsp_from);
$totab[count($totab)]=trim($hsp_to);




print "Hsp #$hsp_num bit_score=<b>$hsp_bitscore</b> Expect=<b>$hsp_evalue</b><br>
Identity=<b>$hsp_identity/$hsp_align_len (".round($hsp_identity/$hsp_align_len*100)."%)</b><br>
Gaps=<b>$hsp_gaps/$hsp_align_len(".round($hsp_gaps/$hsp_align_len*100)."%)</b><br>
from=<b>$hsp_from</b> to=<b>$hsp_to</b><br>
<u>Alignment</u><br>
";




$hsp_qseq=trim($hsp_qseq);
$hsp_midline=trim($hsp_midline);
$hsp_hseq=trim($hsp_hseq);

$t_qseq=(array) null;
$l=trim(strlen($hsp_qseq));$r=ceil($l/80);$SIZE=80;$start=0;
for ($i=0;$i<$r;$i++){$t_qseq[$i]=substr($hsp_qseq,$start,$SIZE);$start+=$SIZE;}
// print_r($t_qseq);

$t_mid=(array) null;
$l=trim(strlen($hsp_midline));$r=ceil($l/80);$SIZE=80;$start=0;
for ($i=0;$i<$r;$i++){$t_mid[$i]=substr($hsp_midline,$start,$SIZE);$start+=$SIZE;}
// print_r($t_mid);

$t_hseq=(array) null;
$l=trim(strlen($hsp_hseq));$r=ceil($l/80);$SIZE=80;$start=0;
for ($i=0;$i<$r;$i++){$t_hseq[$i]=substr($hsp_hseq,$start,$SIZE);$start+=$SIZE;}
// print_r($t_hseq);

for ($I=0;$I<count($t_qseq);$I++)
{
print "<TABLE cellpadding=\"0\" cellspacing=\"0\" border=\"0\">";
$hsp_qseq=trim($t_qseq[$I]);
$hsp_midline=trim($t_mid[$I]);
$hsp_hseq=trim($t_hseq[$I]);
print "<TR>";
	for ($i=0;$i<strlen($hsp_qseq);$i++)
	{
	print "<TD align=\"center\"><font size=\"-2\" face=\"courier\">"; print $hsp_qseq{$i}; print "</font></TD>";
	}
print "</TR>";
print "<TR>";
	for ($i=0;$i<strlen($hsp_midline);$i++)
	{
	print "<TD align=\"center\"><font size=\"-2\" face=\"courier\">";
	if (strlen(trim($hsp_midline{$i}))==0) print "&nbsp;"; else print $hsp_midline{$i};
	print "</font></TD>";
	}
print "</TR>";
print "<TR>";
	for ($i=0;$i<strlen($hsp_hseq);$i++)
	{
	print "<TD align=\"center\"><font size=\"-2\" face=\"courier\">";
	print $hsp_hseq{$i};
	print "</font></TD>";
	}
print "</TR>";
print "</TABLE>";
print "<br>";
}

print "<br>";



}
print "</div>";
print "<div style=\"padding:5px;text-align:center;background-color:lightcyan;color:crimson;border-left:1px solid black;border-bottom:1px solid black;border-right:1px solid black;\">";

print "<b>View #Result$hit_num in GBrowse</b>";

$orig_totab=$totab;
sort($totab);
$MAX=$totab[count($totab)-1];
$MIN=$totab[0];

// print_r($totab);

//print "MAX=$MAX MIN=$MIN";

print "&nbsp;&nbsp;&nbsp;&nbsp;<a target=\"_blank\" href=\"http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis?name=$hit_scaffold:".($MIN-2000)."..".($MAX+2000).";
auto=$hit_scaffold+Blast_results+".$orig_totab[0]."-".$orig_totab[1];

for ($i=2;$i<count($orig_totab);$i++)
{
print ",".$orig_totab[$i]."-".$orig_totab[$i+1];
$i++;
}


//print ";style=%22Blast_results%22+glyph=transcript+connector=hat+fgcolor=red;\">ICI</a>";

print "\">Click here</a>";



print"</div><br>";



//print "<hR>";

}














}
//////////////////



?>



<?php
    include("frames_footer.php");
    ignore_user_abort($old_abort);
?>
