<html>
<head>
<title>ANISEED - Ciona intestinalis biometry results</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This is the results of a search of Ciona intestinalis cells by their shape. Please contact aniseed@ibdm.univ-mrs.fr for more information.">
<meta name="keywords" content="Biometry, Lemaire, Tassy, shape descriptor, cell volume, cell surface, sphericity, convexity, elongation, flatness, squareness, entropy, Ciona intestinalis, Halocynthia roretzi, Aniseed, Ciona intestinalis database, geometry, virtual embryo, cell shape, 3D embryo, geometry, Daian, Dauga, Sobral.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>


<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

	//connection
    include("connection.php");
    include("frames_header.php");
?>

<center>
<?php
	if($_POST["mvol"]==0)
		$mvol=">";
	else
		$mvol="<";
	$vol=$_POST["vol"];

	if($_POST["msurf"]==0)
		$msurf=">";
	else
		$msurf="<";
	$surf=$_POST["surf"];




	if($_POST["msphe"]==0)
		$msphe=">";
	else
		$msphe="<";
	$sphe=$_POST["sphe"];
/*
	if($_POST["mcyl"]==0)
		$mcyl=">";
	else
		$mcyl="<";
	$cyl=$_POST["cyl"];
*/
	if($_POST["melong"]==0)
		$melong=">";
	else
		$melong="<";
	$elong=$_POST["elong"];
	
	if($_POST["mflat"]==0)
		$mflat=">";
	else
		$mflat="<";
	$flat=$_POST["flat"];
/*
	if($_POST["mcomp"]==0)
		$mcomp=">";
	else
		$mcomp="<";
	$comp=$_POST["comp"];
*/
	if($_POST["mocup"]==0)
		$mocup=">";
	else
		$mocup="<";
	$ocup=$_POST["ocup"];
	
	if($_POST["ment"]==0)
		$ment=">";
	else
		$ment="<";
	$ent=$_POST["ent"];
	
	if($_POST["msv"]==0)
		$msv=">";
	else
		$msv="<";
	$sv=$_POST["sv"];
	
	if($_POST["mconv"]==0)
		$mconv=">";
	else
		$mconv="<";
	$conv=$_POST["conv"];

	if($_POST["mvv"]==0)
		$mvv=">";
	else
		$mvv="<";
	$vv=$_POST["vv"];

	



	
	
	if(  (! is_numeric($surf))or($surf<0) or (! is_numeric($vol))or($vol<0)  or (! is_numeric($sphe))or($sphe<0)  or (! is_numeric($flat))or($flat<0) or (! is_numeric($elong))or($elong<0) or (! is_numeric($ocup))or($ocup<0) or (! is_numeric($ent))or($ent<0) or (! is_numeric($sv))or($sv<0)  ){
	    print '<center><h2><strong>Wrong parameter.</strong></h2></center>';
		include("frames_footer.php");
		return;
	}
	
	
	
	$devstage=array();
	if(isset($_POST["devstage"]))
	    {$devstage=$_POST["devstage"];
	    $devstagelist=implode("@",$devstage);
		}
	
	$species="";
	if(isset($_POST["species"]))
	    $species=$_POST["species"];
	
	$celllist="";
	if(isset($_POST["celllist"]))
		$celllist=$_POST["celllist"];
	
	if(strlen($celllist)>0)
		print "<center><H2><font color=\"#FF6600\">Refining subset mode</font></H2></center>";
				
	
	//search for cells		
	$requete="SELECT distinct a.\"CELL\", a.\"VOLUME\", a.\"SURFACE\", d.\"SPHERICITY\", d.\"CYLINDRICITY\", d.\"ELONGATION\", d.\"FLATNESS\", d.\"CONVEXITY\", d.\"OCCUPENCY\", d.\"ENTROPY\", d.\"SV\", d.\"VV\", b.\"NAME\", b.\"SPECIES\", b.\"DEV_STAGE_ID\", c.\"NAME\" as \"DEV\" FROM \"BIOMETRY\" a, \"ANAT_ENTITY\" b, \"DEV_STAGE\" c, \"BIOMETRY_SHAPE\" d WHERE (a.\"CELL\"=b.\"ANAT_ID\") and (b.\"DEV_STAGE_ID\"=c.\"DEV_STAGE_ID\") and (d.\"CELL\"=b.\"ANAT_ID\")";
		

	if( $species>0 )
		$requete.=" AND (c.\"SPECIES\" ='$species') ";
	
	if( count($devstage)>0 ){
	    $devstage=join("','",$devstage);
		$requete.=" AND (b.\"DEV_STAGE_ID\" in ('".$devstage."')) ";
	}
	
	if( $vol>0 )
		$requete.=" AND (a.\"VOLUME\"".$mvol.$vol.") ";
		
	if( $surf>0 )
		$requete.=" AND (a.\"SURFACE\"".$msurf.$surf.") ";
	
	
	
	if( $sphe>0 )
		$requete.=" AND (d.\"SPHERICITY\"".$msphe.$sphe.") ";

	if( $elong>0 )
		$requete.=" AND (d.\"ELONGATION\"".$melong.$elong.") ";
		
	if( $flat>0 )
		$requete.=" AND (d.\"FLATNESS\"".$mflat.$flat.") ";

	if( $ocup>0 )
		$requete.=" AND (d.\"OCCUPENCY\"".$mocup.$ocup.") ";
		
	if( $ent>0 )
		$requete.=" AND (d.\"ENTROPY\"".$ment.$ent.") ";
		
	if( $sv>0 )
		$requete.=" AND (d.\"SV\"".$msv.$sv.") ";

	if( $conv>0 )
		$requete.=" AND (d.\"CONVEXITY\"".$mconv.$conv.") ";
	
	if( $vv>0 )
		$requete.=" AND (d.\"VV\"".$mvv.$vv.") ";
	

		
	
	if( strlen($celllist)>0){
		$celllist = substr($celllist, 0, strlen($celllist)-1);
		$celllist = ereg_replace(":","','",$celllist);

		$requete.=" AND (a.\"CELL\" in('".$celllist."'))";
	}
	
	$requete.="order by b.\"DEV_STAGE_ID\"";
//print "$requete";
		
	$stmt = pg_query($c,$requete);

	print "<font color=\"#D64242\" size=\"3\"><b>Matching records</b></font><br><br>";
	print '<table width="99%" border="0" cellspacing="0" cellpadding="0">';
	print '<tr align="center" valign="middle">
	<td>&nbsp;<font color="#456898" size="2"><b>Anatomical entity</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Developmental stage</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Volume &micro;3</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Surface &micro;2</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Sphericity %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Convexity %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Elongation %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Flatness %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Squareness %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Entropy %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>S/V %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>V/V %</b></font></td>
	<td>&nbsp;<font color="#456898" size="2"><b>Species</b></font></td></tr>';
	$count=0;
	$celllist="";
	while($row=pg_fetch_array($stmt) ){
		
		++$count;
		print '<tr align="center" valign="top">      <td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>       <td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td></tr>';

		print '<tr align="center" valign="top">
		<td><a href="short_hierarchy.php?region='.$row["CELL"].'&dev='.$row["DEV_STAGE_ID"].'"><font color="#000000" size="-1">'.$row["NAME"].'</font></a></td>
		<td><font color="#656565" size="-1">'.$row["DEV"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["VOLUME"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["SURFACE"].' </font></td> 
		<td><font color="#656565" size="-1">'.$row["SPHERICITY"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["CONVEXITY"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["ELONGATION"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["FLATNESS"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["OCCUPENCY"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["ENTROPY"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["SV"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["VV"].'</font></td>
		<td><font color="#656565" size="-1">'.$row["SPECIES"].'</font></td> </tr>';
		
		if($count>500){
			//OCICancel($stmt);
			pg_cancel_query($c);
			break;
		}
		
	    $celllist.= $row["CELL"].":";  //liste les cell id pour le rafinage.
		
	}
	print '<tr valign="top">   <td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td>     <td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td><td><hr size="1"></td></tr>';
	print '</table>';
	
	if($count==0)
		print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
	else
		print "<br><center>$count result(s)</center><br><br>";

	
	if($count>500)
		print "...<br>More than 500 results has been returned.<br>Please refine your query";




	if(substr_count($celllist,":")<1000){
		print '<form name="formulaire3" action="" method="post">';
		print '<input type="hidden" value="'.$celllist.'" name="celllist">';
		print'&nbsp;&nbsp;&nbsp;<input type="image" src="pictures/button-subset.jpg" onClick="javascript: window.document.formulaire3.action= window.document.formulaire3.redirect.value; submit;">';
		
		/*print '<br>
			   <select name="redirect" size="1">
				   <option value="biometry-search.php">Biometry</option>
				   <option value="neighbour-search.php">Neighbours</option>
				   <option value="fate-search.php">Fate</option>
				   <option value="lineage-search.php">Lineage</option>
				   <option value="division-search.php">Cleavage inequality</option>
				   <option value="insitu-search.php">In situ</option>
				   <option value="ID.php">Export ID list</option>
			   </select>';*/
		include("refine_anatomy.php");
			   
		print '</form>';
    }else{print '<font size="-1" color="#999999">Refine mode not available for set > 1000</font>';}

print '</center>';


//Pour l'affichage fichier plat par la methode POST
$css="text-decoration:underline; color:black; font-size:15; text-align:center; background-color:transparent; padding:5px border-width:0px;border-style:none;border-color:blue";
print '<form name="formu" action="FLATexport-biometry.php" method="POST">';

print '<input type="hidden" value="'.$_POST["mvol"].'" name="mvol">';
print '<input type="hidden" value="'.$_POST["vol"].'" name="vol">';
print '<input type="hidden" value="'.$_POST["msurf"].'" name="msurf">';
print '<input type="hidden" value="'.$_POST["surf"].'" name="surf">';
print '<input type="hidden" value="'.$_POST["msphe"].'" name="msphe">';
print '<input type="hidden" value="'.$_POST["sphe"].'" name="sphe">';
//print '<input type="hidden" value="'.$_POST["mcyl"].'" name="mcyl">';
//print '<input type="hidden" value="'.$_POST["cyl"].'" name="cyl">';
print '<input type="hidden" value="'.$_POST["melong"].'" name="melong">';
print '<input type="hidden" value="'.$_POST["elong"].'" name="elong">';
print '<input type="hidden" value="'.$_POST["mflat"].'" name="mflat">';
print '<input type="hidden" value="'.$_POST["flat"].'" name="flat">';
//print '<input type="hidden" value="'.$_POST["mcomp"].'" name="mcomp">';
//print '<input type="hidden" value="'.$_POST["comp"].'" name="comp">';
print '<input type="hidden" value="'.$_POST["mocup"].'" name="mocup">';
print '<input type="hidden" value="'.$_POST["ocup"].'" name="ocup">';
print '<input type="hidden" value="'.$_POST["ment"].'" name="ment">';
print '<input type="hidden" value="'.$_POST["ent"].'" name="ent">';
print '<input type="hidden" value="'.$_POST["msv"].'" name="msv">';
print '<input type="hidden" value="'.$_POST["sv"].'" name="sv">';

print '<input type="hidden" value="'.$devstagelist.'" name="devstagelist">';
print '<input type="hidden" value="'.$_POST["species"].'" name="species">';
print '<input type="hidden" value="'.$_POST["celllist"].'" name="celllist">';

print '<input type="submit" style="'.$css.'" value="Display entry in raw text format">';
print '</form>';
//Fin


?>
<?php
    include("frames_footer.php");
?>