<html>
<head>
<title>ANISEED - Ciona intestinalis cell geometry clustering</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page exploits the shape descriptor values up to the Ciona intestinalis late 44-cell stage to compute distances between cell shapes (See Tassy et al., 2006). Contact: aniseed@ibdm.univ-mrs.frs">
<meta name="keywords" content="Shape descriptor, Ciona intestinalis, Halocynthia roretzi, Aniseed, Ciona intestinalis database, geometry, virtual embryo, cell shape, 3D embryo, geometry, Daian, Dauga, Sobral.">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("frames_header.php");
include ("connection.php");

$embryo=$_POST["embryo"];
$embryoo=$embryo;


//Pour les fates
$fateP=(array) null;
if (isset($_POST["fate"]))
	$fateP=$_POST["fate"];
else $fateP=null;



//WARNING: All the developmental stages are defined by hand here !!!
////////////////////////////////////////////////////////////////////
$dev="";
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

if ($embryo=="early 8-cell stage") {$embryo="e8c.jpg";$dev=559;}
if ($embryo=="mid 8-cell stage") {$embryo="m8c.jpg";$dev=559;}
if ($embryo=="very early 16-cell stage") {$embryo="ve16c.jpg";$dev=560;}
if ($embryo=="early 16-cell stage") {$embryo="e16c.jpg";$dev=560;}
if ($embryo=="late 16-cell stage") {$embryo="l16c.jpg";$dev=560;}
if ($embryo=="24-cell stage") {$embryo="24c.jpg";$dev=561;}
if ($embryo=="early 32-cell stage") {$embryo="e32c.jpg";$dev=562;}
if ($embryo=="early 32-cell stage (4)") {$embryo="e32c-amira4.jpg";$dev=562;}
if ($embryo=="early 32-cell stage (5)") {$embryo="e32c-5.jpg";$dev=562;}
if ($embryo=="early 32-cell stage (6)") {$embryo="e32c-6.jpg";$dev=562;}
if ($embryo=="mid 32-cell stage") {$embryo="m32c-bitplane.jpg";$dev=563;}
if ($embryo=="late 32-cell stage") {$embryo="l32c.jpg";$dev=563;}
if ($embryo=="early 44-cell stage") {$embryo="e44c-bitplane.jpg";$dev=564;}
if ($embryo=="mid 44-cell stage") {$embryo="m44c-bitplane.jpg";$dev=564;}
if ($embryo=="Late 44-cell stage") {$embryo="m44c2.jpg";$dev=564;}


?>
<div style="border-top:0px solid black;border-bottom:1px solid black;">
<font color="#D64242" size="3"><b>Cell geometry clustering for "<? print $embryoo; ?>" embryo</b></font>
</div>
<br>
This page exploits the shape descriptor values up to the late 44-cell
stage to compute distances between cell shapes (See Tassy et al.,
2006, Current Biology, 16, 1-14), which are displayed as a tree.
<br>
<!--<h3><strong><em><u>Similarity tree in Newick format</u></em></strong></h3>-->
<form name="formu" method="POST" action="biom-clust2.php">
<table border="0">
<tr>
                <td align="center" valign="top">
			        &nbsp;<strong>Fate</strong>&nbsp;<br>
					<select name="fate[]" size="10" multiple>
					<?php
						$requete= "SELECT \"KEYWORDS\" from \"FATE_KW\" order by \"KEYWORDS\"";
						$stmt = pg_query($c,$requete);
						while($row=pg_fetch_array($stmt))
						    print "<option value=\"".$row["KEYWORDS"]."\">".$row["KEYWORDS"]."</option>\n";
					?>
					</select>
				</td>
</tr>
<tr>
<td align="center">
<input name="submit" type="image" src="pictures/button-submit.jpg" onClick="submit">
<input type="hidden" name="embryo" value="<? print $embryoo;?>">
</td>
</tr>
</table>
</form>

<table width="99%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td width="10">
<?
//if ($embryo=="4c.jpg") $fichier="treeJPG/4cCOR.nwk";
if ($embryo=="e8c.jpg") $fichier="treeJPG/e8cCOR.nwk";
if ($embryo=="m8c.jpg") $fichier="treeJPG/m8cCOR.nwk";
if ($embryo=="ve16c.jpg") $fichier="treeJPG/ve16cCOR.nwk";
if ($embryo=="e16c.jpg") $fichier="treeJPG/e16cCOR.nwk";
if ($embryo=="l16c.jpg") $fichier="treeJPG/l16cCOR.nwk";
if ($embryo=="24c.jpg") $fichier="treeJPG/24cCOR.nwk";
if ($embryo=="e32c.jpg") $fichier="treeJPG/e32cCOR.nwk";
if ($embryo=="e32c-amira4.jpg") $fichier="treeJPG/e32c-amira4COR.nwk";
if ($embryo=="e32c-5.jpg") $fichier="treeJPG/e32c-5COR.nwk";
if ($embryo=="e32c-6.jpg") $fichier="treeJPG/e32c-6COR.nwk";
if ($embryo=="m32c-bitplane.jpg") $fichier="treeJPG/m32c-bitplaneCOR.nwk";
if ($embryo=="l32c.jpg") $fichier="treeJPG/l32cCOR.nwk";
if ($embryo=="e44c-bitplane.jpg") $fichier="treeJPG/e44c-bitplaneCOR.nwk";
if ($embryo=="m44c-bitplane.jpg") $fichier="treeJPG/m44c-bitplaneCOR.nwk";
if ($embryo=="m44c2.jpg") $fichier="treeJPG/m44c2COR.nwk";
$contenu = fread(fopen($fichier, "r"), filesize($fichier));
//print $contenu;
$nwk=$contenu;

?>
</td>
<td>&nbsp;</td>
<td>&nbsp;</td>
</tr>

<tr>
<td>&nbsp;</td>
<td>&nbsp;</td>
</tr>

<tr>
<td>
<h3><strong><em><u>Similarity tree</u></em></strong></h3>

<br> <!--Affichage des Fates si c choisis -->
<?

?>


<!-- Precalcul de la map -->

<map NAME="mymap0">

<?
$value=$embryo;
$ps=$fichier;
$ps=str_replace(".nwk",".ps",$ps);

$handle = @fopen($ps, "r");
$contenu="";
if ($handle) {
   while (!feof($handle)) {
       $contenu.= fgets($handle, 4096);
   }
}
fclose($handle);
$contenu=str_replace("\n","",$contenu);


$tab=split(" ",$contenu);



$blasto=(array) null;
for ($i=0;$i<count($tab);$i++)
	if (ereg ("([aAbB][0-9]+\.[0-9]+\*{0,1})", $tab[$i], $regs)) $blasto[count($blasto)]=$regs[1];

$result = array_reverse($blasto);

$ids=(array) null;
for ($i=0;$i<count($result);$i++)
{
$requete="SELECT \"ANAT_ID\" from \"ANAT_ENTITY\" where \"DEV_STAGE_ID\"='$dev' and \"NAME\"='".$result[$i]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$ids[count($ids)]=$row["ANAT_ID"];
}


$blastomere=(array) null;

$col=108;
$cell=count($result);
$pas=(1059-108)/($cell-1)+0.2; //Ajout 0.2 pour recaler ...

$coord=(array) null;
for ($i=0;$i<count($result);$i++)
{
//On retrieve les fates
$fat="SELECT \"KEYWORDS\" from \"FATE\" where \"ANAT_ID\"='".$ids[$i]."'";
$stmt=pg_query($c,$fat);
$fate="";
$res=(array) null;
while ($row=pg_fetch_array($stmt)) 
{
$fate.=$row["KEYWORDS"]." <br> ";
$res[count($res)]=$row["KEYWORDS"];
}

$fate=substr($fate,0,strlen($fate)-2);

$bobo=$col+20;
print '<AREA HREF="short_hierarchy.php?region='.$ids[$i].'&dev='.$dev.'" COORDS="705,'.$col.',750,'.$bobo.'" 
onmouseover="return escape(\'<u>Fate</u>: <br><b>'.$fate.'</b>\');">';
	$col+=$pas;

if ($fateP!=null) 
	{
	for ($k=0;$k<count($fateP);$k++)
		{
		if (in_array($fateP[$k],$res))
			{
			//print $result[$i]."<br>";
			$blastomere[count($blastomere)]=$result[$i];
			break;
			}
		}
	}

}


//On implode le tableau des fate
if ($blastomere!=null) 
	{
	$blastofate=implode(":",$blastomere);
	$fatePP=implode(":",$fateP);
	}


?>

</map>
<img src="psTree.php?embryo=<? print $embryo; ?>&ps=<? print $fichier; ?>&blastofate=<? print $blastofate;?>&fateP=<? print $fatePP; ?>" usemap="#mymap0" BORDER="0"/>
</td>
<td>&nbsp;</td>
</tr>
</table>

<?







/*
//Recup des paires de cellules qui correspondent (idem apres pour celles qui correspondent pas)

$paire=(array) null;
while (true)
{
if (ereg("(\([aAbB][0-9]+\.[0-9]+\*{0,1}\:[0-9]+\.[0-9]+\,[aAbB][0-9]+\.[0-9]+\*{0,1}\:[0-9]+\.[0-9]+\))",$nwk,$regs))
{
$nwk=str_replace($regs[1],"",$nwk);
$paire[count($paire)]=$regs[1];
}
else break;
}

$good=(array) null;
for ($i=0;$i<count($paire);$i++)
{
if (ereg("([aAbB][0-9]+\.[0-9]+\*{0,1})\:[0-9]+\.[0-9]+\,([aAbB][0-9]+\.[0-9]+\*{0,1})\:[0-9]+\.[0-9]+",$paire[$i],$regs)) {
if ($regs[1]."*"==$regs[2]) {$good[count($good)]=$regs[1];$good[count($good)]=$regs[2];}
if ($regs[1]==$regs[2]."*") {$good[count($good)]=$regs[1];$good[count($good)]=$regs[2];}
}
}

//print_r($paire);

$ids=(array) null;
for ($i=0;$i<count($paire);$i++)
{
$requete="SELECT \"ANAT_ID\" from \"ANAT_ENTITY\" where \"DEV_STAGE_ID\"='$dev' and \"NAME\"='".$result[$i]."'";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$ids[count($ids)]=$row["ANAT_ID"];
}


//Refine
$celllist=implode(":",$ids);
print '<center>';
print "<br><br>";
print '<h5>Click on Refine button to refine "good cell pairs" subset<br></h5>';
print '<form name="formulaire3" action="" method="post">';
		print '<input type="hidden" value="'.$celllist.'" name="celllist">';
		print'&nbsp;&nbsp;&nbsp;<input type="image" src="pictures/button-subset.jpg" onClick="javascript: window.document.formulaire3.action= window.document.formulaire3.redirect.value; submit;">';
		include("refine_anatomy.php");
			   
		print '</form>';

print '</center>';
*/





?>


<!--Rajout pour le tooltiptext -->
<script type="text/javascript" src="wz_tooltip.js"></script>
<?
include ("frames_footer.php");
?>