<html>
<head>
<title>ANISEED - Ascidian article (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page describes data related to Ciona intestinalis or Halocynthia roretzi article. Data could be expression data, anatomical data, genes studied in the article and pictures.">
<meta name="keywords" content="Aniseed, Ciona intestinalis, Halocynthia roretzi, Ciona intestinalis database, expression data, in situ hybridization, anatomical data, genes, genes function, regulation, article, paper, publication">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>


<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("connection.php");
include ("frames_header.php");

$pmid=$_GET["pmid"];

$web="http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?id=$pmid&db=pubmed&report=xml";
/*$handle = fopen($web, "rb");

$contents = '';
while (!feof($handle)) {
  $contents .= fread($handle, 8192);
}
fclose($handle);
*/

$resource=curl_init("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?id=".$pmid."&db=pubmed&report=xml");
curl_setopt($resource, CURLOPT_RETURNTRANSFER, 1);
$contents=curl_exec($resource);
curl_close($resource);




//Nom de l'article
$contents2=str_replace("&lt;ArticleTitle&gt;","§",$contents);
$contents2=str_replace("&lt;/ArticleTitle&gt;","§",$contents2);
$tab=split("§",$contents2);
$title=$tab[1];

//Nom du journal
$contents2=str_replace("&lt;MedlineTA&gt;","§",$contents);
$contents2=str_replace("&lt;/MedlineTA&gt;","§",$contents2);
$tab=split("§",$contents2);
$paper=$tab[1];

//Nom des auteurs
$contents2=str_replace("&lt;LastName&gt;","§",$contents);
$contents2=str_replace("&lt;/LastName&gt;","§",$contents2);
$tab=split("§",$contents2);
$auteurN=(array) null;
$auteurI=(array) null;
for ($i=1;$i<count($tab)-1;$i++)
	if ($i%2!=0) $auteurN[count($auteurN)]=$tab[$i];
$contents2=str_replace("&lt;Initials&gt;","§",$contents);
$contents2=str_replace("&lt;/Initials&gt;","§",$contents2);
$tab=split("§",$contents2);
for ($i=1;$i<count($tab)-1;$i++)
	if ($i%2!=0) $auteurI[count($auteurI)]=$tab[$i];
$auteur="";
for ($i=0;$i<count($auteurN)-1;$i++)
$auteur.=$auteurN[$i]." ".$auteurI[$i].", ";
$auteur.=$auteurN[count($auteurN)-1]." ".$auteurI[count($auteurN)-1];

//Le volume
$contents2=str_replace("&lt;Volume&gt;","§",$contents);
$contents2=str_replace("&lt;/Volume&gt;","§",$contents2);
$tab=split("§",$contents2);
$volume=$tab[1];

//L'issue
$contents2=str_replace("&lt;Issue&gt;","§",$contents);
$contents2=str_replace("&lt;/Issue&gt;","§",$contents2);
$tab=split("§",$contents2);
$issue=$tab[1];

//L'année
$contents2=str_replace("&lt;Year&gt;","§",$contents);
$contents2=str_replace("&lt;/Year&gt;","§",$contents2);
$tab=split("§",$contents2);
$year=$tab[1];

//la page
$contents2=str_replace("&lt;MedlinePgn&gt;","§",$contents);
$contents2=str_replace("&lt;/MedlinePgn&gt;","§",$contents2);
$tab=split("§",$contents2);
$page=$tab[1];


$paper.=". ".$year." ".$month.";".$volume."(".$issue."):".$page;

$contents=trim($contents);
$one=explode("AbstractText",$contents);
$tmp=$one[1];

$tmp=str_replace("&gt;","",$tmp); 
$tmp=str_replace("&lt;","",$tmp);
$tmp=substr($tmp,0,strlen($tmp)-1);

$abstract=$tmp;



print "<center><font color=\"#D64242\" size=\"2\"><b>". $title."</b></font></center><br>";
print "<center><font color=\"#656565\" size=\"1\"><b>".$auteur."</b></font></center><br>
<center><font color=\"#000000\" size=\"1\"><em>$paper</em></font></center><br>";


print "<div style=\"border-top:1px solid black;border-bottom:1px solid black;margin:10px;padding:10px;\"><font color=\"#656565\"><b><u>Abstract</u></b></font><br><br>$abstract</div>";



print "<div style=\"margin:10px;padding:10px;\">";

print "<br><font color=\"#D64242\" size=\"2\"><b>Data present in Aniseed database related to this article</b></font><br><br>";

//Prendre toutes les molecules qui sont référencées dans cet article

/*$requete="select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (select \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'))";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
$name=$row["NAME"];

}
*/

$tname=(array) null;
$requete="

select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in(select \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\" in (select \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'))))))
UNION
select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (select \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\" in (
select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid')))))
UNION
select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (select \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n'  and \"IN_SITU_ID\" in  (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid')))))
UNION
select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (
select \"TRANSCRIPT_ID\" from \"TRANSCRIPT\" where \"ABSTRACT_ID\" in (select distinct \"ANISEED_ENSEMBL_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\" in(select \"CLONE_NAME\" from \"CLONE\" where \"CLONE_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n'  and \"IN_SITU_ID\" in  (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid')))))))
UNION
select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (select distinct \"ANISEED_KYOTO_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\" in( select \"CLONE_NAME\" from \"CLONE\" where \"CLONE_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"IN_SITU_ID\" in  (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'))))))
UNION
select \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\" in (select distinct \"ANISEED_CLUSTER_ID\" from \"CLONE_SEQ\" where \"CLONE_NAME\" in(select \"CLONE_NAME\" from \"CLONE\" where \"CLONE_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n'  and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'))))))
UNION
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (select distinct \"TARGET_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"IN_SITU_ID\" in  (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'))))";

$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
$name=$row["NAME"];
//TRAITEMENT SUR KYOTO
if ($name{0}=="K")
	{
	$requete0="select \"NAME\" from \"MOL_ENTITY\" where \"NAME\" like '$name.%' and \"TYPE\"<>'abstract'";
	$stmt0=pg_query($c,$requete0);
	while ($row0=pg_fetch_array($stmt0))
		{
		//print $row0["NAME"];
		$tname[count($tname)]=$row0["NAME"];
		}
	}
else
{
//print $name;
$tname[count($tname)]=$name;
}


}


print "Expression data:<br>
<font color=\"#656565\">View all In Situ Hybridization data from this article: </font><a href=\"insitu-result.php?pmid=$pmid\"><font color=\"#000000\">View</font></a><br><br>";

print "Gene Models match: <br>";

////// NOUVEAUTE pour les GENEmodels

$gm=(array) null;
for ($i=0;$i<count($tname);$i++)
{
$requete="SELECT \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\"=(
select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$tname[$i]."'
)";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$gm[count($gm)]=$row["GENE_CLUSTER_ID"];
}

$gm=array_unique($gm);

for ($i=0;$i<count($gm);$i++)
{
if (strlen($gm[$i])==0) continue;
print "<font color=\"#656565\"><b>".(str_replace("cluster","aniseedV3",$gm[$i]))."</b>: ";

$gene_name="";
$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$gm[$i]."'";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if (strlen($gene_name)==0) $gene_name=$row["GENE_CLUSTER_NAME"];
else $gene_name.=" / ".$row["GENE_CLUSTER_NAME"];
}

print $gene_name;

print "</font>";

print "&nbsp;&nbsp;<a href=\"gene-card.php?clusterid=".$gm[$i]."\">View</a>";
print "<br>";

}

/*
for ($i=0;$i<count($tname);$i++)
{
print "<font color=\"#656565\">".$tname[$i]." ";

$requete="
select \"SYNO\" from \"SYNO\" where \"GENE_ID\" in( 
SELECT \"GENE_ID\" from \"SYNO\" where \"SYNO\"='".$tname[$i]."'
) and \"SYNO\"<>'".$tname[$i]."'
";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
	{
	print $row["SYNO"]." / ";
	}

print "</font>";
print "<a href=\"molecule-gene.php?name=".$tname[$i]."\">View</a>";
print "<br>";

}
*/
print "<br>";

print "Developmental stage match<br>";
$requete="SELECT \"NAME\",\"SPECIES\" from \"DEV_STAGE\" where \"DEV_STAGE_ID\" in (
select \"DEV_STAGE_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n'  and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
)))
) order by \"DEV_PERCENT\"";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
print "<font color=\"#656565\">".$row["NAME"]."</font><br>";
}

print "<br>";



print "Anatomical ontology match in Wild type embryos<br>";
$tmp="";
$requete="SELECT distinct anat.\"NAME\",anat.\"ANAT_ID\",anat.\"DEV_STAGE_ID\",anat.\"SPECIES\",dev.\"NAME\" as \"DEV\" from \"ANAT_ENTITY\" anat,\"DEV_STAGE\" dev where anat.\"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='y' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
)))
) and anat.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\"";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if ($row["NAME"]=="Whole embryo") continue;
if ($row["NAME"]=="Whole egg") continue;
if ($row["NAME"]=="No expression") continue;
$tmp="<font color=\"#656565\">".$row["NAME"]."</font><br>";
print "<font color=\"#656565\">".$row["NAME"]."  (".$row["DEV"].")</font>&nbsp;&nbsp;<a href=\"anatomy.php?species=".$row["SPECIES"]."&dev=".$row["DEV_STAGE_ID"]."&region=".$row["ANAT_ID"]."\">View</a><br>";
}
if (strlen($tmp)==0) print "<font color=\"#656565\">No Match</font><br>";
$tmp="";

print "<br>";
print "Anatomical ontology match in Mutant embryos<br>";
$tmp="";
$requete="SELECT distinct \"NAME\",\"ANAT_ID\",\"DEV_STAGE_ID\",\"SPECIES\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='n' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
)))
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if ($row["NAME"]=="Whole embryo") continue;
if ($row["NAME"]=="Whole egg") continue;
if ($row["NAME"]=="No expression") continue;
$tmp="<font color=\"#656565\">".$row["NAME"]."</font><br>";
print "<font color=\"#656565\">".$row["NAME"]."</font>&nbsp;&nbsp;<a href=\"anatomy.php?species=".$row["SPECIES"]."&dev=".$row["DEV_STAGE_ID"]."&region=".$row["ANAT_ID"]."\">View</a><br>";
}
if (strlen($tmp)==0) print "<font color=\"#656565\">No Match</font><br>";
$tmp="";


print "<br>";
print "Fate match in Wild type embryos<br>";
$tmp="";
$requete="
select distinct fate.\"KEYWORDS\" from \"FATE\" fate,\"ANAT_ENTITY\" anat where fate.\"ANAT_ID\" in (
SELECT \"ANAT_ID\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='y' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
)
)
))) and anat.\"ANAT_ID\"=fate.\"ANAT_ID\"";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if ($row["NAME"]=="Whole egg") continue;
if ($row["NAME"]=="Whole embryo") continue;
if ($row["NAME"]=="No expression") continue;
$tmp="<font color=\"#656565\">".$row["KEYWORDS"]."</font><br>";
print "<font color=\"#656565\">".$row["KEYWORDS"]."</font><br>";
}
if (strlen($tmp)==0) print "<font color=\"#656565\">No Match</font><br>";
$tmp="";


print "<br>";
print "Fate match in Mutant embryos:<br>";
$tmp="";
$requete="
select distinct fate.\"KEYWORDS\" from \"FATE\" fate,\"ANAT_ENTITY\" anat where fate.\"ANAT_ID\" in (
SELECT \"ANAT_ID\" from \"ANAT_ENTITY\" where \"ANAT_ID\" in (
select \"REGION_ID\" from \"TARGET\" where \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='n' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
)
)
))) and anat.\"ANAT_ID\"=fate.\"ANAT_ID\"";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if ($row["NAME"]=="Whole egg") continue;
if ($row["NAME"]=="Whole embryo") continue;
if ($row["NAME"]=="No expression") continue;
$tmp="<font color=\"#656565\">".$row["KEYWORDS"]."</font><br>";
print "<font color=\"#656565\">".$row["KEYWORDS"]."</font><br>";
}
if (strlen($tmp)==0) print "<font color=\"#656565\">No Match</font><br>";
$tmp="";


print "<br>";
print "Pictures of embryos in Wild type context<br><br>";
$tmp="";

$requete="SELECT pic.\"PICTURE_ID\",pic.\"IN_SITU_ID\",pic.\"PATH\" FROM \"PICTURE\" pic,\"IN_SITU\" ish,\"DEV_STAGE\" dev WHERE pic.\"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='y' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
))) and pic.\"CONTROL\" IS NULL  and pic.\"IN_SITU_ID\"=ish.\"IN_SITU_ID\" and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"";		
$stmtpic = pg_query($c,$requete);
print "<center>";
if (pg_num_rows($stmtpic)==0) print "<font color=\"#656565\">No Match</font><br>";
else 
{
if (pg_num_rows($stmtpic)>100) 
		{
		print "<font color=\"#656565\">Too much results</font><br>";
		print "<a href=\"insitu-result.php?pmid=$pmid\">View all ISHs from this article</a>";
		
		}
else
		{
while($row3=pg_fetch_array($stmtpic)){
$idpicture=$row3["PICTURE_ID"];
$id=$row3["IN_SITU_ID"];
if(strlen($row3["PATH"])>0)
{
if (!preg_match("/mix/",$row3["PATH"]))
echo "<a href=\"insitu.php?id=$id\"><img src=\"picturesDB/".$row3["PATH"]."\" border=1 width=\"100\" name=\"pics\"></a> ";
}
else
echo "<a href=\"insitu.php?id=$id\"><img src=\"picture-mini.php?id=$idpicture\" border=1 width=\"100\" name=\"pics\"></a> ";
}
		}
}
print "</center>";


print "<br>";
print "Pictures of embryos in Mutant context<br><br>";
$tmp="";

$requete="SELECT pic.\"PICTURE_ID\",pic.\"IN_SITU_ID\",pic.\"PATH\" FROM \"PICTURE\" pic,\"IN_SITU\" ish,\"DEV_STAGE\" dev WHERE pic.\"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' and \"PRIVATE\"='n' and \"WILD_TYPE\"='n' and \"IN_SITU_ID\" in (select \"IN_SITU_ID\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
select \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='$pmid'
))) and pic.\"CONTROL\" IS NULL  and pic.\"IN_SITU_ID\"=ish.\"IN_SITU_ID\" and ish.\"DEV_STAGE_ID\"=dev.\"DEV_STAGE_ID\" order by dev.\"DEV_PERCENT\"";		
$stmtpic = pg_query($c,$requete);
print "<center>";
if (pg_num_rows($stmtpic)==0) print "</center><font color=\"#656565\">No Match</font><br>";
else 
{
if (pg_num_rows($stmtpic)>100) 
		{
		print "<font color=\"#656565\">Too much results</font><br>";
		print "<a href=\"insitu-result.php?pmid=$pmid\">View all ISHs from this article</a>";
		
		}
else
		{
while($row3=pg_fetch_array($stmtpic)){
$idpicture=$row3["PICTURE_ID"];
$id=$row3["IN_SITU_ID"];
if(strlen($row3["PATH"])>0)
{
if (!preg_match("/mix/",$row3["PATH"]))
echo "<a href=\"insitu.php?id=$id\"><img src=\"picturesDB/".$row3["PATH"]."\" border=1 width=\"100\" name=\"pics\"></a> ";
}
else
echo "<a href=\"insitu.php?id=$id\"><img src=\"picture-mini.php?id=$idpicture\" border=1 width=\"100\" name=\"pics\"></a> ";
}
		}
}
print "</center>";



print "</div>";

include ("frames_footer.php");

?>