<html>
<head>
<title>ANISEED - What are ascidians?</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="Aniseed is applied for the moment to early ascidians (Ciona intestinalis and Halocynthia roretzi). Ascidians, which are marine invertebrate
chordates, are model organisms of choice because their embryos develop with a small number of cells and an invariant lineage.
Moreover, ascidians display a larval body plan similar to that of vertebrates.">
<meta name="keywords" content="Aniseed, Ciona intestinalis, Halocynthia roretzi, ciona intestinalis database, invertebrate, chordate, larval body plan, development, Tassy, Lemaire, Daian, Dauga, Sobral, Khoueiry">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("frames_header.php");
?>



<font size="+2" color="#D64242">What are ascidians?</font> 
<font color="#000000" size="-1">
        <p>Ascidians, or sea squirts, are invertebrate chordates, which diverged from 
  the vertebrate lineage near the root of the chordate phylogenetic tree. Their 
  larvae have a tadpole structure that closely resembles lower vertebrate larvae: 
  they have a dorsal hollow nerve cord and a central notochord flanked by skeletal 
  muscle cells. Comparison of present day ascidians with the lower Cambrian fossil 
  record indicates that the adult morphology of these animals has not significantly 
  changed since these remote times. Their study is likely to give us key information 
  about the emergence of the chordate lineage. </p>
<p>In addition to their evolutionary interest, ascidian larvae are composed of 
  a very small number of cells (2600 for the tadpole of Ciona intestinalis) and 
  are therefore simpler to study than vertebrate embryos. They have an invariant 
  cleavage pattern, a rapid development, and their lineage has been determined 
  up to the gastrula stage. These characteristics suggest that it is possible 
  to describe ascidian development at the single-cell level of resolution, a level 
  of precision that has so far only been reached in nematodes. </p>
<p>This morphological simplicity is paralleled by the simplicity of the Ciona 
  intestinalis genome, which has been sequenced and assembled (Joint Genome Institute, 
  USA and Kyoto university, Japan, http://genome.jgi-psf.org/ciona/). This genome 
  is similar in size and gene density to Drosophila and C. elegans and most genes 
  present in 2-4 copies in the vertebrate genomes have a single Ciona orthologue 
  (Dehal et al., 2002). The genome of a second species, Ciona savignyi, has recently 
  been released by the MIT (http://www.broad.mit.edu/annotation/ciona/), opening 
  the way to cross species comparisons. This genomic effort has been complemented 
  by several large-scale in situ hybridisation (ISH) screens. These screens have 
  provided a wealth of molecular markers or effectors for the different embryonic 
  tissues. </p>
<p>Recent years have seen the development of powerful molecular techniques such 
  as mRNA injections, gene loss-of-function by injection of antisense morpholino 
  oligonucleotides and transient transgenesis by egg electroporation. In particular, 
  transgenesis by electroporation allows a rapid characterisation of cis-regulatory 
  sequences. In most cases so far studied, the key regulatory sequences that drive 
  the expression of tissue specific genes are found within 2kb of the transcription 
  start site. As a result, precise direct regulatory networks are emerging for 
  the notochord, endoderm and muscle lineages and it is expected that ascidians 
  will make a major contribution to the deciphering of chordate gene regulatory 
  networks. Finally, Ciona is hermaphroditic with a life cycle of about 2 months, 
  two features that encourage the use of genetic approaches to study ascidian 
  embryonic patterning. The combination of these favourable experimental characteristics 
  and of a key phylogenetic position justifies the renewed interest for this model 
  system.</p>
</font>
<font color="#656565">
<p><u><strong>Selected references:</strong></u></p>
<p>Satoh N, Satou Y, Davidson B, Levine M.2003 Ciona intestinalis: an emerging 
  model for whole-genome analyses. Trends Genet. 19(7):376-81.</p>
<p>Satoh N. 2003 The ascidian tadpole larva: comparative molecular development 
  and genomics.<br>
  Nat Rev Genet. 4:285-95. </p>
<p>Dehal P, Satou Y, et al. 2002 The draft genome of Ciona intestinalis: insights 
  into chordate and vertebrate origins. Science. 298(5601):2157-67</p>
<p>Nishida H. 2002 Patterning the marginal zone of early ascidian embryos: localized 
  maternal mRNA and inductive interactions. Bioessays. 24(7):613-24.</p>
<p>Nishida H. 2002 Specification of developmental fates in ascidian embryos: molecular 
  approach to maternal determinants and signaling molecules. Int Rev Cytol. 217:227-76</p>
<p>Meinertzhagen, IA, Lemaire, P., and Okamura, Y. 2004 The Neurobiology of the 
  Ascidian Tadpole Larva: Recent Developments in an Ancient Chordate. Ann. Rev. 
  Neurosci. In press.</p>
<p>Nakatani Y, Moody R, Smith WC. 1999 Mutations affecting tail and notochord 
  development in the ascidian Ciona savignyi. Development. 126(15):3293-301. <br>
</p>
</font>

<?php
    include("frames_footer.php");
?> 
