<html>
<head>
<title>ANISEED - Anisearch results (Ciona intestinalis, Halocynthia roretzi keyword search)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="This page is the results of a search by Ciona intesinalis or Halocynthia roretzy keyword. Results are classified according to GO term, molecules, genes, in situ hybridization comments, best blast hits, articles">
<meta name="keywords" content="Aniseed, Ciona intestinalis, Halocynthia roretzi, articles, blast, in situ experiment, in situ hybridization, anatomical ontology, tunicate, Gene Ontology, Interpro domain, ascidian database, ciona intestinalis database">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>


<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include ("connection.php");

include ("frames_header.php");

$css="text-decoration:none; color:green; text-align:center; background-color:transparent; padding:5px border-width:0px;border-style:none;border-color:blue;font-family: Arial, Helvetica, sans-serif ;font-size: 9pt;";


?>

<!-- Pour cacher et decacher -->
<script language="JavaScript">
<!--
function changediv(nameid, img1, img2){
    var obj = window.document.getElementById(nameid);
    var obj2 = window.document.getElementById('img' + nameid);
    if(obj==null || obj2==null){
      //window.alert("JavaScript error: contact sobral@ibdm.univ-mrs.fr");
	;
    } else {
        if(obj.style.display=='block'){
           obj.style.display='none';
           obj2.src = img1+'.gif';
        } else {
           obj.style.display='block';
           obj2.src = img2+'.gif';
        }
    }
}
-->
</script>

<style>
    div.hideme { display: none }
    <!-- mais ca ne marche pas... :( -->
    div.showme { display: block }
</style>



<?

//print_r($_POST);

$search=$_POST["search"];
if (strlen($search)==0) $search=$_GET["search"];

$search=trim($search);
//print "SEARCH=$search";

//////////////////////////////// ADD to allow search by aniseed gene model id ////////////////////////
$tsearch=strtoupper($search);
$tsearch=str_replace(" ","_",$tsearch);

$requete="SELECT \"GENE_CLUSTER_ID\",\"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where upper(\"GENE_CLUSTER_ID\")= '".str_replace("ANISEEDV3_","CLUSTER",$tsearch)."'";
$stmt=pg_query($c,$requete);
// print $requete;
$tsname="";
$tsid="";
while ($row=pg_fetch_array($stmt))
{
$tsid=$row["GENE_CLUSTER_ID"];
if (strlen($tsname)==0) $tsname=$row["GENE_CLUSTER_NAME"]; else $tsname.=" / ".$row["GENE_CLUSTER_NAME"];
}

if (strlen($tsid)>0) $tMOL[count($tMOL)]="$tsid@$tsname";
 //print_r($tMOL);
$tsname="";

//////////////////////////////////////////////////////////////////////////////////////////////////////





$IP=$_SERVER["REMOTE_ADDR"]; 

if ($IP!=$instituteAddress)
{
//AJOUT TEMPORAIRE POUR LA TRACE SUR L'OUTIL ANISEARCH
$requete="INSERT INTO \"LOG_TOOL\" (\"TOOL\",\"COMMENTS\") values ('ANISEARCH','$search')";
pg_query($c,"begin");
pg_query($c,$requete);
pg_query($c,"commit");
//FIN AJOUT POUR LA TRACE SUR L'OUTIL ANISEARCH
}

if (strlen($search)==0) {print "Please choose terms you want to search for !";include ("frames_footer.php");return;}

$OP=$_POST["OP"];

/*$JOK=$_POST["term"];
if (strlen($JOK)>0) $JOK=""; else $JOK=" ";*/


$OPWhole="";
if ($OP=="whole") {$search=str_replace(" ","_",$search);/*$OP="AND";*/$OPWhole="whole";}


//Requete sur les GO term
$GO_TERM=""; //Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//print_r($words);
//RAJOUT
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//print_r($words);
//
$query="(UPPER(\"GO_TERM\") like '%$words[0]%')";
//for($a=1; $a<count($words); ++$a) $query .= " and (UPPER(\"GO_TERM\") like '%$words[$a]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"GO_TERM\") like '%$words[$a]%')";
$requete2="select \"GO_ID\", \"GO_TERM\", \"GO_TYPE\", \"DEFINITION\" from \"GO\" where ".$query;
$query=pg_query($c,$requete2);
//print $requete2;
$GO_TERM=pg_num_rows($query);
$tGO_TERM=(array) null;
//print $requete2."<br>";
while ($row=pg_fetch_array($query)) $tGO_TERM[count($tGO_TERM)]=$row["GO_ID"]."@".$row["GO_TERM"]."@".$row["DEFINITION"];
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//Requete sur les GO definition
$GO_DEF=""; //Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"DEFINITION\") like '%$words[0]%')";
//for($a=1; $a<count($words); ++$a) $query .= " and (UPPER(\"GO_TERM\") like '%$words[$a]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"DEFINITION\") like '%$words[$a]%')";
$requete2="select \"GO_ID\",\"GO_TERM\",\"GO_TYPE\",\"DEFINITION\" from \"GO\" where ".$query;
$query=pg_query($c,$requete2);
$GO_DEF=pg_num_rows($query);
//print $requete2;
while ($row=pg_fetch_array($query)) $tGO_DEF[count($tGO_DEF)]=$row["GO_ID"]."@".$row["GO_TERM"]."@".$row["DEFINITION"];

/////////////////////////////////////////////////////

//Requete sur les IPR term
$IP_TERM="";//Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";

$requete2="select \"IP_ID\", \"NAME\", \"TYPE\" from \"INTERPRO\" where ".$query." order by \"TYPE\"";
$stmt2 = pg_query($c,$requete2);
$IP_TERM=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) $tIP_TERM[count($tIP_TERM)]=$row["IP_ID"]."@".$row["NAME"]."@".$row["TYPE"];
/////////////////////////////////////////////////////

//Requete sur les commentaires d'ISH
$ISH_COMMENTS="";//Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"IM_COMMENTS\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"IM_COMMENTS\") like '%$words[$a]%')";
$requete2="select \"IN_SITU_ID\",\"IM_COMMENTS\" from \"IN_SITU\" where ".$query." and \"CHECKED\"='y' and \"PRIVATE\"='n'";
$stmt2 = pg_query($c,$requete2);
$ISH_COMMENTS=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2))
{
//print $row["IN_SITU_ID"]."<br>";
 $tISH_COMMENTS[count($tISH_COMMENTS)]=$row["IN_SITU_ID"]."@".$row["IM_COMMENTS"];
}
/////////////////////////////////////////////////////

//Requete sur les titres de references
$REFERENCE="";//Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"TITLE\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"TITLE\") like '%$words[$a]%')";
$requete2="select distinct \"PUBMED_ID\",\"TITLE\" from \"REFERENCE\" where ".$query." AND \"PUBMED_ID\" is not null";
$stmt2 = pg_query($c,$requete2);
$REFERENCE=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
	{
	if (strlen(trim($row["PUBMED_ID"]))==0) continue;
	$tREFERENCE[count($tREFERENCE)]=$row["PUBMED_ID"]."@".$row["TITLE"];
	}
/////////////////////////////////////////////////////

//Requete sur les Authors
$AUTHOR="";//Variable
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"AUTHORS\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"AUTHORS\") like '%$words[$a]%')";
$requete2="select distinct \"PUBMED_ID\",\"AUTHORS\",\"TITLE\" from \"REFERENCE\" where ".$query." AND \"PUBMED_ID\" is not null";
$stmt2 = pg_query($c,$requete2);
$AUTHOR=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
	{
	if (strlen(trim($row["PUBMED_ID"]))==0) continue;
	$tAUTHOR[count($tAUTHOR)]=$row["PUBMED_ID"]."@".$row["AUTHORS"]."@".$row["TITLE"];
	}
/////////////////////////////////////////////////////



//Requete sur l'anatomy
$ANATOM="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";
$requete2="select distinct \"ANAT_ID\",\"NAME\",\"DEV_STAGE_ID\",\"SPECIES\" from \"ANAT_ENTITY\" where ".$query;
$stmt2 = pg_query($c,$requete2);
$ANATOM=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2))
{
$requete2="select \"NAME\" from \"DEV_STAGE\" where \"DEV_STAGE_ID\"='".$row["DEV_STAGE_ID"]."' and \"SPECIES\"='".$row["SPECIES"]."'";
$stmt3 = pg_query($c,$requete2);
$row2=pg_fetch_array($stmt3);
$tANATOM[count($tANATOM)]=$row["ANAT_ID"]."@".$row["NAME"]."@".$row["DEV_STAGE_ID"]."@".$row["SPECIES"]."@".$row2["NAME"];
}

//////////////////////////////////////////////////////
//Implementation assez lourde suivant le type de requete
/*
//Requete sur les annotations d'ISH
$ISH_ANNOT="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";
//for($a=1; $a<count($words); ++$a) $query .= " AND (\"NAME\" like '%$words[$a]%')";
$requete2="select distinct \"IN_SITU_ID\" from \"IN_SITU\" where \"CHECKED\"='y' AND \"IN_SITU_ID\" in(select distinct \"IN_SITU_ID\" from \"TARGET\" where \"REGION_ID\" in (select distinct \"ANAT_ID\" from \"ANAT_ENTITY\" where ".$query."))";
$stmt2 = pg_query($c,$requete2);
$ISH_ANNOT=pg_num_rows($stmt2);
////////////////////////////////////////////////////////
*/

/////////////////////////////////////////////////////
//Requete sur les Fates
$FATE="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"KEYWORDS\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"KEYWORDS\") like '%$words[$a]%')";
$requete2="select distinct \"KEYWORDS\" from \"FATE\" where ".$query;
$stmt2 = pg_query($c,$requete2);
$FATE=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) $tFATE[count($tFATE)]=$row["KEYWORDS"];
/////////////////////////////////////////////////////
if ($_POST["blast"]=="blast")
{
//Requete sur les BLAST
$BLAST="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"DESCRIPTION\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"DESCRIPTION\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";
$requete2="select \"MOL_ID\",\"DESCRIPTION\",\"EVALUE\" from \"BLAST\" where ".$query. "ORDER BY cast(\"EVALUE\" as float)";
$stmt2 = pg_query($c,$requete2);
$BLAST=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$requete3="SELECT \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"='".$row["MOL_ID"]."'";
$stmt3=pg_query($c,$requete3);
$row2=pg_fetch_array($stmt3);
//$tBLAST[count($tBLAST)]=$row["MOL_ID"]."@".$row["DESCRIPTION"]."@".$row2["NAME"];
$tBLAST[count($tBLAST)]=$row["MOL_ID"]."@".$row["DESCRIPTION"]."@".$row2["NAME"]."@".$row["EVALUE"];
}
}
/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
if ($_POST["ortho"]=="ortho")
{
//Requete sur les PROTEIN FAMILLY
$FAM="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"FAMILLY\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"FAMILLY\") like '%$words[$a]%')";
$requete2="select \"MOL_ID\",\"FAMILLY\",\"SPECIES\",\"ORTHOLOG\" from \"PHYLOGENY\" where ".$query;
$stmt2 = pg_query($c,$requete2);
$FAM=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$requete3="SELECT \"NAME\" from \"MOL_ENTITY\" where \"MOL_ID\"='".$row["MOL_ID"]."'";
$stmt3=pg_query($c,$requete3);
$row2=pg_fetch_array($stmt3);
$tFAM[count($tFAM)]=$row["MOL_ID"]."@".$row["FAMILLY"]."@".$row2["NAME"]."@".$row["SPECIES"]."@".$row["ORTHOLOG"];
}
}
/////////////////////////////////////////////////////


//Requete sur les PROMOTER ////////////////////////////////////
$PROMOTER="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";
$requete2="select \"PROMOTER_ID\",\"NAME\",\"COMMENTS\" from \"PROMOTER\" where ".$query." and \"CHECKED\"='y' and \"PRIVATE\"='n'";
$stmt2 = pg_query($c,$requete2);
$PROMOTER=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$tPROMOTER[count($tPROMOTER)]=$row["PROMOTER_ID"]."@".$row["NAME"]."@".$row["COMMENTS"];
}


//////////////////////////////////////////////////////////////


//Requete sur les PROMOTER COMMENTS ////////////////////////////////////
$PROMOTERCOM="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"COMMENTS\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"COMMENTS\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";
$requete2="select \"PROMOTER_ID\",\"NAME\",\"COMMENTS\" from \"PROMOTER\" where ".$query." and \"CHECKED\"='y' and \"PRIVATE\"='n'";
$stmt2 = pg_query($c,$requete2);
$PROMOTERCOM=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$tPROMOTERCOM[count($tPROMOTERCOM)]=$row["PROMOTER_ID"]."@".$row["NAME"]."@".$row["COMMENTS"];
}


//////////////////////////////////////////////////////////////


/*
//Requete sur les CONSTRUCTIONS ////////////////////////////////////
$CONSTRUCTION="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";


//$requete2="select \"CONSTRUCTION_ID\",\"NAME\",\"COMMENTS\" from \"CONSTRUCTION\" where ".$query;

$requete2="

select \"CONSTRUCTION_ID\",\"NAME\",\"COMMENTS\" from \"CONSTRUCTION\" where \"PROMOTER_ID\" in (
select \"PROMOTER_ID\" from \"CONSTRUCTION\" where ".$query." 
INTERSECT
SELECT \"PROMOTER_ID\" from \"PROMOTER\" where \"CHECKED\"='y' and \"PRIVATE\"='n'
)
";

//print $requete2;


$stmt2 = pg_query($c,$requete2);
$CONSTRUCTION=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$tCONSTRUCTION[count($tCONSTRUCTION)]=$row["CONSTRUCTION_ID"]."@".$row["NAME"]."@".$row["COMMENTS"];
}

//////////////////////////////////////////////////////////////




//Requete sur les CONSTRUCTION COMMENTS//////////////////////
$CONSTRUCTIONCOM="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"COMMENTS\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"COMMENTS\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";
$requete2="select \"CONSTRUCTION_ID\",\"NAME\",\"COMMENTS\" from \"CONSTRUCTION\" where ".$query;
$stmt2 = pg_query($c,$requete2);
$CONSTRUCTIONCOM=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$tCONSTRUCTIONCOM[count($tCONSTRUCTIONCOM)]=$row["CONSTRUCTION_ID"]."@".$row["NAME"]."@".$row["COMMENTS"];
}

//////////////////////////////////////////////////////////////

*/



//Requete sur les MOLECULAR_TOOL//////////////////////
$MOLTOOL="";
$term=$search;
$term=strtoupper($term);
$words = split (" ", $term);
//RAJOUT
//if (count($words)<1) $words[0]=str_replace("_"," ",$search);
if (count($words)==1) {$words[0]=str_replace("_"," ",$term);}
//
$query="(UPPER(\"NAME\") like '%$words[0]%')";
for($a=1; $a<count($words); ++$a) $query .= " $OP (UPPER(\"NAME\") like '%$words[$a]%')";
//$requete2="select \"MOL_ID\",\"DESCRIPTION\" from \"BLAST\" where ".$query. "ORDER BY \"SCORE\"";
$requete2="select \"MOLECULAR_TOOL_ID\",\"NAME\",\"TYPE\" from \"MOLECULAR_TOOL\" where ".$query;
$stmt2 = pg_query($c,$requete2);
$MOLTOOL=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$tMOLTOOL[count($tMOLTOOL)]=$row["MOLECULAR_TOOL_ID"]."@".$row["NAME"]."@".$row["TYPE"];
}

//////////////////////////////////////////////////////////////


/*
//Recherche sur les molecules
$MOL=0;
$name=$search;
$name=strtoupper($name);
$name=ereg_replace("^ +","",$name);
$name=ereg_replace(" +$","",$name);

$name=strtoupper($search);
$name=ereg_replace("[^a-zA-Z0-9]"," ",$name);
$name=ereg_replace("([a-zA-Z])([0-9])","\\1 \\2",$name);
$name=ereg_replace("([0-9])([a-zA-Z])","\\1 \\2",$name);
$name=ereg_replace(" +"," ",$name);
$name=ereg_replace("^ ","",$name);
$name=ereg_replace(" $","",$name);
$term=$name;
//RAJOUT
if ($OP=="whole") {$term=str_replace(" ","_",$term);$OP="AND";}
//
//print $term;
$wordsTMP = split (" ", $term);
//RAJOUT
if (count($wordsTMP)<=1) $wordsTMP[0]=str_replace("_"," ",$term);
//
$query="";
$query="(\"SYNO_UPPER_CASE\" like '%$wordsTMP[0]%')";
for($a=1; $a<count($wordsTMP); ++$a) {
$query .= " $OP (\"SYNO_UPPER_CASE\" like '%$wordsTMP[$a]%')";
}
if (strlen($query)>0)
{
$requete2="SELECT distinct \"GENE_ID\",\"SYNO\" from \"SYNO\" where $query";
$stmt2 = pg_query($c,$requete2);
$MOL+=pg_num_rows($stmt2);
while ($row=pg_fetch_array($stmt2)) 
{
$requete3="SELECT \"NAME\" from \"GENE\" where \"GENE_ID\"='".$row["GENE_ID"]."'";
$stmt3=pg_query($c,$requete3);
$row2=pg_fetch_array($stmt3);
$tMOL[count($tMOL)]=$row["GENE_ID"]."@".$row["SYNO"]."@".$row2["NAME"];
}
//print $requete2;
}
//////////////////////////////////////////////////////////////////////
*/


////// On etend la recherche non plus aux transcrits, mais aux genes
$MOL=0;
$name=$search;
$name=strtoupper($name);
$name=ereg_replace("^ +","",$name);
$name=ereg_replace(" +$","",$name);

$name=strtoupper($search);
$name=ereg_replace("[^a-zA-Z0-9]"," ",$name);
$name=ereg_replace("([a-zA-Z])([0-9])","\\1  \\2",$name);
$name=ereg_replace("([0-9])([a-zA-Z])","\\1  \\2",$name);
$name=ereg_replace(" +"," ",$name);
$name=ereg_replace("^ ","",$name);
$name=ereg_replace(" $","",$name);
$term=$name;

// print "===>".$term."<br>";


/////// Rustine ////////

if (strstr($term,"KYOTOGRAIL")) $OP="whole";

/////////////////////////


//RAJOUT
if ($OP=="whole") {$term=str_replace(" ","_",$term);$OP="AND";}
//
//print $term;
$wordsTMP = split (" ", $term);
//RAJOUT
if (count($wordsTMP)<=1) $wordsTMP[0]=str_replace("_"," ",$term);
//
$query="";
$query="(\"SYNO_UPPER_CASE\" like '%$wordsTMP[0]%')";
for($a=1; $a<count($wordsTMP); ++$a) {
$query .= " $OP (\"SYNO_UPPER_CASE\" like '%$wordsTMP[$a]%')";
}
if (strlen($query)>0)
{
$requete2="
select distinct \"GENE_CLUSTER_ID\" from \"GENE_CONCEPT\" where \"GENE_MODEL_ID\" in (
SELECT distinct \"GENE_ID\" from \"SYNO\" where $query)";
$stmt2 = pg_query($c,$requete2);
$MOL+=pg_num_rows($stmt2);


while ($row=pg_fetch_array($stmt2)) 
{
$requete3="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".$row["GENE_CLUSTER_ID"]."'";
$stmt3=pg_query($c,$requete3);
$gene_cluster_name="";
while ($row2=pg_fetch_array($stmt3))
	{
	if (strlen($gene_cluster_name)==0) $gene_cluster_name=$row2["GENE_CLUSTER_NAME"];
	else $gene_cluster_name.=" / ".$row2["GENE_CLUSTER_NAME"];
	}
$tMOL[count($tMOL)]=$row["GENE_CLUSTER_ID"]."@".$gene_cluster_name;



}
// print $requete2;
}

////////////RAJOUT/////////////
/*
if (count($tMOL)==0)
	{
	$requete0="SELECT \"GENE_CLUSTER_ID\",\"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='".str_replace("aniseedV3_","cluster",$wordsTMP[0])."'";
	print $requete0;
	$stmt0=pg_query($c,$requete0);
	$row0=pg_fetch_array($stmt0);
	$MOL[count($tMOL)]=$row0["GENE_CLUSTER_ID"]."@".$row0["GENE_CLUSTER_NAME"];
	}
*/


///////////////////////////////


/*
$TOTAL=$GO_TERM+$GO_DEF+$IP_TERM+$ISH_COMMENTS+$REFERENCE+$AUTHOR+$ANATOM+$FATE+$BLAST+$FAM+$PROMOTER+$PROMOTERCOM+$CONSTRUCTION+$CONSTRUCTIONCOM+$MOLTOOL+$MOL;

if ($TOTAL==1) print "LUCKY";

print "======>".$TOTAL."<br>";
*/




?>

<table width="99%">
<tr align="center">
<td background="white">
<!--<h2> 
<font face="sans-serif" color="red">A</font>
<font face="sans-serif" color="blue">N</font>
<font face="sans-serif" color="yellow">I</font>
<font face="sans-serif" color="#00FF00">S</font>
<font face="sans-serif" color="red">E</font>
<font face="sans-serif" color="blue">A</font>
<font face="sans-serif" color="yellow">R</font>
<font face="sans-serif" color="#00FF00">C</font>
<font face="sans-serif" color="red">H</font>
</h2>-->
<img src="pictures/anisearch_res.jpg">
</td>
</tr>
</table>

<?
$search2=$search;

$words2=split(" ",$search);
//$toto2=$search2;
for ($j=0;$j<count($words2);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";
//
$toto.='<font color="black"><span style="background-color: '.$color.'"> '.$words2[$j].'</font></span>&nbsp;&nbsp;&nbsp;';
}

$search=str_replace("_"," ",$search);
//$toto=str_replace("_"," ",$search);


print "<br><center><strong><em>Whole results for <br></em>\" $toto\"<br></strong></center>
<center><small><em><b>( Operator: $OP )</b></em></small></center><br>";
print "";
?>




<table width="99%" border="0" cellspacing="0" cellpadding="0">



<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tGO_TERM)>0) 
print '<img id="imgnb0" name="imgnb0" src="plus-box.gif" onclick="changediv(\'nb0\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb0" name="imgnb0" src="min-box.gif" onclick="changediv(\'nb0\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb0" name="imgnb0" src="min-box.gif" onclick="changediv('nb0','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in GO TERM</b></font>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tGO_TERM)>1)print "<font size=\"2\" color='#D64242'><b> ".count($tGO_TERM)." results </b></font></td>";
if (count($tGO_TERM)==1)print "<font size=\"2\" color='#D64242'><b> ".count($tGO_TERM)." result </b></font></td>";
if (count($tGO_TERM)==0)print "<font size=\"2\" color='#656565'><b> No results </b></font></td>";

?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb0" name="nb0">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?



for ($i=0;$i<count($tGO_TERM);$i++)
{
$tmp=explode("@",$tGO_TERM[$i]);

$toto=strtoupper($tmp[1]);

for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);

$tmp0=array(0 => $tmp[0]);
//$tmp0[0]=$tmp[0];

print '<tr> <td style="border-top:1px solid black;">


<font color="#000001" size="2">
<b>
'.$tmp[0].' :</b><em>'.$toto.'</em>.</font>';

print '</td><td  style="border-top:1px solid black;">
<table>
<tr>
<td><form name="formu" action="GO-result.php" method="POST" target="_blank" >
<input type="hidden" name="id" value="'.$tmp[0].'">
<input style="'.$css.';background-image:url(\'pictures/mini-aniseed.jpg\');background-repeat:no-repeat;cursor:pointer;" type="submit" value="                " >
</form></td><td><a style="'.$css.';" target="_blank" href="http://www.godatabase.org/cgi-bin/amigo/go.cgi?view=details&show_associations=list&search_constraint=terms&depth=0&query='.$tmp[0].'"><img border="0" width="60" src="pictures/mini-GO.jpg"></a>
</td>
<td>
<a style="'.$css.'"target="_blank" href="GO-definition.php?id='.$tmp[0].'"><img border="0" src="pictures/mini-GOdef.jpg"></a> 
</td>
</tr>
</table>';

print '</td>
</tr>';

}

?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tGO_DEF)>0) 
print '<img id="imgnb1" name="imgnb1" src="plus-box.gif" onclick="changediv(\'nb1\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb1" name="imgnb1" src="min-box.gif" onclick="changediv(\'nb1\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb1" name="imgnb1" src="min-box.gif" onclick="changediv('nb1','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in GO DEFINITION</b></font>&nbsp;&nbsp; - &nbsp; <? 
if (count($tGO_DEF)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tGO_DEF)." results </b></font></td>"; 
if (count($tGO_DEF)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tGO_DEF)." result </b></font></td>"; 
if (count($tGO_DEF)==0) print "<font size=\"2\" color='#656565'><b> No results </font></b></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb1" name="nb1">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tGO_DEF);$i++)
{
$tmp=explode("@",$tGO_DEF[$i]);

$toto=strtoupper($tmp[2]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);

print '<tr>
<td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>
'.$tmp[0].' :</b>'.$toto.'</font>';

print '</td><td  style="border-top:1px solid black;">
<table>
<tr>
<td>
<form name="formu" action="GO-result.php" method="POST" target="_blank">
<input type="hidden" name="id" value="'.$tmp[0].'">
<input style="'.$css.';background-image:url(\'pictures/mini-aniseed.jpg\');background-repeat:no-repeat;cursor:pointer;" type="submit" value="                ">
</form>
</td>
<td>
<a style="'.$css.'"target="_blank" href="http://www.godatabase.org/cgi-bin/amigo/go.cgi?view=details&show_associations=list&search_constraint=terms&depth=0&query='.$tmp[0].'"><img border="0" width="60" src="pictures/mini-GO.jpg"></a>
</td>
<td><a style="'.$css.'"target="_blank" href="GO-definition.php?id='.$tmp[0].'"><img border="0" src="pictures/mini-GOdef.jpg"></a>
</td>
</tr>
</table>';

print '</td></tr>';
}
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tIP_TERM)>0) 
print '<img id="imgnb2" name="imgnb2" src="plus-box.gif" onclick="changediv(\'nb2\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb2" name="imgnb2" src="min-box.gif" onclick="changediv(\'nb2\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb2" name="imgnb2" src="min-box.gif" onclick="changediv('nb2','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in InterPro TERM</b></font>

</em><b>&nbsp;&nbsp; - &nbsp; <? 
if (count($tIP_TERM)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tIP_TERM)." results </b></font></td>"; 
if (count($tIP_TERM)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tIP_TERM)." result </b></font></td>"; 
if (count($tIP_TERM)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb2" name="nb2">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tIP_TERM);$i++)
{
$tmp=explode("@",$tIP_TERM[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);

print '<tr> <td style="border-top:1px solid black;">';
print '<font color="#000001" size="2"><b>'.$tmp[0].' :</b><em>'.$toto.'</em>. '.$tmp[2].'</font>';
print '</td><td  style="border-top:1px solid black;">
<table>
<tr>
<td><form name="formu" action="IP-result.php" method="POST" target="_blank">
<input type="hidden" name="id" value="'.$tmp[0].'">
<input style="'.$css.';background-image:url(\'pictures/mini-aniseed.jpg\');background-repeat:no-repeat;cursor:pointer;" type="submit" value="                "></form></td>
<td><a style="'.$css.'"target="_blank" href="http://www.ebi.ac.uk/interpro/IEntry?ac='.$tmp[0].'"><img width="40" border="0" src="pictures/mini-interpro.jpg"></a></td>
</tr>
</table>';
print '</td> </tr>';
}
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#7ccdce;">
<? if (count($tISH_COMMENTS)>0) 
print '<img id="imgnb3" name="imgnb3" src="plus-box.gif" onclick="changediv(\'nb3\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb3" name="imgnb3" src="min-box.gif" onclick="changediv(\'nb3\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb3" name="imgnb3" src="min-box.gif" onclick="changediv('nb3','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in ISH Comments</b></font>

</em><b>&nbsp;&nbsp; - &nbsp; <? 
if (count($tISH_COMMENTS)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tISH_COMMENTS)." results </b></font></td>"; 
if (count($tISH_COMMENTS)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tISH_COMMENTS)." result </b></font></td>"; 
if (count($tISH_COMMENTS)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb3" name="nb3">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tISH_COMMENTS);$i++)
{
$tmp=explode("@",$tISH_COMMENTS[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> 
<td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>Aniseed ISH ID: '.$tmp[0].' :</b><em>'.$toto.'</em>.</td>
<td style="border-top:1px solid black;">
<a style="'.$css.'"target="_blank" href="insitu.php?id='.$tmp[0].'"><img border="0" width="60" src="pictures/mini-aniseed.jpg"></a>
</font>
</td> </tr>';
}
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#b9a491;">
<?

/////////////// FILTER THE STATUS OF THE ARTICLE TO KNOW WETHER ITS PUBLIC CURATED, OR NOT (IS NOT CURATED IF ALL THE EXPERIMENTS
//// ASSOCIATED WITH ARE NOT CURATED
$TMP=(array) null;
for ($i=0;$i<count($tREFERENCE);$i++)
{
$m=explode("@",$tREFERENCE[$i]);
$requete0="select distinct \"CHECKED\" from \"IN_SITU\" where \"IN_SITU_ID\" in (
SELECT \"BIO_ID\" from \"REFERENCE\" where \"PUBMED_ID\"='".$m[0]."')";
$stmt0=pg_query($c,$requete0);
$s="";
while ($row0=pg_fetch_array($stmt0)) $s.=$row0["CHECKED"];
if ($s=="n") continue;
$TMP[count($TMP)]=$tREFERENCE[$i];
}
$tREFERENCE=$TMP;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



if (count($tREFERENCE)>0) print '<img id="imgnb4" name="imgnb4" src="plus-box.gif" onclick="changediv(\'nb4\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb4" name="imgnb4" src="min-box.gif" onclick="changediv(\'nb4\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb4" name="imgnb4" src="min-box.gif" onclick="changediv('nb4','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Article Titles Words</b></font>

</em><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tREFERENCE)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tREFERENCE)." results </b></font></td>"; 
if (count($tREFERENCE)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tREFERENCE)." result </b></font></td>"; 
if (count($tREFERENCE)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb4" name="nb4">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tREFERENCE);$i++)
{
$tmp=explode("@",$tREFERENCE[$i]);



$requeteOO="SELECT \"ARTICLE_ID\" from \"ARTICLE\" where \"PUBMED_ID\"='".$tmp[0]."'";
$stmtOO=pg_query($c,$requeteOO);
$rowOO=pg_fetch_array($stmtOO);
$artid=$rowOO["ARTICLE_ID"];



$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr>
<td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>Pubmed ID:  '.$tmp[0].' :</b><em>'.$toto.'</em></font>
</td><td style="border-top:1px solid black;">
<a style="'.$css.'"target="_blank" href="view-article.php?id='.$artid.'"><img border="0" width="60" src="pictures/mini-aniseed.jpg"></a></td>
<td>
<a style="'.$css.'"target="_blank" href="http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids='.$tmp[0].'&query_hl=1&itool=pubmed_docsum"> <img border="0" width="60" src="pictures/mini-pubmed.jpg"></a>
'; 

print '</td> </tr>';
}


?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#b9a491;">
<? if (count($tAUTHOR)>0) 
print '<img id="imgnb10" name="imgnb10" src="plus-box.gif" onclick="changediv(\'nb10\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb10" name="imgnb10" src="min-box.gif" onclick="changediv(\'nb10\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb4" name="imgnb4" src="min-box.gif" onclick="changediv('nb4','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Authors</b></font>

</em><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tAUTHOR)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tAUTHOR)." results </b></font></td>"; 
if (count($tAUTHOR)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tAUTHOR)." result </b></font></td>"; 
if (count($tAUTHOR)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb10" name="nb10">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tAUTHOR);$i++)
{
$tmp=explode("@",$tAUTHOR[$i]);


$requeteOO="SELECT \"ARTICLE_ID\" from \"ARTICLE\" where \"PUBMED_ID\"='".$tmp[0]."'";
$stmtOO=pg_query($c,$requeteOO);
$rowOO=pg_fetch_array($stmtOO);
$artid=$rowOO["ARTICLE_ID"];

$toto=strtoupper($tmp[1]);

//Traitement sur le nom des auteurs pour les majuscules
/*$taut=explode(" ",$toto);
$prenom=strtoupper($taut[1]);
$nom=substr($taut[0], 1);
$init=$toto{0};
$init=strtoupper($init);

$toto=$init.$nom." ".$prenom;
*/

for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);






if (strlen($tmp[0])!=0)
{
print '<tr> <td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>PubmedID '.$tmp[0].' :</b><em>'.$tmp[2].'</em><br>
<font color="#000001" size="2"><b>Authors:</b> '.$toto.'
</font>
</td>
<td style="border-top:1px solid black;">
<a style="'.$css.'"target="_blank" href="view-article.php?id='.$artid.'"><img border="0" width="60" src="pictures/mini-aniseed.jpg"></a></td>
<td>
<a style="'.$css.'"target="_blank" href="http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids='.$tmp[0].'&query_hl=1&itool=pubmed_docsum"> <img border="0" width="60" src="pictures/mini-pubmed.jpg"></a>
'; 
print '</td> </tr>';
}
else
{
print '<tr> <td style="border-top:1px solid black;">
<font color="#000001" size="2">
<b>PubmedID (Unpublished) :</b><em>'.$toto.'</em>.</font></td> </tr>';
}


}


?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->




<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#98a4b0;">
<? if (count($tANATOM)>0) 
print '<img id="imgnb5" name="imgnb5" src="plus-box.gif" onclick="changediv(\'nb5\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb5" name="imgnb5" src="min-box.gif" onclick="changediv(\'nb5\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb5" name="imgnb5" src="min-box.gif" onclick="changediv('nb5','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Anatomical Ontology</b></font>
</em><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tANATOM)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tANATOM)." results </font></td>"; 
if (count($tANATOM)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tANATOM)." result </font></td>"; 
if (count($tANATOM)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb5" name="nb5">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tANATOM);$i++)
{
$tmp=explode("@",$tANATOM[$i]);

//$toto=$tmp[1];
$toto=strtoupper($tmp[1]);
$TODOWN=false;

for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
//TEST pour les parties anatomiques grand A petit a grand B petit b
$r="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"NAME\"='".$words[$j]."'";
$st=pg_query($c,$r);
if (!pg_num_rows($st)) $TODOWN=true;

$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}





if ($TODOWN) $toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>Species: </b><em>'.$tmp[3].'</em>
<b><br>Developmental stage:</b><em> '.$tmp[4].'</em>
<b><br>Anatomical ID:</b><em> '.$tmp[0].'</em>
<b><br>Definition: </b><em>'.$toto.'</em>.</font>
</td>
<td style="border-top:1px solid black;">
<a style="'.$css.'"target="_blank" href="short_hierarchy.php?region='.$tmp[0].'&dev='.$tmp[2].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>';
print '</td> </tr>';
}
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#98a4b0;">
<? if (count($tFATE)>0) 
print '<img id="imgnb6" name="imgnb6" src="plus-box.gif" onclick="changediv(\'nb6\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb6" name="imgnb6" src="min-box.gif" onclick="changediv(\'nb6\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb6" name="imgnb6" src="min-box.gif" onclick="changediv('nb6','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Fate</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tFATE)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tFATE)." results </b></font></td>"; 
if (count($tFATE)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tFATE)." result </b></font></td>"; 
if (count($tFATE)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb6" name="nb6">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
for ($i=0;$i<count($tFATE);$i++)
{
$tmp=explode("@",$tFATE[$i]);

$toto=strtoupper($tmp[0]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">
<font color="#000001" size="2"><b>Fate:</b> <em>'.$toto.'</em>.</font>';
print '</td> </tr>';
}
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tMOL)>0) 
print '<img id="imgnb7" name="imgnb7" src="plus-box.gif" onclick="changediv(\'nb7\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb7" name="imgnb7" src="min-box.gif" onclick="changediv(\'nb7\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb7" name="imgnb7" src="min-box.gif" onclick="changediv('nb7','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Genes</b></font><b>&nbsp;&nbsp; - &nbsp; 
<?
if (count($tMOL)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tMOL)." results $artefact </b></font></td>"; 
if (count($tMOL)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tMOL)." result $artefact </b></font></td>"; 
if (count($tMOL)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?>
 </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb7" name="nb7">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
//rsort($tMOL);
for ($i=0;$i<count($tMOL);$i++)
{
$tmp=explode("@",$tMOL[$i]);

$toto=strtoupper($tmp[1]);

$aniseed_gm=str_replace("cluster","aniseedV3_",$tmp[0]);

$l1=strlen($toto);
$artefact="";
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);

}
$l2=strlen($toto);

//if ($l1==$l2) $artefact="</u><small>(<font color=\"#D64242\"><b>Approximative spelling</b></font>) </small><u>";

if (($l1==$l2) || ($l1!=$l2))
	{
	$requete="SELECT \"GENE_ID\" from \"GENE\" where \"NAME\"='$search'";
	$stmt=pg_query($c,$requete);
	if (pg_num_rows($stmt)>0) $artefact="</u><small>(<font color=\"#459868\"><b>Found by transcript inheritance</b></font>) </small><u>";
	}


$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);
/*
print '<tr> <td style="border-top:1px solid black;">
'.$artefact.'
<font color="#000001" size="2"><b>'.$tmp[2].'  - </b><em>'.$toto.'</em></font>.
</td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="molecule-gene.php?name='.$tmp[2].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';
*/
print '<tr> <td style="border-top:1px solid black;">
'.$artefact.'
<font color="#000001" size="2"><b>'.$aniseed_gm.'  - </b><em>'.$toto.'</em></font>.
</td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="gene-card.php?clusterid='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

/*
if ($tmp[2]{0}=="c") //JGI
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://genome.jgi-psf.org/cgi-bin/dispGeneModel?db=ciona4&id='.str_replace("ci0100","",$tmp[2]).'"><img src="pictures/jgi_logo.jpg" width="40" border="0"></a>
</td>';



if ($tmp[2]{0}=="E") //ENSEMBL
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://www.ensembl.org/Ciona_intestinalis/transview?db=core;transcript='.$tmp[2].'"><img src="pictures/e-bang.jpg" width="40" border="0"></a>
</td>';

if ($tmp[2]{0}=="K") //KYOTO
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://hoya.zool.kyoto-u.ac.jp/cgi-bin/fordetailg2005.cgi?name='.$tmp[2].'&class=mRNA"><img src="pictures/mini-ghost.jpg" width="80" border="0"></a>
</td>';
*/


/*
print '
<td>&nbsp;</td><td>&nbsp;</td><td>
<td>
<a style="'.$css.'"target="_blank" href="http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/?name='.$tmp[2].'"><img src="pictures/mini-gbrowse.jpg" border="0" width="110"></a>
</td>';
*/

print'
</tr>
</table>
';


print '</td> </tr>';
}
?>

<?
if ($_POST["blast"]=="blast")
{
?>
<!-- RAJOUT -->
</table>


</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->

<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tBLAST)>0) 
print '<img id="imgnb8" name="imgnb8" src="plus-box.gif" onclick="changediv(\'nb8\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb8" name="imgnb8" src="min-box.gif" onclick="changediv(\'nb8\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Best Blast Hits</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tBLAST)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tBLAST)." results </b></font></td>"; 
if (count($tBLAST)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tBLAST)." result </b></font></td>"; 
if (count($tBLAST)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb8" name="nb8">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->

<?
//rsort($tBLAST);
for ($i=0;$i<count($tBLAST);$i++)
{
$tmp=explode("@",$tBLAST[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>'.$tmp[2].'  - </b><em>'.$toto.'</em>. <em><b>Evalue: '.$tmp[3].'</b></em> </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="molecule-gene.php?name='.$tmp[2].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

if ($tmp[2]{0}=="c") //JGI
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://genome.jgi-psf.org/cgi-bin/dispGeneModel?db=ciona4&id='.str_replace("ci0100","",$tmp[2]).'"><img src="pictures/jgi_logo.jpg" width="40" border="0"></a>
</td>';



if ($tmp[2]{0}=="E") //ENSEMBL
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://www.ensembl.org/Ciona_intestinalis/transview?db=core;transcript='.$tmp[2].'"><img src="pictures/e-bang.jpg" width="40" border="0"></a>
</td>';

if ($tmp[2]{0}=="K") //KYOTO
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://hoya.zool.kyoto-u.ac.jp/cgi-bin/fordetailg2005.cgi?name='.$tmp[2].'&class=mRNA"><img src="pictures/mini-ghost.jpg" width="80" border="0"></a>
</td>';




print '
<td>
<a style="'.$css.'"target="_blank" href="http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/?name='.$tmp[2].'"><img src="pictures/mini-gbrowse.jpg" border="0" width="110"></a>
</td>
</tr>
</table>
'; 
print '</td> </tr>';

}
}
?>

<?
if ($_POST["ortho"]=="ortho")
{
?>
<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->

<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tFAM)>0) 
print '<img id="imgnb9" name="imgnb9" src="plus-box.gif" onclick="changediv(\'nb9\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb9" name="imgnb9" src="min-box.gif" onclick="changediv(\'nb9\',\'plus-box\',\'min-box\')"/>';
?>
<!--<img id="imgnb9" name="imgnb9" src="min-box.gif" onclick="changediv('nb9','plus-box','min-box')" />-->
<font color="#000000" size="2"><b>Results in Protein Family</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tFAM)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tFAM)." results </b></font></td>"; 
if (count($tFAM)==1) print "<font size\"2\" color='#D64242'><b> ".count($tFAM)." result </b></font></td>"; 
if (count($tFAM)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb9" name="nb9">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->
<?
//rsort($tFAM);
for ($i=0;$i<count($tFAM);$i++)
{
$tmp=explode("@",$tFAM[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">
'.$artefact.' 
<font color="#000001" size="2"><b>
'.$tmp[2].' </b>
<br>Protein Familly: <em>'.$toto.'</em>.
<br>Species: '.$tmp[3].'
<br>Ortholog Gene: '.$tmp[4].'
</font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="molecule-gene.php?name='.$tmp[2].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

if ($tmp[2]{0}=="c") //JGI
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://genome.jgi-psf.org/cgi-bin/dispGeneModel?db=ciona4&id='.str_replace("ci0100","",$tmp[2]).'"><img src="pictures/jgi_logo.jpg" width="40" border="0"></a>
</td>';



if ($tmp[2]{0}=="E") //ENSEMBL
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://www.ensembl.org/Ciona_intestinalis/transview?db=core;transcript='.$tmp[2].'"><img src="pictures/e-bang.jpg" width="40" border="0"></a>
</td>';

if ($tmp[2]{0}=="K") //KYOTO
print '<td>&nbsp;</td><td>&nbsp;</td><td>
<a style="'.$css.'"target="_blank" href="http://hoya.zool.kyoto-u.ac.jp/cgi-bin/fordetailg2005.cgi?name='.$tmp[2].'&class=mRNA"><img src="pictures/mini-ghost.jpg" width="80" border="0"></a>
</td>';




print '
<td>
<a style="'.$css.'"target="_blank" href="http://crfb.univ-mrs.fr/ciona-bin/gbrowse/intestinalis/?name='.$tmp[2].'"><img src="pictures/mini-gbrowse.jpg" border="0" width="110"></a>
</td>
</tr>
</table>
'; 


print '</td> </tr>';
}
}
?>

<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->














<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->

<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tPROMOTER)>0) 
print '<img id="imgnb11" name="imgnb11" src="plus-box.gif" onclick="changediv(\'nb11\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb11" name="imgnb11" src="min-box.gif" onclick="changediv(\'nb11\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Cis-Regulatory Region Name</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tPROMOTER)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tPROMOTER)." results </b></font></td>"; 
if (count($tPROMOTER)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tPROMOTER)." result </b></font></td>"; 
if (count($tPROMOTER)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb11" name="nb11">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->

<?
//rsort($tBLAST);
for ($i=0;$i<count($tPROMOTER);$i++)
{
$tmp=explode("@",$tPROMOTER[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>Name:</b><em>'.$toto.'</em>. <em><br><b>Comments:</b> '.$tmp[2].' </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="reg-region-view.php?id='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';


print '</table></td> </tr>';

}



?>



<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->


<!-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-->






<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->

<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tPROMOTERCOM)>0) 
print '<img id="imgnb12" name="imgnb12" src="plus-box.gif" onclick="changediv(\'nb12\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb12" name="imgnb12" src="min-box.gif" onclick="changediv(\'nb12\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Cis-Regulatory Region Comments</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tPROMOTERCOM)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tPROMOTERCOM)." results </b></font></td>"; 
if (count($tPROMOTERCOM)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tPROMOTERCOM)." result </b></font></td>"; 
if (count($tPROMOTERCOM)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb12" name="nb12">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->

<?
//rsort($tBLAST);
for ($i=0;$i<count($tPROMOTERCOM);$i++)
{
$tmp=explode("@",$tPROMOTERCOM[$i]);

$toto=strtoupper($tmp[2]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>Name:</b><em>'.$tmp[1].'</em>. <em><br><b>Comments:</b> '.$toto.' </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="reg-region-view.php?id='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

print '</table></td> </tr>';

}



?>



<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->


<!-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-->








<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<!--
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tCONSTRUCTION)>0) 
print '<img id="imgnb13" name="imgnb13" src="plus-box.gif" onclick="changediv(\'nb13\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb13" name="imgnb13" src="min-box.gif" onclick="changediv(\'nb13\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Reporter Construct Name</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tCONSTRUCTION)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tCONSTRUCTION)." results </b></font></td>"; 
if (count($tCONSTRUCTION)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tCONSTRUCTION)." result </b></font></td>"; 
if (count($tCONSTRUCTION)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<tr>
<td>

<div class="hideme" id="nb13" name="nb13">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">

<?
//rsort($tBLAST);
for ($i=0;$i<count($tCONSTRUCTION);$i++)
{
$tmp=explode("@",$tCONSTRUCTION[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

if (strlen(trim($tmp[2]))==0) $tmp[2]="<i>No comments</i>";

print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>Name:</b><em>'.$toto.'</em>. <em><br><b>Comments:</b> '.$tmp[2].' </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="construct-view.php?constructid='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

print '</table></td> </tr>';

}



?>


</table>
</div>
</td>
</tr>
-->
<!-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-->







<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->
<!--
<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tCONSTRUCTIONCOM)>0) 
print '<img id="imgnb14" name="imgnb14" src="plus-box.gif" onclick="changediv(\'nb14\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb14" name="imgnb14" src="min-box.gif" onclick="changediv(\'nb14\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Reporter Construct Comments</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tCONSTRUCTIONCOM)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tCONSTRUCTIONCOM)." results </b></font></td>"; 
if (count($tCONSTRUCTIONCOM)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tCONSTRUCTIONCOM)." result </b></font></td>"; 
if (count($tCONSTRUCTIONCOM)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>

<tr>
<td>

<div class="hideme" id="nb14" name="nb14">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">


<?
//rsort($tBLAST);
for ($i=0;$i<count($tCONSTRUCTIONCOM);$i++)
{
$tmp=explode("@",$tCONSTRUCTIONCOM[$i]);

$toto=strtoupper($tmp[2]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);

if (strlen(trim($tmp[2]))==0) $tmp[2]="<i>No comments</i>";

print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>Name:</b><em>'.$tmp[1].'</em>. <em><br><b>Comments:</b> '.$toto.' </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="construct-view.php?constructid='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

print '</table></td> </tr>';

}



?>




</table>
</div>
</td>
</tr>
-->


<!-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-->










<!-- /////////////////////////////////////////////////////////////////////////////////////////// -->

<tr>
<td align="left">
<div style="background-color:#9b90b8;">
<? if (count($tMOLTOOL)>0) 
print '<img id="imgnb15" name="imgnb15" src="plus-box.gif" onclick="changediv(\'nb15\',\'plus-box\',\'min-box\')"/>';
else print '<img id="imgnb15" name="imgnb15" src="min-box.gif" onclick="changediv(\'nb15\',\'plus-box\',\'min-box\')"/>';
?>
<font color="#000000" size="2"><b> Results in Molecular Tools</b></font><b>&nbsp;&nbsp; - &nbsp; 
<? 
if (count($tMOLTOOL)>1) print "<font size=\"2\" color='#D64242'><b> ".count($tMOLTOOL)." results </b></font></td>"; 
if (count($tMOLTOOL)==1) print "<font size=\"2\" color='#D64242'><b> ".count($tMOLTOOL)." result </b></font></td>"; 
if (count($tMOLTOOL)==0) print "<font size=\"2\" color='#656565'><b> No results </b></font></td>"; 
?> </b>
</div>
</tr>
<!-- RAJOUT-->
<tr>
<td>

<div class="hideme" id="nb15" name="nb15">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
<!-- FIN RAJOUT -->

<?
//rsort($tBLAST);
for ($i=0;$i<count($tMOLTOOL);$i++)
{
$tmp=explode("@",$tMOLTOOL[$i]);

$toto=strtoupper($tmp[1]);
for ($j=0;$j<count($words);$j++)
{
//RAJOUT
if ($j==0) $color="rgb(255,255,0)";
if ($j==1) $color="rgb(0,255,0)";
if ($j==2) $color="rgb(0,255,255)";
if ($j==3) $color="rgb(255,0,255)";
if ($j==4) $color="rgb(255,0,0)";
if ($j==5) $color="rgb(0,0,255)";
if ($j==6) $color="rgb(125,125,125)";
if ($j>6) $color="rgb(255,255,255)";

//
$toto=str_replace($words[$j],'<font color="black"><span style="background-color: '.$color.'">'.$words[$j].'</font></span>',$toto);
}
$toto=strtolower($toto);
$toto=str_replace("<br>","",$toto);
$toto=str_replace("<p>","",$toto);


print '<tr> <td style="border-top:1px solid black;">'.$artefact.' 
<font color="#000001" size="2"><b>Name:</b><em>'.$toto.'</em>. <em><br><b>Type:</b> '.$tmp[2].' </font></td>
<td style="border-top:1px solid black;">
<table>
<tr>
<td>
<a style="'.$css.'"target="_blank" href="moltool-card.php?id='.$tmp[0].'"><img src="pictures/mini-aniseed.jpg" width="60" border="0"></a>
</td>
';

print '</table></td> </tr>';

}



?>



<!-- RAJOUT -->
</table>
</div>
</td>
</tr>
<!-- FIN RAJOUT -->


<!-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-->
















</table>


<!-- search area -->
<br>
<br>
<center>
<form name="globalbis" method="POST" action="anisearch2.php">
<input type="text" name="search" value="<? print $search; ?>" size="50"/>
&nbsp;&nbsp;&nbsp;
<input type="submit" value="Submit" />
<br>
<input type="radio" name="OP" value="OR" <? if ($OP=="OR") print "checked"; ?>> OR 
&nbsp;&nbsp;&nbsp;
<input type="radio" name="OP" value="AND"<? if ($OP=="AND") print "checked"; ?>> AND 
&nbsp;&nbsp;&nbsp;
<input type="radio" name="OP" value="whole"<? if (strlen($OPWhole)>0) print "checked"; ?>> Complete sentence 
<br>
<!--<input type="checkbox" name="blast" value="blast" <? if ($_POST["blast"]=="blast") print "checked"; ?>>Include "Molecule Blast" results
<br>
<input type="checkbox" name="ortho" value="ortho" <? if ($_POST["ortho"]=="ortho") print "checked"; ?> > Include "Molecule Ortholog" results
<br>-->
<? if ($_POST["blast"]=="blast") print '<input type="hidden" name="blast" value="blast">'; ?>
<? if ($_POST["ortho"]=="ortho") print '<input type="hidden" name="ortho" value="ortho">'; ?>
</form>
</center>

<br>
<!-- End of search area -->



<?

include ("frames_footer.php");
?>
