<!--ANATOMY module 
 this page is a big formulary (permit to chose some option in the page)
 display antomy for a given stage
-->

<html>
<head>
<title>ANISEED anatomy - Ciona intestinalis and Halocynthia roretzy
anatomy</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description"
	content=" Aniseed hosts over 4 200 anatomical identities 
	(Ciona intestinalis anatomy and Halocynthia roretzi anatomy)
	concerning lineage and fate information, neighborhood relationships, shape of blastomeres,
	inductions, competence of cells. For more information, please contact aniseed@ibdm.univ-mrs.fr">
<meta name="keywords"
	content="Aniseed, Ciona intestinalis, Halocynthia roretzi, anatomy,
	lineage, fate, tunicate, ascidian,
	tunicate database, ciona intestinalis database, lemaire, tassy, 
	daian, dauga, sobral">
<meta name="robots" content="index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">

.tabulation
{
	font-weight: bold;
	padding-left: 1em;
	color: #999999;
}

</style>
<script type="text/javascript">
	var buttonHTMLTags = new Array();
	var cptWindows = 1;
	function showClass(theClass)
	{
		//Create Array of span HTML Tags
		var buttonHTMLTags=document.getElementsByTagName("span");
		//Loop through all tags using a for loop
		for (i=0; i<buttonHTMLTags.length; i++)
		{
			//Get all tags with the specified class name.
			if (buttonHTMLTags[i].className==theClass)
			{
				buttonHTMLTags[i].style.display='block';
			}
		}
	}
	
	function hideClass(theClass)
	{
		//Get all span tags
		var buttonHTMLTags=document.getElementsByTagName("span");
		//Loop through all tags using a for loop
		for (i=0; i<buttonHTMLTags.length; i++)
		{
			//Get all button tags with the specified class name.
			if (buttonHTMLTags[i].className==theClass)
			{
				buttonHTMLTags[i].style.display='none';
			}
		}
	}
	
	function hideClassAll(theClass)
	{
		var i = 0;
		//Loop through all tags using a for loop
		for (i=0; i<document.all.length; i++)
		{
			//Get all button tags with the specified class name.
			if (document.all[i].className==theClass)
			{
				document.all[i].style.display='none';
			}
		}
	}

	
	function changeColor(element_id)
	{
		//Get all span tags
		var buttonHTMLTags=document.getElementsByTagName("button");
		//Loop through all tags using a for loop
		for(i=0;i<buttonHTMLTags.length;i++)
		{
			if(buttonHTMLTags[i].id!=element_id)
			{
				buttonHTMLTags[i].style.backgroundColor='buttonface';
			}
			else
			{
				buttonHTMLTags[i].style.backgroundColor='green';
			}
		}
	}
	function changeCellContactImage()
	{
		var url = document.getElementById("cellContactImage").src;
		var urlModified;
		if(url.charAt([url.length]-1)==0)
		{
			urlModified = url.substring(0,url.length-1)+"1";
		}
		else
		{
			urlModified = url.substring(0,url.length-1)+"0";
		}
		document.getElementById("cellContactImage").src = urlModified;
	}

	//fonctions pour le zoom des images
	function ZoomInCellContact()
	{
		if(document.getElementById("cellContactImage").width<1500)
		{
			document.getElementById("cellContactImage").width+=200;
			document.getElementById("cellContactImage").height+=200;
		}
	}
	function ZoomOutCellContact()
	{
		if(document.getElementById("cellContactImage").width>200)
		{
			document.getElementById("cellContactImage").width-=200;
			document.getElementById("cellContactImage").height-=200;
		}
	}

	function popup(mylink,windowname)
	{
		window.open(mylink,windowname+cptWindows,'width=1700,height=1600,scrollbars=yes,toolbar=no,resizable=yes');
		cptWindows++;
	}

	
	function isImageContactOk()
	{
		var img = document.getElementById("cellContactImage");
		var valHeight = img.height;
		var valWitdht = img.width;
		var valHeightNat = img.naturalHeight;
		var valWitdhtNat = img.naturalWidth;
		
		if(valWitdhtNat==0)
		{
			hideClassAll("hideCellContact");
		}
		else
		{
			if(typeof(valWitdhtNat)=='undefined')
			{
				//special treatement for IE
				if(valWitdht<valHeight)
				{
					hideClassAll("hideCellContact");
				}
				else
				{
				}
			}
			else
			{
			}
		}
	}


</script>
  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />
</head>

<?php
/*
 ANISEED, NISEED System and Database
 Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>

*/
//connection
include("connection.php");
include("frames_header.php");



	//class to construct anatomical trees
class anat_tree
{
//static variable used in recursive function
	public $region;
	public $dev; //dev stage studied
	
//initialize level
	public function __construct($dev,$region)
	{
		$this->region = $region;
		$this->dev = $dev;
	}
	
//this function permit to represent an anatomical territories inclusion tree (left from rigth orientation tree)
//return nothing, just display html with good variable


	public function display_tab($level)
	{
		//loop to display vertical bars
		for($a=0;$a<$level-1;$a++) //begin for
		{
			//test if not root
			if($level>1)
			{
				//print edge of the tree
?>
				<span class="tabulation" >|</span>
<?php
			}
		} //end for
		
	}
	
	public function select_recursif_descendant_2test($conn,$start,$level)
	{
	//global variable (accessible in all the script)
		//test if the root is null
		if ($start!='')
		{
		/* query to select all characteristics of the specific anatomical territory 
		define by its dev stage and its (uniq) father can return several rows*/
			$requete2 = "SELECT * FROM \"ANAT_ENTITY\" 
				WHERE \"DEV_STAGE_ID\"= ".$this->dev." 
				AND \"CHILD_OF\"= $start ORDER BY \"NAME\"";
		}
		//else give roots (it seems to be three roots, whole embryo, whole egg and no expression)
		//select just whole embryo or whole egg (for one special developmental stage = egg)
		else
		{
			$requete2 = "SELECT * FROM \"ANAT_ENTITY\" 
				WHERE  \"DEV_STAGE_ID\"= ".$this->dev." 
				AND (\"NAME\"='Whole embryo' OR \"NAME\"='Whole egg' OR \"NAME\"='Whole organism')
				ORDER BY \"NAME\";";
		}
		$stmt2 = pg_query($conn,$requete2);
		//test if there is son for specified anatomical territory
		if (pg_num_rows($stmt2)!=0){
			//change level (toward leaves)
			$level++;
		}
		if (pg_num_rows($stmt2)==0){
			//change level (toward root)
			$level--;
		}
		//loop to treat all sons
		while($row2 = pg_fetch_array($stmt2))//begin while
		{
			//test anatomical territory type to display convenient picture
			//and assignate class for each type to custom display
			if($row2["TYPE"]=='cell')
			{
				print('<span class="cell" style="display: none;">');
				//function to display vertical bars
				anat_tree::display_tab($level);
?>
					<img src="pictures/cell.gif">
<?php
			}
			else 
			{
				if( $row2["TYPE"]=='organism' )
				{
					print('<span class=organism>');
					//function to display vertical bars
					anat_tree::display_tab($level);
?>
					<img src="pictures/tetard.gif">
<?php
				}
				else
				{
					//test if it is cell pair region : it is a class
					if(preg_match("/cell\spair/",$row2["NAME"]))
					{
						print('<span class="cell_pair">');
					}
					else
					{
						print('<span class="region">');
					}
					//function to display vertical bars
					anat_tree::display_tab($level);
?>
					<img src="pictures/region.gif">
<?php
				}
			}
			//display anatomical territory name ;
//and and radio button for 2D picture of embryo and specified territory
			//test if a region is already choosed (link from other scripts), then tick assiocate box
			if($row2["ANAT_ID"]==$this->region)
			{
?>
					<a name="tag"> 
						<font size="-2" color="#FF9900">
							<strong><?php echo $row2["NAME"];?></strong>
						</font>
					</a>
					<input onclick="embryo_img.src='newtree.php?anat=<?php echo $row2["ANAT_ID"];?>"
						name="region" type="radio" value="<?php ECHO $row2["ANAT_ID"];?>" checked="checked">
<?php
			}
			//else display name and test if radio button are needed
			else
			{;
//
?>
					<font size="-2"><strong><?php echo $row2["NAME"];?></strong></font>
<?php
				//test if region is defined then don't check radio button
					if((strlen($this->region)>0))
					{
?>
					<input onclick="embryo_img.src='newtree.php?anat=<?php echo $row2["ANAT_ID"];?>'"
						name="region" type="radio" value="<?php echo $row2["ANAT_ID"];?>">
<?php
					}
					//check the button depending on level
					else
					{
?>
					<input onclick="embryo_img.src='newtree.php?anat=<?php echo $row2["ANAT_ID"];?>'"
						name="region" type="radio" value="<?php echo $row2["ANAT_ID"];?>"
<?php
						//if the anatomical territory is root check the box
						if ($level==1){
?>
						checked
<?php
						}
?>
					>
<?php
				}
			}
?>
						<br />
<?php
//end anatomy classes
						echo "</span>";
//recursive call of function stoped when arrived to leaves
			$this->select_recursif_descendant_2test($conn,$row2["ANAT_ID"],$level);
//			$res = $this->select_recursif_descendant_2($conn,$row2["ANAT_ID"],$res);
		} //end while
//		return $res;
	} //end function
		
	
//display a table with 4 links to different thing not more used
	function display_faba($faba_num,$faba_3D,$faba_slice,$faba_line,$faba_time){
		print "<table style=\"padding:5px; border:1px solid black;\">";
		print "<tr>";
		print "<td><img width=\"120\" src=\"pictures/FABA/dev3D-$faba_num.jpg\"></td>";
		print "<td>";
		print "<table>";
		print "<tr><td><a target=\"_blank\" href=\"$faba_3D\"><img border=\"0\" src=\"pictures/3D_btn.png\"></a></td></tr>";
		print "<tr><td><a target=\"_blank\" href=\"$faba_slice\"><img border=\"0\" src=\"pictures/slice_btn.png\"></a></td></tr>";
		print "<tr><td><a target=\"_blank\" href=\"$faba_line\"><img border=\"0\" src=\"pictures/cellLineages_btn.png\"></a></td></tr>";
		print "<tr><td><a target=\"_blank\" href=\"$faba_time\"><img border=\"0\" src=\"pictures/timelapse_btn.png\"></a></td></tr>";
		print "</table>";
		print "</td>";
		print "</tr>";
		print "</table>	";
	}

}

?>

<script language="JavaScript">
function getValue(){
	for($i=0; $i< document.formu.length; $i++){
		if(document.formu[$i].checked==true){
			obj=document.formu[$i];
			return obj.value;
		}
	}
}
	function changeImage(url)
	{
		var urlModified;
		if(url.charAt([url.length]-1)==0)
		{
			urlModified = url.substring(0,url.length-1)+"1";
		}
		else
		{
			urlModified = url.substring(0,url.length-1)+"0";
		}
		document.getElementById("cellContactImage").src = urlModified;
	}

</script>

<?php
	$faba_URL = "http://chordate.bpni.bio.keio.ac.jp/faba/1.1";
	$faba_extension = "hpf.html";

//initialization of the variables posted from others scripts (or same script)
	$region="";
	$dev="";
	if(isset($_GET["region"])){
		$region = $_GET["region"];
	}
	if(isset($_GET["dev"])){
		$dev = $_GET["dev"];
	}	
?>
	
	<!-- Header pour l'onglet -->
		<div id="header">
			<ul>
				<li id="current"><a href="#">Anatomical dictionary</a></li>
				<li><a onclick="this.href='short_hierarchy.php?region='+self.getValue()+'&dev=<?php print $dev;?>'"
					href="">Anatomical territory summary card</a>
				</li>
				<li><a onclick="this.href='lineage.php?idanat='+self.getValue()"
					href="#">Lineage</a>
				</li>
				<li><a title='shows expression patterns restricted to the selected territory' 
					onclick="this.href='insitu-result.php?anat_menu=1&BOOLanat=1&only=1&BOOLmut=0&BOOLmanip=2&idanat='+self.getValue()"
					href="">Molecular Markers</a>
				</li>
				<li>
					<a onclick="this.href='anatomy-regulation-card.php?idanat='+self.getValue()" href="#">
						Regulatory Network
					</a>
				</li>
		
			</ul>
		</div>
	<!-- EOF Onglet --> 
	<br />
	<br />

<div id="test">
<!-- begin form to select and pass in direct territory wanted -->
<form action="" method="get" name="formu">
<?php
	//test if it is not a useless query
		if( (strlen($dev)<=0) || (ereg("___",$dev)) )
		{
?>
			<center><h2><strong>No match</strong></h2><br />please select one developmental stage</center>
<?php
			include("frames_footer.php");
			return;
		}

		// select information on the dev stage if exist
		$requete= "SELECT \"NAME\", \"SPECIES\" FROM \"DEV_STAGE\" WHERE \"DEV_STAGE_ID\"= $dev";
		$stmt = pg_query($c,$requete);
		//just 1 row can be retrieved due to database scheme (DEV_STAGE PKEY = 1 SPECIE, 1 NAME)
		//test if query return something else not found message
		if($row=pg_fetch_array($stmt)) //begin if 0 
		{
			//////////// AJOUT POUR LE DEV_STAGE_CARD ///////////////
		//query to have all informations on the dev stage
			$requete0="SELECT \"FABA_LINK\",\"TIME\",\"PERIOD_NAME\",\"DESCRIPTION\",\"STAGE_NAME\",\"GIF_LINK\" 
			FROM \"DEV_STAGE_INFO\" where \"DEV_STAGE_ID\"='$dev'";
			$stmt0 = pg_query($c,$requete0);
			$row0 = pg_fetch_array($stmt0);
	
		//transformation of faba information using faba constant. Can be several link separated by comma 
			$faba = $row0["FABA_LINK"];
			//explode faba link only if it is existing
			if(strlen($faba)>0)
			{
				$faba = explode(",",$faba);
			}
			for ($i=0;$i<count($faba);$i++)
			{
			//change URL to obtain only the faba identifier
			//replace root and extension by nothing
				$faba_num[] = str_replace($faba_extension,"",str_replace($faba_URL."/dev_3D/","",$faba[$i]));
			//construct real URL
				$faba_3D[] = $faba_URL."/3D.html?$faba_num[$i]";
				$faba_slice[] = $faba_URL."/slice.html?$faba_num[$i]";
				$faba_line[] = $faba_URL."/body_atlas.html?$faba_num[$i]";
				$faba_time[] = $faba_URL."/timelapse.html?$faba_num[$i]";
			}	
		
		//dev stage time
			$time = $row0["TIME"];
		//if time is null in the DB, print a message
			if (strlen($time)==0){
				$time = "</b><i>Not defined</i><b>";
			}
		//transformation for display
			$time = str_replace("h", " hours ",$time);
			$time = str_replace("minutes","min",$time);
			$time = str_replace("m"," min",$time);
		
		//dev stage's period name
			$period = $row0["PERIOD_NAME"];
		//if period is null display a message
			if (strlen($period)==0){
				$period = "</b><i>Not defined</i><b>";
			}
		
		//dev stage description	
			$desc = $row0["DESCRIPTION"];
		//if description is null display a message
			if (strlen($desc)==0){
				$desc = "</b><i>Not defined</i><b>";
			}
		
		//dev stage name	
			$stagename = $row0["STAGE_NAME"];
		//if name is null display a message
			if (strlen($stagename)==0){
				$stagename="</b><i>Not defined</i><b>";
			}
		
		//an URL toward gif sur yvette not used 	
			$gif = $row0["GIF_LINK"];
?>
		
<!--html display 	-->
		<br /><br />
		<table width="100%">
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b> Species :</b></font></td>
				<td><font size="-1"><b><?php echo $row["SPECIES"];?></b></font></td>
			</tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Stage Name :</b></font></td>
				<td><font size="-1" color="#FF9900"><b><?php echo $row["NAME"];?></b></font></td>
			</tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Period Name :</b></font></td>
				<td><font size="-1"><b><?php echo $period ;?></b></font></td>
			</tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Hotta Stage Number :</b></font></td>
				<td><font size="-1"><b><?php echo $stagename ;?></b></font></td>
			</tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Time since fertilisation (18&deg;) :</b></font></td>
				<td><font size="-1"><b><?php echo $time ;?></b></font></td>
			</tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Description :</b></font></td>
				<td><font size="-1"><b><?php echo $desc ;?></b></font></td>
			</tr>
			<tr>
				<td>&nbsp;</td><td>&nbsp;</td></tr>
			<tr>
				<td width="30%"><font color="#D64242" size="2"><b>Four-dimensional body atlas (FABA) :</b></font></td>
				<td>
<?php	
					//test if the faba identifiant exist in the BD
						if (strlen($faba)==0)//begin if
						{
						//message to say it is null in DB
?>
							<font size="-1"><i>Not defined</i></font>
<?php
						}//end if
					//if it is existing, display it, depending on the number of faba link
						else//begin else
						{
					//display all faba link (all in the faba tab)		
							for ($i=0;$i<count($faba);$i++)//begin for
							{
?>		
					<table style="padding:5px; border:1px solid black;">
						<tr>
							<td><img width="120" src="pictures/FABA/dev3D-<?php echo $faba_num[$i];?>.jpg"></td>
							<td>
								<table>
									<tr>
										<td>
											<a target="_blank" href="<?php echo $faba_3D[$i];?>">
												<img border="0" src="pictures/3D_btn.png">
											</a>
										</td>
									</tr>
									<tr>
										<td>
											<a target="_blank" href="<?php echo $faba_slice[$i];?>">
												<img border="0" src="pictures/slice_btn.png">
											</a>
										</td>
									</tr>
									<tr>
										<td>
											<a target="_blank" href="<?php echo $faba_line[$i];?>">
												<img border="0" src="pictures/cellLineages_btn.png">
											</a>
										</td>
									</tr>
									<tr>
										<td>
											<a target="_blank" href="<?php echo $faba_time[$i];?>">
												<img border="0" src="pictures/timelapse_btn.png">
											</a>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
<?php 	
							}//end for
?>			
			</td>
			</tr>
<?php
						}//end else
?>

			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
			<!-- Display schema of cell contacts for the stage-->
<?php
	//test if the stage and species are ok : to change 
	$queryCellRelationship = "SELECT A1.\"NAME\" AS object, A2.\"NAME\" AS subject,
			\"CONTACT\" AS contact
		FROM \"NEIGHBOR\"
			JOIN \"ANAT_ENTITY\" A1 ON(A1.\"ANAT_ID\"=\"CELL_A\")
			JOIN \"ANAT_ENTITY\" A2 ON(A2.\"ANAT_ID\"=\"CELL_B\")
		WHERE \"CELL_A\" IN(
			SELECT \"ANAT_ID\"
			FROM \"ANAT_ENTITY\"
			WHERE \"DEV_STAGE_ID\"=$dev
				AND \"SPECIES\"='".$row["SPECIES"]."'
			)
			AND \"CELL_B\" IN(
			SELECT \"ANAT_ID\"
			FROM \"ANAT_ENTITY\"
			WHERE \"DEV_STAGE_ID\"=$dev
				AND \"SPECIES\"='".$row["SPECIES"]."'
			)
			AND \"CONTACT\">0;";
	//select all neighboring relationships of cells in a developemental stage and contact between them
	$resultCellRelationship = pg_query($c,$queryCellRelationship);
	$cellRelationshipRows = pg_num_rows($resultCellRelationship);
	if($cellRelationshipRows>0)
	{
?>

			<tr>
				<td width="30%">
					<font color="#D64242" size="2"><b>Cell contacts scheme : </b></font>
				</td>
				<td>
					<font size="2"><b><img alt="No cell contacts scheme available for this stage" id="cellContactImage" onclick=";" height="300" name="contact_img" src="cell_schema.php?stage=<?php echo $dev;?>&species=<?php echo $row["SPECIES"];?>&mode=0"></b></font>
				</td>
				<td class="hideCellContact" width="30%">
					<font size="2">
						This scheme represents the surface of contact between cells. Thicker
						violet lines correspond to large contacts (&gt;2500 &micro;m<sup>2</sup>), thin
						blue lines to small contacts (&lt;250 &micro;m<sup>2</sup>).<br />
						By default, thicker lines appear above thinner ones. This order can be reversed by clicking on the "change display" button.
					</font>
				</td>
			</tr>
			<tr class="hideCellContact">
				<td width="30%"></td>
				<td align="left">
					<button  type="button" onclick="changeCellContactImage();" class="cellContactButton" >Change display</button>
					<button type="button" onclick="popup(document.getElementById('cellContactImage').src,'Cell contacts schema');" class="cellContactButton">Zoom</button>
				</td>
			</tr>
<?php
	}
?>
			<!-- Display previous and next dev stage with a link toward -->
			<tr>
				<td width="30%">
					<font color="#D64242" size="2"><b>Previous developmental stage :</b></font>
				</td>
<?php 	
				//query to select all precedent stages in term of developmental percentage
					$requete0 = "SELECT \"DEV_STAGE_ID\",\"NAME\" FROM \"DEV_STAGE\" 
							WHERE \"DEV_PERCENT\"<(
								SELECT \"DEV_PERCENT\" FROM \"DEV_STAGE\" 
								WHERE \"DEV_STAGE_ID\"='$dev' AND \"SPECIES\"='".$row["SPECIES"]."'
								) 
							AND \"SPECIES\"='".$row["SPECIES"]."'
							ORDER BY \"DEV_PERCENT\" DESC;";
					$stmt0 = pg_query($c,$requete0);
					$row0 = pg_fetch_array($stmt0);
?>	
				<td>
					<a href="anatomy.php?species=<?php echo $row["SPECIES"];?>&dev=<?php echo $row0["DEV_STAGE_ID"];?>">
						<font size="-2"><b><?php echo $row0["NAME"];?></b></font>
					</a>
				</td>
			</tr>
			<tr>
				<td width="30%">
					<font color="#D64242" size="2"><b>Next developmental stage :</b></font>
				</td>
<?php 	
				//query to select all next stages in term of developmental percentage
					$requete0 = "SELECT \"DEV_STAGE_ID\",\"NAME\" FROM \"DEV_STAGE\" 
						WHERE \"DEV_PERCENT\">(
							SELECT \"DEV_PERCENT\" FROM \"DEV_STAGE\" 
							WHERE \"DEV_STAGE_ID\"='$dev' AND \"SPECIES\"='".$row["SPECIES"]."'
							) 
						AND \"SPECIES\"='".$row["SPECIES"]."'
						ORDER BY \"DEV_PERCENT\" ASC";
					$stmt0=pg_query($c,$requete0);
					$row0=pg_fetch_array($stmt0);
?>				
				<td>
					<a href="anatomy.php?species=<?php echo $row["SPECIES"];?>&dev=<?php echo $row0["DEV_STAGE_ID"];?>">
						<font size="-2"><b><?php echo $row0["NAME"];?></b></font>
					</a>
				</td>
			</tr>
		</table>
		
<!-- separation bar -->
		<hr style="border-top:1px solid black;">

<!-- anatomical territories relation (include relation = tree representation) for studied dev stage -->
		<br />
		<font color="#D64242" size="2"><b>Anatomical Ontology</b></font>
		<br />
		<font size="-1">
			<i>(For details, tick a territory and go to the "anatomical territory summary card" tab)</i>
		</font>
		<br />
		<table>
			<tr>
				<td>
					<span title="display anatomical resolution (with cells or not)" style="color: black;padding-right: 15px; font-size: 11px;">
						Anatomical resolution level
					</span>
				</td>
				<td>
					<button id="tissue_button" type='button' onclick='hideClass("cell_pair");hideClass("cell");changeColor(this.id);'>Tissue</button>
				</td>
				<td>
					<button id="cell_pair_button" style="background-color: green;" type='button' onclick='showClass("cell_pair");hideClass("cell");changeColor(this.id);'>Cell pair</button>
				</td>
				<td>
					<button id="cell_button" style="color: " type='button' onclick='showClass("cell_pair");showClass("cell");changeColor(this.id);'>Cells</button>
				</td>
			</tr>
		</table>
		</div>
		<br />
<?php 	
		/* SIMULATION D'UNE REQUETE SUR HIERARCHIE PAR UNE PROCEDURE DE REQUETES RECURSIVES */
	
		/* VARIANTE DANS LA REQUETE POUR LA CONNECTION ET LE RESULTAT DU SELECT */
		/* VARIANTE SUR LE PASSAGE EN PARAMETRE DU NIVEAU COURANT DE RECURSIVITE 
		 * POUR L'AFFICHAGE DES BARRES VERTICALES */
?>
		<table width="100%">
			<tr>
				<td valign="top" width="60%">
<?php 	
					$test = new anat_tree($dev,$region);
					$test->select_recursif_descendant_2test($c,null,0);
?>
				</td>
				<td valign="top" align="center" width="40%">
<?php
					//test if region is null, case display information message
					if (strlen($region)==0) //begin if
					{
?>
					<img name="embryo_img">
					<br />
					<br />
					<font size="-1"><em>Click on an anatomical part to display its embryo schema</em></font>
<?php 
					}//end if
					//else siplay the 2D embryo picture from newtree.php only if not whole embryo
					else //begin else
					{
						$requete1="SELECT \"NAME\" from \"ANAT_ENTITY\" where \"ANAT_ID\"='$region'";
						$stmt1=pg_query(c,$requete1);
						$row1=pg_fetch_array($stmt1);
						if ($row1["NAME"]!="Whole embryo")
						{
?>
					<img name="embryo_img" src="newtree.php?anat=<?php echo $region;?>">
<?php	
						}
					}//end else
?> 
				</td>
			</tr>
		</table>
<?php
	}//end if 0
	//else dev stage don't exist, print a message
	else// begin else 0
	{ 
?> 
	<br />
	<br />
	<center><h2><strong>No match</strong></h2></center>
	<br />
	<br /> 
<?php
	}//end else 0
?>
</form> <!-- end form -->
</div>
<br />
<br />
<!-- option to display txt format -->
<a href="FLATexport-anatomy.php?region=<?php echo $region;?>&dev=<?php echo $dev;?>">
	Display tree in raw text format
</a>

<?php
include("frames_footer.php");
?>

<script type="text/javascript">
	//test if the image is correctly loaded, then hide button and text for schema
	//isImageContactOk();
</script>

</html>
