<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("connection.php");
	//Title before frames_header
	print '<title>ANISEED v3.0 - Anatomy</title>';
    include("frames_header.php");

	
	//$children
	//$parent
		
	$id=$_GET["idanat"];
	$requete = "SELECT \"SPECIES\", \"DEV_STAGE_ID\" FROM \"ANAT_ENTITY\"
		WHERE \"ANAT_ID\"='$id';";
	$stmt = pg_query($c,$requete);
	$row_anat = pg_fetch_array($stmt);
	$stage = $row_anat["DEV_STAGE_ID"];
	$species = $row_anat["SPECIES"];
	if(!is_numeric($id)){
	    Print "Error: missing parameter";
		include("frames_footer.php");
		return;
	}
	
?>
  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />
<!-- Header pour l'onglet -->
<div id="header">
  <ul>
    <li><a href="anatomy.php?species=<?print $species;?>&dev=<?print $stage;?>&region=<?print $id;?>">Anatomical Ontology</a></li>
    <li><a onclick="this.href='short_hierarchy.php?region=<? print $id;?>&dev=<?print $stage;?>'" href="">Anatomical Territory Summary Card</a></li>
    <li><a href="lineage.php?idanat=<?print $id?>">Lineage</a></li>
    <li><a onclick="this.href='insitu-result.php?anat_menu=1&BOOLanat=1&only=1&BOOLmut=0&BOOLmanip=2&idanat=<?print $id;?>'" href="">Molecular Markers</a></li>

    <!--<li><a href="fates.php?idanat=<?print $id;?>">Fate</a></li>-->


    <!--<li><a onclick="this.href='insitu-result.php?BOOLanat=1&xref=2&idanat=<?print $id;?>:'" href="#">InSitu data</a></li>-->

    <!--<li><a href="position.php?idanat=<?print $id?>">Biometry</a></li>-->
    <!--<li><a href="induction.php?idanat=<?print $id;?>">Induction</a></li>-->
	
	<li id="current"><a href="">Regulatory Network</a></li>

	<!--<li><a href="anatomy-function-card.php?idanat=<?print $id;?>">Function</a></li>-->
	
  </ul>
</div>
<!-- EOF Onglet -->
<br><br><br>
<?
	
    $dev="";
	print "<center>";
	
	$requete="select B.\"NAME\" as \"DEV\", A.\"NAME\", B.\"NAME\" as \"DEV_NAME\", A.\"DEV_STAGE_ID\" from \"ANAT_ENTITY\" A, \"DEV_STAGE\" B where A.\"ANAT_ID\"='$id' and A.\"DEV_STAGE_ID\"=B.\"DEV_STAGE_ID\"";
    $stmt = pg_query($c,$requete);
	if ($row=pg_fetch_array($stmt)){
	    $dev=$row["DEV_STAGE_ID"];
		$devname=$row["DEV_NAME"];
	    print "<font color=\"#D64242\" size=\"3\"><b>".$row["NAME"]." &nbsp;(".$row["DEV"].")</b></font><br><br>";

	    $cellname=$row["NAME"];
	}

	//calculate parents of this region
	$khoueiry = "SELECT \"CHILD_OF\"  FROM 	\"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=$id;";
	$stmt = pg_query($c,$khoueiry);
	$parents[]=$id;
	while (($row=pg_fetch_array($stmt)) && (!is_null($row["CHILD_OF"]))){
		$parents[]=$row["CHILD_OF"];
		$khoueiry = "SELECT \"CHILD_OF\" FROM \"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=".$row["CHILD_OF"];
		$stmt = pg_query($c,$khoueiry);
	}
	
	$regs=(array) null;	
	//Get all available data:
	$khoueiry = "SELECT \"INTERACTION_EVIDENCE_ID\" AS \"EVIDENCE_ID\",
				\"GENE_A\" AS \"GENE_X\", \"GENE_B\" AS \"GENE_Y\",
				\"INTERACTION_TYPE\".\"DESCRIPTION\" AS \"TYPE\",
				\"EVIDENCE_ISH_ID\" AS \"EVIDENCE\", \"CONTROL_ISH_ID\" AS \"CONTROL\"
			FROM \"INTERACTION_EVIDENCE\" JOIN \"INTERACTION_TYPE\"
				ON(\"INTERACTION_TYPE\"=\"INTERACTION_TYPE_ID\")
				JOIN \"INTERACTION_EVIDENCE_TYPE\" ON(\"EVIDENCE_TYPE\"=\"EVIDENCE_TYPE_ID\")
			WHERE \"ANAT_ENTITY_ID\" IN (".implode(",",$parents).")
				AND \"INTERACTION_EVIDENCE_TYPE\".\"DESCRIPTION\"!~'upregulation';";
	$stmt = pg_query($c,$khoueiry);
	while($row=pg_fetch_array($stmt)){
		$regs[$row["GENE_X"]][$row["GENE_Y"]][$row["TYPE"]][] = array($row["EVIDENCE"],$row["CONTROL"],$row["EVIDENCE_ID"]);
		//print $row["GENE_X"]." ".$row["TYPE"]." ".$row["GENE_Y"]." : ".$row["EVIDENCE"]." vs ".$row["CONTROL"]."<br/>";
	}
	
	//Display the data

	print "<font size=\"2\">Interference with the function of genes in the rows affects the expression,
		at the indicated stage, of genes in the columns.<br />
		Note that the regulatory interaction may not be direct.
		In addition, although the result of the interaction has been assayed at the indicated stage,
		the regulation itself may occur earlier.</font><br /><br />";
	
	print '<table width="99%" border="2" cellspacing="1" cellpadding="0">';		
	
	
	
	$wts=(array) null;	
	foreach($regs as $mut_gene => $wtlist){
		foreach($wtlist as $wt_gene => $up_down_list){
			if(!in_array($wt_gene, $wts)){ $wts[] = $wt_gene; }
		}
	}
	
	
	
	print "<tr align=\"center\">";		
	print "<td>&nbsp;</td>";
	foreach($wts as $wt_gene){	
						
		$cluster=str_replace("cluster","aniseedV3_",$wt_gene);			
		$final_name = $cluster;
		//// get name of the clustid
		$name=(array) null;
		$requete = "SELECT \"GENE_CLUSTER_NAME\"
			FROM \"GENE_CONCEPT_NAME\"
			WHERE \"GENE_CLUSTER_ID\"='$wt_gene'
				AND \"MANUAL\"='y';";
		$stmt=pg_query($c,$requete);
		if($row=pg_fetch_array($stmt))
		{
			$name[0] = $row["GENE_CLUSTER_NAME"];
		}
		$requete = "SELECT \"GENE_CLUSTER_NAME\"
			FROM \"GENE_CONCEPT_NAME\"
			WHERE \"GENE_CLUSTER_ID\"='$wt_gene'
				AND (\"MANUAL\"<>'y' OR \"MANUAL\" IS NULL);";
		$stmt=pg_query($c,$requete);
		while($row=pg_fetch_array($stmt))
		{
			$name[count($name)]=$row["GENE_CLUSTER_NAME"];
		}
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$wt_gene'";
			$stmt=pg_query($c,$requete);
			while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
		}
		
		if (count($name)>0) {
			$final_name = $name[0];
		}
		
		$g_name = implode (" / ",$name);
		
		print "<td><a href=\"gene-card.php?clusterid=$wt_gene\" title=\"$g_name\"> $final_name </a></td>";
		
	}	
	print "</tr>";			
	
	foreach($regs as $mut_gene => $wtlist){		
	
		$mutish=(array) null;
		//Check if the gene is expressed in this territory
		
		$khoueiry = "SELECT \"TARGET\".\"IN_SITU_ID\", \"REGION_ID\" FROM \"TARGET\", \"IN_SITU\" WHERE 
			\"TARGET\".\"IN_SITU_ID\"=\"IN_SITU\".\"IN_SITU_ID\" AND \"DEV_STAGE_ID\"=$dev AND
			\"TARGET\".\"IN_SITU_ID\" NOT IN (SELECT \"IN_SITU_ID\" FROM \"MUTANT\") AND 
			\"TARGET\".\"IN_SITU_ID\" NOT IN (SELECT \"IN_SITU_ID\" FROM \"EMBRYO_MANIP\") AND
			\"TARGET_ID\" IN 
			(((SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$mut_gene')
			UNION
			(SELECT \"CLONE_SEQ\".\"CLONE_SEQ_ID\" FROM \"CLONE_SEQ\" WHERE \"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$mut_gene')))
			UNION
			(SELECT \"CLONE\".\"CLONE_ID\" FROM \"CLONE\" WHERE \"CLONE_NAME\" IN 
				(SELECT \"CLONE_NAME\" FROM \"CLONE_SEQ\" WHERE \"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$mut_gene'))));";
		$stmt = pg_query($c,$khoueiry);		
		while($row=pg_fetch_array($stmt)){
			$mutish[$row["IN_SITU_ID"]][] = $row["REGION_ID"];
		}
	
		$present=(array) null;
		$notpresent=(array) null;
		foreach ($mutish as $ish => $regionlist){
			if(count(array_intersect($parents,$regionlist))>0){	$present[] = $ish;	} else { $notpresent[] = $ish;	}
		}		
		
		print "<tr align=\"center\">";	
		
		$cluster=str_replace("cluster","aniseedV3_",$mut_gene);		
		$final_name = $cluster;			
		//// get name of the clustid
		$name=(array) null;
		$requete = "SELECT \"GENE_CLUSTER_NAME\"
			FROM \"GENE_CONCEPT_NAME\"
			WHERE \"GENE_CLUSTER_ID\"='$mut_gene'
				AND \"MANUAL\"='y';";
		$stmt=pg_query($c,$requete);
		if($row=pg_fetch_array($stmt))
		{
			$name[0] = $row["GENE_CLUSTER_NAME"];
		}
		$requete = "SELECT \"GENE_CLUSTER_NAME\"
			FROM \"GENE_CONCEPT_NAME\"
			WHERE \"GENE_CLUSTER_ID\"='$mut_gene'
				AND (\"MANUAL\"<>'y' OR \"MANUAL\" IS NULL);";
		$stmt=pg_query($c,$requete);
		while ($row=pg_fetch_array($stmt))
		{
			$name[count($name)]=$row["GENE_CLUSTER_NAME"];
		}
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$mut_gene'";
			$stmt=pg_query($c,$requete);
			while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
		}
		
		if (count($name)>0) {
			$final_name = $name[0];
		}
		
		$g_name = implode (" / ",$name);
			
		print "<td>";
		print "<a href=\"gene-card.php?clusterid=$mut_gene\" title=\"$g_name\"> $final_name </a>";
		if(count($present)>0){
			//print "<a href=\"display-evidence.php?insitus=".implode(":",$present)."\" target=\"_blank\">(P)</a>";	

		print "&nbsp;&nbsp;<a href=\"http://crfb.univ-mrs.fr/aniseed/view-net.php?clusterid=$mut_gene&dev_stage=$devname&anat_name=$id&h=500\"><small><small>(View Network)</small></small></a>";
			
		}
		else if(count($notpresent)>0){
			//print "<a href=\"display-evidence.php?insitus=".implode(":",$notpresent)."\" target=\"_blank\">(NP)</a>";	
				print "&nbsp;&nbsp;<a href=\"http://crfb.univ-mrs.fr/aniseed/view-net.php?clusterid=$mut_gene&dev_stage=$devname&anat_name=$id&h=500\"><small><small>(View Network)</small></small></a>";
			;
		}
		print "</td>";
	
		foreach($wts as $wt_gene){
			print "<td>";
			if(isset($wtlist[$wt_gene]))
			{
				$in_sits_muts = (array)null;
				$in_sits_wts = (array)null;
				$evidence_display = (array)null;
				$up_down_list = $wtlist[$wt_gene];
				$type = '';
				foreach($up_down_list as $up_down => $evidence){
					$type = $up_down;
					foreach($evidence as $pair_list)
					{
						//print "<tr align=\"center\"><td><font size=\"2\">".$pair_list[0]." vs ".$pair_list[1]."</b></font></td></tr>";
						if(!in_array($pair_list[0],$in_sits_muts))
						{
							$in_sits_muts[]= $pair_list[0];
						}
						if(!in_array($pair_list[1],$in_sits_wts))
						{
							$in_sits_wts[]= $pair_list[1];
						}
						if(!in_array($pair_list[1],$evidence_display))
						{
							$evidence_display[]= $pair_list[2];
						}
					}
				}
				if(count($up_down_list)>1)
				{
					$type='conflict';
				}
				$link = '';
				foreach($evidence_display as $evidence_id)
				{
					$link .= "$evidence_id:";
				}
				$link = substr($link,0,-1);
				$type = preg_replace("/indirectly\s/","",$type);
				$type = preg_replace("/upregulates/","activates",$type);
				$type = preg_replace("/downregulates/","represses",$type);
				print "<font size=\"1\"><a href=\"display-evidence.php?evidences=$link\" target=\"_blank\">$type</a></font>";
			}
			else
			{
				print "&nbsp;";
			}
			print "</td>";
		}
		print "</tr>";
		
	}
	
	

	print '</table>';
///////////////////////////////////////////////////////////////////////////////////////	
		
	print '<br><br><br>';

///////////////////////////////////////////////////////////////////////////////////////

	print "</center>";
	
?>

<?php
    include("frames_footer.php");
?>