<?php
include_once("../constant.php");
///Daniel Sobral
///obtains indirect evidence from in_situ expression and morpholinos

/////////////////////////SIMPLIFY HIERARCHY
function simplify_hierarchy($hierarch,$root,$leaf_lsts,$region_lst){

	$ret_list = (array) null;	
	$expand_list = (array) null;
	foreach($region_lst as $region){ 
		if(isset($leaf_lsts[$region])){	$expand_list = array_merge($expand_list,$leaf_lsts[$region]); }
	}
	$parent_list = array($root);

	while(count($expand_list)>0){
		$child_list = (array)null;
		foreach ($parent_list as $cur_anat){		
			$cur_leafs = (array)null;	
			if(isset($leaf_lsts[$cur_anat])) { $cur_leafs = $leaf_lsts[$cur_anat]; }
			if(count(array_intersect($cur_leafs,$expand_list))>=count($cur_leafs)){
				$ret_list[]=$cur_anat;
			} else { 
				if(isset($hierarch[$cur_anat])){
					$child_list = array_merge($child_list, $hierarch[$cur_anat]);	
				}
			}
		}
		if(count($child_list)==0){ 	break; }
		$parent_list = $child_list;
	}		
	return $ret_list;
}	
/////////////////////////SIMPLIFY HIERARCHY

$c=pg_connect("host=$hostAniseed dbname=$dbnameAniseed user=$userSuperAniseed password=$passwordSuperAniseed") or die("<h3>NO CONNECTION</h3>");

print '<html>';
print '<title>Calculate Evidence for Regulation Events</title>';

print '<body>';

//calculate hierarchy and stuff for anatomy simplification
$hierarchy=(array) null;
$parent_lsts=(array) null;
$leaf_lsts=(array) null;
$roots=(array) null;

ini_set("memory_limit","128M");

$khoueiry = "SELECT A.\"DEV_STAGE_ID\", A.\"ANAT_ID\" AS \"CHILD\", B.\"ANAT_ID\" AS \"PARENT\", B.\"NAME\" FROM 
		\"ANAT_ENTITY\" A, \"ANAT_ENTITY\" B WHERE A.\"CHILD_OF\"=B.\"ANAT_ID\" ";
$stmt = pg_query($c,$khoueiry);
$anat_lst=(array) null;
$inv_hierarchy=(array) null;
while($row=pg_fetch_array($stmt)){
	$inv_hierarchy[$row["DEV_STAGE_ID"]][$row["CHILD"]]=$row["PARENT"];	
	$hierarchy[$row["DEV_STAGE_ID"]][$row["PARENT"]][]=$row["CHILD"];
	$anat_lst[$row["DEV_STAGE_ID"]][$row["CHILD"]]=1;	
	$anat_lst[$row["DEV_STAGE_ID"]][$row["PARENT"]]=1;			
	if($row["NAME"]=='Whole embryo'){ $roots[$row["DEV_STAGE_ID"]] = $row["PARENT"]; }
}

foreach($anat_lst as $stage => $st_anat_lst){
	foreach ($st_anat_lst as $anat => $bogus){		

		$cur_par = $anat;		
		$par_lst=(array) null;
		while(true){
			$par_lst[count($par_lst)] = $cur_par;
			if(!isset($inv_hierarchy[$stage][$cur_par])){
				break;
			} 
			$cur_par = $inv_hierarchy[$stage][$cur_par];
		}
		$parent_lsts[$stage][$anat] = $par_lst;
	
		$to_process=array($anat);
		while(count($to_process)>0){
			$cur = array_pop($to_process);
			if(!isset($hierarchy[$stage][$cur])){
				$leaf_lsts[$stage][$anat][] = $cur;
			} else {
				foreach($hierarchy[$stage][$cur] as $child){
					array_push($to_process, $child);
				}
			}					
		}		
	}
}
//END calculate hierarchy and stuff for anatomy simplification


//Start indirect evidence  - Select only curated records!
$khoueiry="SELECT \"MUTANT\".\"IN_SITU_ID\", \"MUTANT\".\"CTRL_ISH_ID\", \"MUTANT\".\"NAME\", \"MUTANT\".\"UP_DOWN\",
	\"IN_SITU\".\"DEV_STAGE_ID\" FROM \"MUTANT\", \"IN_SITU\" WHERE \"MUTANT\".\"IN_SITU_ID\"=\"IN_SITU\".\"IN_SITU_ID\" AND  \"IN_SITU\".\"CHECKED\"='y' AND \"MUTANT\".\"IN_SITU_ID\" NOT IN (SELECT \"IN_SITU_ID\" FROM \"EMBRYO_MANIP\")";
$stmt = pg_query($c,$khoueiry);
$mut_in_situs=(array) null;
$mut_ctrl_situs=(array) null;
$mut_up_down=(array) null;
$mut_gene_affected=(array) null;
$mut_dev_stages=(array) null;
$gene_names=(array) null;
$conflict_ish = (array) null;
while($row=pg_fetch_array($stmt)){ 		
	//TODO TODO: Check for duplicate of a gene 	
	$mut_in_situs[count($mut_in_situs)] = $row["IN_SITU_ID"];		
	$mut_ctrl_situs[$row["IN_SITU_ID"]] = $row["CTRL_ISH_ID"]+0;
	if(isset($mut_up_down[$row["IN_SITU_ID"]]) && ($mut_up_down[$row["IN_SITU_ID"]] !== $row["UP_DOWN"])){
		$conflict_ish[] = $row["IN_SITU_ID"];
	}
	$mut_up_down[$row["IN_SITU_ID"]] = $row["UP_DOWN"];
	$mut_gene_affected[$row["IN_SITU_ID"]] = $row["NAME"];
	$mut_dev_stages[$row["IN_SITU_ID"]] = $row["DEV_STAGE_ID"];
	$gene_names[$row["NAME"]]=$row["NAME"];
}

$trans_names=(array) null;
foreach ($gene_names as $gene => $name){
	//try to find the real names of the genes...
	$khoueiry = "SELECT \"GENE_CLUSTER_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_MODEL_ID\" IN 
			(SELECT \"GENE_ID\" FROM \"GENE\" WHERE \"NAME\"='$gene');";
	$stmt = pg_query($c,$khoueiry);
	if($row=pg_fetch_array($stmt)){ 
		$trans_names[$gene] = $row["GENE_CLUSTER_ID"]; 
	} else {
		$trans_names[$gene] = $name; 
	}	
}

for($ix=0;$ix<count($mut_in_situs);$ix++){
	$ish = $mut_in_situs[$ix];
	if(in_array($ish,$conflict_ish)){
		
		print $ish." is both up and downregulated in the same in-situ<br/>";
		
		continue;
	}
	
	$ish_gene_mut = $trans_names[$mut_gene_affected[$ish]];
	$stage = $mut_dev_stages[$ish];
	$ctrl_ish = $mut_ctrl_situs[$ish];
	$up_down = $mut_up_down[$ish];
	
	$total_mut_regions=(array) null;	

	/////////////////////////////JGI
	$khoueiry = "		
	(SELECT DISTINCT \"GENE_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"GENE_CONCEPT\" WHERE 
		\"TARGET_ID\"=\"GENE_MODEL_ID\" AND \"IN_SITU_ID\"=$ish)
	UNION
	(SELECT DISTINCT \"GENE_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE_SEQ\", \"GENE_CONCEPT\" WHERE 
		\"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND 
		\"ANISEED_CLUSTER_ID\"=\"GENE_MODEL_ID\" AND \"IN_SITU_ID\"=$ish)
	UNION
	(SELECT DISTINCT \"GENE_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\", \"GENE_CONCEPT\" WHERE 
		\"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND \"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" AND 
		\"ANISEED_CLUSTER_ID\"=\"GENE_MODEL_ID\" AND \"IN_SITU_ID\"=$ish)	
	";	
	$stmt = pg_query($c,$khoueiry);	
	
	while($row=pg_fetch_array($stmt)){ 
		$arr = (array)null;
		if(isset($total_mut_regions[$row["GENE_CLUSTER_ID"]])){
			$arr = $total_mut_regions[$row["GENE_CLUSTER_ID"]];
		}
		if(isset($leaf_lsts[$stage][$row["REGION_ID"]])){
			$arr = array_merge($arr,$leaf_lsts[$stage][$row["REGION_ID"]]);
			$arr = array_unique($arr);
		}
		
		$total_mut_regions[$row["GENE_CLUSTER_ID"]] = $arr;
	}
	
	////////////////////////////////////////////////ENSEMBL
/*	
	if(count($total_mut_regions)==0){
		$khoueiry = "		
	(SELECT DISTINCT \"GENE_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE_SEQ\", \"GENE_CONCEPT\",
		\"TRANSCRIPT\" WHERE \"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND 
		\"ANISEED_ENSEMBL_CLUSTER_ID\"=\"ABSTRACT_ID\" AND \"TRANSCRIPT_ID\"=\"GENE_MODEL_ID\" AND \"IN_SITU_ID\"=$ish)
	UNION
	(SELECT DISTINCT \"GENE_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\", \"GENE_CONCEPT\",
		\"TRANSCRIPT\" WHERE \"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND
		\"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" AND \"ANISEED_ENSEMBL_CLUSTER_ID\"=\"ABSTRACT_ID\" AND 
		\"TRANSCRIPT_ID\"=\"GENE_MODEL_ID\" AND \"IN_SITU_ID\"=$ish)	
			";		
		
		$stmt = pg_query($c,$khoueiry);	
	
		while($row=pg_fetch_array($stmt)){ 
			$arr = (array)null;
			if(isset($total_mut_regions[$row["GENE_CLUSTER_ID"]])){
				$arr = $total_mut_regions[$row["GENE_CLUSTER_ID"]];
			}
			if(isset($leaf_lsts[$stage][$row["REGION_ID"]])){
				$arr = array_merge($arr,$leaf_lsts[$stage][$row["REGION_ID"]]);
				$arr = array_unique($arr);
			}
		
			$total_mut_regions[$row["GENE_CLUSTER_ID"]] = $arr;
		}
		
	}
*/	
	
	//////////////////////////////////////////////// TODO KYOTO
/*	
	if(count($total_mut_regions)==0){
		
		$khoueiry = "		
	SELECT DISTINCT \"ANISEED_KYOTO_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE_SEQ\"
		WHERE \"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND \"IN_SITU_ID\"=$ish
	UNION
	(SELECT DISTINCT \"ANISEED_KYOTO_CLUSTER_ID\", \"REGION_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\"
		WHERE \"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND \"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" 
		AND \"IN_SITU_ID\"=$ish)	
		";				
		
		$stmt = pg_query($c,$khoueiry);	
		while($row=pg_fetch_array($stmt)){
			$kh2 = "SELECT DISTINCT \"GENE_CLUSTER_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_MODEL_ID\" IN
				(SELECT \"GENE_ID\" FROM \"GENE\" WHERE \"NAME\" LIKE '%".$row["ANISEED_KYOTO_CLUSTER_ID"].".%');";
			$st2 = pg_query($c,$kh2);	
			while($r2=pg_fetch_array($st2)){ 
				$arr = (array)null;
				if(isset($total_mut_regions[$r2["GENE_CLUSTER_ID"]])){
					$arr = $total_mut_regions[$r2["GENE_CLUSTER_ID"]];
				}
				if(isset($leaf_lsts[$stage][$row["REGION_ID"]])){
					$arr = array_merge($arr,$leaf_lsts[$stage][$row["REGION_ID"]]);
					$arr = array_unique($arr);
				}
				$total_mut_regions[$r2["GENE_CLUSTER_ID"]] = $arr; 
			}
		}
	}
*/	
	
	foreach ($total_mut_regions as $target => $mut_regions){						
		
		////////////////////////////////////////////////JGI
		$khoueiry = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE 
			\"DEV_STAGE_ID\"=$stage AND \"WILD_TYPE\"='y' AND \"CHECKED\"='y' AND \"IN_SITU_ID\" IN 
		( 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\" WHERE \"TARGET_ID\" IN 
				(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target'))
		UNION 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE_SEQ\" WHERE 
				\"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND \"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target')) 				
		UNION 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\" WHERE 	
				\"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND \"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" AND 
				\"CLONE_SEQ\".\"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target'))
		) ";
		
		$stmt = pg_query($c,$khoueiry);
		$comp_insitus=(array) null;
		while($row=pg_fetch_array($stmt)){ $comp_insitus[] = $row["IN_SITU_ID"]; }
		
/*
		////////////////////////////////////////////////ENSEMBL
		
		$khoueiry = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE 
			\"DEV_STAGE_ID\"=$stage AND \"WILD_TYPE\"='y' AND \"CHECKED\"='y' AND \"IN_SITU_ID\" IN 
		( 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE_SEQ\", \"TRANSCRIPT\" WHERE 
			\"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND 
			\"ANISEED_ENSEMBL_CLUSTER_ID\"=\"ABSTRACT_ID\" AND \"TRANSCRIPT_ID\" IN 
				(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target')) 					
		UNION 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\", \"TRANSCRIPT\" WHERE 	
			\"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND \"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" AND 
			\"ANISEED_ENSEMBL_CLUSTER_ID\"=\"ABSTRACT_ID\" AND \"TRANSCRIPT_ID\" IN 
				(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target'))
		) ";
		
		$stmt = pg_query($c,$khoueiry);
		while($row=pg_fetch_array($stmt)){ $comp_insitus[] = $row["IN_SITU_ID"]; }
*/		
		////////////////////////////////////////////////KYOTO
/*		
		$khoueiry = "SELECT \"IN_SITU_ID\" FROM \"IN_SITU\" WHERE 
			\"DEV_STAGE_ID\"=$stage AND \"WILD_TYPE\"='y' AND \"CHECKED\"='y' AND \"IN_SITU_ID\" IN 
		( 
			(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE_SEQ\" WHERE 
			\"TARGET\".\"TARGET_ID\"=\"CLONE_SEQ\".\"CLONE_SEQ_ID\" AND 
			\"ANISEED_KYOTO_CLUSTER_ID\" IN 
				(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target')) 					
	UNION 
		(SELECT DISTINCT \"IN_SITU_ID\" FROM \"TARGET\", \"CLONE\", \"CLONE_SEQ\" WHERE 	
			\"TARGET\".\"TARGET_ID\"=\"CLONE\".\"CLONE_ID\" AND \"CLONE_SEQ\".\"CLONE_NAME\"=\"CLONE\".\"CLONE_NAME\" AND 
			\"ANISEED_KYOTO_CLUSTER_ID\" IN 
				(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$target'))
		) ";
		
		$stmt = pg_query($c,$khoueiry);
		while($row=pg_fetch_array($stmt)){ $comp_insitus[] = $row["IN_SITU_ID"]; }		
*/

/*		
		$comp_insitus = array_unique($comp_insitus);
*/
		
		////Go through all ISH
		for ($k=0;$k<count($comp_insitus);$k++) {		
			$cur_wt = $comp_insitus[$k];		
		
			//TODO - There is a problem if more than one target exist in the same ISH: 			
			$khoueiry = "SELECT DISTINCT \"REGION_ID\", \"ANAT_ENTITY\".\"NAME\" FROM \"TARGET\", \"ANAT_ENTITY\" WHERE \"REGION_ID\"=\"ANAT_ID\" AND \"IN_SITU_ID\"=".$cur_wt;	
			$stmt = pg_query($c,$khoueiry);
			$comp_regions=(array) null;		
			while($row=pg_fetch_array($stmt)){ 
				if(isset($leaf_lsts[$stage][$row["REGION_ID"]])){
					$comp_regions = array_merge($comp_regions,$leaf_lsts[$stage][$row["REGION_ID"]]);
				}
			}		
			
			$comp_regions = array_unique ( $comp_regions );
					
			$up_regions = (array)null;
			$down_regions = (array)null;
			
			if($up_down=='downregulated'){
				$up_regions = array_diff($comp_regions, $mut_regions);
				$down_regions = array_diff($mut_regions, $comp_regions);
			} else {
				$down_regions = array_diff($comp_regions, $mut_regions);
				$up_regions = array_diff($mut_regions, $comp_regions);
			}
			
			$up_regions  = simplify_hierarchy($hierarchy[$stage],$roots[$stage],$leaf_lsts[$stage],$up_regions);
			$down_regions  = simplify_hierarchy($hierarchy[$stage],$roots[$stage],$leaf_lsts[$stage],$down_regions);			
			
			foreach($up_regions as $up_region){
				print "$ish_gene_mut upregulates $target in $up_region : $ish - $cur_wt</br>";
				
				$khoueiry = "INSERT INTO \"REG_EVIDENCE\" (\"GENE_X\", \"GENE_Y\", \"TYPE\", \"REG_ANAT\", \"DIRECT\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE_ID\") VALUES ('$ish_gene_mut', '$target', 'upregulates', $up_region, 'n', $ish, $cur_wt, $stage) ";	
				$stmt = pg_query($c,$khoueiry) or die("ERROR: ".pg_last_error($c));
			}
			foreach($down_regions as $down_region){
				
				print "$ish_gene_mut downregulates $target in $down_region : $ish - $cur_wt</br>";
				
				$khoueiry = "INSERT INTO \"REG_EVIDENCE\" (\"GENE_X\", \"GENE_Y\", \"TYPE\", \"REG_ANAT\", \"DIRECT\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE_ID\") VALUES ('$ish_gene_mut', '$target', 'downregulates', $down_region, 'n', $ish, $cur_wt, $stage) ";	
				$stmt = pg_query($c,$khoueiry) or die("ERROR: ".pg_last_error($c));
			}
								
		}
		
	}		

}
//END indirect evidence

print '<br/>The End</body></html>';
?>
