<?php

////Daniel Sobral
/// Obtains indirect evidence from analysis of regulatory region and morpholinos

/////////////////////////SIMPLIFY HIERARCHY
function simplify_hierarchy($hierarch,$root,$leaf_lsts,$region_lst){

	$ret_list = (array) null;	
	$expand_list = (array) null;
	foreach($region_lst as $region){ 
		if(isset($leaf_lsts[$region])){	$expand_list = array_merge($expand_list,$leaf_lsts[$region]); }
	}
	$parent_list = array($root);

	while(count($expand_list)>0){
		$child_list = (array)null;
		foreach ($parent_list as $cur_anat){		
			$cur_leafs = (array)null;	
			if(isset($leaf_lsts[$cur_anat])) { $cur_leafs = $leaf_lsts[$cur_anat]; }
			if(count(array_intersect($cur_leafs,$expand_list))>=count($cur_leafs)){
				$ret_list[]=$cur_anat;
			} else { 
				if(isset($hierarch[$cur_anat])){
					$child_list = array_merge($child_list, $hierarch[$cur_anat]);	
				}
			}
		}
		if(count($child_list)==0){ 	break; }
		$parent_list = $child_list;
	}		
	return $ret_list;
}	
/////////////////////////SIMPLIFY HIERARCHY
include("../constant.php");
$c=pg_connect("host=$hostAniseed dbname=$dbnameAniseed user=$userSuperAniseed password=$passwordSuperAniseed") or die("<h3>NO CONNECTION</h3>");

print '<html>';
print '<title>Calculate Evidence for Direct Regulation Events Using Regulatory Region Data</title>';

print '<body>';

ini_set("memory_limit","128M");

//calculate hierarchy and stuff for anatomy simplification
$hierarchy=(array) null;
$parent_lsts=(array) null;
$leaf_lsts=(array) null;
$roots=(array) null;

$khoueiry = "SELECT A.\"DEV_STAGE_ID\", A.\"ANAT_ID\" AS \"CHILD\", B.\"ANAT_ID\" AS \"PARENT\", B.\"NAME\" FROM 
		\"ANAT_ENTITY\" A, \"ANAT_ENTITY\" B WHERE A.\"CHILD_OF\"=B.\"ANAT_ID\" ";
$stmt = pg_query($c,$khoueiry);
$anat_lst=(array) null;
$inv_hierarchy=(array) null;
while($row=pg_fetch_array($stmt)){
	$inv_hierarchy[$row["DEV_STAGE_ID"]][$row["CHILD"]]=$row["PARENT"];	
	$hierarchy[$row["DEV_STAGE_ID"]][$row["PARENT"]][]=$row["CHILD"];
	$anat_lst[$row["DEV_STAGE_ID"]][$row["CHILD"]]=1;	
	$anat_lst[$row["DEV_STAGE_ID"]][$row["PARENT"]]=1;			
	if($row["NAME"]=='Whole embryo'){ $roots[$row["DEV_STAGE_ID"]] = $row["PARENT"]; }
}

foreach($anat_lst as $stage => $st_anat_lst){
	foreach ($st_anat_lst as $anat => $bogus){		

		$cur_par = $anat;		
		$par_lst=(array) null;
		while(true){
			$par_lst[count($par_lst)] = $cur_par;
			if(!isset($inv_hierarchy[$stage][$cur_par])){
				break;
			} 
			$cur_par = $inv_hierarchy[$stage][$cur_par];
		}
		$parent_lsts[$stage][$anat] = $par_lst;
	
		$to_process=array($anat);
		while(count($to_process)>0){
			$cur = array_pop($to_process);
			if(!isset($hierarchy[$stage][$cur])){
				$leaf_lsts[$stage][$anat][] = $cur;
			} else {
				foreach($hierarchy[$stage][$cur] as $child){
					array_push($to_process, $child);
				}
			}					
		}		
	}
}
//END calculate hierarchy and stuff for anatomy simplification

$wt_expr = (array)null;
//Get "WT" expression for all constructions available
$khoueiry="SELECT \"TARGET\".\"IN_SITU_ID\", \"TARGET_ID\", \"REGION_ID\", 
	\"DEV_STAGE_ID\", \"WILD_TYPE\", \"CHECKED\" FROM 
	\"TARGET\", \"IN_SITU\" WHERE 
	\"TARGET\".\"IN_SITU_ID\" = \"IN_SITU\".\"IN_SITU_ID\" AND
	\"TARGET_ID\" IN (SELECT \"CONSTRUCTION_ID\" FROM \"CONSTRUCTION\");";
$stmt = pg_query($c,$khoueiry);
while($row=pg_fetch_array($stmt)){ 
	if(($row["CHECKED"]=="y") && ($row["WILD_TYPE"]=="y")){
		$arr = (array)null;
		if(isset($wt_expr[$row["TARGET_ID"]][$row["DEV_STAGE_ID"]][$row["IN_SITU_ID"]])){
			$arr = $wt_expr[$row["TARGET_ID"]][$row["DEV_STAGE_ID"]][$row["IN_SITU_ID"]];
		}
		if(isset($leaf_lsts[$row["DEV_STAGE_ID"]][$row["REGION_ID"]])){
			$arr = array_merge($arr,$leaf_lsts[$row["DEV_STAGE_ID"]][$row["REGION_ID"]]);
			$arr = array_unique($arr);
		}
		$wt_expr[$row["TARGET_ID"]][$row["DEV_STAGE_ID"]][$row["IN_SITU_ID"]] = $arr;
		
	}
}

$target_promoter = (array)null;
$promoter_target = (array)null;
//check the reg regions associated to these constructions
foreach ($wt_expr as $target => $tglist){
	$khoueiry="SELECT \"PROMOTER_ID\" FROM \"CONSTRUCTION\" WHERE \"CONSTRUCTION_ID\"=$target";
	$stmt = pg_query($c,$khoueiry);	
	if($row=pg_fetch_array($stmt)){ 
		$target_promoter[$target] = $row["PROMOTER_ID"];
		$promoter_target[$row["PROMOTER_ID"]][] = $target;
	}	
}

//try to rebuild the promoter hierarchies...
$children = (array)null;
$prom_hierarchy = (array)null;
foreach ($target_promoter as $target => $promoter){	
	if(!isset($children[$promoter])){
		//avoid repeated work...
		$proc = array($promoter);		
		while(count($proc)>0){ 		
			$current = array_pop($proc);					
			$khoueiry = "SELECT \"PROMOTER_ID\" FROM \"PROMOTER\" WHERE \"BASE_REG_ID\"=$current AND \"PROMOTER_ID\"!=$current";
			$stmt = pg_query($c,$khoueiry);
			while($row=pg_fetch_array($stmt)){
				array_push($proc,$row["PROMOTER_ID"]);
				$children[$promoter][] = $row["PROMOTER_ID"];
				$prom_hierarchy[$current][] = $row["PROMOTER_ID"];
			}			
		}	
	}	
}

//Start direct evidence
foreach ($promoter_target as $promoter => $target_list){	

	//What is the gene associated to this promoter...
	$prom_genes = (array)null;
	$khoueiry="SELECT \"GENE_CLUSTER_ID\" FROM \"GENE_REGULATION\", \"GENE_CONCEPT\"
					WHERE \"GENE_MODEL_ID\"=\"GENE_ID\" AND \"PROMOTER_ID\"=$promoter";	
	$stmt = pg_query($c,$khoueiry);
	while($row=pg_fetch_array($stmt)){
		if(!in_array($row["GENE_CLUSTER_ID"],$prom_genes)){
			$prom_genes[]=$row["GENE_CLUSTER_ID"];
		}
	}

	//A) Check if there are any binding sites associated to this promoter
	$mother_motifs = (array)null;
	$khoueiry = "SELECT \"MOTIF_ID\", \"BEGIN\", \"MOTIF_COORD_ID\" FROM \"MOTIF_COORD\" WHERE \"PROMOTER_ID\"=$promoter";
	$stmt = pg_query($c,$khoueiry);
	while($row=pg_fetch_array($stmt)){
		$mother_motifs[$row["MOTIF_ID"]][$row["BEGIN"]] = $row["MOTIF_COORD_ID"];
	}			
	
	//B) Check the children and see if there are binding sites affected...
	$children_motifs = (array)null;
	if(isset($children[$promoter]) && (count($children[$promoter])>0)){
		$khoueiry = "SELECT \"PROMOTER_ID\", \"MOTIF_ID\", \"BEGIN\", \"MOTIF_COORD_ID\" FROM \"MOTIF_COORD\" 
			WHERE \"PROMOTER_ID\" IN (".implode(",",$children[$promoter]).")";
		$stmt = pg_query($c,$khoueiry);
		while($row=pg_fetch_array($stmt)){
			$children_motifs[$row["PROMOTER_ID"]][$row["MOTIF_ID"]][$row["BEGIN"]] = $row["MOTIF_COORD_ID"];
		}			
	}

	$distinct_motif_coords = (array)null;
	foreach ($children_motifs as $child_promoter => $child_motifs){		
		foreach ($mother_motifs as $motif => $coords_list){
			foreach ($coords_list as $begin => $motif_coord){
				if(!isset($child_motifs[$motif]) || !isset($child_motifs[$motif][$begin])){
					$distinct_motif_coords[$child_promoter][$motif][] = $motif_coord;						
				}					
			}			
		}				
	}
	
	if(count($distinct_motif_coords)>0){
		
		//Get all in_situs from this promoter...
		foreach ($target_list as $target){
			if(isset($wt_expr[$target])){
				foreach($wt_expr[$target] as $stage => $in_situ_list) {
					foreach($in_situ_list as $wtish => $wt_regions){
					
						foreach ($distinct_motif_coords as $child_prom => $motif_lists){
						
							$gene_list =(array)null;
							foreach ($motif_lists as $motif => $coord_list){
								foreach ($coord_list as $coord){
									$khoueiry="SELECT \"GENE_CLUSTER_ID\" FROM 
										\"MOTIF_COORD_GENE\", \"GENE_CONCEPT\" WHERE 
										\"GENE_MODEL_ID\"=\"GENE_ID\" AND \"MOTIF_COORD_ID\"=$coord";
									$stmt = pg_query($c,$khoueiry);	
									while($row=pg_fetch_array($stmt)){
										if(!in_array($row["GENE_CLUSTER_ID"],$gene_list)){
											$gene_list[] = $row["GENE_CLUSTER_ID"];
										}
									}
								}
							}					
						
							if((count($gene_list)>0) && isset($promoter_target[$child_prom])){
								foreach ($promoter_target[$child_prom] as $child_target){									
									if(isset($wt_expr[$child_target]) && isset($wt_expr[$child_target][$stage])){
										foreach($wt_expr[$child_target][$stage] as $mutish => $mut_regions){
																	
											$up_regions = simplify_hierarchy($hierarchy[$stage],
																				$roots[$stage],
																				$leaf_lsts[$stage],
																				array_diff($wt_regions, $mut_regions));
																				
											$down_regions = simplify_hierarchy($hierarchy[$stage],
																				$roots[$stage],
																				$leaf_lsts[$stage],
																				array_diff($mut_regions,$wt_regions));
											
											foreach ($up_regions as $up_region) {
												foreach ($prom_genes as $prom_gene){
													foreach ($gene_list as $aff_gene){
														$khoueiry = "INSERT INTO \"REG_EVIDENCE\" (\"GENE_X\", \"GENE_Y\", \"TYPE\", \"REG_ANAT\", \"DIRECT\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE_ID\") VALUES ('$aff_gene', '$prom_gene', 'upregulates', $up_region, 'y', $mutish, $wtish, $stage) ";	
														$stmt = pg_query($c,$khoueiry) or die("ERROR!");	
														print "Gene $aff_gene upregulates $prom_gene in $up_region: $mutish against $wtish<br/>";
													}
												}
											}											
											
											foreach ($down_regions as $down_region) {
												foreach ($prom_genes as $prom_gene){
													foreach ($gene_list as $aff_gene){
														$khoueiry = "INSERT INTO \"REG_EVIDENCE\" (\"GENE_X\", \"GENE_Y\", \"TYPE\", \"REG_ANAT\", \"DIRECT\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE_ID\") VALUES ('$aff_gene', '$prom_gene', 'upregulates', $down_region, 'y', $mutish, $wtish, $stage) ";	
														$stmt = pg_query($c,$khoueiry) or die("ERROR!");	
														print "Gene $aff_gene downregulates $prom_gene in $down_region: $mutish against $wtish<br/>";
													}
												}
											}
											
										}
									}
								}
							}
						}					
					}
				}
			}			
		}
	
	} 
	
	
}

print '<br/>The End</body></html>';
?>
