<html>
<head>
<title>ANISEED - Gene Ontology result (Ciona intestinalis, Halocynthia roretzi)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="The ANISEED pipeline annotation forms the basis for the Gene Ontology classifications for Ciona intestinalis and Halocynthia roretzi genes. This page lists the GO terms corresponding to your query.">
<meta name="keywords" content="Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database, ciona intestinalis gene, functional annotation, transcript model, Gene ontology, annotation">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>


<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include("connection.php");
include("frames_header.php");
?>

<?php
	$id="";
	$term="";
	$mode="";
	$genelist="";
	if(isset($_POST["id"]))
		$id=$_POST["id"];
	if(isset($_POST["term"]))
		$term=$_POST["term"];
	if(isset($_POST["mode"]))
		$mode=$_POST["mode"];
	if(isset($_POST["genelist"]))
		$genelist=$_POST["genelist"];
	if (isset($_POST["notin"]))
		$notin=$_POST["notin"];
	if (isset($_POST["notin2"]))
		$notin=$_POST["notin2"];



	


	if((strlen($id)<=0)and(strlen($term)<=0)){
	    print "<br><br><center><strong>Please enter a word or an id to search for.</strong></center><br><br>";
	    include("frames_footer.php");
		return;
	}



// print $genelist;

    if(strlen($genelist)>0)
		print "<center><H2><font color=\"#FF6600\">Refine subset mode</font></H2></center>";
			
	print '<form action="GO-result2.php" method="post" name="form">';

   	print '<input name="genelist" type="hidden" value="'.$genelist.'">';

	print '<input name="notin" type="hidden" value="'.$notin.'">';
	

	print "&nbsp;&nbsp;<strong>Species: </strong>&nbsp;<select name=\"species\" size=\"1\">";
	

	/* ------ A MOI --------- */
	print "<option> </option>";

	$requete="SELECT \"NAME\" FROM \"SPECIES\" ORDER BY \"NAME\"";
	$query=pg_query($c,$requete);

	while ($row=pg_fetch_array($query))
		print "<option>".$row["NAME"]."</option>";
	
	print "</select>";
	
	/* -----------------------*/


	print '<br><br>&nbsp;&nbsp;<strong>Annotation origin: </strong>';
	print '&nbsp;&nbsp;<input name="originortho" type="checkbox" value="1" checked>Ortholog prediction';
	print '&nbsp;&nbsp;<input name="originip" type="checkbox" value="1" checked>Interpro';
	print '&nbsp;&nbsp;<input name="originblast" type="checkbox" value="1" checked>Best Blast hit';
	
	
	print "<br><br>&nbsp;<input border=\"1\" name=\"submit\" type=\"image\" src=\"pictures/button-GO.jpg\" onClick=\"submit\"><br><br>";
    print"<font size=\"-1\">Select GO terms of interest and click on \"get corresponding gene\" button.</font><br><br>";
	
	/* A MOI */
	if($mode=="term")
	{
	 $term=strtoupper($term);
	    $words = split (" ", $term);
	    $query="(UPPER(\"GO_TERM\") like '%$words[0]%')";
		for($a=1; $a<count($words); ++$a)
		    $query .= " OR (UPPER(\"GO_TERM\") like '%$words[$a]%')";
		
	    $requete2="select \"GO_ID\", \"GO_TERM\", \"GO_TYPE\", \"DEFINITION\" from \"GO\" where ".$query." order by \"GO_TYPE\"";

	$query=pg_query($c,$requete2);

	print "<center><table width=\"99%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">";
		print '<tr align="center" valign="middle"><td><font color="#456898" size="2"><b>GO ID</b></font></td><td><font color="#456898" size="2"><b>Type</b></font></td><td><font color="#456898" size="2"><b>Term</b></font></td><td><font color="#456898" size="2"><b>Definition</b></font></td></tr>';
        $count=0;
	
	while($row=pg_fetch_array($query)){
		        ++$count;
          
				print "<tr align=\"center\"><td><input name=\"go[]\" type=\"checkbox\" value=\"".$row["GO_ID"]."\"><font color=\"#656565\" size=\"-1\">".$row["GO_ID"]."</font></td><td><font color=\"#656565\" size=\"-1\">".$row["GO_TYPE"]."</font></td><td><font color=\"#656565\" size=\"-1\">".$row["GO_TERM"]."</font></td><td width=\"40%\"><font color=\"#656565\" size=\"-1\">&nbsp;".$row["DEFINITION"]."</font></td></tr>";
		     
		}
	print "</TABLE></center>";
		
		if($count==0)
		    print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
		else
		    print "<br><center>$count result(s)</center><br>";


	}
	/* ------ */
	else
	{
	
	    $id=strtoupper($id);
	    $id=ereg_replace(" ","','",$id);
	
	    $requete2="select \"GO_ID\", \"GO_TERM\", \"GO_TYPE\", \"DEFINITION\" from \"GO\" where \"GO_ID\" in ('".$id."') order by \"GO_TYPE\"";
	    
	$query=pg_query($c,$requete2);
	
	print "<center><table width=\"99%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">";
		print '<tr align="center" valign="middle"><td><font color="#456898" size="2"><b>GO ID</b></font></td><td><font color="#456898" size="2"><b>Type</b></font></td><td><font color="#456898" size="2"><b>Term</b></font></td><td><font color="#456898" size="2"><b>Definition</b></font></td></tr>';
        $count=0;
		while($row=pg_fetch_array($query)){
		        ++$count;
               
				print "<tr align=\"center\"><td><input name=\"go[]\" type=\"checkbox\" value=\"".$row["GO_ID"]."\" checked><font color=\"#656565\" size=\"-1\">".$row["GO_ID"]."</font></td><td><font color=\"#656565\" size=\"-1\">".$row["GO_TYPE"]."</font></td><td><font color=\"#656565\" size=\"-1\">".$row["GO_TERM"]."</font></td><td width=\"40%\"><font color=\"#656565\" size=\"-1\">&nbsp;".$row["DEFINITION"]."</font></td></tr>";
		      
		}
		print "</TABLE></center>";
		
		if($count==0)
		    print "<br><br><center><h2><strong>No match</strong></h2></center><br><br>";
		else
		    print "<br><center>$count result(s)</center><br>";
	}
	
	print '</form>';
?>
<?php
    include("frames_footer.php");
?>