<html>
	<head>
		<title>
			ANISEED - Est cluster alignment (Ciona intestinalis)
		</title>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
		<meta name="description"
			content="You will find on this page the nucleotide sequence and the amino-acid sequence of Halocynthia or Ciona of Est cluster. For more info, contact aniseed@ibdm.univ-mrs.fr">
		<meta name="keywords"
			content="Ciona intestinalis est cluster alignment, nucleotide sequence , amino acid sequence, Ciona intestinalis, Halocynthia roretzi, ascidian database, ciona intestinalis database, Ensembl, JGI, Kyoto.">
		<meta name="robots" content="index, follow, all">
		<meta http-equiv="Content-Language" content="EN">
		<style type="text/css">
			.alignment_cell
			{
				font-size: 11px;
				font-family: Courier New, Courier;
				font-weight: bold;
			}
		</style>
	
	</head>

<?php
/*
 ANISEED, NISEED System and Database
 Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
	include("connection.php");
	//Title before frames_header
	include("frames_header.php");
	
	function formatSequence($sequence)
	{
		$sequence = trim($sequence);
		return $sequence;
	}
	
	function formatSequenceV3($connection,$oidSequence)
	{
		//begin the transaction
		pg_query ($connection, "begin");
		$handle_lo = pg_lo_open($connection,$oidSequence,"r");
		$sequence = pg_lo_read($handle_lo);
		//end the transaction
		pg_query($connection,"end"); 
		$sequence = trim($sequence);
		return $sequence;
	}
	
	function formatAlignment($sequence,$start,$end,$lag=0)
	{
		$sequence = substr($sequence,$start-1,$end);
		$lagString = str_repeat(" ",$lag);
		$sequence = $lagString.$sequence;
		//$sequence = chunk_split($sequence, 70, "\n");
		return $sequence;
	}
	
	function displayAlignment($nameA,$sequenceA,$nameB,$sequenceB)
	{
		$arrayAlignment = array();
		$cptAlignment = 0;
		for($i=0;$i<strlen($sequenceA);$i++)
		{
			if($i%80==0)
			{
				if($i!=0)
				{
					$cptAlignment++;
				}
				$arrayAlignment{$cptAlignment}{$nameA} = array();
				$arrayAlignment{$cptAlignment}{$nameB} = array();
				$arrayAlignment{$cptAlignment}{"separator"} = array();
			}
			array_push($arrayAlignment{$cptAlignment}{$nameA},$sequenceA[$i]);
			if($sequenceA[$i]==$sequenceB[$i])
			{
				array_push($arrayAlignment{$cptAlignment}{"separator"},'|');
			}
			else
			{
				array_push($arrayAlignment{$cptAlignment}{"separator"},' ');
			}
			array_push($arrayAlignment{$cptAlignment}{$nameB},$sequenceB[$i]);
		}
		foreach($arrayAlignment as $line=>$arraySequenceName)
		{
			print("<table>");
			foreach($arraySequenceName as $name=>$arraySequence)
			{
				if($name!='separator')
				{
					if($name==$nameB)
					{
						print('<tr>');
						print("<th align=\"left\" style=\"padding-right: 10px\">");
						print("$name");
						print("</th>");
						foreach($arraySequence as $character)
						{
							print("<td class='alignment_cell'>");
							print($character);
							print("</td>");
						}
						print("</tr>");
						print("<br />");
						print("<br />");
						print("<br />");
					}
					else
					{
						print("<tr>");
						print("<th align=\"left\" style=\"padding-right: 10px\">");
						print("$name");
						print("</th>");
						foreach($arraySequence as $character)
						{
							print("<td width=10px class='alignment_cell'>");
							print($character);
							print("</td>");
						}
						print("</tr>");
						if($name==$nameA)
						{
							print("<tr>");
							print("<td>");
							print("</td>");
							foreach($arrayAlignment{$line}{"separator"} as $character)
							{
								print("<td class='alignment_cell'>");
								print($character);
								print("</td>");
							}
							print("</tr>");
						}
					}
				}
			}
			print("</table>");
		}
	}
?>

<?php
	$idTranscript = $_GET["transcript_id"];
	$idCluster = $_GET["cluster_id"];
	$queryAlignment = "SELECT \"NAME\" AS transcript_name, \"cluster_name\", \"sequence_prot\" AS cluster_sequence,
			\"SEQUENCE\" AS transcript_sequence, \"LENGTH\" AS length_transcript_sequence,
			\"qstart\", \"qend\", \"sstart\", \"send\"
		FROM \"EST_CLUSTER\" JOIN \"CC_TRANSCRIPT_ALIGNMENT\" USING(\"cluster_id\")
			JOIN \"MOL_ENTITY\" ON(\"transcript_id\"=\"MOL_ID\")
			JOIN \"PROT_SEQUENCE\" USING(\"MOL_ID\")
		WHERE \"transcript_id\"=$idTranscript AND \"cluster_id\"=$idCluster;";
	$resultAlignment = pg_query($c,$queryAlignment);
	if($arrayAlignment=pg_fetch_array($resultAlignment))
	{
		$nameTranscript = $arrayAlignment["transcript_name"];
		$nameCluster = $arrayAlignment["cluster_name"];
		$sequenceProtCluster = formatSequence($arrayAlignment["cluster_sequence"]);
		$sequenceProtTranscript = formatSequenceV3($c,$arrayAlignment["transcript_sequence"]);
		$lengthSequenceProtTranscript = $arrayAlignment["length_transcript_sequence"];
		$transcriptStart = $arrayAlignment["qstart"];
		$transcriptEnd = $arrayAlignment["qend"];
		$clusterStart = $arrayAlignment["sstart"];
		$clustertEnd = $arrayAlignment["send"];
		$lengthAlignment = $transcriptEnd-$transcriptStart+1;
		if($clusterStart==$transcriptStart)
		{
			$sequenceAlignmentTranscript = formatAlignment($sequenceProtTranscript,1,$transcriptEnd);
			$sequenceAlignmentCluster = formatAlignment($sequenceProtCluster,1,$clustertEnd);
		}
		else
		{
			if($clusterStart<$transcriptStart)
			{
				$sequenceAlignmentTranscript = formatAlignment($sequenceProtTranscript,1,$transcriptEnd);
				$sequenceAlignmentCluster = formatAlignment($sequenceProtCluster,1,$clustertEnd,$transcriptStart-$clusterStart);
			}
			else
			{
				$sequenceAlignmentTranscript = formatAlignment($sequenceProtTranscript,1,$transcriptEnd,$clusterStart-$transcriptStart);
				$sequenceAlignmentCluster = formatAlignment($sequenceProtCluster,1,$clustertEnd);
			}
		}
		print("<title>ANISEED - EST cluster sequence: $nameTranscript / $nameCluster.'</title>");
		print "<br /><br /><font color=\"#D64242\" size=\"3\"><b>$nameTranscript / EST cluster $nameCluster</b></font></h2>";
		print "<br /><u><font color=\"#456898\" size=\"3\"><b>Aligned sequence</b></font></u><br /><strong>Length: </strong>$lengthAlignment";
		displayAlignment($nameTranscript,$sequenceAlignmentCluster,'EST cluster',$sequenceAlignmentTranscript);
	}
?>

<?php
	include("frames_footer.php");
?> 
