<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
include("connection.php");
//Title before frames_header
?>
<title>ANISEED v3.0 - ESTs cluster</title>
<?
include("frames_header.php");
?>


  <link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<SCRIPT>
function CheckALL() {
		for(a=0; a<document.form.length; ++a){
			document.form[a].checked=!(document.form[a].checked);
		}
}
</SCRIPT>



<?php

	//connection
	

$clustid=$_GET["clusterid"];
$aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);


print '<title>ANISEED - Gene EST cluster : '.(str_replace("cluster","aniseedV3_",$clustid)).'</title>';


//// agregation des modeles de genes
$agreg_gm="";
$requete="SELECT \"NAME\" from \"GENE\" where \"GENE_ID\" in (
select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt))
{
if (strlen($agreg_gm)==0) $agreg_gm=$row["NAME"];
else $agreg_gm.=":".$row["NAME"];

}

?>

<link rel="stylesheet" type="text/css" media="screen" href="ongletv1.css" title="Version 1" />

<div id="header">
  <ul>    
        <li><a href="gene-card.php?clusterid=<?print $clustid;?>">Gene Card</a></li>
        <li id="current" ><a href="#" style="color:black;">ESTs cluster</a></li>
        <li><a href="insitu-result.php?target=<?print $agreg_gm;?>&MOLtype=2&Order=DEV_STAGE_ID&fromgenecard=1">Detailed Expression</a></li>
        <li><a href="gene-picture.php?clusterid=<? print $clustid; ?>">Expression at a glance <i><small><small><b><font color="crimson">New</font></b></small></small></i></a></li>
	<li><a href="moltool-result-gene.php?clusterid=<?print $clustid;?>">Molecular tool</a></li>
        <li ><a href="gene-regulation-card.php?clusterid=<?print $clustid; ?>">Upstream regulators</a></li>
        <li ><a href="gene-function-card.php?clusterid=<?print $clustid; ?>">Downstream targets</a></li>
        <li><a href="bib-mol.php?clusterid=<? print $clustid; ?>&function=1&regulation=1&wild=1">Articles</a></li>
        <!-- <li><a href="#" style="color:white;">Microarray probe</a></li> -->
        <!--<li><a href="#" style="color:white;">Export</a></li> -->
  </ul>
</div>
<br><br>

<?


$requete="
select \"NAME\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";

$stmt=pg_query($c,$requete);

$est=(array) null;
while ($row=pg_fetch_array($stmt))
{

///////////////////////////////////// KYOTO ////
if ($row["NAME"]{0}=="K") //KYOTO
{
$temp=explode(".",$row["NAME"]);
$abstract=$temp[0].".".$temp[1].".".$temp[2];
$qu="SELECT \"MOL_ID\" from \"MOL_ENTITY\" where \"NAME\"='$abstract' and \"TYPE\"='abstract'";
$st=pg_query($c,$qu);
$ro=pg_fetch_array($st);

$kyotoid=$ro["MOL_ID"];

$requete0="select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_KYOTO_CLUSTER_ID\"='$kyotoid'";
$stmt0=pg_query($c,$requete0);
while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;

}

///////////////////////////////////// ENSEMBL ////
if ($row["NAME"]{0}=="E")
	{
	$qu="SELECT \"ABSTRACT_ID\" from \"TRANSCRIPT\" where \"TRANSCRIPT_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$st=pg_query($c,$qu);
	$ro=pg_fetch_array($st);

 	$ensid=$ro["ABSTRACT_ID"];

	$requete0="select \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_ENSEMBL_CLUSTER_ID\"='$ensid'";
	$stmt0=pg_query($c,$requete0);
	while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;

	}

////////////////////////////////////// JGI

if ($row["NAME"]{0}=="c")
	{
	$requete0="SELECT \"CLONE_SEQ_ID\" from \"CLONE_SEQ\" where \"ANISEED_CLUSTER_ID\"=(select \"GENE_ID\" from \"GENE\" where \"NAME\"='".$row["NAME"]."')";
	$stmt0=pg_query($c,$requete0);
	while ($row0=pg_fetch_array($stmt0)) $est[$row0["CLONE_SEQ_ID"]]++;
	}



}


print "<br><br><font color=\"#D64242\" size=\"3\"><b>EST cluster for ".$aniseed_gm." gene</b></font><br>";


print "<br><font color=\"#456898\" size=\"3\"><b><u>Features</u></b></font><br><br>";
        print "<table width=\"100%\"><tr valign=\"top\" align=\"left\"><td width=\"20%\"><font color=\"#656565\" size=\"-1\"><b>Name: </b></font></td><td><font color=\"#656565\" size=\"-1\">Cluster_".$aniseed_gm."</font></td></tr>";
        print "<tr valign=\"top\" align=\"left\"><td><font color=\"#656565\" size=\"-1\"><b>Composition: </b></font></td><td><font color=\"#656565\" size=\"-1\">".(count($est))." sequences</font></td></tr>";

$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid'";
$stmt=pg_query($c,$requete);
$gm_name="";
while ($row=pg_fetch_array($stmt)) if (strlen($gm_name)==0) $gm_name=$row["GENE_CLUSTER_NAME"]; else $gm_name.=" / ".$row["GENE_CLUSTER_NAME"];


print "<tr valign=\"top\" align=\"left\"><td><font color=\"#656565\" size=\"-1\"><b>Corresponding gene: </b></font></td><td><a href=\"gene-card.php?clusterid=$clustid\"><font color=\"#000000\" size=\"-1\">$gm_name</font></a></td></tr>";

$requete="select distinct \"SPECIES\" from \"MOL_ENTITY\" where \"MOL_ID\" in (SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid')";
$stmt=pg_query($c,$requete);
$row=pg_fetch_array($stmt);
$species=$row["SPECIES"];


print "<tr valign=\"top\" align=\"left\"><td><font color=\"#656565\" size=\"-1\"><b>Species: </b></font></td><td><font color=\"#656565\" size=\"-1\">".$species."</font></td></tr>";

print "</table>";


print "<br><br><font color=\"#456898\" size=\"3\"><b><u>Cluster composition</u></b></font><br><br>";

print '<form name="form" action="AllClonesFASTA.php" target="_BLANK" method="POST">
<table width="50%" border="0" cellspacing="0" cellpadding="0">';
print '<tr align="center" valign="middle"><!--<td>&nbsp;</td>--><td><font color="#456898" size="2"><b>Clone name</b></font></td><td><font color="#456898" size="2"><b>Genbank ID</b></font></td><td><font color="#456898" size="2"><b>End</b></font></td></tr>';
$count=0;

foreach ($est as $key => $val)
{
$requete="SELECT \"GENBANK_ID\",\"CLONE_NAME\",\"END\" from \"CLONE_SEQ\" where \"CLONE_SEQ_ID\"='$key'";
$stmt = pg_query($c,$requete);
$row=pg_fetch_array($stmt);

print "<tr align=\"center\"><!--<td><input name=\"id[]\" type=\"checkbox\" value=\"".$row["GENBANK_ID"]."\"></td>--><td width=\"33%\"><a href=\"molecule-clone.php?name=".$row["GENBANK_ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["CLONE_NAME"]."</font></a></td><td width=\"33%\"><a href=\"molecule-clone.php?name=".$row["GENBANK_ID"]."\"><font color=\"#000000\" size=\"-1\">".$row["GENBANK_ID"]."</font></a></td><td width=\"33%\"><font color=\"#656565\" size=\"-1\">".$row["END"]."</font></td></tr>";

}

print "</table></form><br><br>";


// print "&nbsp;&nbsp;&nbsp;<img border=\"0\" src=\"pictures/button-selectALL.jpg\" onClick=\"CheckALL();\">";

print "&nbsp;&nbsp;&nbsp;<a href=\"ESTcluster-gene-sequence.php?clusterid=$clustid\"><img border=\"0\" src=\"pictures/button-download.jpg\"></a>";



?>


<?php
   	include("frames_footer.php");
?> 