<?
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

include ("connection.php");
print "<title> ANISEED V3.0 - Regulatory Network</title>";
include ("frames_header.php");

$regs=(array) null;

print "<br><br><font color=\"#D64242\" size=\"3\"><b>Interaction Inconsistencies</b></font><br><br>";

print "<table border=\"0\" width=\"100%\">";

$all_dev_stages = (array) null;	
$all_dev_stages_ids = (array) null;	
$anat_ids=(array) null;	
	
$khoueiry = "SELECT \"GENE_X\", \"GENE_Y\", \"REG_EVIDENCE\".\"TYPE\", \"REG_ANAT\", \"ANAT_ENTITY\".\"NAME\" AS \"ANAT_NAME\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE\".\"NAME\" AS \"STAGE_NAME\", \"DEV_STAGE\".\"DEV_STAGE_ID\" FROM \"REG_EVIDENCE\", \"DEV_STAGE\", \"ANAT_ENTITY\" WHERE \"ANAT_ENTITY\".\"ANAT_ID\"=\"REG_EVIDENCE\".\"REG_ANAT\" AND \"REG_EVIDENCE\".\"DEV_STAGE_ID\"=\"DEV_STAGE\".\"DEV_STAGE_ID\" ORDER BY \"DEV_PERCENT\"";
$stmt = pg_query($c,$khoueiry);
while($row=pg_fetch_array($stmt)){ 
	if(!in_array($row["STAGE_NAME"],$all_dev_stages)){ 
		$all_dev_stages[count($all_dev_stages)]=$row["STAGE_NAME"];
		$all_dev_stages_ids[count($all_dev_stages_ids)]=$row["DEV_STAGE_ID"];
	}
	$anat_ids[$row["STAGE_NAME"]][$row["ANAT_NAME"]]=$row["REG_ANAT"];
	$regs[$row["STAGE_NAME"]][$row["GENE_X"]][$row["GENE_Y"]][$row["ANAT_NAME"]][$row["TYPE"]][$row["EVIDENCE"]][$row["CONTROL"]] = 1;	
}

for ($i=0;$i<count($all_dev_stages);$i++) {

	$stage = $all_dev_stages[$i];
	$stage_id = $all_dev_stages_ids[$i];
	
	$stage_list = $regs[$stage];
	if(count($stage_list)>0){	
		print "<tr><td>$stage</td><td>&nbsp;</td></tr>";
	}
	
	foreach ($stage_list as $regulator => $regulated_list) {

		//// get name of the clustid
		$name=(array) null;
		$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$regulator' AND \"MANUAL\"='y'";
		$stmt=pg_query($c,$requete) or die (pg_last_error($c));
		while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$regulator'";
			$stmt=pg_query($c,$requete) or die (pg_last_error($c));
			while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		}
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$regulator'";
			$stmt=pg_query($c,$requete);
			while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
		}
		$regulator_name = $name[0];
		
		
		foreach($regulated_list as $target => $target_list) {
		
			//// get name of the clustid
			$name=(array) null;
			$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$target' AND \"MANUAL\"='y'";
			$stmt=pg_query($c,$requete) or die (pg_last_error($c));
			while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
			if (count($name)==0) {
				$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$target'";
				$stmt=pg_query($c,$requete) or die (pg_last_error($c));
				while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
			}
			if (count($name)==0) {
				$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$target	'";
				$stmt=pg_query($c,$requete);
				while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
			}
			$target_name = $name[0];
			
			foreach($target_list as $region => $region_list) {
				
				if(count($region_list)>1) {
					
					foreach($region_list as $up_down => $udre){
				
						$in_sits_muts = (array)null;
						$in_sits_wts = (array)null;
										
						foreach ($udre as $mut_ish => $wt_ish){
							if(!in_array($mut_ish,$in_sits_muts)){ $in_sits_muts[]= $mut_ish; }
							foreach ($wt_ish as $wt => $bogus) {
								if(!in_array($wt,$in_sits_wts)){ $in_sits_wts[]= $wt; }

							}									
						}		
						
						$evidence = "<font size=\"1\"><a href=\"display-evidence.php?insitus=".implode(":",$in_sits_muts ).":".implode(":",$in_sits_wts )."\" target=\"_blank\">evidence</a></font>";	
	
						print "<tr><td>&nbsp;</td><td> <a href=\"gene-card.php?clusterid=$regulator\" title=\"$regulator_name\">  $regulator_name </a> $p $np $up_down <a href=\"gene-card.php?clusterid=$target\" title=\"$vic_name\">  $target_name </a> in $region ($evidence) </td></tr>";	
					
					}
					
					print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
					
				}							
			}
		
		}
	
	}
}


print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr></table>";

include ("frames_footer.php");
?>