<?
// e.g. http://aniseed-ibdm.univ-mrs.fr/gene-regulatory-network.php?clusterid=cluster3592
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

include ("connection.php");
print "<title> ANISEED V3.0 - Regulatory Network</title>";
include ("frames_header.php");


$clustid=$_GET["clusterid"];
$aniseed_gm=str_replace("cluster","aniseedV3_",$clustid);

$regs=(array) null;

$all_dev_stages=(array) null;
$all_dev_stages_ids=(array) null;

//// get gene models related to the gene give by clustid
$gm_name=(array) null;
$gm_id=(array) null;
$requete="select \"NAME\", \"GENE_ID\" from \"GENE\" where \"GENE_ID\" in (
SELECT \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid'
)";
$stmt=pg_query($c,$requete);
while ($row=pg_fetch_array($stmt)) {
	$gm_name[count($gm_name)]=$row["NAME"];
	$gm_id[count($gm_id)]=$row["GENE_ID"];
}

//// agregation des modeles de genes
$agreg_gm="";
for ($i=0;$i<count($gm);$i++)	{
	if (strlen($agreg_gm)==0) $agreg_gm=$gm[$i];
	else $agreg_gm.=":".$gm[$i];
}

//// get name of the clustid
$name=(array) null;
$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid' AND \"MANUAL\"='y'";
$stmt=pg_query($c,$requete) or die (pg_last_error($c));
while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete) or die (pg_last_error($c));
	while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
}

if (count($name)==0) {
	$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$clustid'";
	$stmt=pg_query($c,$requete);
	while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
}

print "<br><br><font color=\"#D64242\" size=\"3\"><b>Gene Regulation</b></font><br><br>";

print "<table border=\"0\" width=\"100%\">";
$gene_name=implode (" / ",$name);
$display_name = $name[0];

print "<tr><td><font color=\"#456898\" size=\"2\"><b>Gene Name :</b></font></td><td><font size=\"2\">$gene_name</font></td></tr>";
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
print "<tr><td><font color=\"#456898\" size=\"2\"><b>Aniseed Gene id:</b></font></td><td><font size=\"2\">$aniseed_gm</font></td></tr>";
print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";


print "<tr><td><font color=\"#456898\" size=\"2\">Gene Regulation</font></td><td>&nbsp;</td></tr>";

$all_dev_stages = (array) null;	
$all_dev_stages_ids = (array) null;	
$anat_ids=(array) null;	
	
$khoueiry = "SELECT \"GENE_X\", \"REG_EVIDENCE\".\"TYPE\", \"REG_ANAT\", \"ANAT_ENTITY\".\"NAME\" AS \"ANAT_NAME\", \"EVIDENCE\", \"CONTROL\", \"DEV_STAGE\".\"NAME\" AS \"STAGE_NAME\", \"DEV_STAGE\".\"DEV_STAGE_ID\" FROM \"REG_EVIDENCE\", \"DEV_STAGE\", \"ANAT_ENTITY\" WHERE \"GENE_Y\"='$clustid' AND \"ANAT_ENTITY\".\"ANAT_ID\"=\"REG_EVIDENCE\".\"REG_ANAT\" AND \"REG_EVIDENCE\".\"DEV_STAGE_ID\"=\"DEV_STAGE\".\"DEV_STAGE_ID\" ORDER BY \"DEV_PERCENT\"";
$stmt = pg_query($c,$khoueiry);
while($row=pg_fetch_array($stmt)){ 
	if(!in_array($row["STAGE_NAME"],$all_dev_stages)){ 
		$all_dev_stages[count($all_dev_stages)]=$row["STAGE_NAME"];
		$all_dev_stages_ids[count($all_dev_stages_ids)]=$row["DEV_STAGE_ID"];
	}
	$anat_ids[$row["STAGE_NAME"]][$row["ANAT_NAME"]]=$row["REG_ANAT"];
	$regs[$row["STAGE_NAME"]][$row["GENE_X"]][$row["ANAT_NAME"]][$row["TYPE"]][$row["EVIDENCE"]][$row["CONTROL"]] = 1;	
}

for ($i=0;$i<count($all_dev_stages);$i++) {
//foreach($regs as $stage => $stage_list){

	$stage = $all_dev_stages[$i];
	$stage_id = $all_dev_stages_ids[$i];
	
	$stage_list = $regs[$stage];
	if(count($stage_list)>0){
		print "<tr><td>$stage</td><td>&nbsp;</td></tr>";
	}


	foreach ($stage_list as $victim => $cve){
	
		//Check where the gene $victim is expressing... $victim is not an appropriate name in this case...
		//Check where this gene is expressing!...
		$stageish=(array) null;
		
		$khoueiry = "SELECT \"TARGET\".\"IN_SITU_ID\", \"REGION_ID\" FROM \"TARGET\", \"IN_SITU\" WHERE 
			\"TARGET\".\"IN_SITU_ID\"=\"IN_SITU\".\"IN_SITU_ID\" AND \"DEV_STAGE_ID\"=$stage_id AND
			\"TARGET\".\"IN_SITU_ID\" NOT IN (SELECT \"IN_SITU_ID\" FROM \"MUTANT\") AND 
			\"TARGET\".\"IN_SITU_ID\" NOT IN (SELECT \"IN_SITU_ID\" FROM \"EMBRYO_MANIP\") AND
			\"TARGET_ID\" IN 
			(((SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$victim')
			UNION
			(SELECT \"CLONE_SEQ\".\"CLONE_SEQ_ID\" FROM \"CLONE_SEQ\" WHERE \"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$victim')))
			UNION
			(SELECT \"CLONE\".\"CLONE_ID\" FROM \"CLONE\" WHERE \"CLONE_NAME\" IN 
				(SELECT \"CLONE_NAME\" FROM \"CLONE_SEQ\" WHERE \"ANISEED_CLUSTER_ID\" IN 
					(SELECT \"GENE_MODEL_ID\" FROM \"GENE_CONCEPT\" WHERE \"GENE_CLUSTER_ID\"='$victim'))));";
		$stmt = pg_query($c,$khoueiry);		
		while($row=pg_fetch_array($stmt)){
			$stageish[$row["IN_SITU_ID"]][] = $row["REGION_ID"];
		}
	
		$vic_cluster = $victim;
		$victim=str_replace("cluster","aniseedV3_",$victim);
			
		//// get name of the clustid
		$name=(array) null;
		$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$vic_cluster' AND \"MANUAL\"='y'";
		$stmt=pg_query($c,$requete) or die (pg_last_error($c));
		while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME\" from \"GENE_CONCEPT_NAME\" where \"GENE_CLUSTER_ID\"='$vic_cluster'";
			$stmt=pg_query($c,$requete) or die (pg_last_error($c));
			while ($row=pg_fetch_array($stmt))	 { $name[count($name)]=$row["GENE_CLUSTER_NAME"]; }
		}
		if (count($name)==0) {
			$requete="SELECT \"GENE_CLUSTER_NAME_BLAST\" from \"GENE_CONCEPT_NAME_BLAST\" where \"GENE_CLUSTER_ID\"='$vic_cluster'";
			$stmt=pg_query($c,$requete);
			while ($row=pg_fetch_array($stmt)) { $name[count($name)]=$row["GENE_CLUSTER_NAME_BLAST"]; }
		}
		$vic_name = implode (" / ",$name);
		$vic_display_name = $name[0];
			
		foreach ($cve as $region => $cre){
			//if(count($cre)>1){ print "<tr><td>&nbsp;</td><td>CONFLICT!!</td></tr>";	}
			
			//calculate parents of this region
			$region_id = $anat_ids[$stage][$region];
			$khoueiry = "SELECT \"CHILD_OF\"  FROM 	\"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=$region_id;";
			$stmt = pg_query($c,$khoueiry);
			$parents[]=$region_id;
			while (($row=pg_fetch_array($stmt)) && (!is_null($row["CHILD_OF"]))){
				$parents[]=$row["CHILD_OF"];
				$khoueiry = "SELECT \"CHILD_OF\" FROM \"ANAT_ENTITY\" A WHERE \"ANAT_ID\"=".$row["CHILD_OF"];
				$stmt = pg_query($c,$khoueiry);
			}
			
			$present=(array) null;
			$notpresent=(array) null;
			foreach ($stageish as $ish => $regionlist){
				if(count(array_intersect($parents,$regionlist))>0){	$present[] = $ish;	} else { $notpresent[] = $ish;	}
			}
			
			foreach($cre as $up_down => $udre){
				//print "<tr><td>&nbsp;</td><td> <a href=\"gene-card.php?clusterid=$vic_cluster\" title=\"$vic_name\"> $victim </a> $up_down $aniseed_gm in $region</td></tr>";	
				
				$in_sits_muts = (array)null;
				$in_sits_wts = (array)null;
				
				foreach ($udre as $mut_ish => $wt_ish){
					if(!in_array($mut_ish,$in_sits_muts)){ $in_sits_muts[]= $mut_ish; }
					foreach ($wt_ish as $wt => $bogus) {
						if(!in_array($wt,$in_sits_wts)){ $in_sits_wts[]= $wt; }
				
					}			
				}		
				
				$region_id = $anat_ids[$all_dev_stages[$i]][$region];
				$region_link = "<a href=\"anatomy.php?dev=$stage_id&region=$region_id\" target=\"_blank\"> $region </a>";				
				$evidence = "<font size=\"1\"><a href=\"display-evidence.php?insitus=".implode(":",$in_sits_muts ).":".implode(":",$in_sits_wts )."\" target=\"_blank\">evidence</a></font>";	
				$p = "";
				$np = "";
				if(count($present)>0){
					$p = "<a href=\"display-evidence.php?insitus=".implode(":",$present)."\" target=\"_blank\">(P)</a>";	
				}
				if(count($notpresent)>0){
					$np = "<a href=\"display-evidence.php?insitus=".implode(":",$notpresent)."\" target=\"_blank\">(NP)</a>";	
				}
				
				print "<tr><td>&nbsp;</td><td> <a href=\"gene-card.php?clusterid=$vic_cluster\" title=\"$vic_name\"> $vic_display_name </a> $p $np $up_down $display_name in $region_link ($evidence) </td></tr>";
				
				
			}
			print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
		}
	}
}


//DOES THIS GENE HAS ANY EXPERIMENTALLY VERIFIED REGULATORY REGIONS?
/*
//only check public ones...
$khoueiry="select a.\"PROMOTER_ID\" from \"GENE_REGULATION\" b, \"PROMOTER\" a where a.\"PROMOTER_ID\"=b.\"PROMOTER_ID\" and b.\"GENE_ID\" in (select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid') and a.\"PRIVATE\"='n' and a.\"CHECKED\"='y' and a.\"BASE_REG_ID\"=a.\"PROMOTER_ID\";";
*/

/*
$khoueiry="SELECT G.\"PROMOTER_ID\", C.\"CONSTRUCTION_ID\", I.\"IN_SITU_ID\", D.\"NAME\", T.\"REGION_ID\" 
FROM \"TARGET\" T, \"IN_SITU\" I, \"DEV_STAGE\" D, \"CONSTRUCTION\" C, \"GENE_REGULATION\" G WHERE 
I.\"DEV_STAGE_ID\"=D.\"DEV_STAGE_ID\" AND T.\"IN_SITU_ID\"=I.\"IN_SITU_ID\" AND 
T.\"TARGET_ID\"=C.\"CONSTRUCTION_ID\" AND G.\"PROMOTER_ID\"=C.\"PROMOTER_ID\" AND 
G.\"GENE_ID\" IN (select \"GENE_MODEL_ID\" from \"GENE_CONCEPT\" where \"GENE_CLUSTER_ID\"='$clustid') 
ORDER BY D.\"DEV_PERCENT\"";

$stmt = pg_query($c,$khoueiry);
$reg_reg_expr=(array) null;
while($row=pg_fetch_array($stmt)){ 	
	$reg_reg_expr[$row["NAME"]][$row["REGION_ID"]][$row["PROMOTER_ID"]][$row["IN_SITU_ID"]] = 1;	
}
if(count($reg_regions)==0){ print "<tr><td>&nbsp;</td><td>There is no evidence for this gene being directly regulated by other genes</td></tr>"; }
//IF SO, WHAT ARE THE GENES POTENTIALLY DIRECTLY REGULATING IT?
*/

print "<tr><td>&nbsp;</td><td>&nbsp;</td></tr></table>";

include ("frames_footer.php");
?>