<html>
<head>
<title>ANISEED - AMI</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="description" content="Aniseed is applied for the moment to early ascidians (Ciona intestinalis and Halocynthia roretzi). Ascidians, which are marine invertebrate
chordates, are model organisms of choice because their embryos develop with a small number of cells and an invariant lineage.
Moreover, ascidians display a larval body plan similar to that of vertebrates.">
<meta name="keywords" content="Annotation, Curation, Aniseed, Curation, Annotation, Ciona intestinalis, Halocynthia roretzi, ciona intestinalis database, invertebrate, chordate, larval body plan, development, Tassy, Lemaire, Daian, Dauga, Sobral, Khoueiry">
<meta name = "robots" content = "index, follow, all">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<style type="text/css">
</style>
</head>

<?php
/*
    ANISEED, NISEED System and Database
    Copyright (C) 2007 Olivier Tassy, Fabrice Daian, Patrick Lemaire

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
    include("frames_header.php");
?>



<font size="+2" color="#D64242">AMI, The Article Minimum Information</font>
<font color="#000000" size="-1">
<p>
The curation process is significantly slowed down by missing information in the articles analyzed.
The identity of the clones used to generate ISH probes and the precise sequences tested in reporter
assays constituted the most frequent omissions. To help authors ensure in the future that necessary information is present in their article,
we defined the Article Minimum Information (AMI) guidelines.

<p>

This section describes for each experiment the mandatory (and useful) information that should be mentioned in literature articles to facilitate the curation process. 
These guidelines extend the minimal information defined by the MISFISHIE format (Deutsch at al. 2008, Nature Biotechnology).

<p>
<strong><font size="+1"> Minimal information to describe a wild-type spatio-temporal expression pattern</font></strong>
<br>
<br>
<em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>
<UL>
<LI>Developmental stage at which the expression was determined, according to the table of Hotta et al. (2007) </LI>
<LI>Clone(s) used to synthesize the in situ hybridization probes used in the experiment,  transgenic construct in the case of electroporations, or antibody, with reference, used in immunohistochemistry. </LI>
<LI>Annotation: use the anatomical ontology of ANISEED to describe the territories of expression in legends and main text. </LI>
</UL>

<em><strong><font color="#6E6E6E">Additional useful information</font></strong></em><br>
<UL>
<LI>
Picture, comments in figure legend.
</LI>
</UL>

<p>
<strong><font size="+1"> Minimal information to describe a molecular perturbation </font></strong>
<br>
<br>
<em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>
<ul>
<li>Identity of the deregulated molecule: The biological name of the gene can be ambiguous. It is preferable to indicate the corresponding gene/transcript model deregulated with a preference for KH (Satou et al., 2008) models, followed by JGI v1.0 and ENSEMBL models.</li>
<li>Type of interference with gene function: gain-of-function or loss-of-function.</li>
<li>Molecular tool used to deregulate the gene, with either reference of a previous study using this tool (eg FGF9/16/20 MO described in Imai et al., 200XX), or the precise sequence (MOs, mRNAs) or origin (Small molecules) of the tool.</li>
<li>Stage of onset of the perturbation (eg. time of injection for morpholinos).</li>
</ul>


<p>
<strong><font size="+1"> Minimal information to describe an anatomical perturbation </font></strong>
<br>
<br>
<em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>
<ul>
<li>Time of perturbation: Hotta stage when the structure(s) was/were removed or when the explants(s) was/were isolated.</li>
<li>Removed anatomy part or explant: use the ANISEED anatomical dictionary to describe the removed anatomy part(s) or the type of explant isolated. </li>
</ul>

<p>
<strong><font size="+1"> Minimal information to describe a molecular phenotype </font></strong><br>
Molecular or anatomical perturbations can lead to molecular phenotypes, consisting in alteration in gene expression patterns. <br>
<br><em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>
<ul>
<li>Description of the molecular or anatomical perturbation leading to the phenotype.</li>
<li>Developmental stage at which the expression of the target gene was determined, according to the developmental table of Hotta et al. ( 2007)</li>
<li>Clone(s) used to synthesize the in situ hybridization probes used in the experiment, transgenic construct in the case of electroporations, or antibody, with reference, used in immunohistochemistry.  </li>
<li>Wild-type control: Clearly indicate the expression profile of the wild type control determined in the same ISH or immunocytochemistry experiment as the experimental sample.</li>
<li>Annotation: use the anatomical ontology of ANISEED to describe the territories in which the expression pattern of the target gene differs between wild-type control and experimental sample. </li>
</ul>

<em><strong><font color="#6E6E6E">Additional useful information</font></strong></em><br>
<ul>
<li>Pictures of embryos with affected and wild-type expression patterns, comments in figure legend.</li>
</ul>

<p>
<strong><font size="+1"> Minimal information to describe a morphological phenotype </font></strong><br>

Molecular or anatomical perturbations can lead to morphological phenotypes, that are described without reference to affected gene expression patterns.
<br>
<br><em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>

<ul>
<li>Description of the molecular or anatomical perturbation leading to the phenotype.</li>
<li>Developmental stage at which the expression of the phenotype was examined, according to the developmental table of Hotta et al. ( 2007)</li>
<li>Part of body/embryo affected (eg. Tail, trunk, sensory vesicle), if possible using the ANISEED anatomical dictionary or of the embryological process affected (eg gastrulation, neurulation, tail extension)</li>
<li>Qualifier of the type of phenotype observed in the indicated dictionary (eg disorganized, short, defective)</li>
</ul>
<em><strong><font color="#6E6E6E">Additional useful information</font></strong></em><br>

<ul>
<li>Pictures of affected and wild-type embryos, comments in figure legend.</li>
</ul>

<p>
<strong><font size="+1"> Minimal information to describe a regulatory region </font></strong>
<br>
<br><em><strong><font color="#6E6E6E">Mandatory information</font></strong></em><br>

<ul>
<li>Regulated gene(s), when known: indicate the KH gene model reference (eg KH.C4.84) in addition to the "common name" (eg Ci-otx).</li>
<li>Name of the region: Please respect the following format for region names: ci-"common gene name" "start of region/end of region e.g. ci-Otx -4037/+31. In the absence of well defined TSS, the definition of +1 should be clearly indicated in the text. Using different naming conventions will lead to a renaming of the regions you studied according to the above criteria and may delay publication of cis-regulatory information in ANISEED.</li>
<li>Name of constructs: Please respect the following format: "p" (for plasmid)"region name" name"" basal promoter name" :: " reporter gene" e.g. "pfog -214/-74 pbra::NLS LacZ"</li>
<li>Sequence of genomic fragments in electroporated constructs: Because of the high level of polymorphism in ascidian genomes, genomic fragments tested by electroporation may depart from the consensus genome sequence (Dehal et al., 2001). Please indicate the sequence in supplemental information, or submit these directly to Genbank or ANISEED.</li>
<li>Sequences of artificial or mutated constructs (ie synthetic DNA not corresponding to a part of the genome): clearly indicate the sequence of the region in the Methods section or supplemental information. regions with internal deletions or mutations of binding sites should be named as follows: insert either "delta" followed by the deleted sequence (eg "ZicL -658bp/codon 7 delta -205/-127" ) or "mutated" following the affected binding site eg "Otx -1541bp/-1417bp Ets1-2 mutated"</li>
<li>Upstream factors binding sites and identity: Clearly indicate the functional binding sites in tested sequences and the upstream factors that bind them (when known) using the relevant KH gene identifier in addition to their common name.</li>
</ul>



<?php
    include("frames_footer.php");
?>
