--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: -
--

CREATE PROCEDURAL LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: ANAT_ENTITY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ANAT_ENTITY" (
    "ANAT_ID" bigint NOT NULL,
    "DEV_STAGE_ID" bigint NOT NULL,
    "SPECIES" character varying(100) NOT NULL,
    "DISPO" bigint DEFAULT 0 NOT NULL,
    "NAME" character varying(240),
    "TYPE" character varying(240),
    "CHILD_OF" bigint
);


SET default_with_oids = false;

--
-- Name: ARTICLE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE" (
    "ARTICLE_ID" bigint NOT NULL,
    "PUBMED_ID" character varying,
    "TITLE" character varying,
    "PAPER" character varying,
    "AUTHORS" character varying,
    "URL" character varying,
    "COMMENTS" character varying,
    "PRIVATE" character varying,
    "CHECKED" character varying,
    "BEING_CURATED" character varying
);


--
-- Name: ARTICLE_ANATOMY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE_ANATOMY" (
    "ARTICLE_ID" bigint NOT NULL,
    "ANAT_ID" bigint NOT NULL,
    "TRANSCRIPT" character varying NOT NULL
);


--
-- Name: ARTICLE_FATE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE_FATE" (
    "ARTICLE_ID" bigint NOT NULL,
    "FATE" character varying NOT NULL,
    "TRANSCRIPT" character varying
);


--
-- Name: ARTICLE_GENE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE_GENE" (
    "TYPE" character varying,
    "ARTICLE_ID" bigint NOT NULL,
    "TRANSCRIPT" character varying
);


--
-- Name: ARTICLE_MORPHOGEN; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE_MORPHOGEN" (
    "MORPHOGEN_ID" bigint NOT NULL,
    "ARTICLE_ID" bigint,
    "COMMENTS" character varying,
    "TRANSCRIPT" character varying,
    "NAME" character varying,
    "DEV_STAGE_ID" bigint,
    "TRANSCRIPT2" character varying
);


--
-- Name: ARTICLE_MORPHOGEN_PICTURE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ARTICLE_MORPHOGEN_PICTURE" (
    "MORPHOGEN_ID" bigint,
    "PICTURE" oid,
    "PICTURE_MORPHOGEN_ID" bigint NOT NULL
);


SET default_with_oids = true;

--
-- Name: AUTHOR; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "AUTHOR" (
    "AUTHOR_ID" bigint NOT NULL,
    "NAME" character varying(50) NOT NULL,
    "SURNAME" character varying(50),
    "LOGIN" character varying(50),
    "MAIL" character varying(100) NOT NULL,
    "TEL" character varying(20),
    "FAX" character varying(20),
    "LAB_ADDRESS" character varying(100),
    "TEAM" character varying(100),
    "IS_CURATOR" character varying(1),
    "IS_ADMIN" character varying(1),
    "LOGO" character varying(30),
    CONSTRAINT "EMAIL_CHECK" CHECK ((("MAIL")::text ~~ '_%@_%._%'::text))
);


--
-- Name: BIOMETRY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "BIOMETRY" (
    "CELL" bigint NOT NULL,
    "VOLUME" bigint NOT NULL,
    "SURFACE" bigint NOT NULL,
    "AV" bigint
);


SET default_with_oids = false;

--
-- Name: BIOMETRY_SHAPE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "BIOMETRY_SHAPE" (
    "CELL" bigint NOT NULL,
    "AV" bigint,
    "SPHERICITY" bigint NOT NULL,
    "CYLINDRICITY" bigint,
    "ELONGATION" bigint NOT NULL,
    "FLATNESS" bigint NOT NULL,
    "COMPLEXITY" bigint,
    "OCCUPENCY" bigint NOT NULL,
    "ENTROPY" bigint NOT NULL,
    "SV" bigint NOT NULL,
    "CONVEXITY" bigint,
    "VV" bigint
);


SET default_with_oids = true;

--
-- Name: BIO_ENTITY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "BIO_ENTITY" (
    "BIO_ID" bigint NOT NULL,
    "CURATED" character varying(1) DEFAULT 'n'::character varying NOT NULL
);


--
-- Name: BLAST; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "BLAST" (
    "MOL_ID" bigint NOT NULL,
    "DB" character varying(10) NOT NULL,
    "ID" real NOT NULL,
    "DESCRIPTION" character varying(350),
    "PROTEIN" character varying(20) NOT NULL,
    "SCORE" real NOT NULL,
    "EVALUE" character varying(10) NOT NULL,
    "BLOCKS" bigint
);


--
-- Name: S_MIKE_CLUSTER_ALIGNMENT; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_MIKE_CLUSTER_ALIGNMENT"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_with_oids = false;

--
-- Name: CC_TRANSCRIPT_ALIGNMENT; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CC_TRANSCRIPT_ALIGNMENT" (
    alignment_id integer DEFAULT nextval('"S_MIKE_CLUSTER_ALIGNMENT"'::regclass) NOT NULL,
    transcript_id integer NOT NULL,
    cluster_id integer NOT NULL,
    group_id integer,
    qstart integer NOT NULL,
    qend integer NOT NULL,
    sstart integer NOT NULL,
    send integer NOT NULL,
    evalue double precision NOT NULL,
    identity double precision
);


--
-- Name: TABLE "CC_TRANSCRIPT_ALIGNMENT"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE "CC_TRANSCRIPT_ALIGNMENT" IS 'Alignement between EST cluster and transcript from blast analysis.';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".alignment_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".alignment_id IS 'Alignment database identifier';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".transcript_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".transcript_id IS 'Transcript identifier';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".cluster_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".cluster_id IS 'EST cluster identifier';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".group_id IS 'Group of the alignment';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".qstart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".qstart IS 'transcript alignment position start';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".qend; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".qend IS 'transcript alignment position end';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".sstart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".sstart IS 'cluster alignment position start';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".send; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".send IS 'cluster alignment position end';


--
-- Name: COLUMN "CC_TRANSCRIPT_ALIGNMENT".evalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "CC_TRANSCRIPT_ALIGNMENT".evalue IS 'evalue of the alignment';


--
-- Name: CIPRO_LINK; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CIPRO_LINK" (
    "GENE_CLUSTER_ID" character varying NOT NULL,
    "CIPRO_GENE_ID" character varying NOT NULL
);


SET default_with_oids = true;

--
-- Name: CLONE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CLONE" (
    "CLONE_ID" bigint NOT NULL,
    "CLONE_NAME" character varying(100) NOT NULL,
    "AMBIGUOUS" character varying(1),
    "LIBRARY_ID" character varying(50),
    "PLATE" character varying,
    "IS_UNIGENE" character varying(1)
);


--
-- Name: CLONE_SEQ; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CLONE_SEQ" (
    "CLONE_SEQ_ID" bigint NOT NULL,
    "TYPE" character varying(240),
    "FULL_LENGTH" character varying(240),
    "END" character varying(1),
    "NAME" character varying(240),
    "GENBANK_ID" character varying(240) NOT NULL,
    "UNIGENE_ID" character varying(240),
    "CLUSTER_ID" character varying(50),
    "COMMENTS" character varying(4000),
    "CLONE_NAME" character varying(240),
    "ANISEED_CLUSTER_ID" bigint,
    "ANISEED_KYOTO_CLUSTER_ID" bigint,
    "ANISEED_ENSEMBL_CLUSTER_ID" bigint
);


--
-- Name: CLUSTERING; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CLUSTERING" (
    "CLUSTER_ID" character varying(240) NOT NULL,
    "GENE_ID" bigint,
    "COMMENTS" character varying(1000),
    "SCORE" bigint
);


SET default_with_oids = false;

--
-- Name: GENE_CONCEPT; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE_CONCEPT" (
    "GENE_CLUSTER_ID" character varying,
    "GENE_MODEL_ID" bigint,
    "SPECIES" character varying
);


SET default_with_oids = true;

--
-- Name: TARGET; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "TARGET" (
    "TARGET_ID" bigint NOT NULL,
    "IN_SITU_ID" bigint NOT NULL,
    "REGION_ID" bigint,
    "PROBE_ID" bigint,
    "METHOD" character varying(100),
    "INTENSITY" character varying(3),
    "SUBSTRATE" character varying(100),
    "SUBCELL_POS" character varying(50),
    "COMMENTS" character varying(500),
    "NAME" character varying(100),
    "SURE" character varying(1),
    "PART_OF" character varying(1),
    "FRACTION" character varying
);


--
-- Name: CLUSTER_BY_TARGET; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW "CLUSTER_BY_TARGET" AS
    ((SELECT DISTINCT "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID" FROM "TARGET", "GENE_CONCEPT" WHERE ("TARGET"."TARGET_ID" = "GENE_CONCEPT"."GENE_MODEL_ID") ORDER BY "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID") UNION (SELECT DISTINCT "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID" FROM "TARGET", "CLONE_SEQ", "GENE_CONCEPT" WHERE (("TARGET"."TARGET_ID" = "CLONE_SEQ"."CLONE_SEQ_ID") AND ("CLONE_SEQ"."ANISEED_CLUSTER_ID" = "GENE_CONCEPT"."GENE_MODEL_ID")) ORDER BY "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID")) UNION (SELECT DISTINCT "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID" FROM "TARGET", "CLONE", "CLONE_SEQ", "GENE_CONCEPT" WHERE ((("TARGET"."TARGET_ID" = "CLONE"."CLONE_ID") AND (("CLONE_SEQ"."CLONE_NAME")::text = ("CLONE"."CLONE_NAME")::text)) AND ("CLONE_SEQ"."ANISEED_CLUSTER_ID" = "GENE_CONCEPT"."GENE_MODEL_ID")) ORDER BY "TARGET"."TARGET_ID", "GENE_CONCEPT"."GENE_CLUSTER_ID");


--
-- Name: COMPETENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "COMPETENCE" (
    "CELL" bigint NOT NULL,
    "COMPETENCE" character varying(50) NOT NULL
);


--
-- Name: CONSTRUCTION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "CONSTRUCTION" (
    "DELETION" character varying(1),
    "MUTATION" character varying(1),
    "ADDITION" character varying(1),
    "MINIMAL_PROMOTER" character varying(100),
    "REPORTER_GENE" character varying(100),
    "COMMENTS" character varying(800),
    "CONSTRUCTION_ID" bigint NOT NULL,
    "PROMOTER_ID" bigint,
    "NAME" character varying(100),
    "ORDRE" bigint,
    "MIN_PROMOT_ID" bigint,
    "REPORTER_ID" character varying,
    "STABLE_ID" character varying(15)
);


--
-- Name: DDD; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "DDD" (
    "LIBRARY_ID" character varying(50) NOT NULL,
    "GENE_ID" bigint NOT NULL,
    "EXP_LEVEL" real NOT NULL,
    "CLONE_COUNT" bigint
);


--
-- Name: DEV_STAGE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "DEV_STAGE" (
    "DEV_STAGE_ID" bigint NOT NULL,
    "SPECIES" character varying(100) NOT NULL,
    "NAME" character varying(240) NOT NULL,
    "DEV_PERCENT" bigint,
    "HOTTA_ID" character varying
);


SET default_with_oids = false;

--
-- Name: DEV_STAGE_INFO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "DEV_STAGE_INFO" (
    "DEV_STAGE_ID" bigint,
    "FABA_LINK" character varying,
    "TIME" character varying,
    "PERIOD_NAME" character varying,
    "DESCRIPTION" character varying,
    "STAGE_NAME" character varying,
    "GIF_LINK" character varying
);


SET default_with_oids = true;

--
-- Name: DIVISION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "DIVISION" (
    "CELL1" bigint NOT NULL,
    "CELL2" bigint NOT NULL,
    "RATIO" bigint NOT NULL
);


SET default_with_oids = false;

--
-- Name: EASTER_EGG; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EASTER_EGG" (
    "EGG_PAGE" character varying,
    "USER" character varying
);


--
-- Name: EMBRYO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO" (
    "EMBRYO_ID" integer NOT NULL,
    "NAME" character varying,
    "WILD_TYPE" character varying,
    "COMMENTS" character varying,
    "SPECIES" character varying,
    "OBJ_DATA" oid,
    "DEV_STAGE_ID" integer,
    "SOFTWARE" character varying,
    "LSM" character varying,
    "Comments" character varying[]
);


--
-- Name: EMBRYO_BIOMETRY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO_BIOMETRY" (
    "EMBRYO_ID" integer NOT NULL,
    "CELL" integer,
    "VOLUME" integer,
    "SURFACE" integer
);


--
-- Name: EMBRYO_BIOMETRY_SHAPE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO_BIOMETRY_SHAPE" (
    "EMBRYO_ID" integer,
    "CELL" integer,
    "SPHERICITY" real,
    "ELONGATION" real,
    "FLATNESS" real,
    "OCCUPENCY" real,
    "ENTROPY" real,
    "SV" real,
    "CONVEXITY" real,
    "VV" real
);


--
-- Name: EMBRYO_DIVISION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO_DIVISION" (
    "CELL1" integer,
    "CELL2" integer,
    "RATIO" real,
    "EMBRYO_ID" integer
);


SET default_with_oids = true;

--
-- Name: EMBRYO_MANIP; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO_MANIP" (
    "IN_SITU_ID" bigint NOT NULL,
    "STRUCTURE_ID" bigint NOT NULL,
    "FROM_ID" bigint,
    "COMMENTS" character varying(10),
    "CTRL_ISH_ID" bigint
);


SET default_with_oids = false;

--
-- Name: EMBRYO_NEIGHBOR; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EMBRYO_NEIGHBOR" (
    "EMBRYO_ID" integer,
    "CELL_A" integer,
    "CELL_B" integer,
    "DISTANCE" real,
    "CONTACT" real
);


SET default_with_oids = true;

--
-- Name: ENTRY_ORIGIN; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ENTRY_ORIGIN" (
    "AUTHOR_ID" bigint NOT NULL,
    "BIO_ID" bigint NOT NULL,
    "ENTRY_DATE" date DEFAULT now(),
    "CURATOR_ID" bigint,
    "CURATION_DATE" date,
    "ANNOTATOR_ID" bigint,
    "ANNOTATION_DATE" date
);


--
-- Name: S_MIKE_CLUSTER_EST; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_MIKE_CLUSTER_EST"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_with_oids = false;

--
-- Name: EST_CLUSTER; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "EST_CLUSTER" (
    cluster_id integer DEFAULT nextval('"S_MIKE_CLUSTER_EST"'::regclass) NOT NULL,
    sequence_prot text,
    sequence_nuc text,
    "FL_score" double precision,
    cluster_name character varying(60) NOT NULL
);


--
-- Name: TABLE "EST_CLUSTER"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE "EST_CLUSTER" IS 'EST cluster consensus sequence from M.Gilchrist';


--
-- Name: COLUMN "EST_CLUSTER".cluster_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "EST_CLUSTER".cluster_id IS 'EST cluster identifier';


--
-- Name: COLUMN "EST_CLUSTER".sequence_prot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "EST_CLUSTER".sequence_prot IS 'AA sequence of the cluster';


--
-- Name: COLUMN "EST_CLUSTER".sequence_nuc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "EST_CLUSTER".sequence_nuc IS 'Nucleotide sequence of the cluster';


--
-- Name: COLUMN "EST_CLUSTER"."FL_score"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "EST_CLUSTER"."FL_score" IS 'Full-length score of the cluster';


--
-- Name: COLUMN "EST_CLUSTER".cluster_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "EST_CLUSTER".cluster_name IS 'cluster name';


SET default_with_oids = true;

--
-- Name: FATE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "FATE" (
    "ANAT_ID" bigint NOT NULL,
    "KEYWORDS" character varying(50) NOT NULL
);


--
-- Name: FATE_KW; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "FATE_KW" (
    "KEYWORDS" character varying(50) NOT NULL
);


--
-- Name: GENE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE" (
    "GENE_ID" bigint NOT NULL,
    "NAME" character varying(240) NOT NULL,
    "FULL_NAME" character varying(240),
    "SCAFFOLD_ID" character varying(100),
    "BEGIN" bigint,
    "END" bigint,
    "CHR_NUM" bigint,
    "INTRON_EXON" character varying,
    "STRAND" character varying(10),
    "MW" bigint,
    "DATABASE" character varying
);


SET default_with_oids = false;

--
-- Name: GENE_CONCEPT_NAME; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE_CONCEPT_NAME" (
    "GENE_CLUSTER_ID" character varying,
    "GENE_CLUSTER_UPPER_NAME" character varying,
    "GENE_CLUSTER_NAME" character varying,
    "MANUAL" character varying
);


--
-- Name: GENE_CONCEPT_NAME_BLAST; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE_CONCEPT_NAME_BLAST" (
    "GENE_CLUSTER_NAME_BLAST" character varying,
    "GENE_CLUSTER_ID" character varying
);


--
-- Name: GENE_MOTIF; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE_MOTIF" (
    "GENE_ID" bigint NOT NULL,
    "MOTIF_ID" bigint NOT NULL
);


SET default_with_oids = true;

--
-- Name: GENE_REGULATION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GENE_REGULATION" (
    "PROMOTER_ID" bigint NOT NULL,
    "GENE_ID" bigint NOT NULL,
    "SURE" character varying(1),
    "TYPE" character varying
);


SET default_with_oids = false;

--
-- Name: GLOBAL_GENE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GLOBAL_GENE" (
    "GLOBAL_GENE_ID" bigint NOT NULL,
    "GENE_ID" bigint NOT NULL
);


SET default_with_oids = true;

--
-- Name: GO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GO" (
    "GO_ID" character varying(10) NOT NULL,
    "GO_TERM" character varying(200) NOT NULL,
    "GO_TYPE" character varying(100),
    "GO_EQ_ID" character varying(100),
    "DEFINITION" character varying(3000)
);


--
-- Name: GO_CHILD_OF; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GO_CHILD_OF" (
    "GO_ID" character varying(10) NOT NULL,
    "CHILD_OF" character varying(10) NOT NULL,
    "LINK_TYPE" character varying(10)
);


--
-- Name: GO_DESCRIPTION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GO_DESCRIPTION" (
    "MOL_ID" bigint NOT NULL,
    "GO_ID" character varying(10) NOT NULL,
    "ORIGIN" character varying(10),
    "SPECIES_ORIGIN" character varying(30),
    "IP_ORIGIN" character varying(1),
    "PHYLOGENY_ORIGIN" character varying(1),
    "BLAST_ORIGIN" character varying(1)
);


SET default_with_oids = false;

--
-- Name: GROUP_ALIGNMENT_CLUSTER; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "GROUP_ALIGNMENT_CLUSTER" (
    group_id integer NOT NULL,
    definition character varying(300) NOT NULL,
    comment text
);


--
-- Name: TABLE "GROUP_ALIGNMENT_CLUSTER"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE "GROUP_ALIGNMENT_CLUSTER" IS 'Belonging group of the alignment transcript/cluster';


--
-- Name: COLUMN "GROUP_ALIGNMENT_CLUSTER".group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "GROUP_ALIGNMENT_CLUSTER".group_id IS 'Group identifier';


--
-- Name: COLUMN "GROUP_ALIGNMENT_CLUSTER".definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "GROUP_ALIGNMENT_CLUSTER".definition IS 'Definition of the group';


--
-- Name: COLUMN "GROUP_ALIGNMENT_CLUSTER".comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN "GROUP_ALIGNMENT_CLUSTER".comment IS 'Comment on association between transcript and cluster';


SET default_with_oids = true;

--
-- Name: INDUCTION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INDUCTION" (
    "INDUCTOR_ID" bigint,
    "INDUCED_ID" bigint NOT NULL,
    "COMMENTS" character varying(500) NOT NULL,
    "DEFAULT_FATE" character varying(50),
    "INDUCED_FATE" character varying(50),
    "INDUCTION_ID" bigint NOT NULL
);


--
-- Name: INDUCTION_FATE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INDUCTION_FATE" (
    "INDUCTION_ID" bigint NOT NULL,
    "FATE" character varying(50) NOT NULL
);


--
-- Name: INDUCTION_MOL; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INDUCTION_MOL" (
    "MOL_ID" bigint NOT NULL,
    "TYPE" character varying(30),
    "INDUCTION_ID" bigint NOT NULL
);


SET default_with_oids = false;

--
-- Name: INTERACTION_EVIDENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INTERACTION_EVIDENCE" (
    "INTERACTION_EVIDENCE_ID" bigint NOT NULL,
    "GENE_A" character varying NOT NULL,
    "GENE_B" character varying NOT NULL,
    "ANAT_ENTITY_ID" bigint,
    "DEV_STAGE_ID" bigint,
    "EVIDENCE_ISH_ID" bigint,
    "CONTROL_ISH_ID" bigint,
    "CONFIDENCE" real NOT NULL,
    "INTERACTION_TYPE" smallint NOT NULL,
    "EVIDENCE_TYPE" smallint NOT NULL
);


--
-- Name: INTERACTION_EVIDENCE_TYPE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INTERACTION_EVIDENCE_TYPE" (
    "EVIDENCE_TYPE_ID" smallint NOT NULL,
    "DESCRIPTION" character varying
);


--
-- Name: INTERACTION_TYPE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INTERACTION_TYPE" (
    "INTERACTION_TYPE_ID" smallint NOT NULL,
    "DESCRIPTION" character varying
);


SET default_with_oids = true;

--
-- Name: INTERPRO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "INTERPRO" (
    "IP_ID" character varying(10) NOT NULL,
    "NAME" character varying(100) NOT NULL,
    "TYPE" character varying(12) NOT NULL,
    "SHORT_NAME" character varying(100) NOT NULL
);


--
-- Name: IN_SITU; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IN_SITU" (
    "IN_SITU_ID" bigint NOT NULL,
    "DEV_STAGE_ID" bigint NOT NULL,
    "SPECIES" character varying(100) NOT NULL,
    "IM_COMMENTS" character varying(5000),
    "EXP_COMMENTS" character varying(500),
    "TIME" character varying(50),
    "TEMPERATURE" bigint,
    "WILD_TYPE" character varying(5) DEFAULT 'y'::character varying,
    "CHECKED" character varying(1) DEFAULT 'n'::character varying NOT NULL,
    "PRIVATE" character varying(1),
    "BEING_CURATED" character varying,
    "ARTICLE_ID" bigint
);


--
-- Name: IN_SITU_CLUSTER; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IN_SITU_CLUSTER" (
    "IN_SITU_ID" bigint NOT NULL,
    "IN_SITU_ID_2" bigint NOT NULL,
    "DISTANCE" real NOT NULL,
    "TYPE" character varying(2) NOT NULL
);


--
-- Name: IN_SITU_CLUSTER2; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IN_SITU_CLUSTER2" (
    "IN_SITU_ID" bigint NOT NULL,
    "IN_SITU_ID_2" bigint NOT NULL,
    "DISTANCE" real NOT NULL,
    "TYPE" character varying(2) NOT NULL
);


--
-- Name: IN_SITU_CLUSTER3; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IN_SITU_CLUSTER3" (
    "IN_SITU_ID" bigint NOT NULL,
    "IN_SITU_ID_2" bigint NOT NULL,
    "DISTANCE" real NOT NULL,
    "TYPE" character varying(2) NOT NULL
);


SET default_with_oids = false;

--
-- Name: IN_SITU_CLUSTER4; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IN_SITU_CLUSTER4" (
    "REGION1" character varying,
    "REGION2" character varying,
    "DISTANCE" double precision
);


SET default_with_oids = true;

--
-- Name: IP_CHILD_OF; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IP_CHILD_OF" (
    "IP_ID" character varying(10) NOT NULL,
    "CHILD_OF" character varying(10) NOT NULL
);


--
-- Name: IP_CONTAINS; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IP_CONTAINS" (
    "IP_ID" character varying(10) NOT NULL,
    "CONTAINS" character varying(10) NOT NULL
);


--
-- Name: IP_DESCRIPTION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "IP_DESCRIPTION" (
    "MOL_ID" bigint NOT NULL,
    "IP_ID" character varying(10) NOT NULL,
    "METHOD" character varying(12) NOT NULL,
    "DB_ID" character varying(60) NOT NULL,
    "LOCATION" text NOT NULL
);


--
-- Name: ISH_BY_CLUSTER; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW "ISH_BY_CLUSTER" AS
    ((SELECT DISTINCT "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID" FROM "TARGET", "GENE_CONCEPT" WHERE ("TARGET"."TARGET_ID" = "GENE_CONCEPT"."GENE_MODEL_ID") ORDER BY "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID") UNION (SELECT DISTINCT "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID" FROM "TARGET", "CLONE_SEQ", "GENE_CONCEPT" WHERE (("TARGET"."TARGET_ID" = "CLONE_SEQ"."CLONE_SEQ_ID") AND ("CLONE_SEQ"."ANISEED_CLUSTER_ID" = "GENE_CONCEPT"."GENE_MODEL_ID")) ORDER BY "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID")) UNION (SELECT DISTINCT "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID" FROM "TARGET", "CLONE", "CLONE_SEQ", "GENE_CONCEPT" WHERE ((("TARGET"."TARGET_ID" = "CLONE"."CLONE_ID") AND (("CLONE_SEQ"."CLONE_NAME")::text = ("CLONE"."CLONE_NAME")::text)) AND ("CLONE_SEQ"."ANISEED_CLUSTER_ID" = "GENE_CONCEPT"."GENE_MODEL_ID")) ORDER BY "GENE_CONCEPT"."GENE_CLUSTER_ID", "TARGET"."IN_SITU_ID");


SET default_with_oids = false;

--
-- Name: ISH_CLUSTERING; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ISH_CLUSTERING" (
    "MOL_ID" bigint,
    "DEV_STAGE_ID" bigint,
    "SPOT" character varying
);


--
-- Name: ISH_PROFILE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "ISH_PROFILE" (
    "GENE_NAME" character varying,
    "PROFILE" character varying
);


SET default_with_oids = true;

--
-- Name: KNOCKDOWN; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "KNOCKDOWN" (
    "PCR_ID" bigint NOT NULL,
    "MOL_ID" bigint NOT NULL,
    "MORPHOLINO" bigint,
    "VALUE" bigint
);


--
-- Name: LIBRARY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "LIBRARY" (
    "LIBRARY_ID" character varying(50) NOT NULL,
    "TITLE" character varying(240),
    "TISSUE" character varying(240),
    "ORGAN" character varying(240),
    "VECTOR" character varying(240),
    "COMMENTS" character varying(240),
    "LIB_SIZE" bigint,
    "ORDRE" bigint,
    "SPECIES" character varying(20),
    "DEV_STAGE" character varying(100),
    "DATABASE" character varying
);


--
-- Name: LINEAGE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "LINEAGE" (
    "MOTHER_CELL" bigint NOT NULL,
    "DAUGHTER_CELL" bigint NOT NULL
);


SET default_with_oids = false;

--
-- Name: LOG; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "LOG" (
    "IP" character varying(17) NOT NULL,
    "DATE" character varying NOT NULL,
    "TIME" character varying,
    "COUNTRY" character varying,
    "VERSION" character varying
);


--
-- Name: LOG_TOOL; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "LOG_TOOL" (
    "TOOL" character varying,
    "COMMENTS" character varying,
    "VERSION" character varying
);


--
-- Name: LOG_WEBSITE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "LOG_WEBSITE" (
    "IP" character varying,
    "DATE" character varying,
    "TIME" character varying,
    "COUNTRY" character varying
);


--
-- Name: MAP; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MAP" (
    "ANAT_ID" bigint NOT NULL,
    "PATH" character varying
);


SET default_with_oids = true;

--
-- Name: MOLECULAR_TOOL; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MOLECULAR_TOOL" (
    "MOLECULAR_TOOL_ID" bigint NOT NULL,
    "NAME" character varying(240) NOT NULL,
    "TYPE" character varying(240) NOT NULL,
    "SUPPLIER" character varying(240),
    "COMMENTS" character varying(500),
    "ASSOCIATED_GENE_ID" character varying,
    "REGULATION" character varying
);


--
-- Name: MOL_ENTITY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MOL_ENTITY" (
    "MOL_ID" bigint NOT NULL,
    "SPECIES" character varying(100),
    "FULL_NAME" character varying(240),
    "NAME" character varying(240),
    "TYPE" character varying(240),
    "OBSOLETE" character varying
);


--
-- Name: MOTIF_COORD; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MOTIF_COORD" (
    "MOTIF_ID" bigint NOT NULL,
    "SEQUENCE" character varying(50),
    "PROMOTER_ID" bigint NOT NULL,
    "BEGIN" bigint,
    "STOP" bigint,
    "ACTION" character(1),
    "EXP_EVIDENCE" bigint,
    "COMMENTS" character varying,
    "ORIENTATION" character varying,
    "UPDATE_MATRIX" character varying,
    "MATRIX_SEQUENCE" character varying,
    "MATRIX_SEQ_BEGIN" bigint,
    "MOTIF_COORD_ID" bigint NOT NULL
);


SET default_with_oids = false;

--
-- Name: MOTIF_COORD_GENE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MOTIF_COORD_GENE" (
    "GENE_ID" bigint NOT NULL,
    "MOTIF_COORD_ID" bigint NOT NULL
);


SET default_with_oids = true;

--
-- Name: MOTIF_REGUL; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MOTIF_REGUL" (
    "NAME" character varying(100) NOT NULL,
    "COMMENTS" character varying(500),
    "MOTIF_ID" bigint NOT NULL,
    "MATRIX" character varying(100),
    "TYPE" character varying,
    "SIZE" bigint,
    "RGB_RED" bigint,
    "RGB_GREEN" bigint,
    "RGB_BLUE" bigint
);


--
-- Name: MUTANT; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "MUTANT" (
    "BIO_ID" bigint,
    "IN_SITU_ID" bigint NOT NULL,
    "FROM_ID" bigint,
    "TO_ID" bigint,
    "UP_DOWN" character varying(50),
    "NAME" character varying(50),
    "INHIBITOR_ID" bigint,
    "TYPE" character varying(15),
    "COMMENTS" character varying(10),
    "CTRL_ISH_ID" bigint
);


--
-- Name: NEIGHBOR; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "NEIGHBOR" (
    "CELL_A" bigint NOT NULL,
    "CELL_B" bigint NOT NULL,
    "DISTANCE" bigint NOT NULL,
    "CONTACT" bigint,
    "AV" bigint
);


--
-- Name: PCR; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PCR" (
    "PCR_ID" bigint NOT NULL,
    "SPECIES" character varying(100) NOT NULL,
    "DEV_STAGE_ID" bigint NOT NULL,
    "GENE_EXAMINED" bigint NOT NULL
);


--
-- Name: PHYLOGENY; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PHYLOGENY" (
    "MOL_ID" bigint NOT NULL,
    "ID" character varying(100),
    "PARALOG" character varying(100),
    "SCORE" bigint,
    "SPECIES" character varying(100) NOT NULL,
    "ORTHOLOG" character varying(100),
    "DB" character varying(100),
    "SCORE1" bigint,
    "SCORE2" bigint,
    "FAMILLY" character varying(700)
);


--
-- Name: PICTURE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PICTURE" (
    "PICTURE_ID" bigint NOT NULL,
    "IN_SITU_ID" bigint NOT NULL,
    "IMAGE" oid,
    "THUMBNAIL" oid,
    "ANNOTATED_IMAGE" oid,
    "CONTROL" character varying(1),
    "PATH" character varying(50)
);


--
-- Name: PROMOTER; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PROMOTER" (
    "COMMENTS" character varying,
    "PROMOTER_ID" bigint NOT NULL,
    "NAME" character varying(100),
    "BEGIN" bigint,
    "END" bigint,
    "DELETION" character varying,
    "MUTATION" character varying,
    "ADDITION" character varying,
    "BASE_REG_ID" bigint,
    "PRIVATE" character varying(1),
    "BEING_CURATED" character varying(1),
    "CHECKED" character varying(1) DEFAULT 'n'::character varying,
    "IS_NATURAL" character varying,
    "TYPE" character varying,
    "STABLE_ID" character varying(15) NOT NULL
);


SET default_with_oids = false;

--
-- Name: PROMOTER_POS; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PROMOTER_POS" (
    "PROMOTER_ID" bigint NOT NULL,
    "LOCAL" character varying,
    "BEGIN" bigint,
    "END" bigint,
    "SURE" character(1),
    "STRAND" character(1)
);


--
-- Name: PROT_SEQUENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "PROT_SEQUENCE" (
    "MOL_ID" bigint NOT NULL,
    "SEQUENCE" oid,
    "LENGTH" bigint
);


SET default_with_oids = true;

--
-- Name: REFERENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "REFERENCE" (
    "BIO_ID" bigint NOT NULL,
    "PUBMED_ID" bigint,
    "TITLE" character varying(200),
    "PAPER" character varying(100),
    "AUTHORS" character varying(300),
    "URL" character varying(200),
    "COMMENTS" character varying(500)
);


SET default_with_oids = false;

--
-- Name: REG_EVIDENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "REG_EVIDENCE" (
    "GENE_X" character varying NOT NULL,
    "GENE_Y" character varying NOT NULL,
    "TYPE" character varying NOT NULL,
    "REG_ANAT" bigint NOT NULL,
    "DIRECT" character(1),
    "EVIDENCE" bigint NOT NULL,
    "CONTROL" bigint NOT NULL,
    "DEV_STAGE_ID" bigint NOT NULL,
    "PERT_TYPE" character varying
);


SET default_with_oids = true;

--
-- Name: REG_SEQ; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "REG_SEQ" (
    "REG_SEQ_ID" bigint NOT NULL,
    "BEGIN" character varying(240),
    "END" bigint,
    "DESCRIPTION" bigint,
    "COMMENTS" character varying(200)
);


--
-- Name: SCAFFOLD; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SCAFFOLD" (
    "SCAFFOLD_ID" character varying(100) NOT NULL,
    "SPECIES" character varying(240) NOT NULL,
    "LENGTH" bigint
);


SET default_with_oids = false;

--
-- Name: SCAFFOLD_FATE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SCAFFOLD_FATE" (
    "SCAFFOLD_ID" character varying,
    "FATE" character varying,
    "SCORE" bigint
);


SET default_with_oids = true;

--
-- Name: SEQUENCE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SEQUENCE" (
    "MOL_ID" bigint NOT NULL,
    "SEQUENCE" oid NOT NULL,
    "LENGTH" bigint,
    "COMMENTS" character varying(500)
);


SET default_with_oids = false;

--
-- Name: SO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SO" (
    "SO_ID" character varying(15) NOT NULL,
    "SO_TERM" character varying(100),
    "DESCRIPTION" character varying(300)
);


--
-- Name: TABLE "SO"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE "SO" IS 'Sequence Ontology';


SET default_with_oids = true;

--
-- Name: SOFTWARE; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SOFTWARE" (
    "NAME" character varying(240),
    "VERSION" bigint,
    "INSTRUCTION" character varying(240)
);


SET default_with_oids = false;

--
-- Name: SO_DESCRIPTION; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SO_DESCRIPTION" (
    "PROMOTER_ID" bigint NOT NULL,
    "SO_ID" character varying(15) NOT NULL
);


SET default_with_oids = true;

--
-- Name: SPECIES; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SPECIES" (
    "NAME" character varying(100) NOT NULL
);


SET default_with_oids = false;

--
-- Name: SUBMITED; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SUBMITED" (
    "SUBMITED_ID" bigint,
    "AUTHOR_NAME" character varying,
    "SUBMISSION_DATE" date,
    "XML" oid
);


SET default_with_oids = true;

--
-- Name: SYNO; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "SYNO" (
    "GENE_ID" bigint NOT NULL,
    "SYNO" character varying(600) NOT NULL,
    "ORIGIN" character varying(10),
    "SYNO_UPPER_CASE" character varying(600) NOT NULL,
    "ORIGIN_SPECIES" character varying(30)
);


--
-- Name: S_ARTICLE_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_ARTICLE_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_AUTHOR_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_AUTHOR_ID"
    START WITH 400
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 20;


--
-- Name: S_BIO_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_BIO_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_DEV_STAGE_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_DEV_STAGE_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 20;


--
-- Name: S_INTERACTION_EVIDENCE_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_INTERACTION_EVIDENCE_ID"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_MORPHOGEN_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_MORPHOGEN_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_PICTURE_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_PICTURE_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_PICTURE_MORPHOGEN_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_PICTURE_MORPHOGEN_ID"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_SUBMITED_ID; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_SUBMITED_ID"
    START WITH 41
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: S_UPDATE_INTERACTION; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE "S_UPDATE_INTERACTION"
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_with_oids = false;

--
-- Name: TARGET_TO_CLUSTER; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "TARGET_TO_CLUSTER" (
    "TARGET_ID" bigint NOT NULL,
    "CLUSTER_ID" character varying
);


--
-- Name: TRANSCRIPT; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "TRANSCRIPT" (
    "TRANSCRIPT_ID" bigint NOT NULL,
    "ABSTRACT_ID" bigint NOT NULL
);


--
-- Name: UPDATE_INTERACTIONS; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE "UPDATE_INTERACTIONS" (
    "ID" bigint NOT NULL,
    "ISH_ID" bigint NOT NULL
);


--
-- Name: AEY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ANAT_ENTITY"
    ADD CONSTRAINT "AEY_PK" PRIMARY KEY ("ANAT_ID");


--
-- Name: ARTICLE_ANATOMY_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ARTICLE_ANATOMY"
    ADD CONSTRAINT "ARTICLE_ANATOMY_pkey" PRIMARY KEY ("ARTICLE_ID", "ANAT_ID", "TRANSCRIPT");


--
-- Name: ARTICLE_ARTICLE_ID_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ARTICLE"
    ADD CONSTRAINT "ARTICLE_ARTICLE_ID_key" UNIQUE ("ARTICLE_ID", "PUBMED_ID");


--
-- Name: ARTICLE_MORPHOGEN_PICTURE_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ARTICLE_MORPHOGEN_PICTURE"
    ADD CONSTRAINT "ARTICLE_MORPHOGEN_PICTURE_pkey" PRIMARY KEY ("PICTURE_MORPHOGEN_ID");


--
-- Name: ARTICLE_MORPHOGEN_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ARTICLE_MORPHOGEN"
    ADD CONSTRAINT "ARTICLE_MORPHOGEN_pkey" PRIMARY KEY ("MORPHOGEN_ID");


--
-- Name: ARTICLE_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "ARTICLE"
    ADD CONSTRAINT "ARTICLE_pkey" PRIMARY KEY ("ARTICLE_ID");


--
-- Name: AUR_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "AUTHOR"
    ADD CONSTRAINT "AUR_PK" PRIMARY KEY ("AUTHOR_ID");


--
-- Name: AUTHOR_NAME_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "AUTHOR"
    ADD CONSTRAINT "AUTHOR_NAME_key" UNIQUE ("NAME");


--
-- Name: BEY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "BIO_ENTITY"
    ADD CONSTRAINT "BEY_PK" PRIMARY KEY ("BIO_ID");


--
-- Name: BIOMETRY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "BIOMETRY"
    ADD CONSTRAINT "BIOMETRY_PK" PRIMARY KEY ("CELL");


--
-- Name: BIOMETTRY_SHAPE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "BIOMETRY_SHAPE"
    ADD CONSTRAINT "BIOMETTRY_SHAPE_PK" PRIMARY KEY ("CELL");


--
-- Name: CC_TRANSCRIPT_ALIGNMENT_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CC_TRANSCRIPT_ALIGNMENT"
    ADD CONSTRAINT "CC_TRANSCRIPT_ALIGNMENT_pkey" PRIMARY KEY (alignment_id);


--
-- Name: CIPRO_LINK_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CIPRO_LINK"
    ADD CONSTRAINT "CIPRO_LINK_pkey" PRIMARY KEY ("GENE_CLUSTER_ID", "CIPRO_GENE_ID");


--
-- Name: CLE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CLONE"
    ADD CONSTRAINT "CLE_PK" PRIMARY KEY ("CLONE_ID");


--
-- Name: CLE_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CLONE"
    ADD CONSTRAINT "CLE_UK" UNIQUE ("CLONE_NAME");


--
-- Name: CLG_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CLUSTERING"
    ADD CONSTRAINT "CLG_PK" PRIMARY KEY ("CLUSTER_ID");


--
-- Name: CONSTRUCTION_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CONSTRUCTION"
    ADD CONSTRAINT "CONSTRUCTION_PK" PRIMARY KEY ("CONSTRUCTION_ID");


--
-- Name: CONSTRUCTION_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CONSTRUCTION"
    ADD CONSTRAINT "CONSTRUCTION_UK" UNIQUE ("NAME");


--
-- Name: CONSTRUCTION_UNIQUE_STABLE_ID; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CONSTRUCTION"
    ADD CONSTRAINT "CONSTRUCTION_UNIQUE_STABLE_ID" UNIQUE ("STABLE_ID");


--
-- Name: CSQ_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CSQ_PK" PRIMARY KEY ("CLONE_SEQ_ID");


--
-- Name: CSQ_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CSQ_UK" UNIQUE ("GENBANK_ID");


--
-- Name: DSE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "DEV_STAGE"
    ADD CONSTRAINT "DSE_PK" PRIMARY KEY ("DEV_STAGE_ID");


--
-- Name: EMBRYO_BIOMETRY_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "EMBRYO_BIOMETRY"
    ADD CONSTRAINT "EMBRYO_BIOMETRY_UK" UNIQUE ("EMBRYO_ID", "CELL");


--
-- Name: EST_CLUSTER_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "EST_CLUSTER"
    ADD CONSTRAINT "EST_CLUSTER_pkey" PRIMARY KEY (cluster_id);


--
-- Name: FATE_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "FATE"
    ADD CONSTRAINT "FATE_UK" UNIQUE ("ANAT_ID", "KEYWORDS");


--
-- Name: FKW_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "FATE_KW"
    ADD CONSTRAINT "FKW_PK" PRIMARY KEY ("KEYWORDS");


--
-- Name: GEC_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "SCAFFOLD"
    ADD CONSTRAINT "GEC_PK" PRIMARY KEY ("SCAFFOLD_ID");


--
-- Name: GEE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GENE"
    ADD CONSTRAINT "GEE_PK" PRIMARY KEY ("GENE_ID");


--
-- Name: GENE_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GENE"
    ADD CONSTRAINT "GENE_UK" UNIQUE ("NAME");


--
-- Name: GO_CHILD_OF_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GO_CHILD_OF"
    ADD CONSTRAINT "GO_CHILD_OF_PK" PRIMARY KEY ("GO_ID", "CHILD_OF");


--
-- Name: GO_DESCRIPTIO_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GO_DESCRIPTION"
    ADD CONSTRAINT "GO_DESCRIPTIO_PK" PRIMARY KEY ("MOL_ID", "GO_ID");


--
-- Name: GO_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GO"
    ADD CONSTRAINT "GO_PK" PRIMARY KEY ("GO_ID");


--
-- Name: GROUP_ALIGNMENT_CLUSTER_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "GROUP_ALIGNMENT_CLUSTER"
    ADD CONSTRAINT "GROUP_ALIGNMENT_CLUSTER_pkey" PRIMARY KEY (group_id);


--
-- Name: IN-SITU-CLUST_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IN_SITU_CLUSTER"
    ADD CONSTRAINT "IN-SITU-CLUST_UK" UNIQUE ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: IN-SITU-CLUST_UK_2; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IN_SITU_CLUSTER2"
    ADD CONSTRAINT "IN-SITU-CLUST_UK_2" UNIQUE ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: IN-SITU-CLUST_UK_2_1; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IN_SITU_CLUSTER3"
    ADD CONSTRAINT "IN-SITU-CLUST_UK_2_1" UNIQUE ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: INDUCTION_FAT_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INDUCTION_FATE"
    ADD CONSTRAINT "INDUCTION_FAT_PK" PRIMARY KEY ("INDUCTION_ID", "FATE");


--
-- Name: INDUCTION_MOL_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INDUCTION_MOL"
    ADD CONSTRAINT "INDUCTION_MOL_PK" PRIMARY KEY ("MOL_ID", "INDUCTION_ID");


--
-- Name: INN_AEY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INDUCTION"
    ADD CONSTRAINT "INN_AEY_PK" PRIMARY KEY ("INDUCTION_ID");


--
-- Name: INTERPRO_PK11075739860408; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INTERPRO"
    ADD CONSTRAINT "INTERPRO_PK11075739860408" PRIMARY KEY ("IP_ID");


--
-- Name: IP_CHILD_OF_PK11075817025406; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IP_CHILD_OF"
    ADD CONSTRAINT "IP_CHILD_OF_PK11075817025406" PRIMARY KEY ("IP_ID", "CHILD_OF");


--
-- Name: IP_CONTAINS_PK11075817040528; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IP_CONTAINS"
    ADD CONSTRAINT "IP_CONTAINS_PK11075817040528" PRIMARY KEY ("IP_ID", "CONTAINS");


--
-- Name: IP_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IP_DESCRIPTION"
    ADD CONSTRAINT "IP_UK" UNIQUE ("MOL_ID", "IP_ID", "METHOD", "LOCATION");


--
-- Name: ISU_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "IN_SITU"
    ADD CONSTRAINT "ISU_PK" PRIMARY KEY ("IN_SITU_ID");


--
-- Name: KDN_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "KNOCKDOWN"
    ADD CONSTRAINT "KDN_PK" PRIMARY KEY ("PCR_ID", "MOL_ID");


--
-- Name: LIE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "LINEAGE"
    ADD CONSTRAINT "LIE_PK" PRIMARY KEY ("MOTHER_CELL", "DAUGHTER_CELL");


--
-- Name: LIY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "LIBRARY"
    ADD CONSTRAINT "LIY_PK" PRIMARY KEY ("LIBRARY_ID");


--
-- Name: MEY_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "MOL_ENTITY"
    ADD CONSTRAINT "MEY_PK" PRIMARY KEY ("MOL_ID");


--
-- Name: MOTIF_REGUL_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "MOTIF_REGUL"
    ADD CONSTRAINT "MOTIF_REGUL_PK" PRIMARY KEY ("MOTIF_ID");


--
-- Name: OTR_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "MOLECULAR_TOOL"
    ADD CONSTRAINT "OTR_PK" PRIMARY KEY ("MOLECULAR_TOOL_ID");


--
-- Name: PCR_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PCR"
    ADD CONSTRAINT "PCR_PK" PRIMARY KEY ("PCR_ID");


--
-- Name: PHYLOGENY_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PHYLOGENY"
    ADD CONSTRAINT "PHYLOGENY_UK" UNIQUE ("MOL_ID", "PARALOG", "ID");


--
-- Name: PIE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PICTURE"
    ADD CONSTRAINT "PIE_PK" PRIMARY KEY ("PICTURE_ID");


--
-- Name: PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "UPDATE_INTERACTIONS"
    ADD CONSTRAINT "PK" PRIMARY KEY ("ID");


--
-- Name: PK_EMBRYO; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "EMBRYO"
    ADD CONSTRAINT "PK_EMBRYO" PRIMARY KEY ("EMBRYO_ID");


--
-- Name: PK_INTERACTION_EVIDENCE; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INTERACTION_EVIDENCE"
    ADD CONSTRAINT "PK_INTERACTION_EVIDENCE" PRIMARY KEY ("INTERACTION_EVIDENCE_ID");


--
-- Name: PK_INTERACTION_TYPE; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INTERACTION_TYPE"
    ADD CONSTRAINT "PK_INTERACTION_TYPE" PRIMARY KEY ("INTERACTION_TYPE_ID");


--
-- Name: PK_INTERACTION_TYPE_ID; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "INTERACTION_EVIDENCE_TYPE"
    ADD CONSTRAINT "PK_INTERACTION_TYPE_ID" PRIMARY KEY ("EVIDENCE_TYPE_ID");


--
-- Name: PK_MOTIF_COORD; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "MOTIF_COORD"
    ADD CONSTRAINT "PK_MOTIF_COORD" PRIMARY KEY ("MOTIF_COORD_ID");


--
-- Name: PROMOTER_STABLE_ID_UNIQUE; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PROMOTER"
    ADD CONSTRAINT "PROMOTER_STABLE_ID_UNIQUE" UNIQUE ("STABLE_ID");


--
-- Name: PROMOTER_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PROMOTER"
    ADD CONSTRAINT "PROMOTER_UK" UNIQUE ("NAME");


--
-- Name: PROMO_PK_1; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PROMOTER"
    ADD CONSTRAINT "PROMO_PK_1" PRIMARY KEY ("PROMOTER_ID");


--
-- Name: PSEQ_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "PROT_SEQUENCE"
    ADD CONSTRAINT "PSEQ_PK" PRIMARY KEY ("MOL_ID");


--
-- Name: SEE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "SEQUENCE"
    ADD CONSTRAINT "SEE_PK" PRIMARY KEY ("MOL_ID");


--
-- Name: SO_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "SO"
    ADD CONSTRAINT "SO_PK" PRIMARY KEY ("SO_ID");


--
-- Name: SPE_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "SPECIES"
    ADD CONSTRAINT "SPE_PK" PRIMARY KEY ("NAME");


--
-- Name: SYNO_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "SYNO"
    ADD CONSTRAINT "SYNO_UK" UNIQUE ("GENE_ID", "SYNO_UPPER_CASE");


--
-- Name: TARGET_TO_CLUSTER_PK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "TARGET_TO_CLUSTER"
    ADD CONSTRAINT "TARGET_TO_CLUSTER_PK" PRIMARY KEY ("TARGET_ID");


--
-- Name: TAT_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "TARGET"
    ADD CONSTRAINT "TAT_UK" UNIQUE ("PROBE_ID", "REGION_ID", "SUBSTRATE", "METHOD", "INTENSITY", "IN_SITU_ID", "TARGET_ID");


--
-- Name: TRANSCRIPT_UK; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "TRANSCRIPT"
    ADD CONSTRAINT "TRANSCRIPT_UK" UNIQUE ("TRANSCRIPT_ID", "ABSTRACT_ID");


--
-- Name: UK_BIOMSHAPE; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "EMBRYO_BIOMETRY_SHAPE"
    ADD CONSTRAINT "UK_BIOMSHAPE" UNIQUE ("EMBRYO_ID", "CELL");


--
-- Name: UK_BIOM_NEIGH; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY "EMBRYO_NEIGHBOR"
    ADD CONSTRAINT "UK_BIOM_NEIGH" UNIQUE ("EMBRYO_ID", "CELL_A", "CELL_B");


--
-- Name: INDEX_AEY_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_AEY_PK" ON "ANAT_ENTITY" USING btree ("ANAT_ID");


--
-- Name: INDEX_ANI_CLUST_IND; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_ANI_CLUST_IND" ON "CLONE_SEQ" USING btree ("ANISEED_CLUSTER_ID");


--
-- Name: INDEX_ANI_ENS_CLUST_IND; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_ANI_ENS_CLUST_IND" ON "CLONE_SEQ" USING btree ("ANISEED_ENSEMBL_CLUSTER_ID");


--
-- Name: INDEX_ANI_KYO_CLUST_IND; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_ANI_KYO_CLUST_IND" ON "CLONE_SEQ" USING btree ("ANISEED_KYOTO_CLUSTER_ID");


--
-- Name: INDEX_BEY_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_BEY_PK" ON "BIO_ENTITY" USING btree ("BIO_ID");


--
-- Name: INDEX_BIOMETRY_PK21099503661812; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_BIOMETRY_PK21099503661812" ON "BIOMETRY" USING btree ("CELL");


--
-- Name: INDEX_BIO_REF_INDEX; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_BIO_REF_INDEX" ON "REFERENCE" USING btree ("BIO_ID");


--
-- Name: INDEX_CLE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CLE_PK" ON "CLONE" USING btree ("CLONE_ID");


--
-- Name: INDEX_CLE_UK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CLE_UK" ON "CLONE" USING btree ("CLONE_NAME");


--
-- Name: INDEX_CLG_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CLG_PK" ON "CLUSTERING" USING btree ("CLUSTER_ID");


--
-- Name: INDEX_CLONEID_NAME; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_CLONEID_NAME" ON "CLONE" USING btree ("CLONE_ID", "CLONE_NAME");


--
-- Name: INDEX_CNAME_ANISEED; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_CNAME_ANISEED" ON "CLONE_SEQ" USING btree ("CLONE_NAME", "ANISEED_CLUSTER_ID");


--
-- Name: INDEX_CNAME_ANISEED_ENSEMBL; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_CNAME_ANISEED_ENSEMBL" ON "CLONE_SEQ" USING btree ("CLONE_NAME", "ANISEED_ENSEMBL_CLUSTER_ID");


--
-- Name: INDEX_CNAME_ANISEED_KYOTO; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_CNAME_ANISEED_KYOTO" ON "CLONE_SEQ" USING btree ("CLONE_NAME", "ANISEED_KYOTO_CLUSTER_ID");


--
-- Name: INDEX_CONSTRUCTION_PK21108575345093; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CONSTRUCTION_PK21108575345093" ON "CONSTRUCTION" USING btree ("CONSTRUCTION_ID");


--
-- Name: INDEX_CONSTRUCTION_UK31108575345093; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CONSTRUCTION_UK31108575345093" ON "CONSTRUCTION" USING btree ("NAME");


--
-- Name: INDEX_CSK_NAME; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_CSK_NAME" ON "CLONE_SEQ" USING btree ("NAME");


--
-- Name: INDEX_CSQ_UK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_CSQ_UK" ON "CLONE_SEQ" USING btree ("GENBANK_ID");


--
-- Name: INDEX_DSE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_DSE_PK" ON "DEV_STAGE" USING btree ("DEV_STAGE_ID");


--
-- Name: INDEX_FATE_UK31079102458859; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_FATE_UK31079102458859" ON "FATE" USING btree ("ANAT_ID", "KEYWORDS");


--
-- Name: INDEX_FKW_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_FKW_PK" ON "FATE_KW" USING btree ("KEYWORDS");


--
-- Name: INDEX_GEC_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_GEC_PK" ON "SCAFFOLD" USING btree ("SCAFFOLD_ID");


--
-- Name: INDEX_GEE_NAME; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_GEE_NAME" ON "GENE" USING btree ("NAME", "FULL_NAME");


--
-- Name: INDEX_GEE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_GEE_PK" ON "GENE" USING btree ("GENE_ID");


--
-- Name: INDEX_GO_CHILD_OF_PK11062429581669; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_GO_CHILD_OF_PK11062429581669" ON "GO_CHILD_OF" USING btree ("GO_ID", "CHILD_OF");


--
-- Name: INDEX_GO_DESCRIPTIO_PK31062170454843; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_GO_DESCRIPTIO_PK31062170454843" ON "GO_DESCRIPTION" USING btree ("MOL_ID", "GO_ID");


--
-- Name: INDEX_GO_PK61062428603303; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_GO_PK61062428603303" ON "GO" USING btree ("GO_ID");


--
-- Name: INDEX_IN-SITU-CLUST_UK_1; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IN-SITU-CLUST_UK_1" ON "IN_SITU_CLUSTER" USING btree ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: INDEX_IN-SITU-CLUST_UK_2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IN-SITU-CLUST_UK_2" ON "IN_SITU_CLUSTER2" USING btree ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: INDEX_IN-SITU-CLUST_UK_2_1; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IN-SITU-CLUST_UK_2_1" ON "IN_SITU_CLUSTER3" USING btree ("IN_SITU_ID", "IN_SITU_ID_2", "TYPE");


--
-- Name: INDEX_INDEX-DDD; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX-DDD" ON "DDD" USING btree ("GENE_ID", "LIBRARY_ID");


--
-- Name: INDEX_INDEX-MOL_ID; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX-MOL_ID" ON "BLAST" USING btree ("MOL_ID");


--
-- Name: INDEX_INDEX_FATE; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_FATE" ON "FATE" USING btree ("KEYWORDS");


--
-- Name: INDEX_INDEX_FATE_ID; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_FATE_ID" ON "FATE" USING btree ("ANAT_ID");


--
-- Name: INDEX_INDEX_INSITU_MANIP; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_INSITU_MANIP" ON "EMBRYO_MANIP" USING btree ("IN_SITU_ID");


--
-- Name: INDEX_INDEX_INSITU_MUT; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_INSITU_MUT" ON "MUTANT" USING btree ("IN_SITU_ID");


--
-- Name: INDEX_INDEX_LIB; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_LIB" ON "CLONE" USING btree ("LIBRARY_ID");


--
-- Name: INDEX_INDEX_NAMES; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_INDEX_NAMES" ON "MOL_ENTITY" USING btree ("NAME", "FULL_NAME");


--
-- Name: INDEX_INDUCTION_FAT_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_INDUCTION_FAT_PK" ON "INDUCTION_FATE" USING btree ("INDUCTION_ID", "FATE");


--
-- Name: INDEX_INDUCTION_MOL_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_INDUCTION_MOL_PK" ON "INDUCTION_MOL" USING btree ("MOL_ID", "INDUCTION_ID");


--
-- Name: INDEX_IND_GO_TYPE; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_IND_GO_TYPE" ON "GO" USING btree ("GO_TYPE");


--
-- Name: INDEX_IND_IPMOL_ID; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_IND_IPMOL_ID" ON "IP_DESCRIPTION" USING btree ("MOL_ID");


--
-- Name: INDEX_IND_SYNO_ORIGIN; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_IND_SYNO_ORIGIN" ON "SYNO" USING btree ("ORIGIN");


--
-- Name: INDEX_INN_AEY_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_INN_AEY_PK" ON "INDUCTION" USING btree ("INDUCTION_ID");


--
-- Name: INDEX_INTERPRO_PK11075739860408; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_INTERPRO_PK11075739860408" ON "INTERPRO" USING btree ("IP_ID");


--
-- Name: INDEX_IN_SITU_INDEX; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_IN_SITU_INDEX" ON "PICTURE" USING btree ("IN_SITU_ID");


--
-- Name: INDEX_IP_CHILD_OF_PK11075817025406; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IP_CHILD_OF_PK11075817025406" ON "IP_CHILD_OF" USING btree ("IP_ID", "CHILD_OF");


--
-- Name: INDEX_IP_CONTAINS_PK11075817040528; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IP_CONTAINS_PK11075817040528" ON "IP_CONTAINS" USING btree ("IP_ID", "CONTAINS");


--
-- Name: INDEX_IP_UK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_IP_UK" ON "IP_DESCRIPTION" USING btree ("MOL_ID", "IP_ID", "METHOD", "LOCATION");


--
-- Name: INDEX_ISU_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_ISU_PK" ON "IN_SITU" USING btree ("IN_SITU_ID");


--
-- Name: INDEX_LIE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_LIE_PK" ON "LINEAGE" USING btree ("MOTHER_CELL", "DAUGHTER_CELL");


--
-- Name: INDEX_LIY_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_LIY_PK" ON "LIBRARY" USING btree ("LIBRARY_ID");


--
-- Name: INDEX_MEY_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_MEY_PK" ON "MOL_ENTITY" USING btree ("MOL_ID");


--
-- Name: INDEX_MOL_ID_IND; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "INDEX_MOL_ID_IND" ON "PHYLOGENY" USING btree ("MOL_ID");


--
-- Name: INDEX_MOTIF_REGUL_PK11106567829042; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_MOTIF_REGUL_PK11106567829042" ON "MOTIF_REGUL" USING btree ("MOTIF_ID");


--
-- Name: INDEX_OTR_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_OTR_PK" ON "MOLECULAR_TOOL" USING btree ("MOLECULAR_TOOL_ID");


--
-- Name: INDEX_PHYLOGENY_UK21063187145202; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_PHYLOGENY_UK21063187145202" ON "PHYLOGENY" USING btree ("MOL_ID", "PARALOG", "ID");


--
-- Name: INDEX_PIE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_PIE_PK" ON "PICTURE" USING btree ("PICTURE_ID");


--
-- Name: INDEX_PROMOTER_UK21108575287234; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_PROMOTER_UK21108575287234" ON "PROMOTER" USING btree ("NAME");


--
-- Name: INDEX_PROMO_PK_1; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_PROMO_PK_1" ON "PROMOTER" USING btree ("PROMOTER_ID");


--
-- Name: INDEX_PSEQ_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_PSEQ_PK" ON "PROT_SEQUENCE" USING btree ("MOL_ID");


--
-- Name: INDEX_SEE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_SEE_PK" ON "SEQUENCE" USING btree ("MOL_ID");


--
-- Name: INDEX_SPE_PK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_SPE_PK" ON "SPECIES" USING btree ("NAME");


--
-- Name: INDEX_SYNO_UK61062672757008; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_SYNO_UK61062672757008" ON "SYNO" USING btree ("GENE_ID", "SYNO_UPPER_CASE");


--
-- Name: INDEX_TAT_UK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX "INDEX_TAT_UK" ON "TARGET" USING btree ("PROBE_ID", "REGION_ID", "SUBSTRATE", "METHOD", "INTENSITY", "IN_SITU_ID", "TARGET_ID");


--
-- Name: ISH_CLUSTERING_INDEX; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "ISH_CLUSTERING_INDEX" ON "ISH_CLUSTERING" USING btree ("MOL_ID", "DEV_STAGE_ID", "SPOT");


--
-- Name: ISH_CLUSTERING_INDEX1; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "ISH_CLUSTERING_INDEX1" ON "ISH_CLUSTERING" USING btree ("MOL_ID");


--
-- Name: ISH_CLUSTERING_INDEX2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "ISH_CLUSTERING_INDEX2" ON "ISH_CLUSTERING" USING btree ("DEV_STAGE_ID");


--
-- Name: ISH_CLUSTERING_INDEX3; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "ISH_CLUSTERING_INDEX3" ON "ISH_CLUSTERING" USING btree ("SPOT");


--
-- Name: ISH_CLUSTERING_INDEX4; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "ISH_CLUSTERING_INDEX4" ON "ISH_CLUSTERING" USING btree ("DEV_STAGE_ID", "SPOT");


--
-- Name: fki_; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fki_ ON "ARTICLE_ANATOMY" USING btree ("ANAT_ID");


--
-- Name: fki_EMBRYO_DIVISION_FK; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "fki_EMBRYO_DIVISION_FK" ON "EMBRYO_DIVISION" USING btree ("EMBRYO_ID");


--
-- Name: fki_EST_CLUSTER_ASSOCIATION; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "fki_EST_CLUSTER_ASSOCIATION" ON "CC_TRANSCRIPT_ALIGNMENT" USING btree (cluster_id);


--
-- Name: fki_FK3_EMBRYO; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "fki_FK3_EMBRYO" ON "EMBRYO" USING btree ("DEV_STAGE_ID");


--
-- Name: fki_TRANSCRIPT_ASSOCIATION; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "fki_TRANSCRIPT_ASSOCIATION" ON "CC_TRANSCRIPT_ALIGNMENT" USING btree (transcript_id);


--
-- Name: fki_group_alignment_fk; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX fki_group_alignment_fk ON "CC_TRANSCRIPT_ALIGNMENT" USING btree (group_id);


--
-- Name: idx_abstract_id; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX idx_abstract_id ON "TRANSCRIPT" USING btree ("ABSTRACT_ID");


--
-- Name: index1; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index1 ON "IN_SITU_CLUSTER4" USING btree ("REGION1");


--
-- Name: index2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index2 ON "IN_SITU_CLUSTER4" USING btree ("REGION2");


--
-- Name: index3; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index3 ON "IN_SITU_CLUSTER4" USING btree ("REGION1", "REGION2", "DISTANCE");


--
-- Name: index4; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index4 ON "IN_SITU_CLUSTER4" USING btree ("REGION1", "DISTANCE");


--
-- Name: index5; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index5 ON "IN_SITU_CLUSTER4" USING btree ("REGION2", "DISTANCE");


--
-- Name: index6; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index6 ON "IN_SITU_CLUSTER4" USING btree ("DISTANCE");


--
-- Name: indexGC; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGC" ON "GENE_CONCEPT" USING btree ("GENE_CLUSTER_ID", "GENE_MODEL_ID");


--
-- Name: indexGC2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGC2" ON "GENE_CONCEPT" USING btree ("GENE_CLUSTER_ID");


--
-- Name: indexGC3; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGC3" ON "GENE_CONCEPT" USING btree ("GENE_CLUSTER_ID");


--
-- Name: indexGCN2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCN2" ON "GENE_CONCEPT_NAME" USING btree ("GENE_CLUSTER_ID", "GENE_CLUSTER_NAME");


--
-- Name: indexGCN3; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCN3" ON "GENE_CONCEPT_NAME" USING btree ("GENE_CLUSTER_ID", "GENE_CLUSTER_UPPER_NAME");


--
-- Name: indexGCNAME; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCNAME" ON "GENE_CONCEPT_NAME" USING btree ("GENE_CLUSTER_ID");


--
-- Name: indexGCNAME2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCNAME2" ON "GENE_CONCEPT_NAME" USING btree ("GENE_CLUSTER_NAME");


--
-- Name: indexGCNB; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCNB" ON "GENE_CONCEPT_NAME_BLAST" USING btree ("GENE_CLUSTER_NAME_BLAST", "GENE_CLUSTER_ID");


--
-- Name: indexGCNB2; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCNB2" ON "GENE_CONCEPT_NAME_BLAST" USING btree ("GENE_CLUSTER_ID");


--
-- Name: indexGCNB3; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "indexGCNB3" ON "GENE_CONCEPT_NAME_BLAST" USING btree ("GENE_CLUSTER_NAME_BLAST");


--
-- Name: index_TARGET_ID; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX "index_TARGET_ID" ON "TARGET" USING btree ("TARGET_ID");


--
-- Name: AEY_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ANAT_ENTITY"
    ADD CONSTRAINT "AEY_BEY_FK" FOREIGN KEY ("ANAT_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: AEY_DSE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ANAT_ENTITY"
    ADD CONSTRAINT "AEY_DSE_FK" FOREIGN KEY ("DEV_STAGE_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: AEY_SPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ANAT_ENTITY"
    ADD CONSTRAINT "AEY_SPE_FK" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: ARTICLE_ANATOMY_ANAT_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ARTICLE_ANATOMY"
    ADD CONSTRAINT "ARTICLE_ANATOMY_ANAT_ID_fkey" FOREIGN KEY ("ANAT_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: ARTICLE_MORPHOGEN_ARTICLE_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ARTICLE_MORPHOGEN"
    ADD CONSTRAINT "ARTICLE_MORPHOGEN_ARTICLE_ID_fkey" FOREIGN KEY ("ARTICLE_ID") REFERENCES "ARTICLE"("ARTICLE_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: ARTICLE_MORPHOGEN_PICTURE_MORPHOGEN_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ARTICLE_MORPHOGEN_PICTURE"
    ADD CONSTRAINT "ARTICLE_MORPHOGEN_PICTURE_MORPHOGEN_ID_fkey" FOREIGN KEY ("MORPHOGEN_ID") REFERENCES "ARTICLE_MORPHOGEN"("MORPHOGEN_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: BIOMETRY_CELL_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "BIOMETRY"
    ADD CONSTRAINT "BIOMETRY_CELL_fkey" FOREIGN KEY ("CELL") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: BIOMETRY_SHAPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "BIOMETRY_SHAPE"
    ADD CONSTRAINT "BIOMETRY_SHAPE_FK" FOREIGN KEY ("CELL") REFERENCES "ANAT_ENTITY"("ANAT_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: BIO_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "REFERENCE"
    ADD CONSTRAINT "BIO_BEY_FK" FOREIGN KEY ("BIO_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: BLT_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "BLAST"
    ADD CONSTRAINT "BLT_MEY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: CLE_LIY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE"
    ADD CONSTRAINT "CLE_LIY_FK" FOREIGN KEY ("LIBRARY_ID") REFERENCES "LIBRARY"("LIBRARY_ID");


--
-- Name: CLE_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE"
    ADD CONSTRAINT "CLE_MEY_FK" FOREIGN KEY ("CLONE_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: CLG_GEE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLUSTERING"
    ADD CONSTRAINT "CLG_GEE_FK" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: CLONE_SEQ_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CLONE_SEQ_FK" FOREIGN KEY ("ANISEED_CLUSTER_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: COMPETENCE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "COMPETENCE"
    ADD CONSTRAINT "COMPETENCE_FK" FOREIGN KEY ("CELL") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: COMPETENCE_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "COMPETENCE"
    ADD CONSTRAINT "COMPETENCE_FK2" FOREIGN KEY ("COMPETENCE") REFERENCES "FATE_KW"("KEYWORDS");


--
-- Name: CONSTRUCTION_FK31110473963102; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CONSTRUCTION"
    ADD CONSTRAINT "CONSTRUCTION_FK31110473963102" FOREIGN KEY ("CONSTRUCTION_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: CSQ_CLE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CSQ_CLE_FK" FOREIGN KEY ("CLONE_NAME") REFERENCES "CLONE"("CLONE_NAME");


--
-- Name: CSQ_CLG_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CSQ_CLG_FK" FOREIGN KEY ("CLUSTER_ID") REFERENCES "CLUSTERING"("CLUSTER_ID");


--
-- Name: CSQ_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CLONE_SEQ"
    ADD CONSTRAINT "CSQ_MEY_FK" FOREIGN KEY ("CLONE_SEQ_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: DSE_SPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "DEV_STAGE"
    ADD CONSTRAINT "DSE_SPE_FK" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: EMBRYO_DIVISION_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO_DIVISION"
    ADD CONSTRAINT "EMBRYO_DIVISION_FK" FOREIGN KEY ("EMBRYO_ID") REFERENCES "EMBRYO"("EMBRYO_ID");


--
-- Name: EMBRYO_MANIP_CTRL_ISH_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO_MANIP"
    ADD CONSTRAINT "EMBRYO_MANIP_CTRL_ISH_ID_fkey" FOREIGN KEY ("CTRL_ISH_ID") REFERENCES "IN_SITU"("IN_SITU_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: EMP_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO_MANIP"
    ADD CONSTRAINT "EMP_BEY_FK" FOREIGN KEY ("STRUCTURE_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: EMP_DSE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO_MANIP"
    ADD CONSTRAINT "EMP_DSE_FK" FOREIGN KEY ("FROM_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: EMP_ISU_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO_MANIP"
    ADD CONSTRAINT "EMP_ISU_FK" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: EON_ANN_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ENTRY_ORIGIN"
    ADD CONSTRAINT "EON_ANN_FK" FOREIGN KEY ("ANNOTATOR_ID") REFERENCES "AUTHOR"("AUTHOR_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: EON_AUR_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ENTRY_ORIGIN"
    ADD CONSTRAINT "EON_AUR_FK" FOREIGN KEY ("AUTHOR_ID") REFERENCES "AUTHOR"("AUTHOR_ID");


--
-- Name: EON_AUR_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ENTRY_ORIGIN"
    ADD CONSTRAINT "EON_AUR_FK2" FOREIGN KEY ("CURATOR_ID") REFERENCES "AUTHOR"("AUTHOR_ID");


--
-- Name: EON_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ENTRY_ORIGIN"
    ADD CONSTRAINT "EON_BEY_FK" FOREIGN KEY ("BIO_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: EST_CLUSTER_ASSOCIATION; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CC_TRANSCRIPT_ALIGNMENT"
    ADD CONSTRAINT "EST_CLUSTER_ASSOCIATION" FOREIGN KEY (cluster_id) REFERENCES "EST_CLUSTER"(cluster_id);


--
-- Name: FAE_AEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "FATE"
    ADD CONSTRAINT "FAE_AEY_FK" FOREIGN KEY ("ANAT_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: FAE_FKW_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "FATE"
    ADD CONSTRAINT "FAE_FKW_FK" FOREIGN KEY ("KEYWORDS") REFERENCES "FATE_KW"("KEYWORDS");


--
-- Name: FK2_EMBRYO; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO"
    ADD CONSTRAINT "FK2_EMBRYO" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: FK3_EMBRYO; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "EMBRYO"
    ADD CONSTRAINT "FK3_EMBRYO" FOREIGN KEY ("DEV_STAGE_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: FK_EXP_CONSTRUCT; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOTIF_COORD"
    ADD CONSTRAINT "FK_EXP_CONSTRUCT" FOREIGN KEY ("EXP_EVIDENCE") REFERENCES "CONSTRUCTION"("CONSTRUCTION_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: FK_GENE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOTIF_COORD_GENE"
    ADD CONSTRAINT "FK_GENE_ID" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: FK_MOTIF_COORD_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOTIF_COORD_GENE"
    ADD CONSTRAINT "FK_MOTIF_COORD_ID" FOREIGN KEY ("MOTIF_COORD_ID") REFERENCES "MOTIF_COORD"("MOTIF_COORD_ID");


--
-- Name: GDN_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GO_DESCRIPTION"
    ADD CONSTRAINT "GDN_MEY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: GEE_GEC_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE"
    ADD CONSTRAINT "GEE_GEC_FK" FOREIGN KEY ("SCAFFOLD_ID") REFERENCES "SCAFFOLD"("SCAFFOLD_ID");


--
-- Name: GEE_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE"
    ADD CONSTRAINT "GEE_MEY_FK" FOREIGN KEY ("GENE_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: GENE_DDD_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "DDD"
    ADD CONSTRAINT "GENE_DDD_FK" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: GENE_MOTIF_GENE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE_MOTIF"
    ADD CONSTRAINT "GENE_MOTIF_GENE_ID" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: GENE_MOTIF_MOTIF_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE_MOTIF"
    ADD CONSTRAINT "GENE_MOTIF_MOTIF_ID" FOREIGN KEY ("MOTIF_ID") REFERENCES "MOTIF_REGUL"("MOTIF_ID");


--
-- Name: GENE_REGULATION_GENE_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE_REGULATION"
    ADD CONSTRAINT "GENE_REGULATION_GENE_ID_fkey" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: GENE_REGULATI_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GENE_REGULATION"
    ADD CONSTRAINT "GENE_REGULATI_FK2" FOREIGN KEY ("PROMOTER_ID") REFERENCES "PROMOTER"("PROMOTER_ID");


--
-- Name: GO_CHILD_OF_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GO_CHILD_OF"
    ADD CONSTRAINT "GO_CHILD_OF_FK" FOREIGN KEY ("GO_ID") REFERENCES "GO"("GO_ID");


--
-- Name: GO_CHILD_OF_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GO_CHILD_OF"
    ADD CONSTRAINT "GO_CHILD_OF_FK2" FOREIGN KEY ("CHILD_OF") REFERENCES "GO"("GO_ID");


--
-- Name: GO_DESCRIPTIO_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "GO_DESCRIPTION"
    ADD CONSTRAINT "GO_DESCRIPTIO_FK" FOREIGN KEY ("GO_ID") REFERENCES "GO"("GO_ID");


--
-- Name: IN-SITU-CLUST_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER"
    ADD CONSTRAINT "IN-SITU-CLUST_FK" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: IN-SITU-CLUST_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER"
    ADD CONSTRAINT "IN-SITU-CLUST_FK2" FOREIGN KEY ("IN_SITU_ID_2") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: IN-SITU-CLUST_FK2_1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER2"
    ADD CONSTRAINT "IN-SITU-CLUST_FK2_1" FOREIGN KEY ("IN_SITU_ID_2") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: IN-SITU-CLUST_FK2_1_1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER3"
    ADD CONSTRAINT "IN-SITU-CLUST_FK2_1_1" FOREIGN KEY ("IN_SITU_ID_2") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: IN-SITU-CLUST_FK_1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER2"
    ADD CONSTRAINT "IN-SITU-CLUST_FK_1" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: IN-SITU-CLUST_FK_1_1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU_CLUSTER3"
    ADD CONSTRAINT "IN-SITU-CLUST_FK_1_1" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: INDUCTION_FAT_FK1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION_FATE"
    ADD CONSTRAINT "INDUCTION_FAT_FK1" FOREIGN KEY ("INDUCTION_ID") REFERENCES "INDUCTION"("INDUCTION_ID");


--
-- Name: INDUCTION_FAT_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION_FATE"
    ADD CONSTRAINT "INDUCTION_FAT_FK2" FOREIGN KEY ("FATE") REFERENCES "FATE_KW"("KEYWORDS");


--
-- Name: INDUCTION_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION"
    ADD CONSTRAINT "INDUCTION_FK" FOREIGN KEY ("INDUCED_FATE") REFERENCES "FATE_KW"("KEYWORDS");


--
-- Name: INDUCTION_MOL_FK1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION_MOL"
    ADD CONSTRAINT "INDUCTION_MOL_FK1" FOREIGN KEY ("INDUCTION_ID") REFERENCES "INDUCTION"("INDUCTION_ID");


--
-- Name: INDUCTION_MOL_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION_MOL"
    ADD CONSTRAINT "INDUCTION_MOL_FK2" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: INN_AEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION"
    ADD CONSTRAINT "INN_AEY_FK" FOREIGN KEY ("INDUCTOR_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: INN_AEY_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "INDUCTION"
    ADD CONSTRAINT "INN_AEY_FK2" FOREIGN KEY ("INDUCED_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: IP_BIO_ID_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IP_DESCRIPTION"
    ADD CONSTRAINT "IP_BIO_ID_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: IP_ID_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IP_DESCRIPTION"
    ADD CONSTRAINT "IP_ID_FK" FOREIGN KEY ("IP_ID") REFERENCES "INTERPRO"("IP_ID");


--
-- Name: ISH_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "UPDATE_INTERACTIONS"
    ADD CONSTRAINT "ISH_FK" FOREIGN KEY ("ISH_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: ISU_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU"
    ADD CONSTRAINT "ISU_BEY_FK" FOREIGN KEY ("IN_SITU_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: ISU_DSE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU"
    ADD CONSTRAINT "ISU_DSE_FK" FOREIGN KEY ("DEV_STAGE_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: ISU_SPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "IN_SITU"
    ADD CONSTRAINT "ISU_SPE_FK" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: KDN_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "KNOCKDOWN"
    ADD CONSTRAINT "KDN_MEY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: KDN_MLT_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "KNOCKDOWN"
    ADD CONSTRAINT "KDN_MLT_FK" FOREIGN KEY ("MORPHOLINO") REFERENCES "MOLECULAR_TOOL"("MOLECULAR_TOOL_ID");


--
-- Name: KDN_PCR_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "KNOCKDOWN"
    ADD CONSTRAINT "KDN_PCR_FK" FOREIGN KEY ("PCR_ID") REFERENCES "PCR"("PCR_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: LIB_DDD_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "DDD"
    ADD CONSTRAINT "LIB_DDD_FK" FOREIGN KEY ("LIBRARY_ID") REFERENCES "LIBRARY"("LIBRARY_ID");


--
-- Name: LIE_AEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "LINEAGE"
    ADD CONSTRAINT "LIE_AEY_FK" FOREIGN KEY ("MOTHER_CELL") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: LIE_AEY_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "LINEAGE"
    ADD CONSTRAINT "LIE_AEY_FK2" FOREIGN KEY ("DAUGHTER_CELL") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: MEY_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOL_ENTITY"
    ADD CONSTRAINT "MEY_BEY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: MEY_SPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOL_ENTITY"
    ADD CONSTRAINT "MEY_SPE_FK" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: MOTIF_COORD_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOTIF_COORD"
    ADD CONSTRAINT "MOTIF_COORD_FK" FOREIGN KEY ("MOTIF_ID") REFERENCES "MOTIF_REGUL"("MOTIF_ID");


--
-- Name: MTL_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MOLECULAR_TOOL"
    ADD CONSTRAINT "MTL_MEY_FK" FOREIGN KEY ("MOLECULAR_TOOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: MUTANT_CTRL_ISH_ID_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUTANT_CTRL_ISH_ID_fkey" FOREIGN KEY ("CTRL_ISH_ID") REFERENCES "IN_SITU"("IN_SITU_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: MUTANT_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUTANT_FK" FOREIGN KEY ("INHIBITOR_ID") REFERENCES "MOLECULAR_TOOL"("MOLECULAR_TOOL_ID");


--
-- Name: MUT_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUT_BEY_FK" FOREIGN KEY ("BIO_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: MUT_DSE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUT_DSE_FK" FOREIGN KEY ("TO_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: MUT_DSE_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUT_DSE_FK2" FOREIGN KEY ("FROM_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: MUT_ISU_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MUTANT"
    ADD CONSTRAINT "MUT_ISU_FK" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: PCR_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PCR"
    ADD CONSTRAINT "PCR_BEY_FK" FOREIGN KEY ("PCR_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: PCR_DVS_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PCR"
    ADD CONSTRAINT "PCR_DVS_FK" FOREIGN KEY ("DEV_STAGE_ID") REFERENCES "DEV_STAGE"("DEV_STAGE_ID");


--
-- Name: PCR_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PCR"
    ADD CONSTRAINT "PCR_MEY_FK" FOREIGN KEY ("GENE_EXAMINED") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: PCR_SPE_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PCR"
    ADD CONSTRAINT "PCR_SPE_FK" FOREIGN KEY ("SPECIES") REFERENCES "SPECIES"("NAME");


--
-- Name: PHYLOGENY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PHYLOGENY"
    ADD CONSTRAINT "PHYLOGENY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: PROMOTER_FK1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PROMOTER"
    ADD CONSTRAINT "PROMOTER_FK1" FOREIGN KEY ("PROMOTER_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: PROMOTER_ID_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "SO_DESCRIPTION"
    ADD CONSTRAINT "PROMOTER_ID_FK" FOREIGN KEY ("PROMOTER_ID") REFERENCES "PROMOTER"("PROMOTER_ID");


--
-- Name: PSEQ_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "PROT_SEQUENCE"
    ADD CONSTRAINT "PSEQ_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: SEE_MEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "SEQUENCE"
    ADD CONSTRAINT "SEE_MEY_FK" FOREIGN KEY ("MOL_ID") REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: SO_ID_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "SO_DESCRIPTION"
    ADD CONSTRAINT "SO_ID_FK" FOREIGN KEY ("SO_ID") REFERENCES "SO"("SO_ID");


--
-- Name: SYNO_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "SYNO"
    ADD CONSTRAINT "SYNO_FK" FOREIGN KEY ("GENE_ID") REFERENCES "GENE"("GENE_ID");


--
-- Name: TARGET_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TARGET"
    ADD CONSTRAINT "TARGET_FK" FOREIGN KEY ("REGION_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID");


--
-- Name: TAT_BEY_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TARGET"
    ADD CONSTRAINT "TAT_BEY_FK" FOREIGN KEY ("TARGET_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: TAT_BEY_FK3; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TARGET"
    ADD CONSTRAINT "TAT_BEY_FK3" FOREIGN KEY ("PROBE_ID") REFERENCES "BIO_ENTITY"("BIO_ID");


--
-- Name: TAT_ISU_FK; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TARGET"
    ADD CONSTRAINT "TAT_ISU_FK" FOREIGN KEY ("IN_SITU_ID") REFERENCES "IN_SITU"("IN_SITU_ID");


--
-- Name: TRANSCRIPT_ASSOCIATION; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CC_TRANSCRIPT_ALIGNMENT"
    ADD CONSTRAINT "TRANSCRIPT_ASSOCIATION" FOREIGN KEY (transcript_id) REFERENCES "MOL_ENTITY"("MOL_ID");


--
-- Name: TRANSCRIPT_FK1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TRANSCRIPT"
    ADD CONSTRAINT "TRANSCRIPT_FK1" FOREIGN KEY ("TRANSCRIPT_ID") REFERENCES "MOL_ENTITY"("MOL_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: TRANSCRIPT_FK2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "TRANSCRIPT"
    ADD CONSTRAINT "TRANSCRIPT_FK2" FOREIGN KEY ("ABSTRACT_ID") REFERENCES "MOL_ENTITY"("MOL_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: fk_ARTICLE_FATE; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "ARTICLE_FATE"
    ADD CONSTRAINT "fk_ARTICLE_FATE" FOREIGN KEY ("FATE") REFERENCES "FATE_KW"("KEYWORDS") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: fk_MAP; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "MAP"
    ADD CONSTRAINT "fk_MAP" FOREIGN KEY ("ANAT_ID") REFERENCES "ANAT_ENTITY"("ANAT_ID") ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: group_alignment_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "CC_TRANSCRIPT_ALIGNMENT"
    ADD CONSTRAINT group_alignment_fk FOREIGN KEY (group_id) REFERENCES "GROUP_ALIGNMENT_CLUSTER"(group_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: -
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: ANAT_ENTITY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ANAT_ENTITY" FROM PUBLIC;
REVOKE ALL ON TABLE "ANAT_ENTITY" FROM ciona_design;
GRANT ALL ON TABLE "ANAT_ENTITY" TO ciona_design;


--
-- Name: ARTICLE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE" TO ciona_design;


--
-- Name: ARTICLE_ANATOMY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE_ANATOMY" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE_ANATOMY" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE_ANATOMY" TO ciona_design;


--
-- Name: ARTICLE_FATE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE_FATE" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE_FATE" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE_FATE" TO ciona_design;


--
-- Name: ARTICLE_GENE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE_GENE" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE_GENE" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE_GENE" TO ciona_design;


--
-- Name: ARTICLE_MORPHOGEN; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE_MORPHOGEN" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE_MORPHOGEN" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE_MORPHOGEN" TO ciona_design;


--
-- Name: ARTICLE_MORPHOGEN_PICTURE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ARTICLE_MORPHOGEN_PICTURE" FROM PUBLIC;
REVOKE ALL ON TABLE "ARTICLE_MORPHOGEN_PICTURE" FROM ciona_design;
GRANT ALL ON TABLE "ARTICLE_MORPHOGEN_PICTURE" TO ciona_design;


--
-- Name: AUTHOR; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "AUTHOR" FROM PUBLIC;
REVOKE ALL ON TABLE "AUTHOR" FROM ciona_design;
GRANT ALL ON TABLE "AUTHOR" TO ciona_design;


--
-- Name: BIOMETRY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "BIOMETRY" FROM PUBLIC;
REVOKE ALL ON TABLE "BIOMETRY" FROM ciona_design;
GRANT ALL ON TABLE "BIOMETRY" TO ciona_design;


--
-- Name: BIOMETRY_SHAPE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "BIOMETRY_SHAPE" FROM PUBLIC;
REVOKE ALL ON TABLE "BIOMETRY_SHAPE" FROM ciona_design;
GRANT ALL ON TABLE "BIOMETRY_SHAPE" TO ciona_design;


--
-- Name: BIO_ENTITY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "BIO_ENTITY" FROM PUBLIC;
REVOKE ALL ON TABLE "BIO_ENTITY" FROM ciona_design;
GRANT ALL ON TABLE "BIO_ENTITY" TO ciona_design;


--
-- Name: BLAST; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "BLAST" FROM PUBLIC;
REVOKE ALL ON TABLE "BLAST" FROM ciona_design;
GRANT ALL ON TABLE "BLAST" TO ciona_design;


--
-- Name: CC_TRANSCRIPT_ALIGNMENT; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CC_TRANSCRIPT_ALIGNMENT" FROM PUBLIC;
REVOKE ALL ON TABLE "CC_TRANSCRIPT_ALIGNMENT" FROM ciona_design;
GRANT ALL ON TABLE "CC_TRANSCRIPT_ALIGNMENT" TO ciona_design;


--
-- Name: CIPRO_LINK; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CIPRO_LINK" FROM PUBLIC;
REVOKE ALL ON TABLE "CIPRO_LINK" FROM ciona_design;
GRANT ALL ON TABLE "CIPRO_LINK" TO ciona_design;
GRANT SELECT ON TABLE "CIPRO_LINK" TO PUBLIC;


--
-- Name: CLONE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CLONE" FROM PUBLIC;
REVOKE ALL ON TABLE "CLONE" FROM ciona_design;
GRANT ALL ON TABLE "CLONE" TO ciona_design;


--
-- Name: CLONE_SEQ; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CLONE_SEQ" FROM PUBLIC;
REVOKE ALL ON TABLE "CLONE_SEQ" FROM ciona_design;
GRANT ALL ON TABLE "CLONE_SEQ" TO ciona_design;


--
-- Name: CLUSTERING; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CLUSTERING" FROM PUBLIC;
REVOKE ALL ON TABLE "CLUSTERING" FROM ciona_design;
GRANT ALL ON TABLE "CLUSTERING" TO ciona_design;


--
-- Name: GENE_CONCEPT; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE_CONCEPT" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE_CONCEPT" FROM ciona_design;
GRANT ALL ON TABLE "GENE_CONCEPT" TO ciona_design;


--
-- Name: TARGET; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "TARGET" FROM PUBLIC;
REVOKE ALL ON TABLE "TARGET" FROM ciona_design;
GRANT ALL ON TABLE "TARGET" TO ciona_design;


--
-- Name: CLUSTER_BY_TARGET; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CLUSTER_BY_TARGET" FROM PUBLIC;
REVOKE ALL ON TABLE "CLUSTER_BY_TARGET" FROM ciona_design;
GRANT ALL ON TABLE "CLUSTER_BY_TARGET" TO ciona_design;
GRANT SELECT ON TABLE "CLUSTER_BY_TARGET" TO PUBLIC;


--
-- Name: COMPETENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "COMPETENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "COMPETENCE" FROM ciona_design;
GRANT ALL ON TABLE "COMPETENCE" TO ciona_design;


--
-- Name: CONSTRUCTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "CONSTRUCTION" FROM PUBLIC;
REVOKE ALL ON TABLE "CONSTRUCTION" FROM ciona_design;
GRANT ALL ON TABLE "CONSTRUCTION" TO ciona_design;


--
-- Name: DDD; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "DDD" FROM PUBLIC;
REVOKE ALL ON TABLE "DDD" FROM ciona_design;
GRANT ALL ON TABLE "DDD" TO ciona_design;


--
-- Name: DEV_STAGE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "DEV_STAGE" FROM PUBLIC;
REVOKE ALL ON TABLE "DEV_STAGE" FROM ciona_design;
GRANT ALL ON TABLE "DEV_STAGE" TO ciona_design;


--
-- Name: DEV_STAGE_INFO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "DEV_STAGE_INFO" FROM PUBLIC;
REVOKE ALL ON TABLE "DEV_STAGE_INFO" FROM ciona_design;
GRANT ALL ON TABLE "DEV_STAGE_INFO" TO ciona_design;


--
-- Name: DIVISION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "DIVISION" FROM PUBLIC;
REVOKE ALL ON TABLE "DIVISION" FROM ciona_design;
GRANT ALL ON TABLE "DIVISION" TO ciona_design;


--
-- Name: EASTER_EGG; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EASTER_EGG" FROM PUBLIC;
REVOKE ALL ON TABLE "EASTER_EGG" FROM ciona_design;
GRANT ALL ON TABLE "EASTER_EGG" TO ciona_design;
GRANT INSERT ON TABLE "EASTER_EGG" TO PUBLIC;


--
-- Name: EMBRYO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO" TO ciona_design;


--
-- Name: EMBRYO_BIOMETRY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO_BIOMETRY" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO_BIOMETRY" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO_BIOMETRY" TO ciona_design;


--
-- Name: EMBRYO_BIOMETRY_SHAPE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO_BIOMETRY_SHAPE" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO_BIOMETRY_SHAPE" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO_BIOMETRY_SHAPE" TO ciona_design;


--
-- Name: EMBRYO_DIVISION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO_DIVISION" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO_DIVISION" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO_DIVISION" TO ciona_design;


--
-- Name: EMBRYO_MANIP; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO_MANIP" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO_MANIP" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO_MANIP" TO ciona_design;


--
-- Name: EMBRYO_NEIGHBOR; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EMBRYO_NEIGHBOR" FROM PUBLIC;
REVOKE ALL ON TABLE "EMBRYO_NEIGHBOR" FROM ciona_design;
GRANT ALL ON TABLE "EMBRYO_NEIGHBOR" TO ciona_design;


--
-- Name: ENTRY_ORIGIN; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ENTRY_ORIGIN" FROM PUBLIC;
REVOKE ALL ON TABLE "ENTRY_ORIGIN" FROM ciona_design;
GRANT ALL ON TABLE "ENTRY_ORIGIN" TO ciona_design;


--
-- Name: EST_CLUSTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "EST_CLUSTER" FROM PUBLIC;
REVOKE ALL ON TABLE "EST_CLUSTER" FROM ciona_design;
GRANT ALL ON TABLE "EST_CLUSTER" TO ciona_design;


--
-- Name: FATE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "FATE" FROM PUBLIC;
REVOKE ALL ON TABLE "FATE" FROM ciona_design;
GRANT ALL ON TABLE "FATE" TO ciona_design;


--
-- Name: FATE_KW; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "FATE_KW" FROM PUBLIC;
REVOKE ALL ON TABLE "FATE_KW" FROM ciona_design;
GRANT ALL ON TABLE "FATE_KW" TO ciona_design;


--
-- Name: GENE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE" FROM ciona_design;
GRANT ALL ON TABLE "GENE" TO ciona_design;


--
-- Name: GENE_CONCEPT_NAME; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE_CONCEPT_NAME" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE_CONCEPT_NAME" FROM ciona_design;
GRANT ALL ON TABLE "GENE_CONCEPT_NAME" TO ciona_design;


--
-- Name: GENE_CONCEPT_NAME_BLAST; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE_CONCEPT_NAME_BLAST" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE_CONCEPT_NAME_BLAST" FROM ciona_design;
GRANT ALL ON TABLE "GENE_CONCEPT_NAME_BLAST" TO ciona_design;
GRANT SELECT ON TABLE "GENE_CONCEPT_NAME_BLAST" TO PUBLIC;


--
-- Name: GENE_MOTIF; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE_MOTIF" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE_MOTIF" FROM ciona_design;
GRANT ALL ON TABLE "GENE_MOTIF" TO ciona_design;


--
-- Name: GENE_REGULATION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GENE_REGULATION" FROM PUBLIC;
REVOKE ALL ON TABLE "GENE_REGULATION" FROM ciona_design;
GRANT ALL ON TABLE "GENE_REGULATION" TO ciona_design;


--
-- Name: GLOBAL_GENE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GLOBAL_GENE" FROM PUBLIC;
REVOKE ALL ON TABLE "GLOBAL_GENE" FROM ciona_design;
GRANT ALL ON TABLE "GLOBAL_GENE" TO ciona_design;


--
-- Name: GO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GO" FROM PUBLIC;
REVOKE ALL ON TABLE "GO" FROM ciona_design;
GRANT ALL ON TABLE "GO" TO ciona_design;


--
-- Name: GO_CHILD_OF; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GO_CHILD_OF" FROM PUBLIC;
REVOKE ALL ON TABLE "GO_CHILD_OF" FROM ciona_design;
GRANT ALL ON TABLE "GO_CHILD_OF" TO ciona_design;


--
-- Name: GO_DESCRIPTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GO_DESCRIPTION" FROM PUBLIC;
REVOKE ALL ON TABLE "GO_DESCRIPTION" FROM ciona_design;
GRANT ALL ON TABLE "GO_DESCRIPTION" TO ciona_design;


--
-- Name: GROUP_ALIGNMENT_CLUSTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "GROUP_ALIGNMENT_CLUSTER" FROM PUBLIC;
REVOKE ALL ON TABLE "GROUP_ALIGNMENT_CLUSTER" FROM ciona_design;
GRANT ALL ON TABLE "GROUP_ALIGNMENT_CLUSTER" TO ciona_design;


--
-- Name: INDUCTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INDUCTION" FROM PUBLIC;
REVOKE ALL ON TABLE "INDUCTION" FROM ciona_design;
GRANT ALL ON TABLE "INDUCTION" TO ciona_design;


--
-- Name: INDUCTION_FATE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INDUCTION_FATE" FROM PUBLIC;
REVOKE ALL ON TABLE "INDUCTION_FATE" FROM ciona_design;
GRANT ALL ON TABLE "INDUCTION_FATE" TO ciona_design;


--
-- Name: INDUCTION_MOL; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INDUCTION_MOL" FROM PUBLIC;
REVOKE ALL ON TABLE "INDUCTION_MOL" FROM ciona_design;
GRANT ALL ON TABLE "INDUCTION_MOL" TO ciona_design;


--
-- Name: INTERACTION_EVIDENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INTERACTION_EVIDENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "INTERACTION_EVIDENCE" FROM ciona_design;
GRANT ALL ON TABLE "INTERACTION_EVIDENCE" TO ciona_design;
GRANT SELECT ON TABLE "INTERACTION_EVIDENCE" TO PUBLIC;


--
-- Name: INTERACTION_EVIDENCE_TYPE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INTERACTION_EVIDENCE_TYPE" FROM PUBLIC;
REVOKE ALL ON TABLE "INTERACTION_EVIDENCE_TYPE" FROM ciona_design;
GRANT ALL ON TABLE "INTERACTION_EVIDENCE_TYPE" TO ciona_design;
GRANT SELECT ON TABLE "INTERACTION_EVIDENCE_TYPE" TO PUBLIC;


--
-- Name: INTERACTION_TYPE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INTERACTION_TYPE" FROM PUBLIC;
REVOKE ALL ON TABLE "INTERACTION_TYPE" FROM ciona_design;
GRANT ALL ON TABLE "INTERACTION_TYPE" TO ciona_design;
GRANT SELECT ON TABLE "INTERACTION_TYPE" TO PUBLIC;


--
-- Name: INTERPRO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "INTERPRO" FROM PUBLIC;
REVOKE ALL ON TABLE "INTERPRO" FROM ciona_design;
GRANT ALL ON TABLE "INTERPRO" TO ciona_design;


--
-- Name: IN_SITU; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IN_SITU" FROM PUBLIC;
REVOKE ALL ON TABLE "IN_SITU" FROM ciona_design;
GRANT ALL ON TABLE "IN_SITU" TO ciona_design;


--
-- Name: IN_SITU_CLUSTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IN_SITU_CLUSTER" FROM PUBLIC;
REVOKE ALL ON TABLE "IN_SITU_CLUSTER" FROM ciona_design;
GRANT ALL ON TABLE "IN_SITU_CLUSTER" TO ciona_design;


--
-- Name: IN_SITU_CLUSTER2; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IN_SITU_CLUSTER2" FROM PUBLIC;
REVOKE ALL ON TABLE "IN_SITU_CLUSTER2" FROM ciona_design;
GRANT ALL ON TABLE "IN_SITU_CLUSTER2" TO ciona_design;


--
-- Name: IN_SITU_CLUSTER3; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IN_SITU_CLUSTER3" FROM PUBLIC;
REVOKE ALL ON TABLE "IN_SITU_CLUSTER3" FROM ciona_design;
GRANT ALL ON TABLE "IN_SITU_CLUSTER3" TO ciona_design;


--
-- Name: IN_SITU_CLUSTER4; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IN_SITU_CLUSTER4" FROM PUBLIC;
REVOKE ALL ON TABLE "IN_SITU_CLUSTER4" FROM ciona_design;
GRANT ALL ON TABLE "IN_SITU_CLUSTER4" TO ciona_design;


--
-- Name: IP_CHILD_OF; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IP_CHILD_OF" FROM PUBLIC;
REVOKE ALL ON TABLE "IP_CHILD_OF" FROM ciona_design;
GRANT ALL ON TABLE "IP_CHILD_OF" TO ciona_design;


--
-- Name: IP_CONTAINS; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IP_CONTAINS" FROM PUBLIC;
REVOKE ALL ON TABLE "IP_CONTAINS" FROM ciona_design;
GRANT ALL ON TABLE "IP_CONTAINS" TO ciona_design;


--
-- Name: IP_DESCRIPTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "IP_DESCRIPTION" FROM PUBLIC;
REVOKE ALL ON TABLE "IP_DESCRIPTION" FROM ciona_design;
GRANT ALL ON TABLE "IP_DESCRIPTION" TO ciona_design;


--
-- Name: ISH_BY_CLUSTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ISH_BY_CLUSTER" FROM PUBLIC;
REVOKE ALL ON TABLE "ISH_BY_CLUSTER" FROM ciona_design;
GRANT ALL ON TABLE "ISH_BY_CLUSTER" TO ciona_design;
GRANT SELECT ON TABLE "ISH_BY_CLUSTER" TO PUBLIC;


--
-- Name: ISH_CLUSTERING; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ISH_CLUSTERING" FROM PUBLIC;
REVOKE ALL ON TABLE "ISH_CLUSTERING" FROM ciona_design;
GRANT ALL ON TABLE "ISH_CLUSTERING" TO ciona_design;


--
-- Name: ISH_PROFILE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "ISH_PROFILE" FROM PUBLIC;
REVOKE ALL ON TABLE "ISH_PROFILE" FROM ciona_design;
GRANT ALL ON TABLE "ISH_PROFILE" TO ciona_design;


--
-- Name: KNOCKDOWN; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "KNOCKDOWN" FROM PUBLIC;
REVOKE ALL ON TABLE "KNOCKDOWN" FROM ciona_design;
GRANT ALL ON TABLE "KNOCKDOWN" TO ciona_design;


--
-- Name: LIBRARY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "LIBRARY" FROM PUBLIC;
REVOKE ALL ON TABLE "LIBRARY" FROM ciona_design;
GRANT ALL ON TABLE "LIBRARY" TO ciona_design;


--
-- Name: LINEAGE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "LINEAGE" FROM PUBLIC;
REVOKE ALL ON TABLE "LINEAGE" FROM ciona_design;
GRANT ALL ON TABLE "LINEAGE" TO ciona_design;


--
-- Name: LOG; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "LOG" FROM PUBLIC;
REVOKE ALL ON TABLE "LOG" FROM ciona_design;
GRANT ALL ON TABLE "LOG" TO ciona_design;


--
-- Name: LOG_TOOL; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "LOG_TOOL" FROM PUBLIC;
REVOKE ALL ON TABLE "LOG_TOOL" FROM ciona_design;
GRANT ALL ON TABLE "LOG_TOOL" TO ciona_design;


--
-- Name: LOG_WEBSITE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "LOG_WEBSITE" FROM PUBLIC;
REVOKE ALL ON TABLE "LOG_WEBSITE" FROM ciona_design;
GRANT ALL ON TABLE "LOG_WEBSITE" TO ciona_design;


--
-- Name: MAP; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MAP" FROM PUBLIC;
REVOKE ALL ON TABLE "MAP" FROM ciona_design;
GRANT ALL ON TABLE "MAP" TO ciona_design;
GRANT SELECT ON TABLE "MAP" TO PUBLIC;


--
-- Name: MOLECULAR_TOOL; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MOLECULAR_TOOL" FROM PUBLIC;
REVOKE ALL ON TABLE "MOLECULAR_TOOL" FROM ciona_design;
GRANT ALL ON TABLE "MOLECULAR_TOOL" TO ciona_design;


--
-- Name: MOL_ENTITY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MOL_ENTITY" FROM PUBLIC;
REVOKE ALL ON TABLE "MOL_ENTITY" FROM ciona_design;
GRANT ALL ON TABLE "MOL_ENTITY" TO ciona_design;


--
-- Name: MOTIF_COORD; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MOTIF_COORD" FROM PUBLIC;
REVOKE ALL ON TABLE "MOTIF_COORD" FROM ciona_design;
GRANT ALL ON TABLE "MOTIF_COORD" TO ciona_design;


--
-- Name: MOTIF_COORD_GENE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MOTIF_COORD_GENE" FROM PUBLIC;
REVOKE ALL ON TABLE "MOTIF_COORD_GENE" FROM ciona_design;
GRANT ALL ON TABLE "MOTIF_COORD_GENE" TO ciona_design;
GRANT SELECT ON TABLE "MOTIF_COORD_GENE" TO PUBLIC;


--
-- Name: MOTIF_REGUL; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MOTIF_REGUL" FROM PUBLIC;
REVOKE ALL ON TABLE "MOTIF_REGUL" FROM ciona_design;
GRANT ALL ON TABLE "MOTIF_REGUL" TO ciona_design;


--
-- Name: MUTANT; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "MUTANT" FROM PUBLIC;
REVOKE ALL ON TABLE "MUTANT" FROM ciona_design;
GRANT ALL ON TABLE "MUTANT" TO ciona_design;


--
-- Name: NEIGHBOR; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "NEIGHBOR" FROM PUBLIC;
REVOKE ALL ON TABLE "NEIGHBOR" FROM ciona_design;
GRANT ALL ON TABLE "NEIGHBOR" TO ciona_design;


--
-- Name: PCR; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PCR" FROM PUBLIC;
REVOKE ALL ON TABLE "PCR" FROM ciona_design;
GRANT ALL ON TABLE "PCR" TO ciona_design;


--
-- Name: PHYLOGENY; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PHYLOGENY" FROM PUBLIC;
REVOKE ALL ON TABLE "PHYLOGENY" FROM ciona_design;
GRANT ALL ON TABLE "PHYLOGENY" TO ciona_design;


--
-- Name: PICTURE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PICTURE" FROM PUBLIC;
REVOKE ALL ON TABLE "PICTURE" FROM ciona_design;
GRANT ALL ON TABLE "PICTURE" TO ciona_design;


--
-- Name: PROMOTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PROMOTER" FROM PUBLIC;
REVOKE ALL ON TABLE "PROMOTER" FROM ciona_design;
GRANT ALL ON TABLE "PROMOTER" TO ciona_design;


--
-- Name: PROMOTER_POS; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PROMOTER_POS" FROM PUBLIC;
REVOKE ALL ON TABLE "PROMOTER_POS" FROM ciona_design;
GRANT ALL ON TABLE "PROMOTER_POS" TO ciona_design;


--
-- Name: PROT_SEQUENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "PROT_SEQUENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "PROT_SEQUENCE" FROM ciona_design;
GRANT ALL ON TABLE "PROT_SEQUENCE" TO ciona_design;


--
-- Name: REFERENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "REFERENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "REFERENCE" FROM ciona_design;
GRANT ALL ON TABLE "REFERENCE" TO ciona_design;


--
-- Name: REG_EVIDENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "REG_EVIDENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "REG_EVIDENCE" FROM ciona_design;
GRANT ALL ON TABLE "REG_EVIDENCE" TO ciona_design;
GRANT SELECT ON TABLE "REG_EVIDENCE" TO PUBLIC;


--
-- Name: REG_SEQ; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "REG_SEQ" FROM PUBLIC;
REVOKE ALL ON TABLE "REG_SEQ" FROM ciona_design;
GRANT ALL ON TABLE "REG_SEQ" TO ciona_design;


--
-- Name: SCAFFOLD; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SCAFFOLD" FROM PUBLIC;
REVOKE ALL ON TABLE "SCAFFOLD" FROM ciona_design;
GRANT ALL ON TABLE "SCAFFOLD" TO ciona_design;


--
-- Name: SEQUENCE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SEQUENCE" FROM PUBLIC;
REVOKE ALL ON TABLE "SEQUENCE" FROM ciona_design;
GRANT ALL ON TABLE "SEQUENCE" TO ciona_design;


--
-- Name: SO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SO" FROM PUBLIC;
REVOKE ALL ON TABLE "SO" FROM ciona_design;
GRANT ALL ON TABLE "SO" TO ciona_design;


--
-- Name: SOFTWARE; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SOFTWARE" FROM PUBLIC;
REVOKE ALL ON TABLE "SOFTWARE" FROM ciona_design;
GRANT ALL ON TABLE "SOFTWARE" TO ciona_design;


--
-- Name: SO_DESCRIPTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SO_DESCRIPTION" FROM PUBLIC;
REVOKE ALL ON TABLE "SO_DESCRIPTION" FROM ciona_design;
GRANT ALL ON TABLE "SO_DESCRIPTION" TO ciona_design;


--
-- Name: SPECIES; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SPECIES" FROM PUBLIC;
REVOKE ALL ON TABLE "SPECIES" FROM ciona_design;
GRANT ALL ON TABLE "SPECIES" TO ciona_design;


--
-- Name: SUBMITED; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SUBMITED" FROM PUBLIC;
REVOKE ALL ON TABLE "SUBMITED" FROM ciona_design;
GRANT ALL ON TABLE "SUBMITED" TO ciona_design;


--
-- Name: SYNO; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "SYNO" FROM PUBLIC;
REVOKE ALL ON TABLE "SYNO" FROM ciona_design;
GRANT ALL ON TABLE "SYNO" TO ciona_design;


--
-- Name: S_ARTICLE_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_ARTICLE_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_ARTICLE_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_ARTICLE_ID" TO ciona_design;


--
-- Name: S_AUTHOR_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_AUTHOR_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_AUTHOR_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_AUTHOR_ID" TO ciona_design;


--
-- Name: S_BIO_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_BIO_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_BIO_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_BIO_ID" TO ciona_design;


--
-- Name: S_DEV_STAGE_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_DEV_STAGE_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_DEV_STAGE_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_DEV_STAGE_ID" TO ciona_design;


--
-- Name: S_INTERACTION_EVIDENCE_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_INTERACTION_EVIDENCE_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_INTERACTION_EVIDENCE_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_INTERACTION_EVIDENCE_ID" TO ciona_design;
GRANT SELECT ON SEQUENCE "S_INTERACTION_EVIDENCE_ID" TO PUBLIC;


--
-- Name: S_MORPHOGEN_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_MORPHOGEN_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_MORPHOGEN_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_MORPHOGEN_ID" TO ciona_design;


--
-- Name: S_PICTURE_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_PICTURE_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_PICTURE_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_PICTURE_ID" TO ciona_design;


--
-- Name: S_PICTURE_MORPHOGEN_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_PICTURE_MORPHOGEN_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_PICTURE_MORPHOGEN_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_PICTURE_MORPHOGEN_ID" TO ciona_design;


--
-- Name: S_SUBMITED_ID; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_SUBMITED_ID" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_SUBMITED_ID" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_SUBMITED_ID" TO ciona_design;


--
-- Name: S_UPDATE_INTERACTION; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON SEQUENCE "S_UPDATE_INTERACTION" FROM PUBLIC;
REVOKE ALL ON SEQUENCE "S_UPDATE_INTERACTION" FROM ciona_design;
GRANT ALL ON SEQUENCE "S_UPDATE_INTERACTION" TO ciona_design;
GRANT SELECT ON SEQUENCE "S_UPDATE_INTERACTION" TO PUBLIC;


--
-- Name: TARGET_TO_CLUSTER; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "TARGET_TO_CLUSTER" FROM PUBLIC;
REVOKE ALL ON TABLE "TARGET_TO_CLUSTER" FROM ciona_design;
GRANT ALL ON TABLE "TARGET_TO_CLUSTER" TO ciona_design;
GRANT SELECT ON TABLE "TARGET_TO_CLUSTER" TO PUBLIC;


--
-- Name: TRANSCRIPT; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "TRANSCRIPT" FROM PUBLIC;
REVOKE ALL ON TABLE "TRANSCRIPT" FROM ciona_design;
GRANT ALL ON TABLE "TRANSCRIPT" TO ciona_design;


--
-- Name: UPDATE_INTERACTIONS; Type: ACL; Schema: public; Owner: -
--

REVOKE ALL ON TABLE "UPDATE_INTERACTIONS" FROM PUBLIC;
REVOKE ALL ON TABLE "UPDATE_INTERACTIONS" FROM ciona_design;
GRANT ALL ON TABLE "UPDATE_INTERACTIONS" TO ciona_design;
GRANT SELECT ON TABLE "UPDATE_INTERACTIONS" TO PUBLIC;


--
-- PostgreSQL database dump complete
--

